#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h> 
#include <vtk.h>  
#include <pdbFile.h>        
#define GLOBAL_DECLARATION
#include "../inc/config.h"
#include "vtkXRenderWindow.h"
#include "vtkXRenderWindowInteractor.h"

#define DEBUG
#include "genUtil.h"
#include "mrcImage.h"
//#include "vtkGraphicsFactory.h"

#include "eosInteractorMyStyle.cc"
#include "eosStereoModeOn.cc"

#define CONEHEIGHT           1.0
#define CONERADIUS           0.5
#define CONERESOLUTION       80

class eosStereoWindow{

  public:
         vtkRenderer     *ren;
         vtkCamera       *cam;
         vtkLight        *light;
         vtkRenderWindow *renWin;
         vtkRenderWindowInteractor *iren;

         eosStereoWindow();
         void init();
         static eosStereoWindow* New();
         void eosStereoWindowSet(vtkActor*);
         void run();
         vtkRenderer* GetRenderer(void);
         vtkRenderWindow* GetRenderWindow(void);

	 eosInteractorMyStyle *myi;
};

eosStereoWindow::eosStereoWindow(){
         init();
}

void eosStereoWindow::init(){

         cam=vtkCamera::New();
	 cam->SetFocalPoint(0,0,0);
	 cam->SetPosition(0,0,10);
	 cam->SetEyeAngle(10.0);

	 light=vtkLight::New();
	 light->SetFocalPoint(0.21406,1.5,0);
	 light->SetPosition(8.3761,4.94858,4.1250);

}


void eosStereoWindow::eosStereoWindowSet(vtkActor* eosActor){

         ren=vtkRenderer::New();
	 ren->SetActiveCamera(cam);
	 ren->AddLight(light);
	 ren->AddActor(eosActor);

	 renWin=vtkRenderWindow::New();
	 renWin->AddRenderer(ren);
	 renWin->SetWindowName("eosStereoWindow");
	 renWin->SetSize(300,300);

	 myi=eosInteractorMyStyle::New();
	
	 iren=vtkRenderWindowInteractor::New();
	 iren->SetRenderWindow(renWin);
	 iren->SetInteractorStyle(myi);
	 myi->SetStereoRenderWindows(ren,iren);
	 
	 /*
	 if(flag==1){

	   iren2=vtkRenderWindowInteractor::New();
	   iren2->SetRenderWindow(renWin2);
	   iren2->SetInteractorStyle(myi2);

	   myi2->SetStereoRenderWindows(ren,renLeft,renRight,iren1,iren2);

	 }
	 */

}

void eosStereoWindow::run(){
  	 renWin->Render();
	 printf("??\n");  
	 iren->Start();
}

vtkRenderer* eosStereoWindow::GetRenderer(void)
{
  return(ren);
}

vtkRenderWindow* eosStereoWindow::GetRenderWindow(void)
{
  return(renWin);
}

int main(int argc, char* argv[])
{
	mrcViewInfo info;
	pdbFile pdb;

	init0(&info);
    	argCheck(&info, argc, argv);
    	init1(&info);

	DEBUGPRINT("Program Start\n");   


	vtkConeSource *cone=vtkConeSource::New();
	 cone->SetHeight(CONEHEIGHT);
	 cone->SetRadius(CONERADIUS);
	 cone->SetResolution(CONERESOLUTION);
	vtkPolyDataMapper *coneMapper=vtkPolyDataMapper::New();
	 coneMapper->SetInput(cone->GetOutput());
	vtkActor *coneActor=vtkActor::New();
	 coneActor->SetMapper(coneMapper);
	 coneActor->GetProperty()->SetColor(0.0,0.0,1.0);
	 coneActor->RotateZ(0.0);
	 coneActor->SetPosition(0.0,0.0,0.0);
	 coneActor->RotateY(0.0);
     
	 eosStereoWindow win;
	 win.eosStereoWindowSet(coneActor);
	 win.run();    
     
	 exit(EXIT_SUCCESS);
}

/*
void
additionalUsage()
{
	fprintf(stderr, "----- Additional Usage -----\n");
}
*/
