/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% lmrcImageSoftEdge ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : lmrcImageSoftEdge 
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%lmrcImageSoftEdge ver%I%; Date:%D% %Z%";

#define DEBUG
#include "genUtil.h"
#include <stdio.h>
#include <stdlib.h>

#include "./lmrcImageSoftEdge.h"

int
lmrcImageSoftEdge(mrcImage* out, mrcImage* in, lmrcImageSoftEdgeInfo linfo, int mode)
{
    mrcImageParaTypeReal x, y, z;
    mrcImageParaTypeReal offsetx, offsety, offsetz;
    double width;
    double data;
    double distance, near, nearx, neary, nearz;
    double xmin, ymin, zmin, xmax, ymax, zmax;
    double max;
    double dstData;

    out->Header = in->Header;
    mrcInit(out, NULL);

    max =  MAX(out->HeaderN.x, MAX(out->HeaderN.y, out->HeaderN.z));

    switch(linfo.envelop) {
        case lmrcImageSoftEdgeInfoEnvelopGaussian: 
            width = linfo.width*3.0; 
            break;
        case lmrcImageSoftEdgeInfoEnvelopCosine: 
            width = linfo.width*2;
            break;
        default:
            fprintf(stderr, "Not supported evelope: %d\n", linfo.envelop);
            exit(EXIT_FAILURE);
            break;
    }

    for(z=0; z<out->HeaderN.z; z++) {
	DEBUGPRINT1("%d\n", (int)z);
    for(y=0; y<out->HeaderN.y; y++) {
    for(x=0; x<out->HeaderN.x; x++) {
        mrcPixelDataGet(in, x, y, z, &data, mrcPixelRePart, mrcPixelHowNearest);
        if(0<data) {
            dstData = data;
        } else {
            near = max;
            dstData = 0;
            xmin = MAX(0, x-width); xmax = MIN(x+width, out->HeaderN.x - 1); 
            ymin = MAX(0, y-width); ymax = MIN(y+width, out->HeaderN.y - 1);
            zmin = MAX(0, z-width); zmax = MIN(z+width, out->HeaderN.z - 1);
            for(offsetz=zmin; offsetz<=zmax; offsetz++) {
            for(offsety=ymin; offsety<=ymax; offsety++) {
            for(offsetx=xmin; offsetx<=xmax; offsetx++) {
                distance = sqrt(SQR(offsetx -x) + SQR(offsety - y) + SQR(offsetz - z));  
                if(distance<width) { 
                    mrcPixelDataGet(in, offsetx, offsety, offsetz, &data, mrcPixelRePart, mrcPixelHowNearest);
                    if(0<data) {
                        if(distance < near) {
                            near = distance;
                            nearx = offsetx;
                            neary = offsety;
                            nearz = offsetz;
                            dstData = data;
                        }
                    }
                }
            }
            }
            }
            if(0<dstData) {
                switch(linfo.envelop) {
                    case lmrcImageSoftEdgeInfoEnvelopGaussian: 
                        dstData *= exp(-SQR(near/linfo.width)/2.0);
                        break;
                    case lmrcImageSoftEdgeInfoEnvelopCosine: 
                        if(near<linfo.width*2) {
                            dstData *= (cos(2*M_PI*near/4/linfo.width)+1)/2.0;
                        } else {
                            dstData = 0;
                        }
                        break;
                    default:
                        fprintf(stderr, "Not supported envelop:  %d\n", linfo.envelop);
                        exit(EXIT_FAILURE);
                        break;
                }
            }
        }
        mrcPixelDataSet(out, x, y, z, dstData, mrcPixelRePart);
    }
    }
    }
    return  0;
}
