/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% eosStarFileRead ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : eosStarFileRead 
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%eosStarFileRead ver%I%; Date:%D% %Z%";

#include <stdio.h>
#include "eosString.h"
#include "Memory.h"
#include "../inc/eosStarFile.h"

void 
eosStarFileRead (FILE* fpt, eosStarFile* star, int mode)
{
    eosStarFileDataSizeGet(fpt, star, mode);    
    eosStarFileRead0(fpt, star, mode);    
}

void
eosStarFileDataSizeGet(FILE* fpt, eosStarFile* star, int mode)
{
    int flagData=0;
    int flagLoop=0;
    int dataBlockIndex = 0;
    int dataKeyIndex = 0;
    int loopDataKeyIndex = 0;
    int i, j;
    char* stmp[STRING_MAX_LENGTH];
    
    // DataBlockCount
    star->numDataBlock = 0;
    for(NULL!=(stmp = stringGetFromFile(stmp, "in", fpt, stderr, 0))) {
        if(stmp[0] != '#' && stmp[0] != ';' && stmp[0] != '\n') { // Not Comment
            if(0==strncmp(stmp, "data_", 5)) { // in loop 
                flagData = 1;
                flagLoop = 0;
                star->numDataBlock++;
            }
            if(0==strncmp(setmp, "loop_", 6)) { // in loop 
                flagData = 0;
                flagLoop = 1;
            }
        }
    }
    star->block = (eosStgrFileDataBlock*)memoryAllocate(sizeof(eosStgrFileDataBlock)* star->numDataBlock, "in  eosStarFileDataSizeGet");

    for(NULL!=(stmp = stringGetFromFile(stmp, "in", fpt, stderr, 0))) {
        if(stmp[0] != '#' && stmp[0] != ';' && stmp[0] != '\n') { // Not Comment
            if(flagLoop==1) {
                if(stmp[0] == '_') { // LoopKey
                    star->block[dataBlockIndex-1].numLoopKey++;
                } else { // LoopData
                    star->block[dataBlockIndex-1].numLoopData++;
                }
            }
            if(flagLoop==1) {
                if(stmp[0] == '_') { // dataItem
                    star->block[dataBlockIndex-1].numDataItem++;
                }
            }
            
            // Mode Check
            if(0==strncmp(stmp, "data_", 5)) { // in loop 
                flagData = 1;
                flagLoop = 0;
                dataBlockIndex++;
            }
            if(0==strncmp(stmp, "loop_", 6)) { // in loop 
                flagData = 0;
                flagLoop = 1;
            }
        }
    }
    for(i=0; i<star->numDataBlock; i++) {
        star->block[i].data = (eosStarFileData*)memoryAllocate(sizeof(eosStarFileData)* star->block[i].numDataItem, "in  eosStarFileDataSizeGet");
        for(j=0; j<star->block[i].numDataItem; j++) { 
            star->block[i].data[j].valueS = (char**)  malloc(sizeof(char*));
            star->block[i].data[j].valueI = (int*)    malloc(sizeof(int));
            star->block[i].data[j].valueR = (double*) malloc(sizeof(double));
        }
        star->block[i].loop = (eosStarFileData*)memoryAllocate(sizeof(eosStarFileData)* star->block[i].numLoopKey, "in  eosStarFileDataSizeGet");
        for(j=0; j<star->block[i].numLoopKey; j++) {
            star->block[i].data[j].valueS = (char**)  malloc(sizeof(char*) *star->block[i].numLoopData);
            star->block[i].data[j].valueI = (int*)    malloc(sizeof(int)   *star->block[i].numLoopData);
            star->block[i].data[j].valueR = (double*) malloc(sizeof(double)*star->block[i].numLoopData);
        }
    }
}


void 
eosStarFileRead0 (FILE* fpt, eosStarFile* star, int mode)
{
}
