#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i                  r                   (1.0       )phi                 (90.0      )theta               (0.0       )] :Optional  :input: coord\n");
    fprintf(stderr, "    [-o                  Out                 (stdout    )] :Optional  :output: coord\n");
    fprintf(stderr, "    [-centre             cx                  (0.0       )cy                  (0.0       )cz                  (0.0       )] :Optional  :Centre\n");
    fprintf(stderr, "    [-xaxis              xx                  (1.0       )xy                  (0.0       )xz                  (0.0       )] :Optional  :x-axis\n");
    fprintf(stderr, "    [-zaxis              zx                  (0.0       )zy                  (0.0       )zz                  (1.0       )] :Optional  :z-axis\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
