#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Optional  :InputDataFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Optional  :OutputDataFile\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-t[itle]            Title               (NULL      )] :Optional  :Title\n");
    fprintf(stderr, "    [-d[elta]            delta               (2.5       )] :Optional  :delta[A]\n");
    fprintf(stderr, "    [-C                  RepeatDistance      (2.5       )] :Optional  :RepeatDistance[A]\n");
    fprintf(stderr, "    [-r[Max]             rMax                (2.5       )] :Optional  :rMax[A]\n");
    fprintf(stderr, "    [-p[hiStart]         phiStart            (0         )] :Optional  :phiStart[degree]\n");
    fprintf(stderr, "    [-zmi[n]             zMin                (0.0       )] :Optional  :zMin\n");
    fprintf(stderr, "    [-zma[x]             zMax                (55.0      )] :Optional  :zMax\n");
    fprintf(stderr, "    [-zde[lta]           deltaz              (2.5       )] :Optional  :deltaz\n");
    fprintf(stderr, "    [-w[eight]           WeightOf0thLayer    (0.5       )] :Optional  :WeightOf0thLayer\n");
    fprintf(stderr, "    [-l[Weight]          Layer               (NULL      )] :Optional  :Layer WeightOfEachLayer\n");
    fprintf(stderr, "    [-f9[9]              ] :Optional  :IF(NN(LL)!=NL(LL)) WT(LL) = 0.0\n");
    fprintf(stderr, "    [-O[ffset]           CUT                 (0.5       )] :Optional  :CUT\n");
    fprintf(stderr, "    [-a[mean]            Mean                (0.0       )] :Optional  :Mean\n");
    fprintf(stderr, "    [-s[igma]            Sigma               (0.0       )] :Optional  :Sigma\n");
    fprintf(stderr, "    [-I[nverse]          ] :Optional  :Nega-Posi Reverse\n");
    fprintf(stderr, "    [-n[otInteractive]   ] :Optional  :not Intaracitve\n");
    fprintf(stderr, "    [-AntiPole           ] :Optional  :Anti Pole: zmax -> zmin:  Else zmin->zmax\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :\n\t\t\t\t0: Normarize\n\t\t\t\t1: Not Normarize bu edge average is zero.\n\t\t\t\t2: Not Normarize\n\t\t\t\tdefalt: 0\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
