#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-I[nput]            In                  (NULL      )] :Essential :InputDataFileList\n");
    fprintf(stderr, "    [-o[utput]R[eal]     OutR                (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-o[utput]I[m]       OutI                (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-o[utput]L[ength]   OutL                (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-o[utput]P[hase]    OutP                (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-o[utput]LL         OutLL               (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-Log                Log                 (NULL      )] :Essential :LogFile\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
