#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-v[ector]           vx                  (1         )vy                  (0         )vz                  (0         )] :Optional  :Input: vector\n");
    fprintf(stderr, "    [-polar[vector]      phi                 (0         )theta               (0         )] :Optional  :Input: vector[degree]\n");
    fprintf(stderr, "    [-polarz[axis]       zx                  (0         )zy                  (0         )zz                  (1         )] :Optional  :Input: z-axis for polar\n");
    fprintf(stderr, "    [-polarx[axis]       xx                  (1         )xy                  (0         )xz                  (0         )] :Optional  :Input: x-axis for polar\n");
    fprintf(stderr, "    [-ori[ginal]         sx                  (0         )sy                  (3         )sz                  (0         )] :Optional  :Input: origin\n");
    fprintf(stderr, "    [-step               step                (1.6       )] :Optional  :Input: step [A]\n");
    fprintf(stderr, "    [-o[utput]           Out                 (stdout    )] :Optional  :Output: pdbFile\n");
    fprintf(stderr, "    [-n                  n                   (20        )] :Optional  :Input: Number Of CA\n");
    fprintf(stderr, "    [-ID                 ID                  (A         )] :Optional  :Input: Chain ID\n");
    fprintf(stderr, "    [-Res                Res                 (GLY       )] :Optional  :Input: Chain ID\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
