#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :Input: pdbFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (stdout    )] :Optional  :Output: Coordinates List\n");
    fprintf(stderr, "    [-P[ointOfInterest]  Px                  (0.0       )Py                  (0.0       )Pz                  (0.0       )] :Optional  :PointOfInterest: Coordinates \n");
    fprintf(stderr, "    [-V[olumeOfInterest] MRC                 (NULL      )] :Optional  :VolumeOfInterest: MRC\n");
    fprintf(stderr, "    [-C[outourLevel]     Contour             (0.0       )] :Optional  :ContourLevel for VolumeOfInterest: MRC\n");
    fprintf(stderr, "    [-d[istance]         distance            (0.0       )] :Optional  :Distance [A]\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
