#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-x                  X                   (0.0       )] :Optional  :Move X[A]\n");
    fprintf(stderr, "    [-y                  Y                   (0.0       )] :Optional  :Move Y[A]\n");
    fprintf(stderr, "    [-z                  Z                   (0.0       )] :Optional  :Move Z[A]\n");
    fprintf(stderr, "    [-originTo           toX                 (0.0       )toY                 (0.0       )toZ                 (0.0       )] :Optional  :move (0,0,0) to (X,Y,Z)\n");
    fprintf(stderr, "    [-toOrigin           fromX               (0.0       )fromY               (0.0       )fromZ               (0.0       )] :Optional  :move (X,Y,Z) to (0,0,0)\n");
    fprintf(stderr, "    [-GCtoOrigin         ] :Optional  :GC(Gravity Centre) to origin\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
