#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputFETDataFileList\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :OutputEulerAngleDataFileList\n");
    fprintf(stderr, "    [-i[nput]Ref         InR                 (NULL      )] :Essential :InputReferenceFETDataFileList\n");
    fprintf(stderr, "    [-i[nput]Euler       InE                 (NULL      )] :Essential :InputEulerAngleDataFile\n");
    fprintf(stderr, "    [-n[ormalize]m[ode]  NM                  (0         )] :Optional  :normalizeMode\n");
    fprintf(stderr, "    [-o[utputList]m[ode] OM                  (2         )] :Optional  :outputListMode\n");
    fprintf(stderr, "    [-t[op]n[um]         TN                  (10        )] :Optional  :top number\n");
    fprintf(stderr, "    [-refR[ange]         RR                  (15        )] :Optional  :reference select Range\n");
    fprintf(stderr, "    [-w[eight]           WEIGHT              (NULL      )] :Optional  :CorrelationCalcWeight\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
