#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-p[osition]         iP                  (0         )iW                  (0         )iA                  (0         )] :Optional  :Position of Center of model creation. Phi(degree) ,Omega(degree) ,Alpha(degree) \n:Omega and Alpha range must be around 0 or 180. \n");
    fprintf(stderr, "    [-w[idth]            Wp                  (360       )Ww                  (10        )Wa                  (10        )] :Optional  :Width of Phi(degree,plus minus) ,Omega(degree,plus minus) ,Alpha(degree,plus minus) \n");
    fprintf(stderr, "    [-d[elta]            Dp                  (5         )Dw                  (5         )Da                  (5         )] :Optional  :Interval of model creation(degree) Phi(around Z axis),Omega(Y axis),Alpha(X axis)\n");
    fprintf(stderr, "    [-x                  Wx                  (NULL      )] :Optional  :Data length of x in the outputfile.Default:Data length of x in the inputfile\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
