#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (stdin     )] :Optional  :Input: ASCII\n");
    fprintf(stderr, "    [-o[utput]           Out                 (stdout    )] :Optional  :Output: mrcImage\n");
    fprintf(stderr, "    [-nx                 Nx                  (512       )] :Essential :ImageSize: x\n");
    fprintf(stderr, "    [-ny                 Ny                  (512       )] :Optional  :ImageSize: y\n");
    fprintf(stderr, "    [-nz                 Nz                  (1         )] :Optional  :ImageSize: z\n");
    fprintf(stderr, "    [-sx                 Sx                  (3         )] :Essential :FilterSize: x\n");
    fprintf(stderr, "    [-sy                 Sy                  (3         )] :Optional  :FilterSize: y\n");
    fprintf(stderr, "    [-sz                 Sz                  (1         )] :Optional  :FilterSize: z\n");
    fprintf(stderr, "    [-v[erbose]          ] :Optional  :Verbose\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-M[ode]             Mode                (0         )] :Optional  :Mode: Filter shape\n");
    fprintf(stderr, "    [-m[ode]             mode                (2         )] :Optional  :mode: output mrc\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
