#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :Input: MRC(3D)\n");
    fprintf(stderr, "    [-o[utput]           Out                 (stdout    )] :Optional  :Output: SymmetryFindParameters\n");
    fprintf(stderr, "    [-a[verage]          Avg                 (NULL      )] :Optional  :Output: SymmetryAverage\n");
    fprintf(stderr, "    [-S[paceGroupNumber] ISGN                (0         )] :Optional  :SpaceGroupNumber\n");
    fprintf(stderr, "    [-Rot[ation]Mode     RotMode             (XOYS      )] :Optional  :EulerMode\n");
    fprintf(stderr, "    [-Rot1               minRot1             (0.        )maxRot1             (360.      )dRot1               (1.0       )] :Optional  :[degree]\n");
    fprintf(stderr, "    [-Rot2               minRot2             (-90.      )maxRot2             (90.       )dRot2               (1.0       )] :Optional  :[degree]\n");
    fprintf(stderr, "    [-dCos               dCos                (1         )] :Optional  :dCos\n");
    fprintf(stderr, "    [-CorMode            corMode             (16        )] :Optional  :CorrelationMode\n");
    fprintf(stderr, "    [-OffsetMode         OffsetMode          (0         )] :Optional  :OffsetMode\n");
    fprintf(stderr, "    [-InterpolationMode  InterpolationMode   (2         )] :Optional  :InterpolationMode\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
