# Directory containing class headers.
SET(VTK_RENDERING_HEADER_DIR "${VTK_INSTALL_PREFIX}/include/vtk-5.4")

# Classes in vtkRendering.
SET(VTK_RENDERING_CLASSES
  "vtkAbstractMapper3D"
  "vtkAbstractPicker"
  "vtkAbstractPropPicker"
  "vtkAbstractVolumeMapper"
  "vtkActorCollection"
  "vtkActor"
  "vtkAreaPicker"
  "vtkAssembly"
  "vtkAxisActor2D"
  "vtkCamera"
  "vtkCameraActor"
  "vtkCameraInterpolator"
  "vtkCellCenterDepthSort"
  "vtkCellPicker"
  "vtkChooserPainter"
  "vtkClipPlanesPainter"
  "vtkCoincidentPoints"
  "vtkCoincidentTopologyResolutionPainter"
  "vtkCompositePainter"
  "vtkCompositePolyDataMapper2"
  "vtkCompositePolyDataMapper"
  "vtkCullerCollection"
  "vtkCuller"
  "vtkDataSetMapper"
  "vtkDefaultPainter"
  "vtkDisplayListPainter"
  "vtkDynamic2DLabelMapper"
  "vtkExporter"
  "vtkFollower"
  "vtkFrameBufferObject"
  "vtkFrustumCoverageCuller"
  "vtkGenericRenderWindowInteractor"
  "vtkGenericVertexAttributeMapping"
  "vtkGraphicsFactory"
  "vtkHardwareSelector"
  "vtkHardwareSelectionPolyDataPainter"
  "vtkHierarchicalPolyDataMapper"
  "vtkImageActor"
  "vtkImageMapper"
  "vtkImageViewer2"
  "vtkImageViewer"
  "vtkImagingFactory"
  "vtkImporter"
  "vtkInteractorEventRecorder"
  "vtkInteractorObserver"
  "vtkInteractorStyle"
  "vtkInteractorStyleFlight"
  "vtkInteractorStyleImage"
  "vtkInteractorStyleJoystickActor"
  "vtkInteractorStyleJoystickCamera"
  "vtkInteractorStyleRubberBand2D"
  "vtkInteractorStyleRubberBand3D"
  "vtkInteractorStyleRubberBandPick"
  "vtkInteractorStyleRubberBandZoom"
  "vtkInteractorStyleSwitch"
  "vtkInteractorStyleTerrain"
  "vtkInteractorStyleTrackballActor"
  "vtkInteractorStyleTrackballCamera"
  "vtkInteractorStyleTrackball"
  "vtkInteractorStyleUnicam"
  "vtkInteractorStyleUser"
  "vtkIVExporter"
  "vtkLabeledDataMapper"
  "vtkLabelHierarchy"
  "vtkLabelHierarchyAlgorithm"
  "vtkLabelHierarchyIterator"
  "vtkLabelPlacer"
  "vtkLabelSizeCalculator"
  "vtkLeaderActor2D"
  "vtkLightActor"
  "vtkLightCollection"
  "vtkLight"
  "vtkLightingPainter"
  "vtkLightKit"
  "vtkLinesPainter"
  "vtkLODActor"
  "vtkLODProp3D"
  "vtkMapperCollection"
  "vtkMapper"
  "vtkOBJExporter"
  "vtkObserverMediator"
  "vtkOOGLExporter"
  "vtkPainter"
  "vtkPainterDeviceAdapter"
  "vtkPainterPolyDataMapper"
  "vtkParallelCoordinatesActor"
  "vtkPicker"
  "vtkPixelBufferObject"
  "vtkPointPicker"
  "vtkPointSetToLabelHierarchy"
  "vtkPointsPainter"
  "vtkPOVExporter"
  "vtkPolyDataMapper2D"
  "vtkPolyDataMapper"
  "vtkPolyDataPainter"
  "vtkPolygonsPainter"
  "vtkPrimitivePainter"
  "vtkProp3DCollection"
  "vtkProp3D"
  "vtkProperty"
  "vtkPropPicker"
  "vtkQuadricLODActor"
  "vtkQuaternionInterpolator"
  "vtkRenderedAreaPicker"
  "vtkRendererCollection"
  "vtkRenderer"
  "vtkRendererDelegate"
  "vtkRendererSource"
  "vtkRenderPass"
  "vtkRenderState"
  "vtkRenderWindowCollection"
  "vtkRenderWindow"
  "vtkRenderWindowInteractor"
  "vtkRepresentationPainter"
  "vtkScalarBarActor"
  "vtkScalarsToColorsPainter"
  "vtkScaledTextActor"
  "vtkScenePicker"
  "vtkSelectVisiblePoints"
  "vtkShader"
  "vtkShaderDeviceAdapter"
  "vtkShaderProgram"
  "vtkStandardPolyDataPainter"
  "vtkTesting"
  "vtkTextActor3D"
  "vtkTextActor"
  "vtkTextMapper"
  "vtkTextProperty"
  "vtkTexture"
  "vtkTexturedActor2D"
  "vtkTextureObject"
  "vtkTransformInterpolator"
  "vtkTStripsPainter"
  "vtkTupleInterpolator"
  "vtkVisibilitySort"
  "vtkVolumeCollection"
  "vtkVolume"
  "vtkVolumeProperty"
  "vtkVRMLExporter"
  "vtkWindowToImageFilter"
  "vtkWorldPointPicker"
  "vtkVisibleCellSelector"
  "vtkIdentColoredPainter"
  "vtkFreeTypeUtilities"
  "vtkXRenderWindowInteractor"
  "vtkCameraPass"
  "vtkDefaultPass"
  "vtkDepthPeelingPass"
  "vtkGaussianBlurPass"
  "vtkLightsPass"
  "vtkGLSLShaderDeviceAdapter2"
  "vtkOpaquePass"
  "vtkOpenGLActor"
  "vtkOpenGLCamera"
  "vtkOpenGLClipPlanesPainter"
  "vtkOpenGLCoincidentTopologyResolutionPainter"
  "vtkOpenGLDisplayListPainter"
  "vtkOpenGLExtensionManager"
  "vtkOpenGLHardwareSupport"
  "vtkOpenGLImageActor"
  "vtkOpenGLImageMapper"
  "vtkOpenGLLight"
  "vtkOpenGLLightingPainter"
  "vtkOpenGLPainterDeviceAdapter"
  "vtkOpenGLPolyDataMapper"
  "vtkOpenGLPolyDataMapper2D"
  "vtkOpenGLProperty"
  "vtkOpenGLRenderWindow"
  "vtkOpenGLRenderer"
  "vtkOpenGLRepresentationPainter"
  "vtkOpenGLScalarsToColorsPainter"
  "vtkOpenGLTexture"
  "vtkOverlayPass"
  "vtkRenderPassCollection"
  "vtkSequencePass"
  "vtkShader2"
  "vtkShader2Collection"
  "vtkShaderProgram2"
  "vtkShadowMapPass"
  "vtkSobelGradientMagnitudePass"
  "vtkTextureUnitManager"
  "vtkTranslucentPass"
  "vtkUniformVariables"
  "vtkVolumetricPass"
  "vtkGLSLShader"
  "vtkGLSLShaderDeviceAdapter"
  "vtkGLSLShaderProgram"
  "vtkOpenGLFreeTypeTextMapper"
  "vtkgl"
  "vtkXOpenGLRenderWindow")

# Abstract classes in vtkRendering.
SET(VTK_RENDERING_CLASSES_ABSTRACT
  "vtkAbstractMapper3D"
  "vtkAbstractPicker"
  "vtkAbstractPropPicker"
  "vtkAbstractVolumeMapper"
  "vtkCuller"
  "vtkExporter"
  "vtkImporter"
  "vtkInteractorObserver"
  "vtkLabelHierarchyIterator"
  "vtkMapper"
  "vtkPainter"
  "vtkPolyDataPainter"
  "vtkPrimitivePainter"
  "vtkProp3D"
  "vtkRendererDelegate"
  "vtkRenderPass"
  "vtkRenderState"
  "vtkShader"
  "vtkShaderDeviceAdapter"
  "vtkShaderProgram"
  "vtkVisibilitySort"
  "vtkOpenGLRenderWindow"
  "vtkgl")

# Wrap-exclude classes in vtkRendering.
SET(VTK_RENDERING_CLASSES_WRAP_EXCLUDE
  "vtkRenderPass"
  "vtkRenderState"
  "vtkFreeTypeUtilities"
  "vtkCameraPass"
  "vtkDefaultPass"
  "vtkDepthPeelingPass"
  "vtkGaussianBlurPass"
  "vtkLightsPass"
  "vtkOpaquePass"
  "vtkOverlayPass"
  "vtkRenderPassCollection"
  "vtkSequencePass"
  "vtkShader2"
  "vtkShader2Collection"
  "vtkShaderProgram2"
  "vtkShadowMapPass"
  "vtkSobelGradientMagnitudePass"
  "vtkTextureUnitManager"
  "vtkTranslucentPass"
  "vtkVolumetricPass"
  "vtkgl")

# Set convenient variables to test each class.
FOREACH(class ${VTK_RENDERING_CLASSES})
  SET(VTK_CLASS_EXISTS_${class} 1)
ENDFOREACH(class)
FOREACH(class ${VTK_RENDERING_CLASSES_ABSTRACT})
  SET(VTK_CLASS_ABSTRACT_${class} 1)
ENDFOREACH(class)
FOREACH(class ${VTK_RENDERING_CLASSES_WRAP_EXCLUDE})
  SET(VTK_CLASS_WRAP_EXCLUDE_${class} 1)
ENDFOREACH(class)
