/**
***  Copyright  (C) 1985-2008 Intel Corporation. All rights reserved.
***
*** The information and source code contained herein is the exclusive
*** property of Intel Corporation and may not be disclosed, examined
*** or reproduced in whole or in part without explicit written authorization
*** from the company.
**/

/* float.h standard header -- IEEE 754 version */
#ifndef _FLOAT_H__
#define _FLOAT_H__

		/* common properties */
#define FLT_RADIX		2
#define FLT_ROUNDS		1

		/* float properties */
#define FLT_EPSILON		1.19209290e-07F
#define FLT_MAX			3.40282347e+38F
#define FLT_MIN			1.17549435e-38F

#define FLT_DIG			6
#define FLT_MANT_DIG		24
#define FLT_MAX_10_EXP		38
#define FLT_MAX_EXP		128
#define FLT_MIN_10_EXP		(-37)
#define FLT_MIN_EXP		(-125)

		/* double properties */
#define DBL_EPSILON		2.2204460492503131e-16
#define DBL_MAX			1.7976931348623157e+308
#define DBL_MIN			2.2250738585072014e-308

#define DBL_DIG			15
#define DBL_MANT_DIG		53
#define DBL_MAX_10_EXP		308
#define DBL_MAX_EXP		1024
#define DBL_MIN_10_EXP		(-307)
#define DBL_MIN_EXP		(-1021)

		/* long double properties */
#define LDBL_EPSILON		1.0842021724855044340075E-19L
#define LDBL_MAX		1.1897314953572317650213E+4932L
#define LDBL_MIN		3.3621031431120935062627E-4932L

#define LDBL_DIG		18
#define LDBL_MANT_DIG		64
#define LDBL_MAX_10_EXP		4932
#define LDBL_MAX_EXP		16384
#define LDBL_MIN_10_EXP		(-4931)
#define LDBL_MIN_EXP		(-16381)

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >=199901L

#undef DECIMAL_DIG
#undef FLT_EVAL_METHOD

#define DECIMAL_DIG	21
#ifdef __FLT_EVAL_METHOD__
#define FLT_EVAL_METHOD __FLT_EVAL_METHOD__
#else
#define FLT_EVAL_METHOD -1
#endif

#endif  /* __STDC_VERSION__ >= C99 */

#ifdef __STDC_WANT_DEC_FP__ 

#ifdef __DEC_EVAL_METHOD__
#define DEC_EVAL_METHOD __DEC_EVAL_METHOD__
#else
#define DEC_EVAL_METHOD -1
#endif

#ifndef DEC32_MANT_DIG
#define DEC32_MANT_DIG __DEC32_MANT_DIG__
#endif
#ifndef DEC64_MANT_DIG
#define DEC64_MANT_DIG __DEC64_MANT_DIG__
#endif             
#ifndef DEC128_MANT_DIG
#define DEC128_MANT_DIG __DEC128_MANT_DIG__           
#endif             
#ifndef DEC32_MIN_EXP           
#define DEC32_MIN_EXP __DEC32_MIN_EXP__
#endif             
#ifndef DEC64_MIN_EXP           
#define DEC64_MIN_EXP __DEC64_MIN_EXP__
#endif             
#ifndef DEC128_MIN_EXP           
#define DEC128_MIN_EXP __DEC128_MIN_EXP__
#endif             
#ifndef DEC32_MAX_EXP           
#define DEC32_MAX_EXP __DEC32_MAX_EXP__
#endif             
#ifndef DEC64_MAX_EXP           
#define DEC64_MAX_EXP __DEC64_MAX_EXP__
#endif             
#ifndef DEC128_MAX_EXP           
#define DEC128_MAX_EXP __DEC128_MAX_EXP__
#endif             
#ifndef DEC32_EPSILON           
#define DEC32_EPSILON __DEC32_EPSILON__
#endif             
#ifndef DEC64_EPSILON           
#define DEC64_EPSILON __DEC64_EPSILON__
#endif             
#ifndef DEC128_EPSILON           
#define DEC128_EPSILON __DEC128_EPSILON__
#endif             
#ifndef DEC32_MIN           
#define DEC32_MIN __DEC32_MIN__
#endif             
#ifndef DEC64_MIN           
#define DEC64_MIN __DEC64_MIN__
#endif             
#ifndef DEC128_MIN           
#define DEC128_MIN __DEC128_MIN__
#endif             
#ifndef DEC32_MAX           
#define DEC32_MAX __DEC32_MAX__
#endif             
#ifndef DEC64_MAX           
#define DEC64_MAX __DEC64_MAX__
#endif             
#ifndef DEC128_MAX           
#define DEC128_MAX __DEC128_MAX__
#endif             
#ifndef DEC32_DEN           
#define DEC32_DEN __DEC32_SUBNORMAL_MIN__
#endif             
#ifndef DEC64_DEN           
#define DEC64_DEN __DEC64_SUBNORMAL_MIN__
#endif             
#ifndef DEC128_DEN           
#define DEC128_DEN __DEC128_SUBNORMAL_MIN__
#endif   

#endif /* __STDC_WANT_DEC_FP__ */

#endif /* _FLOAT */
