/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkImageCast.h,v $
  Language:  C++
  Date:      $Date: 2002/01/22 15:31:58 $
  Version:   $Revision: 1.37 $

  Copyright (c) 1993-2002 Ken Martin, Will Schroeder, Bill Lorensen 
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkImageCast -  Image Data type Casting Filter
// .SECTION Description
// vtkImageCast filter casts the input type to match the output type in
// the image processing pipeline.  The filter does nothing if the input
// already has the correct type.  To specify the "CastTo" type,
// use "SetOutputScalarType" method.

// .SECTION See Also
// vtkImageThreshold vtkImageShiftScale

#ifndef __vtkImageCast_h
#define __vtkImageCast_h


#include "vtkImageToImageFilter.h"

class VTK_IMAGING_EXPORT vtkImageCast : public vtkImageToImageFilter
{
public:
  static vtkImageCast *New();
  vtkTypeRevisionMacro(vtkImageCast,vtkImageToImageFilter);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // Set the desired output scalar type to cast to.
  vtkSetMacro(OutputScalarType,int);
  vtkGetMacro(OutputScalarType,int);
  void SetOutputScalarTypeToFloat(){this->SetOutputScalarType(VTK_FLOAT);};
  void SetOutputScalarTypeToDouble(){this->SetOutputScalarType(VTK_DOUBLE);};
  void SetOutputScalarTypeToInt(){this->SetOutputScalarType(VTK_INT);};
  void SetOutputScalarTypeToUnsignedInt()
    {this->SetOutputScalarType(VTK_UNSIGNED_INT);};
  void SetOutputScalarTypeToLong(){this->SetOutputScalarType(VTK_LONG);};
  void SetOutputScalarTypeToUnsignedLong()
    {this->SetOutputScalarType(VTK_UNSIGNED_LONG);};
  void SetOutputScalarTypeToShort(){this->SetOutputScalarType(VTK_SHORT);};
  void SetOutputScalarTypeToUnsignedShort()   
    {this->SetOutputScalarType(VTK_UNSIGNED_SHORT);};
  void SetOutputScalarTypeToUnsignedChar()
    {this->SetOutputScalarType(VTK_UNSIGNED_CHAR);};
  void SetOutputScalarTypeToChar()
    {this->SetOutputScalarType(VTK_CHAR);};

  // Description:
  // When the ClampOverflow flag is on, the data is thresholded so that
  // the output value does not exceed the max or min of the data type.
  // By default ClampOverflow is off.
  vtkSetMacro(ClampOverflow, int);
  vtkGetMacro(ClampOverflow, int);
  vtkBooleanMacro(ClampOverflow, int);
  
  
protected:
  vtkImageCast();
  ~vtkImageCast() {};

  int ClampOverflow;
  int OutputScalarType;
  void ExecuteInformation(vtkImageData *inData, vtkImageData *outData);
  void UpdateData(vtkDataObject *data);
  void ExecuteInformation(){this->vtkImageToImageFilter::ExecuteInformation();};
  void ThreadedExecute(vtkImageData *inData, vtkImageData *outData, 
                       int ext[6], int id);

private:
  vtkImageCast(const vtkImageCast&);  // Not implemented.
  void operator=(const vtkImageCast&);  // Not implemented.
};

#endif




