/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkGESignaReader.h,v $
  Language:  C++
  Date:      $Date: 2002/11/12 19:44:35 $
  Version:   $Revision: 1.10 $

  Copyright (c) 1993-2002 Ken Martin, Will Schroeder, Bill Lorensen 
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkGESignaReader - read GE Signa ximg files
// .SECTION Description
// vtkGESignaReader is a source object that reads some GE Signa ximg files It
// does support reading in pixel spacing, slice spacing and it computes an
// origin for the image in millimeters. It always produces greyscale unsigned
// short data and it supports reading in rectangular, packed, compressed, and
// packed&compressed. It does not read in slice orientation, or position
// right now. To use it you just need to specify a filename or a file prefix
// and pattern.

//
// .SECTION See Also
// vtkImageReader2

#ifndef __vtkGESignaReader_h
#define __vtkGESignaReader_h

#include "vtkMedicalImageReader2.h"

class VTK_IO_EXPORT vtkGESignaReader : public vtkMedicalImageReader2
{
public:
  static vtkGESignaReader *New();
  vtkTypeRevisionMacro(vtkGESignaReader,vtkMedicalImageReader2);
  virtual void PrintSelf(ostream& os, vtkIndent indent);

  // Description: is the given file name a GESigna file?
  virtual int CanReadFile(const char* fname);

  // Description:
  // Valid extentsions
  virtual const char* GetFileExensions()
    {
      return ".MR .CT";
    }

  // Description: 
  // A descriptive name for this format
  virtual const char* GetDescriptiveName()
    {
      return "GESigna";
    }

protected:
  vtkGESignaReader() {};
  ~vtkGESignaReader() {};

  virtual void ExecuteInformation();
  virtual void ExecuteData(vtkDataObject *out);

private:
  vtkGESignaReader(const vtkGESignaReader&);  // Not implemented.
  void operator=(const vtkGESignaReader&);  // Not implemented.
};
#endif


