#
# This module add the VTK include paths to a project
# It should be included after the FindVTK module
#

# This file must support both the CMake 1.4 FindVTK.cmake module and
# the new VTK_DIR based find.  If any of the old variables are set,
# the VTKConfig.cmake file has not yet been included.  Otherwise, this
# file is being included from the VTK_USE_FILE setting provided in
# VTKConfig.cmake, so the settings have already been loaded.

# If VTK_USE_FILE is set, then VTKConfig.cmake has already been loaded.
IF(NOT VTK_USE_FILE)
  # We are being included through USE_VTK_FILE.  Load the settings.
  IF(USE_INSTALLED_VTK)
    INCLUDE(${VTK_INSTALL_PATH}/lib/vtk/VTKConfig.cmake)
  ELSE(USE_INSTALLED_VTK)
    IF(USE_BUILT_VTK)
      INCLUDE(${VTK_BINARY_PATH}/VTKConfig.cmake)
    ENDIF(USE_BUILT_VTK)
  ENDIF(USE_INSTALLED_VTK)
ENDIF(NOT VTK_USE_FILE)

# Load the compiler settings used for VTK.
IF(${CMAKE_MAJOR_VERSION}.${CMAKE_MINOR_VERSION} GREATER 1.4)
  IF(VTK_BUILD_SETTINGS_FILE)
    INCLUDE(${CMAKE_ROOT}/Modules/CMakeImportBuildSettings.cmake)
    CMAKE_IMPORT_BUILD_SETTINGS(${VTK_BUILD_SETTINGS_FILE})
  ENDIF(VTK_BUILD_SETTINGS_FILE)
ELSE(${CMAKE_MAJOR_VERSION}.${CMAKE_MINOR_VERSION} GREATER 1.4)
  # We have only CMake 1.4.  Fall back to LOAD_CACHE to get the
  # compiler settings.
  SET(VTK_CACHE_DIR "")
  IF(USE_INSTALLED_VTK)
    SET(VTK_CACHE_DIR ${VTK_INSTALL_PATH}/include/vtk)
  ELSE(USE_INSTALLED_VTK)
    IF(USE_BUILT_VTK)
      SET(VTK_CACHE_DIR ${VTK_BINARY_PATH})
    ENDIF(USE_BUILT_VTK)
  ENDIF(USE_INSTALLED_VTK)
  IF(VTK_CACHE_DIR)
    # Save the current compiler setting.
    SET(VTK_PRE_LOAD_CACHE_CXX_COMPILER ${CMAKE_CXX_COMPILER})

    # Load the cache, but exclude everything that is not a CMake build
    # variable.
    LOAD_CACHE(${VTK_CACHE_DIR} EXCLUDE
      BUILDNAME
      BUILD_DOCUMENTATION
      BUILD_ERROR_REPORT_LIMIT
      BUILD_EXAMPLES
      BUILD_SHARED_LIBS
      BUILD_TESTING
      BUILD_WARNING_REPORT_LIMIT
      COMPRESSIONCOMMAND
      CVSCOMMAND
      CVS_UPDATE_OPTIONS
      DART_ROOT
      DART_TESTING_TIMEOUT
      DELIVER_CONTINUOUS_EMAIL
      EXECUTABLE_OUTPUT_PATH
      FTGL_BUILD_EXAMPLES
      GUNZIPCOMMAND
      JAVACOMMAND
      JAVA_ARCHIVE
      JAVA_AWT_INCLUDE_PATH
      JAVA_AWT_LIBRARY
      JAVA_COMPILE
      JAVA_INCLUDE_PATH2
      JAVA_INCLUDE_PATH
      JAVA_RUNTIME
      LIBRARY_OUTPUT_PATH
      MAKECOMMAND
      MPIRUN
      MPI_EXTRA_LIBRARY
      MPI_INCLUDE_PATH
      MPI_LIBRARY
      VTK_MPI_MAX_NUMPROCS
      MPI_POSTFLAGS
      MPI_PREFLAGS
      OPENGL_INCLUDE_DIR
      OPENGL_gl_LIBRARY
      OPENGL_glu_LIBRARY
      OPENGL_xmesa_INCLUDE_DIR
      PURIFYCOMMAND
      PYTHON_EXECUTABLE
      PYTHON_INCLUDE_PATH
      PYTHON_LIBRARY
      SCPCOMMAND
      SITE
      TCL_INCLUDE_PATH
      TCL_LIBRARY_DEBUG
      TCL_STUB_LIBRARY
      TCL_STUB_LIBRARY_DEBUG
      TCL_TCLSH
      TK_INCLUDE_PATH
      TK_LIBRARY_DEBUG
      TK_STUB_LIBRARY
      TK_STUB_LIBRARY_DEBUG
      TK_WISH
      UTIL_LIBRARY
      VERBOSE_BUILD
      VTKEXPAT_BINARY_DIR
      VTKEXPAT_SOURCE_DIR
      VTKFREETYPE_BINARY_DIR
      VTKFREETYPE_SOURCE_DIR
      VTKFTGL_BINARY_DIR
      VTKFTGL_SOURCE_DIR
      VTKJPEG_BINARY_DIR
      VTKJPEG_SOURCE_DIR
      VTKPNG_BINARY_DIR
      VTKPNG_SOURCE_DIR
      VTKTIFF_BINARY_DIR
      VTKTIFF_SOURCE_DIR
      VTKZLIB_BINARY_DIR
      VTKZLIB_SOURCE_DIR
      VTK_BINARY_DIR
      VTK_BUILD_PYTHON_EXECUTABLE
      VTK_DATA_ROOT
      VTK_DEBUG_LEAKS
      VTK_DISABLE_TK_INIT
      VTK_JAVA_HOME
      VTK_MANGLE_MESA
      VTK_MPIRUN_EXE
      VTK_MPI_MAX_NUMPROCS
      VTK_MPI_POSTFLAGS
      VTK_MPI_PREFLAGS
      VTK_OPENGL_HAS_OSMESA
      VTK_PARSE_JAVA_EXE
      VTK_USE_64BIT_IDS
      VTK_USE_ANSI_STDLIB
      VTK_USE_FREETYPE
      VTK_USE_HYBRID
      VTK_USE_MANGLED_MESA
      VTK_USE_MPI
      VTK_USE_PARALLEL
      VTK_USE_PATENTED
      VTK_USE_RENDERING
      VTK_USE_VOLUMEPRO
      VTK_USE_X
      VTK_WRAP_HINTS
      VTK_WRAP_JAVA
      VTK_WRAP_JAVA_EXE
      VTK_WRAP_PYTHON
      VTK_WRAP_PYTHON_EXE
      VTK_WRAP_TCL
      VTK_WRAP_TCL_EXE
      vtkCommonJava_LIB_DEPENDS
      vtkCommonPython_LIB_DEPENDS
      vtkCommonTCL_LIB_DEPENDS
      vtkCommon_LIB_DEPENDS
      vtkFilteringJava_LIB_DEPENDS
      vtkFilteringPython_LIB_DEPENDS
      vtkFilteringTCL_LIB_DEPENDS
      vtkFiltering_LIB_DEPENDS
      vtkGraphicsJava_LIB_DEPENDS
      vtkGraphicsPython_LIB_DEPENDS
      vtkGraphicsTCL_LIB_DEPENDS
      vtkGraphics_LIB_DEPENDS
      vtkHybridJava_LIB_DEPENDS
      vtkHybridPython_LIB_DEPENDS
      vtkHybridTCL_LIB_DEPENDS
      vtkHybrid_LIB_DEPENDS
      vtkIOJava_LIB_DEPENDS
      vtkIOPython_LIB_DEPENDS
      vtkIOTCL_LIB_DEPENDS
      vtkIO_LIB_DEPENDS
      vtkImagingJava_LIB_DEPENDS
      vtkImagingPython_LIB_DEPENDS
      vtkImagingTCL_LIB_DEPENDS
      vtkImaging_LIB_DEPENDS
      vtkParallelJava_LIB_DEPENDS
      vtkParallelPython_LIB_DEPENDS
      vtkParallelTCL_LIB_DEPENDS
      vtkParallel_LIB_DEPENDS
      vtkPatentedJava_LIB_DEPENDS
      vtkPatentedPython_LIB_DEPENDS
      vtkPatentedTCL_LIB_DEPENDS
      vtkPatented_LIB_DEPENDS
      vtkRenderingJava_LIB_DEPENDS
      vtkRenderingPythonTkWidgets_LIB_DEPENDS
      vtkRenderingPython_LIB_DEPENDS
      vtkRenderingTCL_LIB_DEPENDS
      vtkRendering_LIB_DEPENDS
      vtkexpat_LIB_DEPENDS
      vtkfreetype_LIB_DEPENDS
      vtkftgl_LIB_DEPENDS
      vtkjpeg_LIB_DEPENDS
      vtkpng_LIB_DEPENDS
      vtktiff_LIB_DEPENDS
      vtkzlib_LIB_DEPENDS
    )

    # Check if the compiler changed and warn the user.
    SET(VTK_CXX_COMPILER_CHANGED 0)  
    IF(VTK_PRE_LOAD_CACHE_CXX_COMPILER STRLESS CMAKE_CXX_COMPILER)
      SET(VTK_CXX_COMPILER_CHANGED 1)
    ENDIF(VTK_PRE_LOAD_CACHE_CXX_COMPILER STRLESS CMAKE_CXX_COMPILER)
    IF(VTK_PRE_LOAD_CACHE_CXX_COMPILER STRGREATER CMAKE_CXX_COMPILER)
      SET(VTK_CXX_COMPILER_CHANGED 1)
    ENDIF(VTK_PRE_LOAD_CACHE_CXX_COMPILER STRGREATER CMAKE_CXX_COMPILER)
    IF(VTK_CXX_COMPILER_CHANGED)
      MESSAGE("Warning: CMake is forcing CMAKE_CXX_COMPILER to "
              "\"${CMAKE_CXX_COMPILER}\" to match that imported from VTK.  "
              "This is required because C++ projects must use the same "
              "compiler.")
    ENDIF(VTK_CXX_COMPILER_CHANGED)
  ENDIF(VTK_CACHE_DIR)
ENDIF(${CMAKE_MAJOR_VERSION}.${CMAKE_MINOR_VERSION} GREATER 1.4)

# Add compiler flags needed to use VTK.
SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${VTK_REQUIRED_C_FLAGS}")
SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${VTK_REQUIRED_CXX_FLAGS}")

# Add include directories needed to use VTK.
INCLUDE_DIRECTORIES(${VTK_INCLUDE_DIRS})

# Add link directories needed to use VTK.
LINK_DIRECTORIES(${VTK_LIBRARY_DIRS})
