/*
 *  MICO --- an Open Source CORBA implementation
 *  Copyright (c) 1997-2003 by The Mico Team
 *
 *  This file was automatically generated. DO NOT EDIT!
 */

#include <CORBA.h>
#include <mico/throw.h>

#ifndef __COSGRAPHS_H__
#define __COSGRAPHS_H__






namespace CosGraphs
{

class Traversal;
typedef Traversal *Traversal_ptr;
typedef Traversal_ptr TraversalRef;
typedef ObjVar< Traversal > Traversal_var;
typedef ObjOut< Traversal > Traversal_out;

class Node;
typedef Node *Node_ptr;
typedef Node_ptr NodeRef;
typedef ObjVar< Node > Node_var;
typedef ObjOut< Node > Node_out;

class TraversalCriteria;
typedef TraversalCriteria *TraversalCriteria_ptr;
typedef TraversalCriteria_ptr TraversalCriteriaRef;
typedef ObjVar< TraversalCriteria > TraversalCriteria_var;
typedef ObjOut< TraversalCriteria > TraversalCriteria_out;

class TraversalFactory;
typedef TraversalFactory *TraversalFactory_ptr;
typedef TraversalFactory_ptr TraversalFactoryRef;
typedef ObjVar< TraversalFactory > TraversalFactory_var;
typedef ObjOut< TraversalFactory > TraversalFactory_out;

class Role;
typedef Role *Role_ptr;
typedef Role_ptr RoleRef;
typedef ObjVar< Role > Role_var;
typedef ObjOut< Role > Role_out;

class NodeFactory;
typedef NodeFactory *NodeFactory_ptr;
typedef NodeFactory_ptr NodeFactoryRef;
typedef ObjVar< NodeFactory > NodeFactory_var;
typedef ObjOut< NodeFactory > NodeFactory_out;

class EdgeIterator;
typedef EdgeIterator *EdgeIterator_ptr;
typedef EdgeIterator_ptr EdgeIteratorRef;
typedef ObjVar< EdgeIterator > EdgeIterator_var;
typedef ObjOut< EdgeIterator > EdgeIterator_out;

}



#include <coss/CosObjectIdentity.h>
#include <mico/ir_base.h>
#include <mico/ir.h>
#include <coss/CosRelationships.h>



namespace CosGraphs
{

struct NodeHandle;
typedef TVarVar< NodeHandle > NodeHandle_var;
typedef TVarOut< NodeHandle > NodeHandle_out;


struct NodeHandle {
  #ifdef HAVE_TYPEDEF_OVERLOAD
  typedef NodeHandle_var _var_type;
  #endif
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  NodeHandle();
  ~NodeHandle();
  NodeHandle( const NodeHandle& s );
  NodeHandle& operator=( const NodeHandle& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS

  Node_var the_node;
  ::CosObjectIdentity::ObjectIdentifier constant_random_id;
};

enum Mode {
  depthFirst = 0,
  breadthFirst,
  bestFirst
};

typedef Mode& Mode_out;


/*
 * Base class and common definitions for interface TraversalFactory
 */

class TraversalFactory : 
  virtual public CORBA::Object
{
  public:
    virtual ~TraversalFactory();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef TraversalFactory_ptr _ptr_type;
    typedef TraversalFactory_var _var_type;
    #endif

    static TraversalFactory_ptr _narrow( CORBA::Object_ptr obj );
    static TraversalFactory_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static TraversalFactory_ptr _duplicate( TraversalFactory_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static TraversalFactory_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual Traversal_ptr create_traversal_on( const NodeHandle& root_node, TraversalCriteria_ptr the_criteria, Mode how ) = 0;

  protected:
    TraversalFactory() {};
  private:
    TraversalFactory( const TraversalFactory& );
    void operator=( const TraversalFactory& );
};

// Stub for interface TraversalFactory
class TraversalFactory_stub:
  virtual public TraversalFactory
{
  public:
    virtual ~TraversalFactory_stub();
    Traversal_ptr create_traversal_on( const NodeHandle& root_node, TraversalCriteria_ptr the_criteria, Mode how );

  private:
    void operator=( const TraversalFactory_stub& );
};

#ifndef MICO_CONF_NO_POA

class TraversalFactory_stub_clp :
  virtual public TraversalFactory_stub,
  virtual public PortableServer::StubBase
{
  public:
    TraversalFactory_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~TraversalFactory_stub_clp ();
    Traversal_ptr create_traversal_on( const NodeHandle& root_node, TraversalCriteria_ptr the_criteria, Mode how );

  protected:
    TraversalFactory_stub_clp ();
  private:
    void operator=( const TraversalFactory_stub_clp & );
};

#endif // MICO_CONF_NO_POA

struct NamedRole;
typedef TVarVar< NamedRole > NamedRole_var;
typedef TVarOut< NamedRole > NamedRole_out;


struct NamedRole {
  #ifdef HAVE_TYPEDEF_OVERLOAD
  typedef NamedRole_var _var_type;
  #endif
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  NamedRole();
  ~NamedRole();
  NamedRole( const NamedRole& s );
  NamedRole& operator=( const NamedRole& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS

  Role_var the_role;
  ::CosRelationships::RoleName_var the_name;
};

struct EndPoint;
typedef TVarVar< EndPoint > EndPoint_var;
typedef TVarOut< EndPoint > EndPoint_out;


struct EndPoint {
  #ifdef HAVE_TYPEDEF_OVERLOAD
  typedef EndPoint_var _var_type;
  #endif
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  EndPoint();
  ~EndPoint();
  EndPoint( const EndPoint& s );
  EndPoint& operator=( const EndPoint& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS

  NodeHandle the_node;
  NamedRole the_role;
};


/*
 * Base class and common definitions for interface Traversal
 */

class Traversal : 
  virtual public CORBA::Object
{
  public:
    virtual ~Traversal();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef Traversal_ptr _ptr_type;
    typedef Traversal_var _var_type;
    #endif

    static Traversal_ptr _narrow( CORBA::Object_ptr obj );
    static Traversal_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static Traversal_ptr _duplicate( Traversal_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static Traversal_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    typedef CORBA::ULong TraversalScopedId;
    typedef TraversalScopedId& TraversalScopedId_out;
    struct ScopedEndPoint;
    typedef TVarVar< ScopedEndPoint > ScopedEndPoint_var;
    typedef TVarOut< ScopedEndPoint > ScopedEndPoint_out;


    struct ScopedEndPoint {
      #ifdef HAVE_TYPEDEF_OVERLOAD
      typedef ScopedEndPoint_var _var_type;
      #endif
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      ScopedEndPoint();
      ~ScopedEndPoint();
      ScopedEndPoint( const ScopedEndPoint& s );
      ScopedEndPoint& operator=( const ScopedEndPoint& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS

      EndPoint point;
      TraversalScopedId id;
    };

    typedef SequenceTmpl< ScopedEndPoint,MICO_TID_DEF> ScopedEndPoints;
    typedef TSeqVar< SequenceTmpl< ScopedEndPoint,MICO_TID_DEF> > ScopedEndPoints_var;
    typedef TSeqOut< SequenceTmpl< ScopedEndPoint,MICO_TID_DEF> > ScopedEndPoints_out;

    struct ScopedRelationship;
    typedef TVarVar< ScopedRelationship > ScopedRelationship_var;
    typedef TVarOut< ScopedRelationship > ScopedRelationship_out;


    struct ScopedRelationship {
      #ifdef HAVE_TYPEDEF_OVERLOAD
      typedef ScopedRelationship_var _var_type;
      #endif
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      ScopedRelationship();
      ~ScopedRelationship();
      ScopedRelationship( const ScopedRelationship& s );
      ScopedRelationship& operator=( const ScopedRelationship& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS

      ::CosRelationships::RelationshipHandle scoped_relationship;
      TraversalScopedId id;
    };

    struct ScopedEdge;
    typedef TVarVar< ScopedEdge > ScopedEdge_var;
    typedef TVarOut< ScopedEdge > ScopedEdge_out;


    struct ScopedEdge {
      #ifdef HAVE_TYPEDEF_OVERLOAD
      typedef ScopedEdge_var _var_type;
      #endif
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      ScopedEdge();
      ~ScopedEdge();
      ScopedEdge( const ScopedEdge& s );
      ScopedEdge& operator=( const ScopedEdge& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS

      ScopedEndPoint from;
      ScopedRelationship the_relationship;
      ScopedEndPoints relatives;
    };

    typedef SequenceTmpl< ScopedEdge,MICO_TID_DEF> ScopedEdges;
    typedef TSeqVar< SequenceTmpl< ScopedEdge,MICO_TID_DEF> > ScopedEdges_var;
    typedef TSeqOut< SequenceTmpl< ScopedEdge,MICO_TID_DEF> > ScopedEdges_out;

    virtual CORBA::Boolean next_one( ScopedEdge_out the_edge ) = 0;
    virtual CORBA::Boolean next_n( CORBA::Short how_many, ScopedEdges_out the_edges ) = 0;
    virtual void destroy() = 0;

  protected:
    Traversal() {};
  private:
    Traversal( const Traversal& );
    void operator=( const Traversal& );
};

// Stub for interface Traversal
class Traversal_stub:
  virtual public Traversal
{
  public:
    virtual ~Traversal_stub();
    CORBA::Boolean next_one( ScopedEdge_out the_edge );
    CORBA::Boolean next_n( CORBA::Short how_many, ScopedEdges_out the_edges );
    void destroy();

  private:
    void operator=( const Traversal_stub& );
};

#ifndef MICO_CONF_NO_POA

class Traversal_stub_clp :
  virtual public Traversal_stub,
  virtual public PortableServer::StubBase
{
  public:
    Traversal_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~Traversal_stub_clp ();
    CORBA::Boolean next_one( ScopedEdge_out the_edge );
    CORBA::Boolean next_n( CORBA::Short how_many, ScopedEdges_out the_edges );
    void destroy();

  protected:
    Traversal_stub_clp ();
  private:
    void operator=( const Traversal_stub_clp & );
};

#endif // MICO_CONF_NO_POA

typedef SequenceTmpl< EndPoint,MICO_TID_DEF> EndPoints;
typedef TSeqVar< SequenceTmpl< EndPoint,MICO_TID_DEF> > EndPoints_var;
typedef TSeqOut< SequenceTmpl< EndPoint,MICO_TID_DEF> > EndPoints_out;

struct Edge;
typedef TVarVar< Edge > Edge_var;
typedef TVarOut< Edge > Edge_out;


struct Edge {
  #ifdef HAVE_TYPEDEF_OVERLOAD
  typedef Edge_var _var_type;
  #endif
  #ifdef HAVE_EXPLICIT_STRUCT_OPS
  Edge();
  ~Edge();
  Edge( const Edge& s );
  Edge& operator=( const Edge& s );
  #endif //HAVE_EXPLICIT_STRUCT_OPS

  EndPoint from;
  ::CosRelationships::RelationshipHandle the_relationship;
  EndPoints relatives;
};


/*
 * Base class and common definitions for interface TraversalCriteria
 */

class TraversalCriteria : 
  virtual public CORBA::Object
{
  public:
    virtual ~TraversalCriteria();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef TraversalCriteria_ptr _ptr_type;
    typedef TraversalCriteria_var _var_type;
    #endif

    static TraversalCriteria_ptr _narrow( CORBA::Object_ptr obj );
    static TraversalCriteria_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static TraversalCriteria_ptr _duplicate( TraversalCriteria_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static TraversalCriteria_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    struct WeightedEdge;
    typedef TVarVar< WeightedEdge > WeightedEdge_var;
    typedef TVarOut< WeightedEdge > WeightedEdge_out;


    struct WeightedEdge {
      #ifdef HAVE_TYPEDEF_OVERLOAD
      typedef WeightedEdge_var _var_type;
      #endif
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      WeightedEdge();
      ~WeightedEdge();
      WeightedEdge( const WeightedEdge& s );
      WeightedEdge& operator=( const WeightedEdge& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS

      Edge the_edge;
      CORBA::ULong weight;
      typedef SequenceTmpl< NodeHandle,MICO_TID_DEF> _next_nodes_seq;
      _next_nodes_seq next_nodes;
    };

    typedef SequenceTmpl< WeightedEdge,MICO_TID_DEF> WeightedEdges;
    typedef TSeqVar< SequenceTmpl< WeightedEdge,MICO_TID_DEF> > WeightedEdges_var;
    typedef TSeqOut< SequenceTmpl< WeightedEdge,MICO_TID_DEF> > WeightedEdges_out;

    virtual void visit_node( const NodeHandle& a_node, Mode search_mode ) = 0;
    virtual CORBA::Boolean next_one( WeightedEdge_out the_edge ) = 0;
    virtual CORBA::Boolean next_n( CORBA::Short how_many, WeightedEdges_out the_edges ) = 0;
    virtual void destroy() = 0;

  protected:
    TraversalCriteria() {};
  private:
    TraversalCriteria( const TraversalCriteria& );
    void operator=( const TraversalCriteria& );
};

// Stub for interface TraversalCriteria
class TraversalCriteria_stub:
  virtual public TraversalCriteria
{
  public:
    virtual ~TraversalCriteria_stub();
    void visit_node( const NodeHandle& a_node, Mode search_mode );
    CORBA::Boolean next_one( WeightedEdge_out the_edge );
    CORBA::Boolean next_n( CORBA::Short how_many, WeightedEdges_out the_edges );
    void destroy();

  private:
    void operator=( const TraversalCriteria_stub& );
};

#ifndef MICO_CONF_NO_POA

class TraversalCriteria_stub_clp :
  virtual public TraversalCriteria_stub,
  virtual public PortableServer::StubBase
{
  public:
    TraversalCriteria_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~TraversalCriteria_stub_clp ();
    void visit_node( const NodeHandle& a_node, Mode search_mode );
    CORBA::Boolean next_one( WeightedEdge_out the_edge );
    CORBA::Boolean next_n( CORBA::Short how_many, WeightedEdges_out the_edges );
    void destroy();

  protected:
    TraversalCriteria_stub_clp ();
  private:
    void operator=( const TraversalCriteria_stub_clp & );
};

#endif // MICO_CONF_NO_POA


/*
 * Base class and common definitions for interface Node
 */

class Node : 
  virtual public ::CosObjectIdentity::IdentifiableObject
{
  public:
    virtual ~Node();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef Node_ptr _ptr_type;
    typedef Node_var _var_type;
    #endif

    static Node_ptr _narrow( CORBA::Object_ptr obj );
    static Node_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static Node_ptr _duplicate( Node_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static Node_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    typedef IfaceSequenceTmpl< Role_var,Role_ptr> Roles;
    typedef TSeqVar< IfaceSequenceTmpl< Role_var,Role_ptr> > Roles_var;
    typedef TSeqOut< IfaceSequenceTmpl< Role_var,Role_ptr> > Roles_out;

    struct NoSuchRole : public CORBA::UserException {
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      NoSuchRole();
      ~NoSuchRole();
      NoSuchRole( const NoSuchRole& s );
      NoSuchRole& operator=( const NoSuchRole& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS


      #ifdef HAVE_STD_EH
      NoSuchRole *operator->() { return this; }
      NoSuchRole& operator*() { return *this; }
      operator NoSuchRole*() { return this; }
      #endif // HAVE_STD_EH

      void _throwit() const;
      const char *_repoid() const;
      void _encode( CORBA::DataEncoder &en ) const;
      void _encode_any( CORBA::Any &a ) const;
      CORBA::Exception *_clone() const;
      static NoSuchRole *_downcast( CORBA::Exception *ex );
      static const NoSuchRole *_downcast( const CORBA::Exception *ex );
    };

    #ifdef HAVE_STD_EH
    typedef NoSuchRole NoSuchRole_catch;
    #else
    typedef ExceptVar< NoSuchRole > NoSuchRole_var;
    typedef TVarOut< NoSuchRole > NoSuchRole_out;
    typedef NoSuchRole_var NoSuchRole_catch;
    #endif // HAVE_STD_EH

    struct DuplicateRoleType : public CORBA::UserException {
      #ifdef HAVE_EXPLICIT_STRUCT_OPS
      DuplicateRoleType();
      ~DuplicateRoleType();
      DuplicateRoleType( const DuplicateRoleType& s );
      DuplicateRoleType& operator=( const DuplicateRoleType& s );
      #endif //HAVE_EXPLICIT_STRUCT_OPS


      #ifdef HAVE_STD_EH
      DuplicateRoleType *operator->() { return this; }
      DuplicateRoleType& operator*() { return *this; }
      operator DuplicateRoleType*() { return this; }
      #endif // HAVE_STD_EH

      void _throwit() const;
      const char *_repoid() const;
      void _encode( CORBA::DataEncoder &en ) const;
      void _encode_any( CORBA::Any &a ) const;
      CORBA::Exception *_clone() const;
      static DuplicateRoleType *_downcast( CORBA::Exception *ex );
      static const DuplicateRoleType *_downcast( const CORBA::Exception *ex );
    };

    #ifdef HAVE_STD_EH
    typedef DuplicateRoleType DuplicateRoleType_catch;
    #else
    typedef ExceptVar< DuplicateRoleType > DuplicateRoleType_var;
    typedef TVarOut< DuplicateRoleType > DuplicateRoleType_out;
    typedef DuplicateRoleType_var DuplicateRoleType_catch;
    #endif // HAVE_STD_EH

    virtual ::CosRelationships::RelatedObject_ptr related_object() = 0;
    virtual ::CosGraphs::Node::Roles* roles_of_node() = 0;

    virtual Roles* roles_of_type( ::CORBA::InterfaceDef_ptr role_type ) = 0;
    virtual void add_role( Role_ptr a_role ) = 0;
    virtual void remove_role( ::CORBA::InterfaceDef_ptr of_type ) = 0;

  protected:
    Node() {};
  private:
    Node( const Node& );
    void operator=( const Node& );
};

// Stub for interface Node
class Node_stub:
  virtual public Node,
  virtual public ::CosObjectIdentity::IdentifiableObject_stub
{
  public:
    virtual ~Node_stub();
    ::CosRelationships::RelatedObject_ptr related_object();
    ::CosGraphs::Node::Roles* roles_of_node();

    Roles* roles_of_type( ::CORBA::InterfaceDef_ptr role_type );
    void add_role( Role_ptr a_role );
    void remove_role( ::CORBA::InterfaceDef_ptr of_type );

  private:
    void operator=( const Node_stub& );
};

#ifndef MICO_CONF_NO_POA

class Node_stub_clp :
  virtual public Node_stub,
  virtual public ::CosObjectIdentity::IdentifiableObject_stub_clp
{
  public:
    Node_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~Node_stub_clp ();
    ::CosRelationships::RelatedObject_ptr related_object();
    ::CosGraphs::Node::Roles* roles_of_node();

    Roles* roles_of_type( ::CORBA::InterfaceDef_ptr role_type );
    void add_role( Role_ptr a_role );
    void remove_role( ::CORBA::InterfaceDef_ptr of_type );

  protected:
    Node_stub_clp ();
  private:
    void operator=( const Node_stub_clp & );
};

#endif // MICO_CONF_NO_POA


/*
 * Base class and common definitions for interface NodeFactory
 */

class NodeFactory : 
  virtual public CORBA::Object
{
  public:
    virtual ~NodeFactory();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef NodeFactory_ptr _ptr_type;
    typedef NodeFactory_var _var_type;
    #endif

    static NodeFactory_ptr _narrow( CORBA::Object_ptr obj );
    static NodeFactory_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static NodeFactory_ptr _duplicate( NodeFactory_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static NodeFactory_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual Node_ptr create_node( CORBA::Object_ptr related_object ) = 0;

  protected:
    NodeFactory() {};
  private:
    NodeFactory( const NodeFactory& );
    void operator=( const NodeFactory& );
};

// Stub for interface NodeFactory
class NodeFactory_stub:
  virtual public NodeFactory
{
  public:
    virtual ~NodeFactory_stub();
    Node_ptr create_node( CORBA::Object_ptr related_object );

  private:
    void operator=( const NodeFactory_stub& );
};

#ifndef MICO_CONF_NO_POA

class NodeFactory_stub_clp :
  virtual public NodeFactory_stub,
  virtual public PortableServer::StubBase
{
  public:
    NodeFactory_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~NodeFactory_stub_clp ();
    Node_ptr create_node( CORBA::Object_ptr related_object );

  protected:
    NodeFactory_stub_clp ();
  private:
    void operator=( const NodeFactory_stub_clp & );
};

#endif // MICO_CONF_NO_POA

typedef SequenceTmpl< Edge,MICO_TID_DEF> Edges;
typedef TSeqVar< SequenceTmpl< Edge,MICO_TID_DEF> > Edges_var;
typedef TSeqOut< SequenceTmpl< Edge,MICO_TID_DEF> > Edges_out;


/*
 * Base class and common definitions for interface Role
 */

class Role : 
  virtual public ::CosRelationships::Role
{
  public:
    virtual ~Role();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef Role_ptr _ptr_type;
    typedef Role_var _var_type;
    #endif

    static Role_ptr _narrow( CORBA::Object_ptr obj );
    static Role_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static Role_ptr _duplicate( Role_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static Role_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual void get_edges( CORBA::Long how_many, Edges_out the_edges, EdgeIterator_out the_rest ) = 0;

  protected:
    Role() {};
  private:
    Role( const Role& );
    void operator=( const Role& );
};

// Stub for interface Role
class Role_stub:
  virtual public Role,
  virtual public ::CosRelationships::Role_stub
{
  public:
    virtual ~Role_stub();
    void get_edges( CORBA::Long how_many, Edges_out the_edges, EdgeIterator_out the_rest );

  private:
    void operator=( const Role_stub& );
};

#ifndef MICO_CONF_NO_POA

class Role_stub_clp :
  virtual public Role_stub,
  virtual public ::CosRelationships::Role_stub_clp
{
  public:
    Role_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~Role_stub_clp ();
    void get_edges( CORBA::Long how_many, Edges_out the_edges, EdgeIterator_out the_rest );

  protected:
    Role_stub_clp ();
  private:
    void operator=( const Role_stub_clp & );
};

#endif // MICO_CONF_NO_POA


/*
 * Base class and common definitions for interface EdgeIterator
 */

class EdgeIterator : 
  virtual public CORBA::Object
{
  public:
    virtual ~EdgeIterator();

    #ifdef HAVE_TYPEDEF_OVERLOAD
    typedef EdgeIterator_ptr _ptr_type;
    typedef EdgeIterator_var _var_type;
    #endif

    static EdgeIterator_ptr _narrow( CORBA::Object_ptr obj );
    static EdgeIterator_ptr _narrow( CORBA::AbstractBase_ptr obj );
    static EdgeIterator_ptr _duplicate( EdgeIterator_ptr _obj )
    {
      CORBA::Object::_duplicate (_obj);
      return _obj;
    }

    static EdgeIterator_ptr _nil()
    {
      return 0;
    }

    virtual void *_narrow_helper( const char *repoid );

    virtual CORBA::Boolean next_one( Edge_out the_edge ) = 0;
    virtual CORBA::Boolean next_n( CORBA::ULong how_many, Edges_out the_edges ) = 0;
    virtual void destroy() = 0;

  protected:
    EdgeIterator() {};
  private:
    EdgeIterator( const EdgeIterator& );
    void operator=( const EdgeIterator& );
};

// Stub for interface EdgeIterator
class EdgeIterator_stub:
  virtual public EdgeIterator
{
  public:
    virtual ~EdgeIterator_stub();
    CORBA::Boolean next_one( Edge_out the_edge );
    CORBA::Boolean next_n( CORBA::ULong how_many, Edges_out the_edges );
    void destroy();

  private:
    void operator=( const EdgeIterator_stub& );
};

#ifndef MICO_CONF_NO_POA

class EdgeIterator_stub_clp :
  virtual public EdgeIterator_stub,
  virtual public PortableServer::StubBase
{
  public:
    EdgeIterator_stub_clp (PortableServer::POA_ptr, CORBA::Object_ptr);
    virtual ~EdgeIterator_stub_clp ();
    CORBA::Boolean next_one( Edge_out the_edge );
    CORBA::Boolean next_n( CORBA::ULong how_many, Edges_out the_edges );
    void destroy();

  protected:
    EdgeIterator_stub_clp ();
  private:
    void operator=( const EdgeIterator_stub_clp & );
};

#endif // MICO_CONF_NO_POA

typedef SequenceTmpl< NodeHandle,MICO_TID_DEF> NodeHandles;
typedef TSeqVar< SequenceTmpl< NodeHandle,MICO_TID_DEF> > NodeHandles_var;
typedef TSeqOut< SequenceTmpl< NodeHandle,MICO_TID_DEF> > NodeHandles_out;

typedef SequenceTmpl< NamedRole,MICO_TID_DEF> NamedRoles;
typedef TSeqVar< SequenceTmpl< NamedRole,MICO_TID_DEF> > NamedRoles_var;
typedef TSeqOut< SequenceTmpl< NamedRole,MICO_TID_DEF> > NamedRoles_out;

enum PropagationValue {
  deep = 0,
  shallow,
  none,
  inhibit
};

typedef PropagationValue& PropagationValue_out;

}


#ifndef MICO_CONF_NO_POA



namespace POA_CosGraphs
{

class TraversalFactory : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~TraversalFactory ();
    CosGraphs::TraversalFactory_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static TraversalFactory * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual ::CosGraphs::Traversal_ptr create_traversal_on( const ::CosGraphs::NodeHandle& root_node, ::CosGraphs::TraversalCriteria_ptr the_criteria, ::CosGraphs::Mode how ) = 0;

  protected:
    TraversalFactory () {};

  private:
    TraversalFactory (const TraversalFactory &);
    void operator= (const TraversalFactory &);
};

class Traversal : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~Traversal ();
    CosGraphs::Traversal_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static Traversal * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual CORBA::Boolean next_one( ::CosGraphs::Traversal::ScopedEdge_out the_edge ) = 0;
    virtual CORBA::Boolean next_n( CORBA::Short how_many, ::CosGraphs::Traversal::ScopedEdges_out the_edges ) = 0;
    virtual void destroy() = 0;

  protected:
    Traversal () {};

  private:
    Traversal (const Traversal &);
    void operator= (const Traversal &);
};

class TraversalCriteria : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~TraversalCriteria ();
    CosGraphs::TraversalCriteria_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static TraversalCriteria * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual void visit_node( const ::CosGraphs::NodeHandle& a_node, ::CosGraphs::Mode search_mode ) = 0;
    virtual CORBA::Boolean next_one( ::CosGraphs::TraversalCriteria::WeightedEdge_out the_edge ) = 0;
    virtual CORBA::Boolean next_n( CORBA::Short how_many, ::CosGraphs::TraversalCriteria::WeightedEdges_out the_edges ) = 0;
    virtual void destroy() = 0;

  protected:
    TraversalCriteria () {};

  private:
    TraversalCriteria (const TraversalCriteria &);
    void operator= (const TraversalCriteria &);
};

class Node : 
  virtual public POA_CosObjectIdentity::IdentifiableObject
{
  public:
    virtual ~Node ();
    CosGraphs::Node_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static Node * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual ::CosRelationships::RelatedObject_ptr related_object() = 0;
    virtual ::CosGraphs::Node::Roles* roles_of_node() = 0;

    virtual ::CosGraphs::Node::Roles* roles_of_type( ::CORBA::InterfaceDef_ptr role_type ) = 0;
    virtual void add_role( ::CosGraphs::Role_ptr a_role ) = 0;
    virtual void remove_role( ::CORBA::InterfaceDef_ptr of_type ) = 0;

  protected:
    Node () {};

  private:
    Node (const Node &);
    void operator= (const Node &);
};

class NodeFactory : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~NodeFactory ();
    CosGraphs::NodeFactory_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static NodeFactory * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual ::CosGraphs::Node_ptr create_node( CORBA::Object_ptr related_object ) = 0;

  protected:
    NodeFactory () {};

  private:
    NodeFactory (const NodeFactory &);
    void operator= (const NodeFactory &);
};

class Role : 
  virtual public POA_CosRelationships::Role
{
  public:
    virtual ~Role ();
    CosGraphs::Role_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static Role * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual void get_edges( CORBA::Long how_many, ::CosGraphs::Edges_out the_edges, ::CosGraphs::EdgeIterator_out the_rest ) = 0;

  protected:
    Role () {};

  private:
    Role (const Role &);
    void operator= (const Role &);
};

class EdgeIterator : virtual public PortableServer::StaticImplementation
{
  public:
    virtual ~EdgeIterator ();
    CosGraphs::EdgeIterator_ptr _this ();
    bool dispatch (CORBA::StaticServerRequest_ptr);
    virtual void invoke (CORBA::StaticServerRequest_ptr);
    virtual CORBA::Boolean _is_a (const char *);
    virtual CORBA::InterfaceDef_ptr _get_interface ();
    virtual CORBA::RepositoryId _primary_interface (const PortableServer::ObjectId &, PortableServer::POA_ptr);

    virtual void * _narrow_helper (const char *);
    static EdgeIterator * _narrow (PortableServer::Servant);
    virtual CORBA::Object_ptr _make_stub (PortableServer::POA_ptr, CORBA::Object_ptr);

    virtual CORBA::Boolean next_one( ::CosGraphs::Edge_out the_edge ) = 0;
    virtual CORBA::Boolean next_n( CORBA::ULong how_many, ::CosGraphs::Edges_out the_edges ) = 0;
    virtual void destroy() = 0;

  protected:
    EdgeIterator () {};

  private:
    EdgeIterator (const EdgeIterator &);
    void operator= (const EdgeIterator &);
};

}


#endif // MICO_CONF_NO_POA

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_NodeHandle;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_Mode;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_TraversalFactory;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_NamedRole;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_EndPoint;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_Traversal_ScopedEndPoint;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_Traversal_ScopedRelationship;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_Traversal_ScopedEdge;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_Traversal;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_Edge;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_TraversalCriteria_WeightedEdge;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_TraversalCriteria;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_Node_NoSuchRole;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_Node_DuplicateRoleType;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_Node;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_NodeFactory;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_Role;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_EdgeIterator;

extern CORBA::StaticTypeInfo *_marshaller_CosGraphs_PropagationValue;

extern CORBA::StaticTypeInfo *_marshaller__seq_CosGraphs_Traversal_ScopedEndPoint;

extern CORBA::StaticTypeInfo *_marshaller__seq_CosGraphs_Traversal_ScopedEdge;

extern CORBA::StaticTypeInfo *_marshaller__seq_CosGraphs_EndPoint;

extern CORBA::StaticTypeInfo *_marshaller__seq_CosGraphs_NodeHandle;

extern CORBA::StaticTypeInfo *_marshaller__seq_CosGraphs_TraversalCriteria_WeightedEdge;

extern CORBA::StaticTypeInfo *_marshaller__seq_CosGraphs_Role;

extern CORBA::StaticTypeInfo *_marshaller__seq_CosGraphs_Edge;

extern CORBA::StaticTypeInfo *_marshaller__seq_CosGraphs_NamedRole;

#endif
