'\"
'\" Copyright 1991-1997 by Bell Labs Innovations for Lucent Technologies.
'\"
'\" Permission to use, copy, modify, and distribute this software and its
'\" documentation for any purpose and without fee is hereby granted, provided
'\" that the above copyright notice appear in all copies and that both that the
'\" copyright notice and warranty disclaimer appear in supporting documentation,
'\" and that the names of Lucent Technologies any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the software
'\" without specific, written prior permission.
'\"
'\" Lucent Technologies disclaims all warranties with regard to this software,
'\" including all implied warranties of merchantability and fitness.  In no event
'\" shall Lucent Technologies be liable for any special, indirect or
'\" consequential damages or any damages whatsoever resulting from loss of use,
'\" data or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or performance
'\" of this software.  
'\"
'\" Bgexec command created by George Howlett.
'\"
.HS bgexec BLT
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
bgexec \- Run programs in the background while handling Tk events.
.SH SYNOPSIS
\fBbgexec \fIvarName\fR ?\fIoption value\fR?... \fIprogram\fR ?\fIarg\fR?...
.BE
.SH DESCRIPTION
.PP
The \fBbgexec\fR command executes programs in the background,
allowing Tk to handle events.  A global Tcl variable \fIvarName\fR is
set when the program has completed.
.SH INTRODUCTION
Tcl's \fBexec\fR command is very useful for gathering information from
the operating system.  It runs a program and returns the output as its 
result.  This works well for Tcl-only applications. But
for Tk applications, a problem occurs when the program takes time to
process.  Let's say we want the get the disk usage of a
directory.  We'll use the Unix program \f(CWdu\fR to get the summary.
.DS
set out [exec du -s $dir]
puts "Disk usage for $dir is $out"
.DE
While \f(CWdu\fR is running, scrollbars won't respond.  None of the Tk
widgets will be redrawn properly.  The \fBsend\fR command won't work.
And the worst part is that the application appears hung up or dead.
The problem is that while \fBexec\fR is waiting for \fIdu\fR to
finish, Tk is not able to handle X events.
.PP
The \fBbgexec\fR command performs the same functions as \fBexec\fR,
but also allows Tk to handle events.  You can execute a long-running
program and the Tk widgets will behave normally.  When the
program finishes, its output and the exit status are written to Tcl
variables.  This makes it easy to monitor and save the output of a
program.
.SH EXAMPLE
Here is the disk usage example again, this time using \fBbgexec\fR.
The syntax for the program is exactly the same as the previous
example, when we used \fBexec\fR.
.DS
global myStatus myOutput
bgexec myStatus -output myOutput du -s $dir
puts "Disk usage for $dir is $myOutput"
.DE
Two global variables, \f(CWmyStatus\fR and \f(CWmyOutput\fR, will be set by
\fBbgexec\fR when \f(CWdu\fR has completed. \f(CWMyStatus\fR
will contain the program's exit status.  \f(CWMyOutput\fR, specified by the
\fB\-output\fR option, will store the output of the program.
.PP
You can also terminate the program by setting the variable
\f(CWmyStatus\fR.  If \f(CWmyStatus\fR is set before \f(CWdu\fR has
completed, the process is killed. Under Unix, this is done sending by
a configurable signal (by default it's SIGKILL). Under Win32, this
is done by calling \fBTerminateProcess\fR. It makes no
difference what \f(CWmyStatus\fR is set to.
.DS
set myStatus {}
.DE
There are several \fBbgexec\fR options to collect different types of
information.
.DS
global myStatus myOutput myErrs
bgexec myStatus -output myOutput -error myErrs du -s $dir
.DE
The \fB\-error\fR option is similar to \fB\-output\fR.  It sets a global
variable when the program completes.  The variable will contain
any data written to stderr by the program.
.PP
The \fB\-output\fR and \fB\-error\fR variables are set only
after the program completes.  But if the program takes a long time, to
run you may want to receive its partial output.  You can gather data
as it becomes available using the \fB\-onoutput\fR option.  It
specifies a Tcl command prefix.  Whenever new data is available, this
command is executed, with the data appended as an argument to the
command.
.DS
proc GetInfo { data } {
    puts $data
}
bgexec myStatus -onoutput GetInfo du -s $dir
.DE
When output is available, the procedure \f(CWGetInfo\fR is called.
The \fB\-onerror\fR option performs a similar function for the stderr
data stream.
.PP
Like \fBexec\fR, \fBbgexec\fR returns an error if the exit code of the
program is not zero.  If you think you may get a non-zero exit
code, you might want to invoke \fBbgexec\fR from within a \fBcatch\fR.
.DS
catch { bgexec myStatus -output myOutput du -s $dir }
.DE
By default, \fBbgexec\fR will wait for the program to finish.
But you can detach the program making ampersand (&) the last
argument on the command line.
.DS
global myStatus myOutput
bgexec myStatus -output myOutput du -s $dir &
.DE
\fBBgexec\fR will return immediately and its result will be a list of
the spawned process ids.  If at some point you need to wait for the
program to finish up, you can use \fBtkwait\fR.  When the program
finishes, the variable \f(CWmyStatus\fR will be written to, breaking
out the \fBtkwait\fR command.
.DS
global myStatus myOutput
bgexec myStatus -output myOutput du -s $dir &
	...
tkwait variable myStatus
.DE
.SH SYNTAX
The \fBbgexec\fR command takes the following form:
.sp
\fB	bgexec \fIvarName\fR ?\fIoption value\fR?... \fIprogram\fR ?\fIarg\fR?...
.sp
\fIVarName\fR is the name of a global variable which is set when 
\fIprogram\fR has finished executing.  The exit status of
will be stored in \fIvarName\fR.  The exit status is a
list of a status token, the process-id of the program, the exit code,
and a status message.  You can also prematurely terminate the program
by setting \fIvarName\fR.  Under Unix, the program will be sent a signal to
terminate it (by default the signal is a SIGKILL; see the
\fB\-killsignal\fR option).
.PP
\fIProgram\fR is the name of the program to be executed and \fIargs\fR
are any extra arguments for \fIprogram\fR.  The syntax of
\fIprogram\fR and \fIargs\fR is the same as the \fBexec\fR command. So
you can redirect I/O, execute pipelines, etc. (see the \fBexec\fR
manual for further information) just like \fBexec\fR.  If the last
argument is an ampersand (&), the program will be run detached, and
\fBbgexec\fR will return immediately.  \fIVarName\fR will still be set
with the return status when \fIprogram\fR completes.
.SH OPTIONS
\fIOption\fR refers to the switch name always beginning with a dash (\-).
\fIValue\fR is the value of the option.  Option-value pairs are
terminated either by the program name, or double dashes (\-\-).
The following options are available for \fBbgexec\fR:
.TP 
\fB\-error \fIvarName\fR 
.br
Specifies that a global variable \fIvarName\fR is to be set with the
contents of stderr after the program has completed. 
.TP 
\fB\-keepnewline \fIboolean\fR
Specifies that a trailing newline should be retained in the 
output. If \fIboolean\fR is true, the trailing newline is truncated
from the output of the \fB\-onoutput\fR and \fB\-output\fR variables.  
The default value is \f(CWtrue\fR.
.TP 
\fB\-killsignal \fIsignal\fR
Specifies the signal to be sent to the program when 
terminating. This is available only under Unix. 
\fISignal\fR can either be a number (typically 1-32) or
a mnemonic (such as SIGINT). If \fIsignal\fR is the empty string, 
then no signal is sent.  The default signal is \f(CW9\fR (SIGKILL).
.TP 
\fB\-lasterror \fIvarName\fR
Specifies a variable \fIvarName\fR that is updated whenever data
becomes available from standard error of the program.
\fIVarName\fR is a global variable. Unlike the \fB\-error\fR option,
data is available as soon as it arrives.
.TP 
\fB\-lastoutput \fIvarName\fR 
Specifies a variable \fIvarName\fR that is updated whenever data
becomes available from standard output of the program.
\fIVarName\fR is a global variable. Unlike the \fB\-output\fR option,
data is available as soon as it arrives.
.TP 
\fB\-output \fIvarName\fR
.br
Specifies that a global variable \fIvarName\fR is to be set with the
output of the program, once it has completed.  If this option 
is not set, no output will be accumulated.
.TP 
\fB\-onerror \fIcommand\fR
Specifies the start of a Tcl command that will be executed
whenever new data is available from standard error. The data
is appended to the command as an extra argument before it is
executed.
.TP 
\fB\-onoutput \fIcommand\fR 
Specifies the start of a Tcl command that will be executed
whenever new data is available from standard output. The data
is appended to the command as an extra argument before it is
executed.
.TP 
\fB\-update \fIvarName\fR 
Deprecated. This option is replaced by \fB\-onerror\fR.
.TP 
\fB\-\|\-\fR
This marks the end of the options.  The following argument will
be considered the name of a program even if it starts with 
a dash (\fB\-\fR).
.SH PREEMPTION
Because \fBbgexec\fR allows Tk to handle events while a program is
running, it's possible for an application to preempt itself with
further user-interactions.  Let's say your application has a button
that runs the disk usage example.  And while the \f(CWdu\fR program is
running, the user accidently presses the button again.  A second
\fBbgexec\fR program will preempt the first.  What this means is that
the first program can not finish until the second program has
completed.
.PP
Care must be taken to prevent an application from preempting itself by
blocking further user-interactions (such as button clicks).  The BLT
\fBbusy\fR command is very useful for just these situations.
See the \fBbusy\fR manual for details.
.SH DIFFERENCES WITH FILEEVENT
Since Tk 4.0, a subset of \fBbgexec\fR can be also achieved using the
\fBfileevent\fR command.  The steps for running a program in the
background are:
.PP
Execute the program with the \fBopen\fR command (using the "|"
syntax) and save the file handle.
.DS
global fileId 
set fileId [open "|du -s $dir" r]
.DE
Next register a Tcl code snippet with \fBfileevent\fR to be run
whenever output is available on the file handle.  The code snippet
will read from the file handle and save the output in a variable.
.DS
fileevent fileId readable { 
    if { [gets $fileId line] < 0 } {
	close $fileId
	set output $temp
	unset fileId temp
    } else {
	append temp $line
    }
}
.DE
.PP
The biggest advantage of \fBbgexec\fR is that, unlike \fBfileevent\fR,
it requires no additional Tcl code to run a program.  It's simpler and
less error prone.  You don't have to worry about non-blocking I/O.
It's handled tranparently for you.
.PP
\fBBgexec\fR runs programs that \fBfileevent\fR can not.
\fBFileevent\fR assumes that the when stdout is closed the program has
completed.  But some programs, like the Unix \f(CWcompress\fR program,
reopen stdout, fooling \fBfileevent\fR into thinking the program has
terminated.  In the example above, we assume that the program will
write and flush its output line-by-line.  However running another
program, your application may block in the \fBgets\fR command reading
a partial line.
.PP
\fBBgexec\fR lets you get back the exit status of the program. It also
allows you to collect data from both stdout and stderr simultaneously.
Finally, since data collection is handled in C code, \fBbgexec\fR is
faster. You get back to the Tk event loop more quickly, making your
application seem more responsive.
.SH SEE ALSO
busy, exec, tkwait
.SH KEYWORDS
exec, background, busy
