'\"
'\" Copyright 1991-1997 by Bell Labs Innovations for Lucent Technologies.
'\"
'\" Permission to use, copy, modify, and distribute this software and its
'\" documentation for any purpose and without fee is hereby granted, provided
'\" that the above copyright notice appear in all copies and that both that the
'\" copyright notice and warranty disclaimer appear in supporting documentation,
'\" and that the names of Lucent Technologies any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the software
'\" without specific, written prior permission.
'\"
'\" Lucent Technologies disclaims all warranties with regard to this software,
'\" including all implied warranties of merchantability and fitness.  In no event
'\" shall Lucent Technologies be liable for any special, indirect or
'\" consequential damages or any damages whatsoever resulting from loss of use,
'\" data or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or performance
'\" of this software.  
'\"
.HS beep BLT
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
beep \- ring the bell
.SH SYNOPSIS
\fBbeep\fR ?\fIpercent\fR?
.BE
.SH DESCRIPTION
The \fBbeep\fR command rings the keyboard bell.  \fIPercent\fR is
relative to the base volume of the keyboard bell and can range from
-100 to 100 inclusive.
.PP
If \fIpercent\fR is nonnegative then the bell volume is:
.DS C
base - [(base * \fIpercent\fR) / 100] + \fIpercent\fR
.DE
If \fIpercent\fR is negative then the bell volume is:
.DS C
base + [(base * \fIpercent\fR) / 100]
.DE
The default \fIpercent\fR is 50.
.SH EXAMPLE
.DS
beep
.DE
.SH KEYWORDS
bell, beep
