// ugviewView.h : interface of the CUgviewView class
//
/////////////////////////////////////////////////////////////////////////////
#include "vtkMFCInteractor.h"
#include "vtkRenderMaster.h"
#include "vtkRenderWindow.h"
#include "vtkConeSource.h"

#ifdef class
#undef class
#endif

class CVtkView : public CView
{
protected: // create from serialization only
  CVtkView();
  DECLARE_DYNCREATE(CVtkView)
vtkMFCInteractor * iren;
  vtkRenderer * ren;
  vtkRenderWindow * renWindow;
  vtkRenderMaster * renMaster;
  HWND hWnd;
  HDC hDC;
  int DIBDepth;
  float DIBScale;
  LPSTGMEDIUM CopyMedium;				// for copying to the clipboard
  COleDataSource *CopySource;


  // Attributes
public:
  CVtkDoc* GetDocument();

  // Operations
public:

  // Overrides
  // ClassWizard generated virtual function overrides
  //{{AFX_VIRTUAL(CVtkView)
public:
  virtual void OnDraw(CDC* pDC);  // overridden to draw this view
  virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
protected:
  virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
  virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
  virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
  virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
  //}}AFX_VIRTUAL

  // Implementation
public:
  virtual ~CVtkView();
#ifdef _DEBUG
  virtual void AssertValid() const;
  virtual void Dump(CDumpContext& dc) const;
#endif

protected:
  BYTE *GetDIB();

  // Generated message map functions
protected:
  //{{AFX_MSG(CVtkView)
  afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
  afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
  afx_msg void OnTimer(UINT nIDEvent);
  afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
  afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
  afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
  afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
  afx_msg void OnMouseMove(UINT nFlags, CPoint point);
  afx_msg void OnSize(UINT nType, int cx, int cy);
  afx_msg BOOL OnEraseBkgnd(CDC* pDC);
  afx_msg void OnEditCopy();
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in ugviewView.cpp
inline CVtkDoc* CVtkView::GetDocument()
{ return (CVtkDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
