#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Optional  :InputDataFile\n");
    fprintf(stderr, "    [-I[nput]            In2                 (NULL      )] :Optional  :InputDataFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-O[utput]           Out2                (NULL      )] :Optional  :OutputDataFile[2DMulti]\n");
    fprintf(stderr, "    [-single             single              (1         )] :Optional  :SingleTiltMode\n");
    fprintf(stderr, "    [-InterpolationMode  InterpolationMode   (1         )] :Optional  :InterpolationMode\n");
    fprintf(stderr, "    [-Double             ] :Optional  :DoubleTiltMode\n");
    fprintf(stderr, "    [-DoubleCounter      DoubleCounter       (NULL      )] :Optional  :DoubleCounter\n");
    fprintf(stderr, "    [-CounterThreshold   CounterThreshold    (1e-6      )] :Optional  :CounterThreshold\n");
    fprintf(stderr, "    [-CounterThresholdModeCounterThresholdMode(0         )] :Optional  :CounterThresholdMode\n");
    fprintf(stderr, "    [-WeightMode         WeightMode          (0         )] :Optional  :WeightMode\n");
    fprintf(stderr, "    [-thicknessWeight    ] :Optional  :ThicknessWeight\n");
    fprintf(stderr, "    [-Sub[Sampling]      SubSampling         (1         )] :Optional  :SubSampling: [pixel]\n");
    fprintf(stderr, "    [-PlusXrot           ] :Optional  :plus x-rotation by 180 for rasmol.\n");
    fprintf(stderr, "    [-N                  Nx                  (0         )Ny                  (0         )Nz                  (0         )] :Optional  :OutputSize\n");
    fprintf(stderr, "    [-SIRT               ] :Optional  :by SIRT\n");
    fprintf(stderr, "    [-max[Iter]          maxIter             (30        )] :Optional  :MaxIteration for SIRT\n");
    fprintf(stderr, "    [-rms                rms                 (1.0       )] :Optional  :Ending Conditions: rms for SIRT\n");
    fprintf(stderr, "    [-CTF[Info]          CTFInfo             (NULL      )] :Optional  :CTFInfo: for SIRT\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
