#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-I[nformation]      Info                (NULL      )] :Essential :Information\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Optional  :MontageFile\n");
    fprintf(stderr, "    [-S[hrink]           Shrink              (NULL      )] :Optional  :When inputimage was shrunk\n");
    fprintf(stderr, "    [-width              Width               (0.0       )] :Optional  :Width\n");
    fprintf(stderr, "    [-height             Height              (0.0       )] :Optional  :Height\n");
    fprintf(stderr, "    [-M[ode]             Mode                (2         )] :Optional  :ImageType:0 byte 1 short 2 float\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
