#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Essential :InputDataFile\n");
    fprintf(stderr, "    [-o[utput]           Out                 (NULL      )] :Essential :OutputDataFile\n");
    fprintf(stderr, "    [-r[oi]              blx                 (0.0       )bly                 (0.0       )brx                 (0.0       )bry                 (0.0       )trx                 (0.0       )try                 (0.0       )tlx                 (0.0       )tly                 (0.0       )] :Optional  :Rectangle ROI \n");
    fprintf(stderr, "    [-x                  WidthBeforeExpansion(1.0/* Default is set by -r */)] :Optional  :Width  before expansion\n");
    fprintf(stderr, "    [-y                  HeightBeforeExpansion(1.0/* Default is set by -r */)] :Optional  :Height before expansion\n");
    fprintf(stderr, "    [-a[ngle]            Angle               (0.0       )] :Optional  :This value [degree] is added to angle of current source image.\n");
    fprintf(stderr, "    [-W                  WidthAfterExpansion (1.0       )] :Optional  :Width  after expansion[Pixel]\n");
    fprintf(stderr, "    [-H                  HeightAfterExpansion(1.0       )] :Optional  :Height after expansion[Pixel]: \n\t\tROI Size is (10,20):\n\t\t\tIf -W 30 -H 40, out (30,40)\n\t\t\tIf -W 30, out (30, 20*30/10)\n\t\t\tIf -H 40, out (10*40/20,40)\n\t\t\t\tIf omitted, out (10,20)\n");
    fprintf(stderr, "    [-Shift              ShiftX              (0.0       )ShiftY              (0.0       )] :Optional  :ROI ARea Shift [Pixel]\n");
    fprintf(stderr, "    [-turePitch          truePitch           (430.0     )] :Optional  :truePitch [A]\n");
    fprintf(stderr, "    [-dY                 dY                  (0.0       )] :Optional  :Number of turePitch\n");
    fprintf(stderr, "    [-Ly                 Ly                  (5.0       )] :Optional  :Header Length y [A/Pixel]\n");
    fprintf(stderr, "    [-S[hrink]           Shrink              (1         )] :Optional  :When inputfile is shrinked\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
