#include <stdio.h>
#include <stdlib.h>
#include "../inc/config.h"

void
usage(char* thisProgram)
{
    fprintf(stderr, "Usage: %s\n", thisProgram);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "    [-i[nput]            In                  (NULL      )] :Optional  :InputData: ASCII Log: Need -i, -i2, or -ib\n");
    fprintf(stderr, "    [-i[nput]2           In2                 (NULL      )] :Optional  :InputData: ASCII Log2\n");
    fprintf(stderr, "    [-i[nput]b[inary]    InB                 (NULL      )] :Optional  :InputData: BinaryLog: basename\n");
    fprintf(stderr, "    [-o[utput]           Out                 (stdout    )] :Optional  :Output: All\n");
    fprintf(stderr, "    [-O[utput]           Out2                (stdout    )] :Optional  :Output: ClusterOnly\n");
    fprintf(stderr, "    [-PS[output]         OutPS               (stdout    )] :Optional  :Output: ClusterForPS: Need -I\n");
    fprintf(stderr, "    [-O[utput]L[ist]     OutOL               (stdout    )] :Optional  :Output: ClusterList \n");
    fprintf(stderr, "    [-O[utput]T[reeInfo] TreeInfo            (NULL      )] :Optional  :Output: TreeInfo\n");
    fprintf(stderr, "    [-A[verage]L[ist]    OutAL               (stdout    )OutALRange          (0         )OutALSuffix         (avg       )] :Optional  :Output: ClusterList range\n");
    fprintf(stderr, "    [-Last[ClusterNumber]LastNum             (1         )] :Optional  :Last: Num\n");
    fprintf(stderr, "    [-S[cale]            ShoulderScale       (1         )ArmScale            (1         )] :Optional  :Scale: Shoulder Arm\n");
    fprintf(stderr, "    [-P[osition]         PosX                (0         )PosY                (0         )] :Optional  :Position: X Y\n");
    fprintf(stderr, "    [-Offset             Offset              (1         )] :Optional  :Offset: Arm\n");
    fprintf(stderr, "    [-I[nfileList]       InList              (NULL      )] :Optional  :FileList\n");
    fprintf(stderr, "    [-Log                ] :Optional  :Arm: Log Scale\n");
    fprintf(stderr, "    [-Scaling            ] :Optional  :with Scaling\n");
    fprintf(stderr, "    [-c[onfig]           configFile          (NULL      )] :Optional  :ConfigurationFile\n");
    fprintf(stderr, "    [-m[ode]             mode                (0         )] :Optional  :Mode\n");
    additionalUsage();
}

void
htmlBeforeUsage(char* thisProgram)
{
    fprintf(stderr, "<HTML>\n");
    fprintf(stderr, "<HEAD>\n");
    fprintf(stderr, "<TITLE>%s</TITLE>\n", thisProgram);
    fprintf(stderr, "</HEAD>\n");
    fprintf(stderr, "<BODY>\n");
    fprintf(stderr, "<H1>%s</H1>\n", thisProgram);
    fprintf(stderr, "<H2>Usage</H2>\n");
    fprintf(stderr, "<PRE>\n");
}

void
htmlAfterUsage(char* thisProgram)
{
    fprintf(stderr, "</PRE>\n");
    fprintf(stderr, "</BODY>\n");
    fprintf(stderr, "</HTML>\n");
}
