/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% lmrc3Dto2D ver %I%
#%Z% Created by tacyas
#%Z%
#%Z% Usage : mrc3Dto2D
#%Z% Attention
#%Z%
*/

#include "./lmrc3Dto2D.h"

void
lmrcImage3Dto2DSingle(mrcImage* out2D, mrcImage* in3D, 
			char   Mode[4],
			double Rot1,	
			double Rot2,	
			double Rot3,	
			lmrc3Dto2DInfo* linfo,
			lmrc3Dto2DSingleInfo* llinfo,
			int mode)
{
	int max;
	double sum;
	mrcImageParaTypeReal gx, gy, gz;
	mrcImageParaTypeReal g3x, g3y, g3z;
	mrcImageParaTypeReal r3x, r3y, r3z;
	mrcImageParaTypeReal x, y, z;
	mrcImageParaTypeReal prjx, prjy, prjz;
	floatVector v;
	Matrix3D MatrixAnti;
	double data;

	max = MAX(in3D->HeaderN.x, MAX(in3D->HeaderN.y, in3D->HeaderN.z));

	if(llinfo->flagInit) {
		out2D->Header = in3D->Header;
		out2D->HeaderN.x = max;
		out2D->HeaderN.y = max;
		out2D->HeaderN.z = 1;
		mrcInit(out2D, NULL);
	} 

	floatVectorInit(&v, 4);
	r3x = g3x = (in3D->HeaderN.x - 1)/2.0;
	r3y = g3y = (in3D->HeaderN.y - 1)/2.0;
	r3z = g3z = (in3D->HeaderN.z - 1)/2.0;
	gx  = (max - 1)/2.0;
	gy  = (max - 1)/2.0;
	gz  = (max - 1)/2.0;

	matrix3DRotationAntiSetFollowingEulerAngle(MatrixAnti,
		Mode, Rot1, Rot2, Rot3, MATRIX_3D_MODE_INITIALIZE);

	v.data[3] = 1;

	for(prjx=0; prjx<max; prjx++) {
	for(prjy=0; prjy<max; prjy++) {
		sum =0.0;
		for(prjz=0; prjz<max; prjz++) {
			v.data[0] = prjx - gx;
			v.data[1] = prjy - gy;
			v.data[2] = prjz - gz;
			matrix3DMultiplyVector(&v, MatrixAnti);
			x = v.data[0] + g3x;
			y = v.data[1] + g3y;
			z = v.data[2] + g3z;
			switch(linfo->AreaMode) {
				lmrc3Dto2DInfoAreaModeGlobular: {
					if(SQR((x - g3x)/r3x) 
					 + SQR((y - g3y)/r3y) 
					 + SQR((z - g3z)/r3z) <= 1.0) {
						mrcPixelDataGet(in3D, x, y, z, &data, 
							mrcPixelRePart, linfo->InterpolationMode);
					} else {
						data = 0;
					}
					break;
				}
				lmrc3Dto2DInfoAreaModeCubic: 
				default: {
					if(-0.5<=x && x<in3D->HeaderN.x-0.5
			 		 &&-0.5<=y && y<in3D->HeaderN.y-0.5
					 &&-0.5<=z && z<in3D->HeaderN.z-0.5) {
						mrcPixelDataGet(in3D, x, y, z, &data, 
							mrcPixelRePart, linfo->InterpolationMode);
					} else {
						data = 0;
					}
					break;
				}
			}
			sum+=data;
		}
		mrcPixelDataSet(out2D, prjx,  prjy, llinfo->section, sum/max, mrcPixelRePart);
	}
	}
}

void
lmrcImage3Dto2DFollowingTailer(mrcImage* out2Ds, mrcImage* in3D, mrcImage* ref2Ds, 
	lmrc3Dto2DInfo* linfo, 
	int mode)
{
	int max;
	int count;
	lmrc3Dto2DSingleInfo llinfo;

	out2Ds->Header = ref2Ds->Header;
	mrcInit(out2Ds, 0);
	max = ref2Ds->HeaderN.z;  
	out2Ds->numTailer = max;
	mrcTailerInit(out2Ds, 0);

	llinfo.flagInit = 0;
	for(count=0; count<max; count++) {
		llinfo.section = count;

		out2Ds->Tailer[count] = ref2Ds->Tailer[count]; 

		lmrcImage3Dto2DSingle(out2Ds, in3D,  
			out2Ds->Tailer[count].Cont.EulerAngleMode,
			out2Ds->Tailer[count].Cont.Rot1,
			out2Ds->Tailer[count].Cont.Rot2,
			out2Ds->Tailer[count].Cont.Rot3,
			linfo, &llinfo, mode);

	}
}

void
lmrcImage3Dto2D(mrcImage* out, mrcImage* in, lmrc3Dto2DInfo* linfo, int mode)
{
	int n;
	int max;
	int count;
	double Rot1, Rot2, Rot3;
	double RatiodRot1=1;
	double RatiodRot2=1;
	double RatiodRot3=1;
	int    nRot1, nRot2, nRot3;
	int    iRot1, iRot2, iRot3;
	double sum;
	mrcImageParaTypeReal gx, gy, gz;
	mrcImageParaTypeReal g3x, g3y, g3z;
	mrcImageParaTypeReal r3x, r3y, r3z;
	mrcImageParaTypeReal x, y, z;
	mrcImageParaTypeReal prjx, prjy, prjz;
	floatVector v;
	/* Matrix3D Matrix; */
	Matrix3D MatrixAnti;
	double data;
	mrcImage tmp;
	lmrc3Dto2DSingleInfo llinfo;


	n=linfo->nRot1*linfo->nRot2*linfo->nRot3;
	max = MAX(in->HeaderN.x, MAX(in->HeaderN.y, in->HeaderN.z));
	out->Header.Cont = in->Header.Cont;
	out->HeaderN.x = max;
	out->HeaderN.y = max;
	out->HeaderN.z = n;
	mrcInit(out, NULL);
	out->numTailer = n;
	mrcTailerInit(out, 0);

	tmp.Header.Cont = in->Header.Cont;
	tmp.HeaderN.x = max;
	tmp.HeaderN.y = max;
	tmp.HeaderN.z = max;
	mrcInit(&tmp, NULL);

	floatVectorInit(&v, 4);
	r3x = g3x = (in->HeaderN.x - 1)/2.0;
	r3y = g3y = (in->HeaderN.y - 1)/2.0;
	r3z = g3z = (in->HeaderN.z - 1)/2.0;
	gx  = (tmp.HeaderN.x - 1)/2.0;
	gy  = (tmp.HeaderN.y - 1)/2.0;
	gz  = (tmp.HeaderN.z - 1)/2.0;

	count = 0;
	/*
	for(Rot1=linfo->Rot1Start; Rot1<=linfo->Rot1End; Rot1+=linfo->Rot1Delta) {
	for(Rot2=linfo->Rot2Start; Rot2<=linfo->Rot2End; Rot2+=linfo->Rot2Delta) {
	for(Rot3=linfo->Rot3Start; Rot3<=linfo->Rot3End; Rot3+=linfo->Rot3Delta) {
	*/

	nRot1 = linfo->nRot1;
	for(iRot1=0; iRot1<nRot1; iRot1++) {
		Rot1 = linfo->Rot1Start + iRot1*linfo->Rot1Delta*RatiodRot1;
		if(0x01&mode) {
			nRot2 = MAX(1,(int)(linfo->nRot2*fabs(sin(Rot1))+0.5));
			RatiodRot2 = 2*M_PI/nRot2/linfo->Rot2Delta;
		} else {
			nRot2 = linfo->nRot2;		
		}	
	for(iRot2=0; iRot2<nRot2; iRot2++) {
		Rot2 = linfo->Rot2Start + iRot2*linfo->Rot2Delta*RatiodRot2;
		nRot3 = linfo->nRot3;
	for(iRot3=0; iRot3<linfo->nRot3; iRot3++) {
		Rot3 = linfo->Rot3Start + iRot3*linfo->Rot3Delta*RatiodRot3;

		DEBUGPRINT2("%d / %d\n", count, n);
		out->Tailer[count].Cont.Mode = mrcImageTailerMode2DProjection;
		out->Tailer[count].Cont.EulerAngleMode[0] = linfo->EulerAngleMode[0]; 
		out->Tailer[count].Cont.EulerAngleMode[1] = linfo->EulerAngleMode[1]; 
		out->Tailer[count].Cont.EulerAngleMode[2] = linfo->EulerAngleMode[2]; 
		out->Tailer[count].Cont.EulerAngleMode[3] = linfo->EulerAngleMode[3]; 
		out->Tailer[count].Cont.Rot1 = Rot1;
		out->Tailer[count].Cont.Rot2 = Rot2;
		out->Tailer[count].Cont.Rot3 = Rot3;
/*
		matrix3DRotationSetFollowingEulerAngle(Matrix,
			out->Tailer[count].Cont.EulerAngleMode, 
			out->Tailer[count].Cont.Rot1,
			out->Tailer[count].Cont.Rot2,
			out->Tailer[count].Cont.Rot3,
			MATRIX_3D_MODE_INITIALIZE);
*/
/*
		matrix3DRotationAntiSetFollowingEulerAngle(MatrixAnti,
			out->Tailer[count].Cont.EulerAngleMode,
			out->Tailer[count].Cont.Rot1,
			out->Tailer[count].Cont.Rot2,
			out->Tailer[count].Cont.Rot3,
			MATRIX_3D_MODE_INITIALIZE);

		for(prjx=0; prjx<tmp.HeaderN.x; prjx++) {
		for(prjy=0; prjy<tmp.HeaderN.y; prjy++) {
			sum =0.0;
		for(prjz=0; prjz<tmp.HeaderN.z; prjz++) {
		
			v.data[0] = prjx - gx;
			v.data[1] = prjy - gy;
			v.data[2] = prjz - gz;
			v.data[3] = 1;
			matrix3DMultiplyVector(&v, MatrixAnti);
			x = v.data[0] + g3x;
			y = v.data[1] + g3y;
			z = v.data[2] + g3z;
			switch(linfo->AreaMode) {
				lmrc3Dto2DInfoAreaModeGlobular: {
					if(SQR((x - g3x)/r3x) 
					 + SQR((y - g3y)/r3y) 
					 + SQR((z - g3z)/r3z) <= 1.0) {
						mrcPixelDataGet(in, x, y, z, &data, mrcPixelRePart, linfo->InterpolationMode);
					} else {
						data = 0;
					}
					break;
				}
				lmrc3Dto2DInfoAreaModeCubic: 
				default: {
					if(-0.5<=x && x<in->HeaderN.x-0.5
			 		 &&-0.5<=y && y<in->HeaderN.y-0.5
					 &&-0.5<=z && z<in->HeaderN.z-0.5) {
						mrcPixelDataGet(in, x, y, z, &data, mrcPixelRePart, linfo->InterpolationMode);
					} else {
						data = 0;
					}
				}
			}
			// mrcPixelDataSet(&tmp, prjx, prjy, prjz, data, mrcPixelRePart);
			sum+=data;
		}
			mrcPixelDataSet(out, prjx,  prjy, count, sum/tmp.HeaderN.z, mrcPixelRePart);
		}
		}
*/
		llinfo.flagInit = 0;
		llinfo.section  = count;
		lmrcImage3Dto2DSingle(out, in, 
			out->Tailer[count].Cont.EulerAngleMode,
			out->Tailer[count].Cont.Rot1,
			out->Tailer[count].Cont.Rot2,
			out->Tailer[count].Cont.Rot3,
			linfo, 
			&llinfo, 
			mode);

		count++;
		if(n<count) {
			fprintf(stderr, "Something wrong: count %d n %d\n", count, n);
			exit(EXIT_FAILURE);
		}
	}
	}
	}
	out->HeaderN.z = count;
	out->numTailer = count;
}

