/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% lmrcImageModelCreate ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : lmrcImageModelCreate 
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%lmrcImageModelCreate ver%I%; Date:%D% %Z%";
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  

#define DEBUG
#include "genUtil.h"
#include "mrcImage.h"
#include "lmrcImageModelCreate.h"

void 
_lmrcImageModelCreateMode0(mrcImage* out, mrcImageParaTypeReal radius)
{
	mrcImageParaTypeReal x, y, z;
	double data;

	for(x=0; x<out->HeaderN.x; x++) {
		for(y=0; y<out->HeaderN.y; y++) {
			for(z=0; z<out->HeaderN.z; z++) {
				if(SQR(x-out->HeaderN.x/2)+SQR(y-out->HeaderN.y/2)+SQR(z-out->HeaderN.z/2)<=SQR(radius)) {
					mrcPixelDataSet(out, x, y, z, 1.0, mrcPixelRePart);
				} else {
					mrcPixelDataSet(out, x, y, z, 0.0, mrcPixelRePart);
				}
			}
		}
	}
	for(x=0; x<out->HeaderN.x; x++) {
		for(y=0; y<out->HeaderN.y; y++) {
			for(z=0; z<out->HeaderN.z; z++) {
				if(x < y) {	
					mrcPixelDataGet(out, x, y, z, &data, mrcPixelRePart, mrcPixelHowNearest);
					mrcPixelDataSet(out, x, y, z, data+1.0, mrcPixelRePart);
				} 
			}
		}
	}
}


void 
_lmrcImageModelCreateMode1(mrcImage* out, _lmrcImageModelCreateMode1Info info)
{
	mrcImageParaTypeInteger i1=0, i2=0;
	int count=0;
	mrcImageParaTypeReal x=0, y=0, z=0, zTurn=0;
	float Phi=0, Phi1=0, Phi2=0;
	mrcImageParaTypeReal dstx=0, dsty=0, dstz=0;
	double data=0;

	zTurn = (int) ( fabs( info.endZ - info.startZ ) / info.zPitch );
	DEBUGPRINT1("phiAngle: %f\n", info.phiAngle);

	if(0==out->HeaderN.x%2 || 0==out->HeaderN.y%2) {
		fprintf(stderr, "Even size is not supported\n");
		exit(EXIT_FAILURE);
	}

	switch(info.units) {
		case 9: {
			for ( i2 = 0; i2 <= zTurn; i2++){ 
				for ( i1 = 0; i1 < info.nHelix; i1++){
					count++;
					Phi = info.startPhi + i1*info.phiAngle  + i2*info.deltaPhi;
					Phi1 = Phi + 30.0*RADIAN;
					Phi2 = Phi + 60.0*RADIAN;

					x = info.radius * cos(Phi);
					y = info.radius * sin(Phi);
					z = info.startZ + i2*info.zPitch; 

					fprintf(stderr ,"(%8.3f %8.3f %8.3f) ThickFilaments %d \n",x,y,z,count);
					dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
					dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
					dstz = z/out->HeaderLength.z;
			
					if(info.flagIn) {
						switch(info.fm) {
							case 0: {
								mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi, info.inMode);
								break;
							}
							case 1: {
								mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi, info.inMode);

								x = info.radius * cos(Phi1);
								y = info.radius * sin(Phi1);
								z = info.startZ + i2*info.zPitch; 
								dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
								dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
								dstz = z/out->HeaderLength.z;
								mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi1, info.inMode);
	
								x = info.radius * cos(Phi2);
								y = info.radius * sin(Phi2);
								z = info.startZ + i2*info.zPitch; 
								dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
								dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
								dstz = z/out->HeaderLength.z;
								mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi2, info.inMode);
	
								break;
							}
							case 2: {
								mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi, info.inMode);
	
								x = 1.2 * info.radius * cos(Phi);
								y = 1.2 * info.radius * sin(Phi);
								z = 30 + info.startZ + i2*info.zPitch; 
								dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
								dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
								dstz = z/out->HeaderLength.z;
								mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi, info.inMode);
	
								x = 1.4 * info.radius * cos(Phi);
								y = 1.4 * info.radius * sin(Phi);
								z = 60 + info.startZ + i2*info.zPitch; 
								dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
								dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
								dstz = z/out->HeaderLength.z;
								mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi, info.inMode);
	
								break;
							}
							case 3: {
								mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi, info.inMode);
	
								x = 1.2 * info.radius * cos(Phi1);
								y = 1.2 * info.radius * sin(Phi1);
								z = info.startZ + i2*info.zPitch; 
								dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
								dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
								dstz = z/out->HeaderLength.z;
								mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi1, info.inMode);
	
								x = 1.4 * info.radius * cos(Phi2);
								y = 1.4 * info.radius * sin(Phi2);
								z = info.startZ + i2*info.zPitch; 
								dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
								dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
								dstz = z/out->HeaderLength.z;
								mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi2, info.inMode);
	
								break;
							}
							default: {
								fprintf(stderr, "Not supported mode in formation: %d\n", info.fm);
								exit(EXIT_FAILURE);
							}
						}
					} else {
						mrcPixelDataGet(out, dstx, dsty, dstz, &data, mrcPixelRePart, mrcPixelHowLinear);
						mrcPixelDataSet(out, dstx, dsty, dstz, data+1.0, mrcPixelRePart);
					}
				}
			}
		break;
		}
		case 3: {
			DEBUGPRINT2("startZ %f, zPitch %f\n",info.startZ, info.zPitch)
			for ( i1 = 0; i1 < info.nHelix; i1++){
				count++;
				Phi  = info.startPhi + i1*info.phiAngle  + i2*info.deltaPhi;
				Phi1 = Phi + 30.0*RADIAN;
				Phi2 = Phi + 60.0*RADIAN;

				DEBUGPRINT3("Phi %f, Phi1 %f, Phi2 %f\n",Phi, Phi1, Phi2)

				fprintf(stderr ,"(%8.3f %8.3f %8.3f) ThickFilaments %d \n",x,y,z,count);
			
				if(info.flagIn) {
					switch(info.fm) {
						case 0: {
							/* First Crown*/
							/* 1 */
							x = info.radius * cos(Phi);
							y = info.radius * sin(Phi);
							z = info.startZ; 
							dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
							dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
							dstz = z/out->HeaderLength.z;
							mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi, info.inMode);

							/* 2 */
							x = info.radius * cos(Phi);
							x = 1.4*info.radius * cos(Phi);
							y = 1.4*info.radius * sin(Phi);
							z = info.startZ; 
							dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
							dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
							dstz = z/out->HeaderLength.z;
							mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi, info.inMode);

							/* 3 */
							x = 1.8*info.radius * cos(Phi);
							y = 1.8*info.radius * sin(Phi);
							z = info.startZ; 
							dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
							dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
							dstz = z/out->HeaderLength.z;
							mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi, info.inMode);

							/* Second Crown*/
							/* 1 */
							x = info.radius * cos(Phi1);
							y = info.radius * sin(Phi1);
							z = info.startZ + info.zPitch; 
							dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
							dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
							dstz = z/out->HeaderLength.z;
							mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi1, info.inMode);
	
							/* 2 */
							x = 1.3*info.radius * cos(Phi1-5*RADIAN);
							y = 1.3*info.radius * sin(Phi1-5*RADIAN);
							z = info.startZ + info.zPitch +25; 
							dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
							dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
							dstz = z/out->HeaderLength.z;
							mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi1, info.inMode);
	
							/* 3 */
							x = 1.6*info.radius * cos(Phi1-10*RADIAN);
							y = 1.6*info.radius * sin(Phi1-10*RADIAN);
							z = info.startZ + info.zPitch +50; 
							dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
							dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
							dstz = z/out->HeaderLength.z;
							mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi1, info.inMode);
	
							/* Third Crown*/
							/* 1 */
							x = info.radius * cos(Phi2);
							y = info.radius * sin(Phi2);
							z = info.startZ + 2*info.zPitch; 
							dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
							dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
							dstz = z/out->HeaderLength.z;
							mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi2, info.inMode);

							/* 2 */
							x = 1.3*info.radius * cos(Phi2+10*RADIAN);
							y = 1.3*info.radius * sin(Phi2+10*RADIAN);
							z = info.startZ + 2*info.zPitch -10; 
							dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
							dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
							dstz = z/out->HeaderLength.z;
							mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi2, info.inMode);

							/* 3 */
							x = 1.6*info.radius * cos(Phi2+20*RADIAN);
							y = 1.6*info.radius * sin(Phi2+20*RADIAN);
							z = info.startZ + 2*info.zPitch -20; 
							dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
							dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
							dstz = z/out->HeaderLength.z;
							mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi2, info.inMode);

							/* First Crown Again */
							/* 1 */
							x = info.radius * cos(Phi);
							y = info.radius * sin(Phi);
							z = info.startZ + 3*info.zPitch; 
							dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
							dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
							dstz = z/out->HeaderLength.z;
							mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi, info.inMode);

							x = 1.4*info.radius * cos(Phi);
							y = 1.4*info.radius * sin(Phi);
							z = info.startZ + 3*info.zPitch; 
							dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
							dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
							dstz = z/out->HeaderLength.z;
							mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi, info.inMode);

							x = 1.8*info.radius * cos(Phi);
							y = 1.8*info.radius * sin(Phi);
							z = info.startZ + 3*info.zPitch; 
							dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
							dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
							dstz = z/out->HeaderLength.z;
							mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi, info.inMode);

							/* Second Crown Again */
							/* 1 */
							x = info.radius * cos(Phi1);
							y = info.radius * sin(Phi1);
							z = info.startZ + 4*info.zPitch; 
							dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
							dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
							dstz = z/out->HeaderLength.z;
							mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi1, info.inMode);
	
							/* 2 */
							x = 1.3*info.radius * cos(Phi1-5*RADIAN);
							y = 1.3*info.radius * sin(Phi1-5*RADIAN);
							z = info.startZ + 4*info.zPitch +25; 
							dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
							dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
							dstz = z/out->HeaderLength.z;
							mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi1, info.inMode);
	
							/* 3 */
							x = 1.6*info.radius * cos(Phi1-10*RADIAN);
							y = 1.6*info.radius * sin(Phi1-10*RADIAN);
							z = info.startZ + 4*info.zPitch +50; 
							dstx = x/out->HeaderLength.x + (out->HeaderN.x-1.0)/2.0;
							dsty = y/out->HeaderLength.y + (out->HeaderN.y-1.0)/2.0;
							dstz = z/out->HeaderLength.z;
							mrcImageDataSet(out, info.in, dstx, dsty, dstz, Phi1, info.inMode);
	


							break;
						}
						default: {
							fprintf(stderr, "Not supported mode in formation: %d\n", info.fm);
							exit(EXIT_FAILURE);
						}
					}
				}
			}
		break;
		}
		default: {
			fprintf(stderr, "Not supported mode in formation: %d\n", info.units);
			exit(EXIT_FAILURE);
		}
	}
}


void
_lmrcImageModelCreateMode2(mrcImage* out)
{

	mrcImageParaTypeReal x,y;

	for(x=0; x<=out->HeaderN.x; x++){
		for(y=0; y<=out->HeaderN.y; y++){
			if(x== out->HeaderN.x/4 && y== out->HeaderN.y/4){
				mrcPixelDataSet(out,x,y,0.0,1.0,mrcPixelRePart);
			}
			
			else if(x== out->HeaderN.x/4+5 && y==out->HeaderN.y/4+5){
				mrcPixelDataSet(out,x,y,0.0,1.0,mrcPixelRePart);
			}
			
			else if(x== out->HeaderN.x/4+10 && y==out->HeaderN.y/4){
				mrcPixelDataSet(out,x,y,0.0,1.0,mrcPixelRePart);
			}
			else{
				mrcPixelDataSet(out,x,y,0.0,0.0,mrcPixelRePart);
			}	
			
		}
	}
}	

void
_lmrcImageModelCreateMode3(mrcImage* out)
{
	double data;
	mrcImageParaTypeReal x,y,z;

	for(x=0; x<=out->HeaderN.x; x++){
		for(y=0; y<=out->HeaderN.y; y++){
			for(z=0; z<=out->HeaderN.y; z++){
				if( SQR(x-out->HeaderN.x/2)
				   +SQR(y-out->HeaderN.y/2)
				   +SQR(z-out->HeaderN.y/2) < SQR(out->HeaderN.x/5.0) ) {
					mrcPixelDataGet(out,x,y,0.0,&data,mrcPixelRePart, mrcPixelHowNearest);
					mrcPixelDataSet(out,x,y,0.0,data+1,mrcPixelRePart);
				}
				if( SQR(x-out->HeaderN.x/2+out->HeaderN.x/5.0)
				   +SQR(y-out->HeaderN.y/2+out->HeaderN.x/5.0)
				   +SQR(z-out->HeaderN.y/2+out->HeaderN.x/5.0) < SQR(out->HeaderN.x/7.5) ) {
					mrcPixelDataGet(out,x,y,0.0,&data,mrcPixelRePart, mrcPixelHowNearest);
					mrcPixelDataSet(out,x,y,0.0,data+1,mrcPixelRePart);
				}
				if( SQR(x-out->HeaderN.x/2-out->HeaderN.x/5.0)
				   +SQR(y-out->HeaderN.y/2-out->HeaderN.x/5.0)
				   +SQR(z-out->HeaderN.y/2-out->HeaderN.x/5.0) < SQR(out->HeaderN.x/5) ) {
					mrcPixelDataGet(out,x,y,0.0,&data,mrcPixelRePart, mrcPixelHowNearest);
					mrcPixelDataSet(out,x,y,0.0,data+1,mrcPixelRePart);
				}
			}
		}
	}
}	

void
_lmrcImageModelCreateMode4(mrcImage* out)
{
	double data;
	mrcImageParaTypeReal x,y,z;

	for(x=0; x<=out->HeaderN.x; x++){
		for(y=0; y<=out->HeaderN.y; y++){
			for(z=0; z<=out->HeaderN.y; z++){
				if( SQR(x-out->HeaderN.x/2)
				   +SQR(y-out->HeaderN.y/2)
				   +SQR(z-out->HeaderN.y/2) < SQR(out->HeaderN.x/8.0) 
				 && -out->HeaderN.y/10.6<z-out->HeaderN.y/2) {
					mrcPixelDataGet(out,x,y,0.0,&data,mrcPixelRePart, mrcPixelHowNearest);
					mrcPixelDataSet(out,x,y,0.0,data+1,mrcPixelRePart);
				}
				if( SQR(x-out->HeaderN.x/2-out->HeaderN.x/4*cos(M_PI/2.0))
				   +SQR(y-out->HeaderN.y/2-out->HeaderN.x/4*sin(M_PI/2.0))
				   +SQR(z-out->HeaderN.y/2) < SQR(out->HeaderN.x/8.0) 
				 && -out->HeaderN.y/10.6<z-out->HeaderN.y/2) {
					mrcPixelDataGet(out,x,y,0.0,&data,mrcPixelRePart, mrcPixelHowNearest);
					mrcPixelDataSet(out,x,y,0.0,data+1,mrcPixelRePart);
				}
				if( SQR(x-out->HeaderN.x/2-out->HeaderN.x/4*cos(M_PI/2.0+M_PI/3.0))
				   +SQR(y-out->HeaderN.y/2-out->HeaderN.x/4*sin(M_PI/2.0+M_PI/3.0))
				   +SQR(z-out->HeaderN.y/2) < SQR(out->HeaderN.x/8.0) 
				 && -out->HeaderN.y/10.6<z-out->HeaderN.y/2) {
					mrcPixelDataGet(out,x,y,0.0,&data,mrcPixelRePart, mrcPixelHowNearest);
					mrcPixelDataSet(out,x,y,0.0,data+1,mrcPixelRePart);
				}
				if( SQR(x-out->HeaderN.x/2-out->HeaderN.x/4*cos(M_PI/2.0-M_PI/3.0))
				   +SQR(y-out->HeaderN.y/2-out->HeaderN.x/4*sin(M_PI/2.0-M_PI/3.0))
				   +SQR(z-out->HeaderN.y/2) < SQR(out->HeaderN.x/8.0) 
				 && -out->HeaderN.y/10.6<z-out->HeaderN.y/2) {
					mrcPixelDataGet(out,x,y,0.0,&data,mrcPixelRePart, mrcPixelHowNearest);
					mrcPixelDataSet(out,x,y,0.0,data+1,mrcPixelRePart);
				}
				if( SQR(x-out->HeaderN.x/2+out->HeaderN.x/8.0)
				   +SQR(y-out->HeaderN.y/2+out->HeaderN.x/8.0)
				   +SQR(z-out->HeaderN.y/2+out->HeaderN.x/8.0) < SQR(out->HeaderN.x/7.5) 
				  && 0<z-out->HeaderN.y/2+out->HeaderN.x/5.0) {
					mrcPixelDataGet(out,x,y,0.0,&data,mrcPixelRePart, mrcPixelHowNearest);
					mrcPixelDataSet(out,x,y,0.0,data+1,mrcPixelRePart);
				}
				if( SQR(x-out->HeaderN.x/2-out->HeaderN.x/4/sqrt(3)*cos(M_PI/2.0-M_PI/6.0))
				   +SQR(y-out->HeaderN.y/2-out->HeaderN.x/4/sqrt(3)*sin(M_PI/2.0-M_PI/6.0))
				   +SQR(z-out->HeaderN.y/2-out->HeaderN.x/5.0) < SQR(out->HeaderN.x/15) 
				   && 0<z-out->HeaderN.y/2-out->HeaderN.x/5.0) {
					mrcPixelDataGet(out,x,y,0.0,&data,mrcPixelRePart, mrcPixelHowNearest);
					mrcPixelDataSet(out,x,y,0.0,data+1,mrcPixelRePart);
				}
				if( SQR(x-out->HeaderN.x/2-out->HeaderN.x/6)
				   +SQR(y-out->HeaderN.y/2+out->HeaderN.x/6)
				   +SQR(z-out->HeaderN.y/2+out->HeaderN.x/6) < SQR(out->HeaderN.x/5) 
				   && out->HeaderN.y/8<z-out->HeaderN.y/2+out->HeaderN.x/6.0) {
					mrcPixelDataGet(out,x,y,0.0,&data,mrcPixelRePart, mrcPixelHowNearest);
					mrcPixelDataSet(out,x,y,0.0,data+1,mrcPixelRePart);
				}
			}
		}
	}
}	
void
_lmrcImageModelCreateMode5(mrcImage* out)
{
	double data;
	double ratio = 0.7;
	mrcImageParaTypeReal x,y,z,r, roffset, rmax, redge, redgeoffset, offset, d, doffset, xx, xxoffset, yy, yyoffset, w, woffset;
	rmax = out->HeaderN.x/8.0;
	offset = sqrt(2.0)*rmax;
	for(x=0; x<=out->HeaderN.x; x++){
		for(y=0; y<=out->HeaderN.y; y++){
			for(z=0; z<=out->HeaderN.y; z++){
				r       = SQR(x-out->HeaderN.x/2       ) +SQR(y-out->HeaderN.y/2);
				roffset = SQR(x-out->HeaderN.x/2-offset) +SQR(y-out->HeaderN.y/2);
				if(0<r) {
					r = sqrt(r);
				}	
				if(0<roffset) {
					roffset = sqrt(roffset);
				}	

				if(SQR((z-out->HeaderN.x/2)/(ratio*rmax)) + SQR(r/rmax) <= 1 
			     && 1<SQR(roffset/rmax) ) {
					mrcPixelDataGet(out,x,y,0.0,&data,mrcPixelRePart, mrcPixelHowNearest);
					mrcPixelDataSet(out,x,y,0.0,data+1,mrcPixelRePart);
				} else if(SQR(r/rmax)<=1 
				 && SQR(roffset/rmax)<=1 ) {

					d  = x-out->HeaderN.x/2;
					yy = y-out->HeaderN.y/2;
					doffset = x-out->HeaderN.x/2-offset;

					xx       = sqrt(SQR(rmax) - SQR(yy));
					xxoffset = offset - sqrt(SQR(rmax) - SQR(yy)); 
					redgeoffset = sqrt(SQR(xxoffset)+SQR(yy));    	
					w = (ratio*rmax*sqrt(1-SQR(redgeoffset/rmax)) - 0)/(xx - xxoffset) ;

				 	if(fabs(z-out->HeaderN.x/2) < w*(xx - d)) {
						mrcPixelDataGet(out,x,y,0.0,&data,mrcPixelRePart, mrcPixelHowNearest);
						mrcPixelDataSet(out,x,y,0.0,data+1,mrcPixelRePart);
					}
				}

				if(SQR((z-out->HeaderN.x/2)/(ratio*rmax)) + SQR(roffset/rmax) <= 1 
			     && 1<SQR(r/rmax) ) {
					mrcPixelDataGet(out,x,y,0.0,&data,mrcPixelRePart, mrcPixelHowNearest);
					mrcPixelDataSet(out,x,y,0.0,data+1,mrcPixelRePart);
				} else if(SQR(roffset/rmax)<=1 
				     && SQR(r/rmax)<=1 ) {

					d  = x-out->HeaderN.x/2;
					yy = y-out->HeaderN.y/2;
					doffset = x-out->HeaderN.x/2-offset;

					xx       = sqrt(SQR(rmax) - SQR(yy));
					xxoffset = offset - sqrt(SQR(rmax) - SQR(yy)); 
					redge    = sqrt(SQR(offset-xx)+SQR(yy));    	
					
					w = (ratio*rmax*sqrt(1-SQR(redge/rmax)) - 0)/(xx-xxoffset) ;

				 	if(fabs(z-out->HeaderN.x/2) < w*(d-xxoffset)) {
						mrcPixelDataGet(out,x,y,0.0,&data,mrcPixelRePart, mrcPixelHowNearest);
						mrcPixelDataSet(out,x,y,0.0,data+1,mrcPixelRePart);
					}
				}
/*
				if(SQR((z-out->HeaderN.x/2)/(0.7*rmax)) + SQR(roffset/rmax) <= 1 
			     && 1<SQR(r/rmax) 
				 && -0.6*rmax < z-out->HeaderN.x/2.0) {
					mrcPixelDataGet(out,x,y,0.0,&data,mrcPixelRePart, mrcPixelHowNearest);
					mrcPixelDataSet(out,x,y,0.0,data+1,mrcPixelRePart);
				} else if(SQR(roffset/rmax)<=1  
			     &&	SQR(r/rmax) <=1
				 && -0.6*rmax<z-out->HeaderN.x/2.0
				 &&	fabs(z-out->HeaderN.x/2) < sqrt(3)*0.7*(rmax -roffset)) {
					mrcPixelDataGet(out,x,y,0.0,&data,mrcPixelRePart, mrcPixelHowNearest);
					mrcPixelDataSet(out,x,y,0.0,data+1,mrcPixelRePart);
				}
*/				
			}
		}
	}
}	
