/*
# lmrcImageMasking.c  1.1
# The latest update : 01/23/97 at 10:38:49
#
#@(#) lmrcImageMasking ver 1.1
#@(#) Created by 
#@(#)
#@(#) Usage : lmrcImageMasking
#@(#) Attention
#@(#)
*/
static char __sccs_id[] = "@(#)lmrcImageMasking ver1.1; Date:97/01/23 @(#)";

#undef DEBUG
#include "genUtil.h"
#include "mrcImage.h"
#include "lmrcImageMasking.h"

void
lmrcImageMasking(mrcImage* out, mrcImage* in, lmrcImageMaskingInfo* linfo, int mode)
{
	mrcImageParaTypeReal x, y;
	double data;
	double sum;
	double count, avg;

	out->Header =  in->Header;
	mrcInit(out, NULL);

	switch(linfo->shape) {
		case lmrcImageMaskingInfoShapeCircle: {
			sum   = 0.0;
			count = 0.0;
			for(x=0; x<out->HeaderN.x; x++) {
				for(y=0; y<out->HeaderN.y; y++) {
					if(SQR((x - out->HeaderN.x/2.0)/(linfo->n.x/2.0)) + SQR((y - out->HeaderN.y/2.0)/(linfo->n.y/2.0)) >= 1) {
						mrcPixelDataGet(in, x, y, 0.0,  &data, mrcPixelRePart, mrcPixelHowNearest);	
						sum += data;
						count ++;
					}
				}
			}
			avg = sum/count;
			for(x=0; x<out->HeaderN.x; x++) {
				for(y=0; y<out->HeaderN.y; y++) {
					if(SQR((x - out->HeaderN.x/2.0)/(linfo->n.x/2.0)) + SQR((y - out->HeaderN.y/2.0)/(linfo->n.y/2.0)) <= 1) {
						mrcPixelDataGet(in, x, y, 0.0,  &data, mrcPixelRePart, mrcPixelHowNearest);	
						data -= avg;
						mrcPixelDataSet(out, x, y, 0.0, data, mrcPixelRePart);	
					} else {
						DEBUGPRINT2("(%f, %f) outside circle\n", x, y);
						mrcPixelDataSet(out, x, y, 0.0, 0.0, mrcPixelRePart);	
					}
				}
			}
			break;
		}
		default: {
			break;
		}
	}
}
