/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% lmrcImageCrystalCreate ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : lmrcImageCrystalCreate 
#%Z% Attention
#%Z%
*/

#include "lmrcImageCrystalCreate.h"


void 
lmrcImageCrystalCreate(mrcImage* out, mrcImage* in, lmrcImageCrystalCreateInfo* info)
{
	mrcImageParaTypeReal x, y, z;
	mrcImageParaTypeReal ix, iy, iz;
	double data;

	out->Header = in->Header;
	out->HeaderN.x *= info->nx;
	out->HeaderN.y *= info->ny;
	out->HeaderN.z *= info->nz;
	mrcInit(out, NULL);

	for(x=0; x<in->HeaderN.x; x++) {
		for(y=0; y<in->HeaderN.y; y++) {
			for(z=0; z<in->HeaderN.z; z++) {
				mrcPixelDataGet(in, x, y, z, &data, mrcPixelRePart, mrcPixelHowNearest);
				for(ix=0; ix<info->nx; ix++) {
					for(iy=0; iy<info->ny; iy++) {
						for(iz=0; iz<info->nz; iz++) {
							mrcPixelDataSet(out, ix*in->HeaderN.x+x, 
												 iy*in->HeaderN.y+y, 
												 iz*in->HeaderN.z+z,
												 data, mrcPixelRePart);
						}
					}
				}
			}
		}
	}
}
