/*
# mrcImageLabeling : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : mrcImageLabeling
# Attention
#   $Loccker$
#  	$State$ 
#
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  
#define GLOBAL_DECLARATION
#include "../inc/config.h"

#define DEBUG
#include "genUtil.h"
#include "mrcImage.h"
#include "lmrcImageLabeling.h"

/*
Example:
typedef struct lmrcImageLabelingInfo {
	float a;
	int   b;
} lmrcImageLabelingInfo;

typedef enum lmrcImageLabelingMode {
	a=0,
	b=1
} lmrcImageLabelingMode;
*/

int
main(int argc, char* argv[]) 
{
	mrcImageLabelingInfo info;
	mrcImage in;
	mrcImage out;

	init0(&info);
    argCheck(&info, argc, argv);
    init1(&info);

	DEBUGPRINT("Program Start\n");
	mrcFileRead(&in, info.In, "", 0);
	lmrcImageLabeling(&out, &in, info.neighbor, info.mode);
	mrcFileWrite(&out, info.Out, "", 0);

	exit(EXIT_SUCCESS);
}

void
additionalUsage()
{
	fprintf(stderr, "----- Additional Usage -----\n");
	lmrcImageLabelingUsage(stderr);
}	
