/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% eosBayesCondition ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : eosBayesCondition 
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%eosBayesCondition ver%I%; Date:%D% %Z%";


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../inc/eosBayes.h"

#define DEBUG
#include "genUtil.h"
#include "String.h"

void eosBayesCondition(FILE* fptIn, eosBayes* d, eosBayesDistributionInfo* llinfo, int mode){

	int i;
	char s[1024];
	
	DEBUGPRINT("File read start\n");
	for(i=0; i<d->numDistribution;i++){
		// read each of min, max, delta, mode, mean, sigma

		DEBUGPRINT2("%d/%d loop\n",i+1,d->numDistribution);
		stringGetFromFile(s, "in main", fptIn, stdout, 3);

		llinfo->min      = stringGetNthRealData(s, 2," \t");
		llinfo->max      = stringGetNthRealData(s, 3," \t");
		llinfo->delta    = stringGetNthRealData(s, 4," \t");
		llinfo->mode     = stringGetNthIntegerData(s, 5," \t");

		llinfo->mean     = stringGetNthRealData(s, 6," \t");
		llinfo->sigma    = stringGetNthRealData(s, 7," \t");

		DEBUGPRINT1("%s\n",s);
		DEBUGPRINT6("min:%f max:%f delta:%f mode:%u mean:%f sigma:%f\n",llinfo->min,llinfo->max,llinfo->delta,llinfo->mode,llinfo->mean,llinfo->sigma);
		eosBayesDistributionInit(&(d->prior[i]),llinfo,0);
		eosBayesDistributionInit(&(d->posterior[i]),llinfo,0);
		eosBayesDistributionInit(&(d->likelihood[i]),llinfo,0);
		eosBayesDistributionInitialProbabilitySet(&(d->prior[i]), llinfo, 0);
	}
	DEBUGPRINT("eosBayesConditon finish\n")

}
