/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% defocuslikelihood ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : defocuslikelihood 
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%defocuslikelihood ver%I%; Date:%D% %Z%";


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include "eosBayes.h"
#include "../inc/ctfInfo.h"
#include "./ctffuncforbayes.h"

#undef DEBUG
#undef DEBUG2
#include "genUtil.h"
#include "String.h"




void defocuslikelihood(ctfforbayes ctf, eosBayes* d, int count, int mode){

  switch(mode){
  
  case 0:
	defocuslikelihoodcaluculationLorentz(ctf, d->likelihood, d->numLikelihood, count, 0);
	break;
	
  default:
	fprintf(stderr,"");
	break;
	
  }

}

void defocuslikelihoodcaluculationLorentz(ctfforbayes ctf, eosBayesDistribution* d, int numLikelihood, int count, int mode){
	float difference;
	float* sum;

	int length;

	int i;
	int j;
	int k;

	int* L;

	DEBUGPRINT("In defocuslikelihood\n");

	length = 1;
	for(i=0;i<numLikelihood;i++){
		length *= d[i].n;
	}



	L = (int *)malloc(sizeof(int)*numLikelihood);
	DEBUGPRINT("L malloc\n");

	sum = (float*)malloc(sizeof(float)*numLikelihood);
	
	DEBUGPRINT("sum malloc\n");

	for(i=0;i<numLikelihood;i++){
//		DEBUGPRINT("sum\n");
		sum[i] = 0;
		for(j=0;j<d[i].n;j++){
//		DEBUGPRINT("prob\n");
			d[i].prob[j] = 0;
		}
	}

	DEBUGPRINT("prob init\n");


	for(j=0;j<length;j++){
	  
	  eosBayesloop(d,L,numLikelihood,j);

	  
	  difference = 0;
	  for(k=0;k<ctf.n;k++){
		if((ctf.rmin<=ctf.R[k]) && (ctf.R[k]<=ctf.rmax)){
		  difference += (ctf.I[k]-ctf.Ii[k][j])*(ctf.I[k]-ctf.Ii[k][j]);
		}
		/*check value*/
#ifdef DEBUG2									
		ctfforbayescheckRvsValue("./data/diffdef",ctf.R[k],(ctf.I[k]-ctf.Ii[k][L[0]])*(ctf.I[k]-ctf.Ii[k][L[0]]),count);
		ctfforbayescheckRvsValue("./data/diffA",ctf.R[k],(ctf.I[k]-ctf.Ii[k][L[1]])*(ctf.I[k]-ctf.Ii[k][L[1]]),count);
		ctfforbayescheckRvsValue("./data/diffB",ctf.R[k],(ctf.I[k]-ctf.Ii[k][L[2]])*(ctf.I[k]-ctf.Ii[k][L[2]]),count);
#endif
		
	  }
	  

	  //DEBUGPRINT3("L[0]:%d L[1]:%d L[2]:%d\n",L[0],L[1],L[2]);
	  for(k=0;k<numLikelihood;k++){
		d[k].prob[L[k]] += 1/(1e-6 + difference);
	  }

	}

	
	
	DEBUGPRINT("likelihood culcu\n");
	
	/*normalization*/
	for(i=0;i<numLikelihood;i++){
	  for(j=0;j<d[i].n;j++){
		sum[i] += d[i].prob[j];
	  }
	}
	

	
	for(i=0;i<numLikelihood;i++){
	  DEBUGPRINT2("%dlikelihood.n:%d\n",i,d[i].n);
	  for(j=0;j<d[i].n;j++){
		d[i].prob[j] /= sum[i];
		DEBUGPRINT2("likelihood%d:%f\n",i,d[i].prob[j]);
	  }
	}
	
	DEBUGPRINT("free\n");
	
	free(L);
	free(sum);
	
}
