/*!
 * jQuery CDN Loader Plugin v0.1
 * http://sourceforge.jp/projects/editors/
 *
 * Copyright 2013 typista
 * Released under the MIT license
 */
(function (factory) {
	if (typeof define === 'function' && define.amd) {
		// AMD. Register as anonymous module.
		define(['jquery'], factory);
	} else {
		// Browser globals.
		factory(jQuery);
	}
}(function ($) {
	var cdnLoaderTimer = new Array();
	var src = new Array();
	var srcLength = new Array();
	var srcIndex = new Array();
	var error = new Array();
	var success = new Array();
	var _load = new Array();
	$.cdnLoader = function(s) {
		if ( typeof s.hash === "undefined" ) {
			s.hash = String( Math.random() ).replace( '.', '' );
		}
		var hash = s.hash;
		s.crossDomain = true;
		s.async = ( typeof s.async !== "undefined" && s.async === false ) ? false : true;
		s.timeout = ( typeof s.timeout !== "undefined" && is_numeric( s.timeout ) ) ? s.timeout : ( 1000 * 30 );
		success[hash] = ( typeof s.success === "function" ) ? s.success : ( typeof success[hash] === "function" ) ? success[hash] : function(e) {};
		error[hash] = ( typeof s.error === "function" ) ? s.error : ( typeof error[hash] === "function" ) ? error[hash] : function(e) {};
		s.error = undefined;
		if ( typeof s.src === "undefined" || s.src === null || s.src === "" ) {
			return;
		}
		if ( typeof srcIndex[hash] === "undefined" ) {
			src[hash] = isArray( s.src ) ? s.src : new Array( s.src );
			srcLength[hash] = src[hash].length;
			srcIndex[hash] = 0;
		}
		if ( srcLength[hash] <= srcIndex[hash] ) {
			clearTimeout(cdnLoaderTimer[hash]);
			var e = { statusText: "[Error] All CDN are not available." };
			error[hash]( e );
			return;
		}
		s.url = src[hash][srcIndex[hash]];
		console.log( s.url );
		srcIndex[hash]++;
		s.dataType = 'jsonp';
		if ( s.url.match(/.*\.css.*/) !== null ) {
			//s.dataType = 'json';
			s.dataType = 'text';
		}
		s.complete = function( data, status ) {
			clearTimeout(cdnLoaderTimer[hash]);
			if ( data.readyState == 4 && data.status == 200 ) {
				success[hash]( data );
			} else {
				if ( typeof _load[hash] !== "undefined" ) {
					_load[hash].remove();
					_load[hash][0] = null;
				}
				if ( srcLength[hash] >= srcIndex[hash] ) {
					$.cdnLoader( s );
				} else {
					var e = { statusText: "[Error] CDN are not found or reached." };
					error[hash]( e );
				}
			}
		};
		cdnLoaderTimer[hash] = null;
		if (s.timeout) {
			cdnLoaderTimer[hash] = setTimeout(function() {
				clearTimeout(cdnLoaderTimer[hash]);
				cdnLoaderTimer[hash] = null;
				var e = {
					statusText : "timeout"
				};
				if ( srcLength[hash] >= srcIndex[hash] ) {
					$.cdnLoader( s );
				} else {
					var e = { statusText: "[Error] Timeout when you include CDN." };
					error[hash](e);
				}
			}, s.timeout);
		}
		$.ajax(s);
 	
		if ( s.url.match(/.*\.css.*/) !== null ) {
			var css = $('<link rel="stylesheet" href="' + s.url + '">');
			$('head').append( css );
			_load[hash] = css;
		} else {
			var $script = $(document.getElementsByTagName('head')[0].firstChild);
			_load[hash] = $script;
		}
		_load[hash][0].onerror = function(e) {
			clearTimeout(cdnLoaderTimer[hash]);
			cdnLoaderTimer[hash] = null;
			if ( typeof _load[hash] !== "undefined" ) {
				_load[hash].remove();
				_load[hash][0] = null;
			}
			if ( srcLength[hash] >= srcIndex[hash] ) {
				$.cdnLoader( s );
			} else {
				var e = { statusText: "[Error] Loading CDN." };
				error[hash](e);
			}
		};
		function is_numeric(input){
			return typeof(input)=='number';
		}
		function isArray( argument ) {
			var ret = false;
			if (_checkArgument('Array', argument)) {
				ret = true;
			}
			return ret;
		}
		function _checkArgument(type, argument) {
			var object = Object.prototype.toString.call(argument).slice(8, -1);
			return argument !== undefined && argument !== null && object === type;
		}
	};
}));
