﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace utility
{
    public static class ErrorHandler
    {
        public static readonly string FILE_ERRORLOG;         //!< エラーログファイルの格納先

        static ErrorHandler()
        {
            string appBasePath = System.AppDomain.CurrentDomain.SetupInformation.ApplicationBase;
            FILE_ERRORLOG = appBasePath + "errlog.txt";
        }

        //-----------------------------------------------------------------------------
        /*!
        @brief 例外処理時のエラー文字列を生成、ログ出力
        @code
        try
        {
            //
        }
        catch (Exception ex)
        {
            MessageBox.Show(ErrorHandler.getErrStr(ex, System.Reflection.MethodBase.GetCurrentMethod().Name));
        }
        @endcode
        */
        //-----------------------------------------------------------------------------
        public static string getErrStr(Exception ex, string strMethodName)
        {
            string errstr = "";
            errstr += "-------------\r\n";
            errstr += "<<例外発生>>\r\n";
            errstr += "関数：" + strMethodName + "\r\n";
            errstr += "種別：" + ex.GetType().FullName + "\r\n";
            errstr += "説明：" + ex.Message + "\r\n";
            errstr += "-------------";
            errstr += ex.StackTrace.Replace("場所", "\r\n場所");
            errstr += "\r\n";
            using (StreamWriter sw = new StreamWriter(ErrorHandler.FILE_ERRORLOG, true))
            {
                sw.Write(errstr + "\r\n\r\n");
            }
            return errstr;
        }
    }
}
