/*
	GR[T[o[
*/

#include	"dscsd_g3.h"
extern	struct	echo_info	*EchoListPnt;		/* GR[ELE[Xg|C^[ */

void	EchoServerHeader (unsigned char header[], unsigned char ipaddress[])
{
	struct	echo_info *e_info;
	struct	echo_info *next;
	struct	TrustTable *trustpnt;
	unsigned char	seq;
	unsigned char 	file_temp[32];

	/* echo_info ̎gpԂ`FbN */
	checkEchoInfo();

	/* wb_[̏ꍇ̓XLbv */
	next = EchoListPnt;
	while (next)
	{
		if (!memcmp(next->ip, ipaddress, 4))
		{
			if (!memcmp(next->msgID, &header[12], 2)) return;
		}
		if (!next->next_pnt) break;
		next=next->next_pnt;
	}
	UpdateMsgServerIP(EchoSenderCallsign, TrustZrCallsign, TrustArCallsign);	/* update Echo Server IP address */

	trustpnt  = start_pnt(&header[42]);	/* Jnʒu𓾂 */
	while (trustpnt)
	{
		if(!memcmp( trustpnt->callsign, &header[42], 8)) break;
		trustpnt = trustpnt-> next_pnt;
	}
	if (!trustpnt) return;

	e_info = malloc (sizeof (struct echo_info));
	memcpy (e_info->ip, ipaddress, 4);
	memcpy (e_info->callsign, &header[42], 8);
	memcpy (e_info->zone, trustpnt->zone_callsign, 8);
	memcpy (e_info->area, trustpnt->area_callsign, 8);
	memcpy (e_info->msgID, &header[12], 2);
	time (&(e_info->update_time));
	e_info->next_pnt = NULL;
	e_info->cnt = 0;
	memset (e_info->FileName, 0x00, 32);
	sprintf (e_info->FileName, "/var/tmp/%2.2x%2.2x%2.2x%2.2x_%2.2x%2.2x.dsv\0",
		ipaddress[0], ipaddress[1], ipaddress[2], ipaddress[3], header[12],header[13]);

	e_info->EchoFile = fopen (e_info->FileName, "wb");
	seq = 0x00;
	seq = CallVoice (e_info->callsign, seq, e_info->EchoFile);

	if (EchoListPnt == NULL)
	{
		EchoListPnt = e_info;
	}
	else
	{
		next->next_pnt = e_info;
	}
}

void	EchoServerVoice (unsigned char voice[], unsigned char ipaddress[])
{
	struct	echo_info *next;
	pthread_t	thread_id;
	int	status;

	next = EchoListPnt;
	while (next)
	{
		if (!memcmp(next->ip, ipaddress, 4))
		{
			if (!memcmp(next->msgID, &voice[12], 2)) break;
		}
		next=next->next_pnt;
	}
	if (!next) return;
	time (&next->update_time);
	next->cnt++;
	fwrite (&voice[15], 12, 1, next->EchoFile);
	if (voice[14] & 0x40)
	{
		fclose(next->EchoFile);
		if (Info)
		{
			fprintf (LogFile, "%s INFO  echo   %8.8s %8.8s %8.8s %d packets\n", loctime(), next->callsign, next->area, next->zone, next->cnt);
			fflush(LogFile); 
		}
		status = pthread_create(&thread_id, NULL, SendEchoMsg,  next);
	}
}

void	*SendEchoMsg(void *arg)
{
	struct	echo_info *voice;
	struct	sockaddr_in VoiceSockAddr;
	int	VoiceSocket;
	int	length;
	uint32_t	ip_temp;
	unsigned char	header[56];
	uint16_t	crc;
	struct	timeval	t1, t2, t3, t4;
	uint16_t	rand_t;
	int	seq;
	int	k;
	int	timeout;
	int	ret;
	struct timeval tv;
	fd_set	readfd;
	FILE	*infile;

	pthread_detach( pthread_self());
	timeout = 0;
	voice = arg;

	/* ̑M\Pbg */
	VoiceSocket = socket(AF_INET, SOCK_DGRAM, 0);
	memset(&VoiceSockAddr, 0x00, sizeof(VoiceSockAddr));
	VoiceSockAddr.sin_port = htons(VoicePort);
	VoiceSockAddr.sin_family = AF_INET;
	memcpy (&VoiceSockAddr.sin_addr.s_addr, &voice->ip, 4);
ReTry:
	memcpy (&header[0], "DSVT", 4);
	header[4] = 0x10;		/*  */
	header[5] = 0x00;		/*  */
	header[6] = 0x00;		/*  */
	header[7] = 0x00;		/*  */

	header[8] = 0x20;
	header[9] = 0x00;		/*  */
	header[10] = 0x01;		/*  */
	header[11] = 0x02;		/*  */	/* 0x02: @햼@@0x03: @햼Ȃ */
	
	rand_t = msgID();
	header[12] = rand_t >>8;	/* pPbgID̃Zbg */
	header[13] = rand_t & 0xff;
	header[14] = 0x80;

	header[15] = 0x00;		/* flag1 */
	header[16] = 0x00;		/* flag2 */
	header[17] = 0x00;		/* flaf3 */
	memcpy (&header[18], voice->area, 8);		/* rpt1 */
	memcpy (&header[26], voice->zone, 8);	/* rpt2 */
	header[33] = 'G';
	memcpy (&header[34], voice->callsign, 8);	/* YourCall */
	memcpy (&header[42], EchoSenderCallsign, 8);	/* MyCall */
	memcpy (&header[50], "ECHO", 4);

	crc = calc_crc (&header[15],  39);
	header[54] = crc >> 8;
	header[55] = crc & 0xff;

	/* wb_̑M */
	for (k = 0 ; k < 5 ; k++)
	{
		sendto (VoiceSocket, header , 56, 0, (struct sockaddr *)&VoiceSockAddr , sizeof (struct sockaddr));
		usleep(500);
	}
	gettimeofday (&t1, NULL);
	t4.tv_sec = 0;
	t4.tv_usec = 20000;		/* 20 m sec */	
	timeradd (&t1, &t4, &t3);
	t1.tv_sec = t3.tv_sec;
	t1.tv_usec = t3.tv_usec;

	header[14] = 0x00;
	seq = 0;
	header[4] = 0x20;
	infile = fopen (voice->FileName, "rb");
	
	while (1)
	{
		if (BusyCheck(voice->ip))
		{
			fclose(infile);
			if (timeout++ > 300)
			{
				unlink (voice->FileName);
				return;
			}
			sleep(1);
			goto ReTry;
		}

		gettimeofday (&t2, NULL);
		if (timercmp (&t2, &t1, >))
		{
			if (fread (&header[15], 12, 1, infile) != 1) break;
			/* M */
			sendto (VoiceSocket, header , 27, 0, (struct sockaddr *)&VoiceSockAddr , sizeof (struct sockaddr));
			header[14]++;
			if (header[14] > 20) header[14] = 0x00;
			timeradd (&t1, &t4, &t3);
			t1.tv_sec = t3.tv_sec;
			t1.tv_usec = t3.tv_usec;
			seq++;
		}
		else
		{
			usleep (2000);	/* wait 2 m sec */
		}
	}
	fclose (infile);
	unlink (voice->FileName);
	memset(voice->FileName, 0x00, 32);

	/* Xgt[̑M */
	header[24] = 0x55;
	header[25] = 0x55;
	header[26] = 0x55;
	sendto (VoiceSocket, header , 27, 0, (struct sockaddr *)&VoiceSockAddr , sizeof (struct sockaddr));
	header[14]++;
	if (header[14] > 20) header[14] = 0x00;
	header[14] |= 0x40;
	header[15] = 0x55;
	header[16] = 0xc8;
	header[17] = 0x7a;
	memset (&header[18], 0x00, 9);
	sendto (VoiceSocket, header , 27, 0, (struct sockaddr *)&VoiceSockAddr , sizeof (struct sockaddr));
}

/*
	LbZ[W𑗐Mpt@CɏށB
	uxx1xx ́@7M3TJZ GR[T[o[łB̃bZ[WɈEMbZ[W𑗐M܂v
*/
unsigned char	CallVoice (unsigned char callsign[], unsigned char seq, FILE *EchoFile)
{
	int	i;
	int	k;
	FILE	*VoiceFile;
	unsigned char	buff[12];
	unsigned char	NullVoice0[12] = {0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x55,0x2d,0x16};
	unsigned char	NullVoice1[12] = {0x9e,0x8d,0x32,0x88,0x26,0x1a,0x3f,0x61,0xe8,0x16,0x29,0xf5};
	unsigned char FileName[26] = {"/etc/dscsd_g3/audio/*.dsv\0"};

	for (i = 0 ; i < 8 ; i++)
	{
		if (callsign[i] != 0x20)
		{
			FileName[20] = callsign[i];
			VoiceFile = fopen (FileName, "rb");
			while (fread (buff, 12, 1, VoiceFile))
			{
				if (seq == 0) memcpy (&buff[9], &NullVoice0[9], 3);
				else	memcpy (&buff[9], &NullVoice1[9], 3);
				fwrite (buff, 12, 1, EchoFile);
				seq++;
				if (seq >= 21) seq = 0;
			} 
			fclose (VoiceFile);
		}
		else
		{
			for (k = 0 ; k < 5 ; k++)
			{
				if (seq == 0) fwrite (NullVoice0, 12, 1, EchoFile);
				else	fwrite (NullVoice1, 12, 1, EchoFile);
				seq++;
				if (seq >= 21) seq = 0;
			}
		}
	}
	VoiceFile = fopen ("/etc/dscsd_g3/audio/mycall01.dsv", "rb");
	while (fread (buff, 12, 1, VoiceFile))
	{
		if (seq == 0) memcpy (&buff[9], &NullVoice0[9], 3);
		else	memcpy (&buff[9], &NullVoice1[9], 3);
		fwrite (buff, 12, 1, EchoFile);
		seq++;
		if (seq >= 21) seq = 0;
	} 
	fclose (VoiceFile);

	/* ̃pPbgēpPbgɂȂ悤Ƀ_~[} */
	while (seq != 0)
	{
		fwrite (NullVoice1, 12, 1, EchoFile);
		seq++;
		if (seq >= 21) seq = 0;
	}

	return seq; 
}

/*
	
*/
void	checkEchoInfo(void)
{
	struct	echo_info	*next;
	struct	echo_info	*save;
	struct	echo_info	*before;


	next = EchoListPnt;
	before = NULL;
	while (next)
	{
		if (!next->FileName[0])
		{
			if (before)
			{
				save = next;
				before->next_pnt = next->next_pnt;
				free (save);
				next = before->next_pnt;
			}
			else
			{
				save = next;
				EchoListPnt = next->next_pnt;
				free (save);
				if (!EchoListPnt) return;
				next = EchoListPnt;
				before = NULL;
			}
		}
		else
		{
			before = next;
			next = next->next_pnt;
		}
	}
}

