﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;

namespace Sasa.QualityTools.DrFx.Explorer.Report
{
    /// <summary>
    /// 違反メッセージが何に対する違反なのかを表します。
    /// </summary>
    public enum WarningTarget
    {
        /// <summary>
        /// 対象が不明であることを表します。
        /// </summary>
        Unknown = 0,

        /// <summary>
        /// アセンブリが対象であることを表します。
        /// </summary>
        Assembly,

        /// <summary>
        /// 名前空間が対象であることを表します。
        /// </summary>
        Namespace,

        /// <summary>
        /// 型が対象であることを表します。
        /// </summary>
        Type,

        /// <summary>
        /// メンバーが対象であることを表します。
        /// </summary>
        Member
    }
}
