﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;
using System.Runtime.Serialization;

namespace Sasa.QualityTools.DrFx.Core
{
    /// <summary>
    /// FxCopCmd.exe プロセスオブジェクトを生成するための設定値に不正な値が含まれていたことを表す例外です。
    /// </summary>
    [Serializable]
    public sealed class ValidationException : Exception
    {
        /// <summary>
        /// インスタンスを初期化します。
        /// </summary>
        public ValidationException()
        {
        }

        /// <summary>
        /// 指定されたメッセージを使用して、インスタンスを初期化します。
        /// </summary>
        /// <param name="message">例外に関する情報を表すメッセージ。</param>
        public ValidationException(string message)
            : base(message)
        {
        }

        /// <summary>
        /// 指定されたメッセージと例外情報を使用して、インスタンスを初期化します。
        /// </summary>
        /// <param name="message">例外に関する情報を表すメッセージ。</param>
        /// <param name="innerException">この例外が発生する原因となった例外。</param>
        public ValidationException(string message, Exception innerException)
            : base(message, innerException)
        {
        }

        /// <summary>
        /// シリアライズされたデータを使用して、インスタンスを初期化します。
        /// </summary>
        /// <param name="info">シリアライズされたデータ。</param>
        /// <param name="context">シリアライズストリーミング。</param>
        private ValidationException(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {
        }
    }
}
