//	yaneTimer.cpp

// Copyright yaneurao 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "stdafx.h"
#include "yaneTimer.h"

//////////////////////////////////////////////////////////////////////////////
int			CTimeBase::m_nRef = 0;			//	QƃJEg
bool		CTimeBase::m_bUseTGT;
TIMECAPS	CTimeBase::m_dwTimeCaps;
//MMTIME		CTimeBase::m_mmtime;
CTimeBase	CTimeBaseInitializer;			//	NCTimeBase::CTimeBase(void)Ăяo
CTimeBase __timebase_dummy;	// RXgN^ŏ邽߂̂

CTimeBase::CTimeBase(void) {
	if (::timeGetDevCaps(&m_dwTimeCaps,sizeof(TIMECAPS))!=TIMERR_NOERROR) {
		//	ȂH^C}Ă̂H
		m_dwTimeCaps.wPeriodMin = 1;	//	̂ɂȂ:p
		m_bUseTGT	= false;			// GetTickCountgp
		return ;
	}
	if (m_dwTimeCaps.wPeriodMin>=10) {
		//	傫ƎĝɂȂ
		m_dwTimeCaps.wPeriodMin = 1;		//	̂ɂȂ:p
		m_bUseTGT	= false;		// GetTickCountgp
	} else {
		m_bUseTGT	= true;			// timeGetTimegp
//		m_mmtime.wType = TIME_MS;	//	timeGetSystemTime
	}
}

//////////////////////////////////////////////////////////////////////////////

//	timeBeginPeriodtimeEndPeriod͓\ɂđΉ邱ƁB
//	܂A\ɑ΂Ă̓lXeBOoȂBitAZĒׂj

int CTimeBase::timeBeginPeriodMin(void){

	//---	iRXgN^łĂ̂Ɠej
	::timeGetDevCaps(&m_dwTimeCaps,sizeof(TIMECAPS));
	if (m_dwTimeCaps.wPeriodMin>=10) {
	//	傫ƎĝɂȂ
		m_dwTimeCaps.wPeriodMin = 1;		//	̂ɂȂ:p
		m_bUseTGT	= false;		// GetTickCountgp
	} else {
		m_bUseTGT	= true;			// timeGetTimegp
//		m_mmtime.wType = TIME_MS;	//	timeGetSystemTime
	}
	//---

	if (m_nRef++==0 && m_bUseTGT) {
		// timeGetTimegȂȂtimeBeginPeriod͖Ӗ
		::timeBeginPeriod(m_dwTimeCaps.wPeriodMin);
	}
	return m_dwTimeCaps.wPeriodMin;
}

void CTimeBase::timeEndPeriodMin(void){
	if (--m_nRef==0 && m_bUseTGT) {
		::timeEndPeriod(m_dwTimeCaps.wPeriodMin);
	}
}

//////////////////////////////////////////////////////////////////////////////

set<CTimer*>	CTimer::m_aTimer;	//	SCX^X̃`F[

CTimer::CTimer(void){
	m_aTimer.insert(this);	//	`FCɃCX^Xǉ
	Reset();
}

CTimer::~CTimer(){
	m_aTimer.erase(this);
}

DWORD CTimer::Get(void) {
	if (m_bPaused>0) return m_dwPauseTime-m_dwOffsetTime;
	return (DWORD)(CTimeBase::timeGetTime()-m_dwOffsetTime);
}

void CTimer::Set(DWORD dw) {
	if (m_bPaused>0) {
		//	񂩂ȁ`H
		m_dwOffsetTime = m_dwPauseTime-dw;
	} else {
		m_dwOffsetTime = (DWORD)(CTimeBase::timeGetTime() - dw);
	}
}

// Ԃ𒲐 by Nickle
void CTimer::Adjust(int off){

	m_dwOffsetTime -= off;

}

void CTimer::Reset(void) {
	m_dwOffsetTime = CTimeBase::timeGetTime();
	m_bPaused = 0;
}

// |[YĂꔭŉł悤 by Nickle
void CTimer::Pause(void){
	if (m_bPaused == 0) {
	//	Pause
		m_dwPauseTime = CTimeBase::timeGetTime();
		m_bPaused++;
	}
}

void CTimer::Restart(void){
	if (m_bPaused == 1) {
	//	Pause
		m_dwOffsetTime += CTimeBase::timeGetTime() - m_dwPauseTime;
		m_bPaused--;
	}
}

//////////////////////////////////////////////////////////////////////////////
LRESULT CTimer::PauseAll(void){
	if (m_aTimer.empty()) return 0;
	for (set<CTimer*>::iterator it=m_aTimer.begin();it!=m_aTimer.end();it++){
		(*it)->Pause();
	}
	return 0;
}

LRESULT CTimer::RestartAll(void){
	if (m_aTimer.empty()) return 0;
	for (set<CTimer*>::iterator it=m_aTimer.begin();it!=m_aTimer.end();it++){
		(*it)->Restart();
	}
	return 0;
}

//////////////////////////////////////////////////////////////////////////////
//	class CTimerEx

// static members..
DWORD	CTimerEx::m_dwTimeGetTime = 0;

DWORD	CTimerEx::Get(void){
	if (m_bPaused>0) return m_dwPauseTime-m_dwOffsetTime;
	return (DWORD)(m_dwTimeGetTime-m_dwOffsetTime);
}

void	CTimerEx::Flush(void){
	m_dwTimeGetTime = CTimeBase::timeGetTime();
}

void	CTimerEx::Set(DWORD dw) {
	if (m_bPaused>0) {
		//	񂩂ȁ`H
		m_dwOffsetTime = m_dwPauseTime-dw;
	} else {
		m_dwOffsetTime = (DWORD)(m_dwTimeGetTime - dw);
	}
}

void	CTimerEx::Reset(void) {
	m_dwOffsetTime = m_dwTimeGetTime;
	m_bPaused = 0;
}

void	CTimerEx::Pause(void){
	if (m_bPaused++ == 0) {
	//	Pause
		m_dwPauseTime = m_dwTimeGetTime;
	}
}

void	CTimerEx::Restart(void){
	if (--m_bPaused == 0) {
	//	Pause
		m_dwOffsetTime += m_dwTimeGetTime - m_dwPauseTime;
	}
}
