// yaneMIDIInput.h
//	 This is a MIDI input wrapper.
//		programmed by yaneurao(M.Isozaki) '99/08/26

// Copyright yaneurao 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef __yaneMIDIInput_h__
#define __yaneMIDIInput_h__

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#pragma comment(lib,"winmm.lib")
#include <mmsystem.h>

#include "yaneKeyBase.h"
#include "yaneWrapBase.h"

#define MAX_MIDI_CH 8		//	8`lŏ\H

class CMIDIInput : public CKeyBase,public CWrapBase {
	//////////////////////////////////////////////////////////////////
public:
	//	from CWrapBase
	LRESULT Initialize(HWND hWnd,HINSTANCE hInst); // 
	LRESULT Terminate(void);  // I͖IɂׂI

	//	from CKeyBase
	LRESULT GetKeyState(void); // 256oCgԂǂݍށBP.B.Mod.QlIɎ擾ł悤ɕύX by Nickle
	char*	GetKeyName(int key);	// keyԂ̃L[̖O擾 by Nickle

	BYTE	GetVelocity(int key) { return m_byKeyBuffer[m_nKeyBufNo][key]; }

	//////////////////////////////////////////////////////////////////
protected:
	//	MIDI̓R[obN֐
	static void CALLBACK MidiInProc(HMIDIIN hMidiIn, WORD wMsg, DWORD dwInstance,
									DWORD dwParam1, DWORD dwParam2);

	//////////////////////////////////////////////////////////////////
protected:
	HMIDIIN hMidiIn[MAX_MIDI_CH];
	int		nNumDevices;
	static BYTE	m_byKeyBuffer2[256];		//	real time key buffer for MidiInProc
};

#endif
