// Copyright yaneurao 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "yaneCDDA.h"
#include "yaneError.h"

HRESULT CCDDA::Initialize(HWND hWnd,HINSTANCE hInst) {
	m_hWnd = hWnd;
	MsgHook(hWnd);
	return 0;
}

HRESULT CCDDA::Terminate(void){
	MsgUnhook();
	return 0;
}

CCDDA::CCDDA(void) {
	m_bLoopPlay	= false;
	m_uDeviceID	= 0;
	m_nSongMax	= 0;
	m_bOpen		= false;
	m_szDrive[0]= '\0';

}

CCDDA::~CCDDA() {
	if (m_bOpen) Close(); // ĂіYĂ܂Ł[
}

HRESULT	CCDDA::Open(char* szDrive/* = NULL */) {	// CD Info̎擾˂
	bool bAgain = false;	// CloseQxȂ߂̃tO
	if (m_bOpen) {
		Close();	// CloseɌĂԂ[H[B񂩁H
		bAgain = true;
	}

retry: ;

	MCI_OPEN_PARMS open;
	open.lpstrDeviceType	= "cdaudio";

	DWORD fdwCmd = MCI_OPEN_TYPE;

	if(szDrive!=NULL)
	{
		if(szDrive[0]!='\0')
		{
			strcpy(m_szDrive, szDrive); // Open悤ƂhCu̕ۑ by Nickle

			open.lpstrElementName = szDrive;
			fdwCmd |= MCI_OPEN_ELEMENT;
//			wsprintf( szAliasName, TEXT("CD%lu:"), GetCurrentTime());
//			open.lpstrAlias = szAliasName;
		}
		else
			m_szDrive[0] = '\0';
	}else
		m_szDrive[0] = '\0';

	if (mciSendCommand(0, MCI_OPEN, fdwCmd, (DWORD)&open)){
		if (bAgain) {
			InnerLog("CCDDA::OpenMCI_OPENɎs");
			// CDhCu݂ȂꍇÃG[î͂j
			return 1;
		} else {
			// 邢́AClosełւĂւ̂ႤH
			m_bOpen = true;
			Close();
			bAgain = true;
			goto retry;
		}
	}

	m_uDeviceID = open.wDeviceID;

	// `Ƀ~bɂĂ݂() by Nickle
	MCI_SET_PARMS parm;
	parm.dwTimeFormat = MCI_FORMAT_MILLISECONDS;
	if (mciSendCommand(m_uDeviceID,MCI_SET,MCI_SET_TIME_FORMAT,(DWORD)&parm)){
		InnerLog("CCDDA::OpenMCI_SET(MCI_SET_TIME_FORMAT)Ɏs");
		return 2;	// CDĂȂꍇÃG[
	}

	// status cdaudio number of tracks
	MCI_STATUS_PARMS status;
	status.dwItem = MCI_STATUS_NUMBER_OF_TRACKS;
	if (mciSendCommand(m_uDeviceID,MCI_STATUS,MCI_STATUS_ITEM,(DWORD)&status)){
		InnerLog("CCDDA::OpenMCI_STATUS(MCI_STATUS_NUMBER_OF_TRACKS)Ɏs");
		return 2;	// CDĂȂꍇÃG[
	}
	m_nSongMax = status.dwReturn;

	// status cdaudio length
	status.dwItem = MCI_STATUS_LENGTH;
	if (mciSendCommand(m_uDeviceID,MCI_STATUS,MCI_STATUS_ITEM,(DWORD)&status)){
		InnerLog("CCDDA::OpenMCI_STATUS(MCI_STATUS_LENGTH)Ɏs");
		return 3;
	}
	m_dwSongLength[0] = status.dwReturn;

	for(int i=1;i<=m_nSongMax;i++){
		// status cdaudio position track
		status.dwItem	= MCI_STATUS_POSITION;
		status.dwTrack	= i;
		if (mciSendCommand(m_uDeviceID,MCI_STATUS,MCI_STATUS_ITEM|MCI_TRACK,(DWORD)&status)){
			InnerLog("CCDDA::OpenMCI_STATUS(MCI_STATUS_POSITION)Ɏs");
			return 4;
		}
		m_dwSongStart[i] = status.dwReturn;

		// status cdaudio length track
		status.dwItem	= MCI_STATUS_LENGTH;
		status.dwTrack	= i;
		if (mciSendCommand(m_uDeviceID,MCI_STATUS,MCI_STATUS_ITEM|MCI_TRACK,(DWORD)&status)){
			InnerLog("CCDDA::OpenMCI_STATUS(MCI_STATUS_LENGTH)Ɏs");
			return 5;
		}
		m_dwSongLength[i] = status.dwReturn;
	}

	// OpenɎsĂAĐłȂ̂...
	m_bOpen = true;

	return 0;
}

HRESULT	CCDDA::Close(void){
	if (!m_bOpen) return 0; // OpenĂȂ̂Close̓iZX
	if (m_bNowPlay) Stop();	// stopȂClosełȂ[

	// close cdaudio
	mciSendCommand(m_uDeviceID,MCI_CLOSE,0,(DWORD)NULL);

	m_bOpen = false; // CLOSEˁ[I
//	m_szDrive[0] = '\0';
	return 0;
}

HRESULT CCDDA::Play(void){	// S
	return Play(1,m_nSongMax);	// SȂȂ̂
}

HRESULT CCDDA::Play(int n){ // w̃gbNĐ
	return Play(n,n); // PȂȂ̂
}

HRESULT CCDDA::Play(int n,int m){ // w̃gbNwgbN̍Đ
	if (!m_bOpen)
	{
		if (Open(m_szDrive))
		{
			InnerLog("CCDDA::PlayŁAOpenɎsB");
			return 1;		// OpenĂȂI
		}
	}
	
	if (m > m_nSongMax || n<0 || m<0){
		InnerLog("CCDDA::PlayōĐgbNőgbN𒴂Ă܂");
		return 2;
	}

	if (n < m_nSongMax && m<m_nSongMax) {
		// play cdaudio from ȓ to ̋ȓ
		MCI_PLAY_PARMS play;
		play.dwFrom		= m_dwSongStart[n];
		play.dwTo		= m_dwSongStart[m+1];
		play.dwCallback = (DWORD) m_hWnd;

		m_nStartPos	= play.dwFrom;
		m_nEndPos	= play.dwTo;

		if (mciSendCommand(m_uDeviceID,MCI_PLAY,MCI_FROM|MCI_TO|MCI_NOTIFY,(DWORD)&play)){
			InnerLog("CCDDA::PlayMCI_PLAYɎs");
			return 3;
		}
	} else {
		// play cdaudio from ȓ
		MCI_PLAY_PARMS play;
		play.dwFrom		= m_dwSongStart[n];
		play.dwCallback = (DWORD) m_hWnd;

		m_nStartPos	= play.dwFrom;
		m_nEndPos	= ~0;	// Infinity

		if (mciSendCommand(m_uDeviceID,MCI_PLAY,MCI_FROM|MCI_NOTIFY,(DWORD)&play)){
			InnerLog("CCDDA::PlayMCI_PLAYɎs");
			return 3;
		}
	}

	m_bNowPlay = true;

	return 0;
}

HRESULT CCDDA::PlayDW(DWORD n,DWORD m){ // w̃|WVw|WV̍Đ
	if (!m_bOpen) {
		InnerLog("CCDDA::PlayDWAOpenĂȂ̂ɌĂяo܂");
		return 1;		// OpenĂȂI
	}

	if (m != ~0) {	// m!=~0(infinity)
		// play cdaudio from ȓ to ̋ȓ
		MCI_PLAY_PARMS play;
		play.dwFrom		= n;
		play.dwTo		= m;
		play.dwCallback = (DWORD) m_hWnd;

		m_nStartPos	= n;
		m_nEndPos	= m;

		if (mciSendCommand(m_uDeviceID,MCI_PLAY,MCI_FROM|MCI_TO|MCI_NOTIFY,(DWORD)&play)){
			InnerLog("CCDDA::PlayDWMCI_PLAYɎs");
			return 2;
		}
	} else {
		// play cdaudio from ȓ
		MCI_PLAY_PARMS play;
		play.dwFrom		= n;
		play.dwCallback = (DWORD) m_hWnd;

		m_nStartPos	= n;
		m_nEndPos	= ~0;	// Infinity

		if (mciSendCommand(m_uDeviceID,MCI_PLAY,MCI_FROM|MCI_NOTIFY,(DWORD)&play)){
			InnerLog("CCDDA::PlayDWMCI_PLAYɎs");
			return 2;
		}
	}

	m_bNowPlay = true;
	return 0;
}


HRESULT	CCDDA::Stop(void){
	if (!m_bOpen) {		// [
		InnerLog("CCDDA::StopAOpenĂȂ̂ɌĂяo܂");
		return 1;		// OpenĂȂI
	}
	if (!IsPlay()) {	// ĐĂȂ̂StopȂ
//		InnerLog("CCDDA::StopAĐłȂ̂ɌĂяo܂");
		return 2;
	}
	m_bNowPlay = false;

	// stop cdaudio
	mciSendCommand(m_uDeviceID,MCI_STOP,0,(DWORD)NULL);

	return 0;
}

HRESULT	CCDDA::Pause(void){
	m_bPaused = false;
	if (!m_bOpen) {
	//	InnerLog("CCDDA::PauseAOpenĂȂ̂ɌĂяo܂");
		return 1;		// OpenĂȂI
	}
	if (!IsPlay()) return 2;	// ĐĂȂ̂PauseȂ

	if (GetCurrentPos(m_nPausePos)) {
		InnerLog("CCDDA::PauseGetCurrentPosɎs");
		return 3;
	}

	Stop();

	m_bPaused = true;
	return 0;
}

HRESULT	CCDDA::Replay(void){
	if (!m_bOpen) return 1;		// OpenĂȂI
	// PausePosۑĂ̂ŁA
	// Pause->Stop->Close->Open->ReplayƂ΂CD~ĂvI
	// {́APauseĂ邩̃`FbNKvAȂق
	// ֗ȂƂ̂ŁA킴ƂȂB

	PlayDW(m_nPausePos,m_nEndPos);	// ĐĊJ
	return 0;
}

HRESULT	CCDDA::GetCurrentPos(DWORD &dw){
	if (!m_bOpen) { dw = 0; return 1; }		// OpenĂȂI

	// ݂̍Đ|WV𓾂
	MCI_STATUS_PARMS status;
	status.dwItem = MCI_STATUS_POSITION;
	if (mciSendCommand(m_uDeviceID,MCI_STATUS,MCI_STATUS_ITEM,(DWORD)&status)){
		InnerLog("CCDDA::GetCurrentPosMCI_STATUS(MCI_STATUS_POSITION)Ɏs");
		dw = 0;
		return 2;	// CDĂȂꍇÃG[
	}

	dw = status.dwReturn;
	return 0;
}

int CCDDA::GetCurrentTrack(void){ // ݍĐ̃gbNԍ𓾂 by Nickle

	if(!IsPlay())
		return(-1); // ĐĂȂ

	DWORD pos;
	GetCurrentPos(pos); // ̂łƒx

	for(int i=1;m_dwSongStart[i]<=pos;i++); // Đ̋Ȕԍ(+1)𒲂ׂ

	return(i-1);

}

HRESULT	CCDDA::GetTimeFormat(DWORD &dw){
	if (!m_bOpen) { dw = 0; return 1; }		// OpenĂȂI

	// ݂̎`𓾂 by Nickle
	MCI_STATUS_PARMS status;
	status.dwItem = MCI_STATUS_TIME_FORMAT;
	if (mciSendCommand(m_uDeviceID,MCI_STATUS,MCI_STATUS_ITEM,(DWORD)&status)){
		InnerLog("CCDDA::GetCurrentPosMCI_STATUS(MCI_STATUS_TIME_FORMAT)Ɏs");
		dw = 0;
		return 2;	// CDĂȂꍇÃG[
	}

	dw = status.dwReturn;
	return 0;
}

HRESULT	CCDDA::LoopPlay(void){
	if (m_bLoopPlay) {
		return PlayDW(m_nStartPos,m_nEndPos);
	} else {
		return Stop();
	}
}

void	CCDDA::SetLoopMode(bool bLoop){
	m_bLoopPlay = bLoop;
}

int		CCDDA::GetSongMax(void){
	return m_nSongMax;
}

bool	CCDDA::IsPlay(void){
	return m_bNowPlay;
}
bool	CCDDA::IsOpen(void){	// I[vł by Nickle
	return m_bOpen;
}

//////////////////////////////////////////////////////////////////////////////

// WM_MCINOTIFY̒ʒm󂯎Kv
LRESULT CCDDA::WndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam){
	if (hWnd!=m_hWnd) return 0;
	switch(uMsg){
	case MM_MCINOTIFY : {
		// ̃bZ[WCD̂񂩁H
		if (lParam!=(LPARAM)m_uDeviceID) return 0; // ႤI

		// StopŒ~Ƃ́AMCI_NOTIFY_ABORTED
		if (wParam==MCI_NOTIFY_SUCCESSFUL){
			mciSendCommand(m_uDeviceID,MCI_CLOSE,0,(DWORD)NULL);
			LoopPlay();
			return 1;
		}
	}

	} // end switch

	return 0;
}
