// DDR.cpp : AvP[Vp̃Gg |Cg̒`

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "DDR.h"

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{

	// ONbVnh
	CCrashHandler ch;

	// dN`FbN
	CMutex mutex;
	if(mutex.Open("Delight_Running")==1)
	{
		// ɋNĂ̂ŏIđdNh~
		return 0;
	}

	// vOIɃ[N
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF);

	// [NA
	// {}̔ԍƂ̃mۂƂbreak
	// ƎvǁAAEgvbgEBhE̊YsNbN邾ł炵
	// _CrtSetBreakAlloc(2954);

	if(!InitApp(hInstance))
	{
		QuitGame(hmainwnd);
		return 0;
	}

/*	char szFile[MAX_PATH];
	szFile[0] = '\0';

	BOOL bIgSpace = FALSE; // Xy[XtO(""ň͂Ăꍇ)

	if(lpCmdLine[0]!='\0')
	{
		int i=0;
		int j=0;

		while( (lpCmdLine[i]!=' ' || bIgSpace) && lpCmdLine[i]!='\0' ) // IvV̍ŏ̂ЂƂ擾
		{
			if(lpCmdLine[i] == '\"')
				bIgSpace = !bIgSpace;
			else
			{
				szFile[j] = lpCmdLine[i];
				j++;
			}

			i++;

		}
		szFile[j] = '\0';
	}

*/

	char szFile[MAX_PATH]; // NɓǂݍBMSt@C
	szFile[0] = '\0';

	// tH_At@CƂԍŌ̂ݔF
	// ݔrȃIvVl
    for(int i=0; i<__argc; i++)
    {
//		Notice(__argv[i]);
		char cmdLine[MAX_PATH];
		strcpy(cmdLine, __argv[i]);

		if(CheckType(cmdLine)==TYPE_LNK)
		{
			// V[gJbg̃N
			char buf[MAX_PATH];
			WIN32_FIND_DATA wfd;
			if(SUCCEEDED(GetShortcutLink(cmdLine, buf, MAX_PATH, &wfd)))
			{
				strcpy(cmdLine, buf);
			}
		}

		if(IsFolder(cmdLine))
		{
//			strcpy(szSearchPath[0], __argv[i]);
			szDropPathArray.push_back(cmdLine);
		}

		if(CheckType(cmdLine)==TYPE_BMS || CheckType(cmdLine)==TYPE_MSD)
		{
//			strcpy(szFile, cmdLine);
			szDropPathArray.push_back(cmdLine);
		}

		if(CheckType(cmdLine)==TYPE_LST)
		{
			strcpy(szLstFile, cmdLine);
			Juke.SetCacheFile(szLstFile);
			g_bCacheDrop = TRUE;
		}

//		if(CheckType(cmdLine)==TYPE_CFG) InitAppōs
//			strcpy(szCfgFile, cmdLine);

		if(_stricmp(cmdLine, "/noap")==0)
			Cfg["AutoPlay"] = opt.iAutoPlay = 0;

		if(_stricmp(cmdLine, "/ap1")==0)
			Cfg["AutoPlay"] = opt.iAutoPlay = 1;

		if(_stricmp(cmdLine, "/ap2")==0)
			Cfg["AutoPlay"] = opt.iAutoPlay = 2;

		if(_stricmp(cmdLine, "/apb")==0)
			Cfg["AutoPlay"] = opt.iAutoPlay = 3;

		if(_stricmp(cmdLine, "/apa")==0)
			Cfg["AutoPlay"] = opt.iAutoPlay = 4;

		if(_stricmp(cmdLine, "/bm4")==0)
			Cfg["Mode"] = opt.iMode = MD_BM_4;

		if(_stricmp(cmdLine, "/bm5")==0)
			Cfg["Mode"] = opt.iMode = MD_BM_5;

		if(_stricmp(cmdLine, "/bm7")==0)
			Cfg["Mode"] = opt.iMode = MD_BM_7;

		if(_stricmp(cmdLine, "/ddr4")==0)
			Cfg["Mode"] = opt.iMode = MD_DDR_4;

		if(_stricmp(cmdLine, "/ddr6")==0)
			Cfg["Mode"] = opt.iMode = MD_DDR_6;

		if(_stricmp(cmdLine, "/bga")==0)
			Cfg["BackGroundAnime"] = opt.bBgAnime = TRUE;

		if(_stricmp(cmdLine, "/nobga")==0)
			Cfg["BackGroundAnime"] = opt.bBgAnime = FALSE;

		if(_stricmp(cmdLine, "/bmsa")==0)
			Cfg["BMSAnime"] = opt.bBMSA = TRUE;

		if(_stricmp(cmdLine, "/nobmsa")==0)
			Cfg["BMSAnime"] = opt.bBMSA = FALSE;

		if(_stricmp(cmdLine, "/event")==0)
			g_EventMode = TRUE;

	}
//	LoadConfig();
	OptionDispatch();

    // DirectDrawgpAvP[ṼbZ[W[v
	MSG msg;
    while (TRUE)
	{
        if (PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))	// L[ɃbZ[W
		{
			// bZ[WEď
			{
				BOOL res = GetMessage(&msg, NULL, 0, 0);
				if (res==0 || res==-1)
					break; // WM_QUIT or Error
			}

TransMes:
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
        else	// Ȃ΃C
		{
            // AvP[ṼC
            if (bIsActive)
			{
				// ANeBuȂAppMain()Ă

                iLoop++; // [vJE^++

				int ret;
//				if(szFile[0] != '\0') // BMSt@CPhbvꂽ
				if(szDropPathArray.size()==1 && CheckType(szDropPathArray[0].c_str())==TYPE_BMS)
					ret = AppMain(szDropPathArray[0].c_str());
				else
					ret = AppMain();

				if(ret==-1)
					break; // WinMainEo
            }
			else
			{
				// AvANeBułȂ΁A
				PauseSequence(SEQ_PAUSE);

				// GetMessageɐ؂ւĕׂ炷
				{
					BOOL res = GetMessage(&msg,NULL,0,0); // ɂAقڂOɂł͂
					if(res==0 || res==-1)
						break; // WM_QUIT or Error
				}

				// WM_ACTIVATEAPP烁bZ[WĊJ(Ԃ)
				goto TransMes;
			}
        }
    }
    
    return msg.wParam;

}

LRESULT CALLBACK WindowProc(HWND hwnd, UINT iMessage, WPARAM wParam, LPARAM lParam)
{
    
    switch (iMessage)
	{
        case WM_ACTIVATEAPP:
            bIsActive = (BOOL)wParam;
            if ((wParam) && (iLoop))
			{
                dd.Restore(); // DirectDraw̍č\z
                return TRUE;
            }
            break;

		case WM_INITMENU:
			// AltL[etcŃVXej[ĴŃ^C}[~
			PauseSequence(SEQ_PAUSE);
			break;
            
        case WM_SETCURSOR:
			if(opt.bFullScr)
			{
	            SetCursor(NULL); // J[\
	            return TRUE;
			}
			break;

        case WM_KEYDOWN: // L[
            switch (wParam)
			{
/*			case VK_ESCAPE:
				PostMessage(hwnd, WM_CLOSE, 0, 0L);
				break;
*/
			case VK_LWIN:
				if(opt.bFullScr) return 0;
				break;

			case VK_RWIN:
				if(opt.bFullScr) return 0;
				break;
			}
            return 0;

		case WM_PAINT:
			{
/*				if(!opt.bFullScr)
				{
					PAINTSTRUCT ps;
					HDC hdc = BeginPaint(hmainwnd, &ps);
					dd.FlipToDC(hdc);
//					dd.Flip();
					EndPaint(hmainwnd, &ps);
					return 0;
				}
*/				break;
			}

        case WM_CLOSE:
            QuitGame(hwnd);
			break;
        
        case WM_DESTROY:
	        PostQuitMessage(0);
            return TRUE;

		case WM_SYSCOMMAND:
			if(wParam == SC_CLOSE)
			{
				if(dd.bReady)	//DirectDrawłĂȂ
					dd.GetLpDD()->RestoreDisplayMode();	// ʂ̃`h~

				ShowWindow(hwnd,SW_HIDE); // ^XNo[ɔc̖h~ by yaneurao
			}
			break;
    }
    return (DefWindowProc(hwnd, iMessage, wParam, lParam));
}

BOOL LoadDDRBMP(int mem){

	if(!dd.LoadBMP(0, "Image\\Allow.bmp",RGB(0,0,0), mem)){ // ꍇSysRAM̕
		WriteLog("Image\\Allow.bmp̓ǂݍ݂Ɏs");
	}

	if(opt.bAllow6)
	{
		if(!dd.LoadBMP(4, "Image\\Allow2.bmp",RGB(0,0,0), mem)){
			WriteLog("Image\\Allow2.bmp̓ǂݍ݂Ɏs");
		}
	}

	LOAD_BMP(1, "Image\\FAllow.bmp");

	if(opt.bAllow6)
	{
		LOAD_BMP(5, "Image\\FAllow2.bmp");
		for(int i=0;i<=1;i++) // Allow2,FAllow2̃XvCgĒ`
		{
			dd.DefSprite(i+19, 4, i*64 ,0  ,64+i*64 ,64);	// 19,20 : (,E) sɂăAj܂
			dd.DefSprite(i+21, 5, i*64 ,0  ,64+i*64 ,64);	// 21,22 : 肷Ƃ(,E)
			dd.DefSprite(i+23, 5, i*64 ,64 ,64+i*64 ,128);	// 23,24 : V̌(,E)
		}
	}

	// 400 : t[YA[.bmp
	LOAD_BMP(400, "Image\\DDR\\f_arrow.bmp");

	LOAD_BMP(14, "Image\\Light.bmp");
	LOAD_BMP(3, "Image\\Gauge.bmp");
	LOAD_BMP(6, "Image\\Judgment.bmp");
	LOAD_BMP(7, "Image\\Combo.bmp");
	LOAD_BMP(21, "Image\\fan_ddr.bmp");
	LOAD_BMP(10, "Image\\score.bmp");
	LOAD_BMP(15, "Image\\mode.bmp");

	DefSprite();

	if(!dd.SetStretchInstance(25, 1.0, 1.4, 0.02)){
		WriteLog("Perfect̊gkɎs");
	}
	if(!dd.SetStretchInstance(26, 1.0, 1.3, 0.02)){
		WriteLog("Great̊gkɎs");
	}

	if(!dd.SetStretchInstance(4, 0.7, 1.0, 0.02)){
		WriteLog("胉C()̊gkɎs");
	}
	if(!dd.SetStretchInstance(5, 0.7, 1.0, 0.02)){
		WriteLog("胉C()̊gkɎs");
	}
	if(!dd.SetStretchInstance(6, 0.7, 1.0, 0.02)){
		WriteLog("胉C()̊gkɎs");
	}
	if(!dd.SetStretchInstance(7, 0.7, 1.0, 0.02)){
		WriteLog("胉C()̊gkɎs");
	}

	if(!dd.SetStretchInstance(8, 0.7, 1.0, 0.02)){
		WriteLog("胉C()̊gkɎs");
	}
	if(!dd.SetStretchInstance(9, 0.7, 1.0, 0.02)){
		WriteLog("胉C()̊gkɎs");
	}
	if(!dd.SetStretchInstance(10, 0.7, 1.0, 0.02)){
		WriteLog("胉C()̊gkɎs");
	}
	if(!dd.SetStretchInstance(11, 0.7, 1.0, 0.02)){
		WriteLog("胉C()̊gkɎs");
	}

	if(opt.bAllow6)
	{
		if(!dd.SetStretchInstance(21, 0.7, 1.0, 0.02)){
			WriteLog("胉C()̊gkɎs");
		}
		if(!dd.SetStretchInstance(22, 0.7, 1.0, 0.02)){
			WriteLog("胉C(E)̊gkɎs");
		}
		if(!dd.SetStretchInstance(23, 0.7, 1.0, 0.02)){
			WriteLog("胉C()̊gkɎs");
		}
		if(!dd.SetStretchInstance(24, 0.7, 1.0, 0.02)){
			WriteLog("胉C(E)̊gkɎs");
		}
	}

	return TRUE;

}

BOOL LoadBMBMP(int mem){

	// 57-61BM̃UgŎgp

	LOAD_BMP(40, "Image\\BM\\button.bmp");
	LOAD_BMP(41, "Image\\BM\\button-r.bmp");

	if(!g_bClub)
	{
		LOAD_BMP(42, "Image\\BM\\main.bmp");
	}
	else
	{
		LOAD_BMP(44, "Image\\BM\\main_club.bmp");
	}

	LOAD_BMP(62, "Image\\BM\\gauge.bmp");
	LOAD_BMP(43, "Image\\BM\\judge.bmp");
	LOAD_BMP(53, "Image\\BM\\stone.bmp");
	LOAD_BMP(45, "Image\\BM\\object.bmp");
	LOAD_BMP(46, "Image\\BM\\green.bmp");
	LOAD_BMP(54, "Image\\BM\\keydown.bmp");

	if(opt.iEffect>=GE_HIGH && opt.iScCol!=SCCOL_256)
	{
		if(!dd.LoadBMP(55, "Image\\BM\\explosion.bmp",RGB(0,0,0),LOAD_RAM) ){
			WriteLog("Image\\BM\\explosion.bmp̓ǂݍ݂Ɏs");
		}
	}
	else
	{
		if(!dd.LoadBMP(55, "Image\\BM\\explosion_256.bmp",RGB(0,0,0),mem) ){
			WriteLog("Image\\BM\\explosion.bmp̓ǂݍ݂Ɏs");
		}
	}

	LOAD_BMP(63, "Image\\BM\\fan.bmp");
	LOAD_BMP(48, "Image\\BM\\autoplay.bmp");
	LOAD_BMP(49, "Image\\BM\\number.bmp");
	LOAD_BMP(50, "Image\\BM\\glinex.bmp");
	LOAD_BMP(51, "Image\\BM\\gliney.bmp");

	int mode = (opt.iEffect>=GE_HIGH) ? LOAD_RAM : mem;

	if(!dd.LoadBMP(47, "Image\\BM\\particle.bmp",RGB(0,0,0),mode) ){
		WriteLog("Image\\BM\\particle.bmp̓ǂݍ݂Ɏs");
	}

	LOAD_BMP(56, "Image\\BM\\judgeline.bmp");
	LOAD_BMP(80, "Image\\BM\\tempo_percent.bmp");
	
	return TRUE;

}

// BMPǂݍ݁BɓǂނقVRAMɏ\Ƃ̂ɖB
// Ƃ͂AV[ƂɓǂݍނƂɂ̂ł̊֐BMPfBXNLbVɂƂǂ܂
BOOL LoadBMP(int mem){

	for(int i=0;i<=400;i++) // S
		dd.UnLoadBMP(i);

	if(mem==LOAD_DEFAULT)
		WriteLog("BMPǂݍ݊Jn(VRAM) FreeVRAM:%2.3fMB", float(dd.GetFreeVRAM())/1024.0F/1024.0F);
	else
		WriteLog("BMPǂݍ݊Jn(SystemRAM) FreeVRAM:%2.3fMB", float(dd.GetFreeVRAM())/1024.0F/1024.0F);

/*	if(opt.iScCol==SCCOL_256)
	{
		// pbgݒ
		if(IN(opt.iMode,MD_BM_4,MD_BM_7))
		{
			dd.LoadPalette("Image\\pal_bm.bmp");
		}
		else
		{
			dd.LoadPalette("Image\\pal_ddr.bmp");
		}
	}
*/
//	LOAD_BMP(70, "Image\\ms_back.bmp");

//	LOAD_BMP(74, "Image\\ms_listbox.bmp");

	LoadDDRBMP(mem);
	LoadBMBMP(mem);

	// Nuł낤ƁAȂ낤ƃLbV
	LOAD_BMP(42, "Image\\BM\\main.bmp");
	LOAD_BMP(44, "Image\\BM\\main_club.bmp");

	//
/*	LOAD_BMP(16, "Image\\CD.bmp");
	LOAD_BMP(17, "Image\\CD_big.bmp");

	LOAD_BMP(78,"Image\\ms_title.bmp");
//	LOAD_BMP(2, "Image\\Door.bmp");
	LOAD_BMP(71, "Image\\ms_caption.bmp");
	LOAD_BMP(72, "Image\\ms_difficulty.bmp");
	LOAD_BMP(73, "Image\\ms_line.bmp");
	LOAD_BMP(75, "Image\\ms_mode1.bmp");
	LOAD_BMP(76, "Image\\ms_mode2.bmp");
	LOAD_BMP(77, "Image\\ms_mode3.bmp");
*/
	LOAD_BMP(12, "Image\\Cleared.bmp");
	LOAD_BMP(13, "Image\\Failed.bmp");

	LOAD_BMP(20, "Image\\Title.bmp");
	LOAD_BMP(25, "Image\\title-menu.bmp");

	LOAD_BMP(24, "Image\\cursor.bmp");

	LOAD_BMP(22, "Image\\connect.bmp");
//	LOAD_BMP(23, "Image\\eax.bmp");

	// BM肴
	LOAD_BMP(57, "Image\\BM\\result-back.bmp");
	LOAD_BMP(58, "Image\\BM\\result-box.bmp");
	LOAD_BMP(59, "Image\\BM\\result-font.bmp");
	LOAD_BMP(60, "Image\\BM\\result-graph.bmp");
	LOAD_BMP(61, "Image\\BM\\result-point.bmp");

	// DDR肴
	LOAD_BMP( 8, "Image\\Total.bmp");
	LOAD_BMP( 9, "Image\\valuation.bmp");
	LOAD_BMP(11, "Image\\result.bmp");

	WriteLog("BMPǂݍ݊ FreeVRAM:%2.3fMB", float(dd.GetFreeVRAM())/1024.0F/1024.0F);

	// S()
	// ƃLbV炢̂I
	for(i=0;i<=400;i++)
		dd.UnLoadBMP(i);

	return TRUE;

}

void DefSprite(void){

	// XvCg`
	for(int i=0;i<=3;i++)
		dd.DefSprite(i,0,     i*64, 0,  64+i*64     ,64);	// 0-3  : () sɂăAj܂

	for(i=4;i<=7;i++)
		dd.DefSprite(i,1, (i-4)*64, 0,  64+(i-4)*64 ,64);	// 4-7  : 肷Ƃ

	for(i=8;i<=11;i++)
		dd.DefSprite(i,1, (i-8)*64, 64, 64+(i-8)*64 ,128);	// 8-11 : V̌

	dd.DefSprite(12,2,  0,0,0,0);	// 12 : ǂ
//	dd.DefSprite(13,2,320,0,640,480);	// 13 : ǂE

	dd.DefSprite(14,3,  0,  0,258, 30);   // 14:Q[Wg
	dd.DefSprite(15,3,  0, 60,  2, 79);   // 15:Q[W
	dd.DefSprite(16,3,  2, 60,  4, 79);   // 16:Q[W΂P
	dd.DefSprite(17,3,  4, 60,  6, 79);   // 17:Q[W΂Q
/*
	dd.DefSprite(14,3,  0,  0,250, 30);   // 14:Q[Wg
	dd.DefSprite(15,3,  0, 30,  3, 60);   // 15:Q[Wԁ
	dd.DefSprite(16,3,  3, 30,  6, 60);   // 16:Q[W΂P
	dd.DefSprite(17,3,  6, 30,  9, 60);   // 17:Q[W΂Q
*/
	for(i=0;i<=1;i++)
	{
		dd.DefSprite(i+19, 4, i*64 ,0  ,64+i*64 ,64);	// 19,20 : (,E) sɂăAj܂
		dd.DefSprite(i+21, 5, i*64 ,0  ,64+i*64 ,64);	// 21,22 : 肷Ƃ(,E)
		dd.DefSprite(i+23, 5, i*64 ,64 ,64+i*64 ,128);	// 23,24 : V̌(,E)
	}

	for(i=0;i<7;i++)
		dd.DefSprite(25+i, 6, 0, i*40, 200, 40+i*40);	// 25-31 : ,MAXCOMBO

	// 32 : BG-BMP(VGA) for MSD
	// 33 : BG-BMP(VGA) for BMS

	dd.DefSprite(34,12,0,0,0,0); // 34 : Cleared
	dd.DefSprite(35,13,0,0,0,0); // 35 : Failed

	dd.DefSprite(36, 6, 0, 280, 0, 320); // 36 : OK
	dd.DefSprite(37, 6, 0, 320, 0, 360); // 37 : NG

	for(i=0;i<10;i++)
		dd.DefSprite(40+i, 7,i*25, 0, 25+i*25, 50);		// 40-49 : COMBOp0-9

	dd.DefSprite(50, 7, 250, 0, 350, 50);				// 50 : COMBO

	dd.DefSprite(51, 9,   0,   0, 100, 100); // 51 : SS
	dd.DefSprite(52, 9, 100,   0, 200, 100); // 52 : S
	dd.DefSprite(53, 9,   0, 100, 100, 200); // 53 : A
	dd.DefSprite(54, 9, 100, 100, 200, 200); // 54 : B
	dd.DefSprite(55, 9,   0, 200, 100, 300); // 55 : C
	dd.DefSprite(56, 9, 100, 200, 200, 300); // 56 : D
	dd.DefSprite(57, 9,   0, 300, 100, 400); // 57 : F
	dd.DefSprite(58, 9, 100, 300, 200, 400); // 58 : N

	dd.DefSprite(59,11,   0,   0,   0,   0); // 59 : "RESULT"̕

	for(i=0;i<10;i++)
		dd.DefSprite(60+i, 8,i*25, 0, 25+i*25, 40);		// 60-69 : Ugp0-9

	for(i=0;i<10;i++)
		dd.DefSprite(70+i,10,i*20, 0, 20+i*20, 30);		// 70-79 : XRAp0-9

	// 80-86 : 󂪂ځ[ď

	for(i=0;i<4;i++)
		dd.DefSprite(90+i, 15, 0, 120+i*30, 70, 120+(i+1)*30); // 90-93 : SINGLE,DOUBLE,VERSUS,COUPLE

	for(i=0;i<3;i++)
		dd.DefSprite(94+i, 15, 0, i*30, 70, (i+1)*30); // 94-96 : BASIC,ANOTHER,MANIAC

	// 100-355 : BMS #BMP00-FF
	// 356 : StageFile

	for(i=0;i<8;i++)
		dd.DefSprite(360+i, 15, 70, i*30, 140, (i+1)*30); // 360-367 : HID,SUD,STE,SHUF,MIRR,LIT,MIN,FLAT

	dd.DefSprite(369, 17,0,0,0,0); // 369 : CD_big
	dd.DefSprite(370, 16,0,0,0,0); // 370 : CD
	dd.DefSprite(371, 78,0,0,0,0); // 371 : ms_title

/*	dd.DefSprite(375, 18,   0,  0,   50,  50);// 375 : f[^itj@^[datainfo.bmp]
	dd.DefSprite(376, 18,  50,  0,   75,  50);// 376 : f[^ibcj@@^[datainfo.bmp]
	dd.DefSprite(377, 18,  75,  0,  100,  50);// 377 : f[^ilhchj^[datainfo.bmp]
	dd.DefSprite(378, 18, 100,  0,  150,  50);// 378 : f[^iAjj@^[datainfo.bmp]
	dd.DefSprite(379, 18, 150,  0,  200,  50);// 379 : f[^iaflj@^[datainfo.bmp]

	dd.DefSprite(380, 18,   0, 50,   50, 100);// 380 : f[^itj@^_[datainfo.bmp]
	dd.DefSprite(381, 18,  50, 50,   75, 100);// 381 : f[^ibcj@@^_[datainfo.bmp]
	dd.DefSprite(382, 18,  75, 50,  100, 100);// 382 : f[^ilhchj^_[datainfo.bmp]
	dd.DefSprite(383, 18, 100, 50,  150, 100);// 383 : f[^iAjj@^_[datainfo.bmp]
	dd.DefSprite(384, 18, 150, 50,  200, 100);// 384 : f[^iaflj@^_[datainfo.bmp]
*/

	for(i=0;i<3;i++)
		dd.DefSprite(390+i, 72,i*32,0,(i+1)*32,0); // 390-392 : ȃZ̓Փx

	dd.DefSprite(400, 20,0,0,0,0); // 400 : ^Cg
	dd.DefSprite(401, 24,0,0,0,0); // 401 : J[\

	dd.DefSprite(402, 26,  0, 0,  64, 0); // 402,403 : BM/DDR [hACR
	dd.DefSprite(403, 26, 64, 0, 128, 0);

	dd.DefSprite(404, 27,  0, 0, 0, 0); // 404 : Loading...

	dd.DefSprite(405, 22,0,0,0,0); // 405 : ڑACR
	dd.DefSprite(406, 23,0,0,0,0); // 406 : EAXACR

	for(i=0;i<4;i++)
	{
		dd.DefSprite(410+i,21,i*64,  0,(i+1)*64,64 ); //410-413 : DDRCʏ
		dd.DefSprite(414+i,21,i*64, 64,(i+1)*64,128); //414-417 : DDRC@
	}

	// 420-429 : ȃZ(󂫂Ȃc)

	dd.DefSprite(430,3,  6, 60,  8, 79);   // 430:Q[WP
	dd.DefSprite(431,3, 10, 60, 12, 79);   // 431:Q[WQ
	dd.DefSprite(432,3,  8, 60, 10, 79);   // 432:Q[WP
	dd.DefSprite(433,3, 12, 60, 14, 79);   // 433:Q[WQ

	for(i=0;i<7;i++)
	{
		dd.DefSprite(435+i, 25,   0,i*30, 220, (i+1)*30); // 435-441 : ^Cgj[
		dd.DefSprite(442+i, 25, 220,i*30, 440, (i+1)*30); // 442-448 : ^Cgj[
	}

	// 450-499 : ȃZ

	if(opt.b1PScL)
	{
		dd.DefSprite(507,40,0,0,60,70); // 507 : Sc 点܂
		for(i=0;i<6;i++)
			dd.DefSprite(500+i, 40, 60+i*18, 0, 60+(i+1)*18, 70); // 500-505 :  点܂ 1p
		dd.DefSprite(506,40,168,0,210,70); // 506 :  点܂
	}
	else
	{
		dd.DefSprite(500, 40, 0, 70, 40,140); // 500-506 :  点܂ 1p
		for(i=0;i<5;i++)
			dd.DefSprite(501+i, 40, 40+i*18, 70, 40+(i+1)*18, 140); // 500-506 :  点܂ 1p
		dd.DefSprite(506,40,130,70,150,140); // 506 :  点܂ 1p
		dd.DefSprite(507,40,150,70,210,140); // 507 : Sc 点܂
	}

	if(opt.b2PScL)
	{
		dd.DefSprite(587,40,210,70,270,140); // 587 : Sc 点܂
		for(i=0;i<6;i++)
			dd.DefSprite(580+i, 40, 270+i*18, 70, 270+(i+1)*18, 140); // 580-585 :  点܂ 1p
		dd.DefSprite(586,40,378,70,420,140); // 586 :  点܂
	}
	else
	{
		dd.DefSprite(580, 40, 210, 0, 250,70); // 580-586 :  点܂ 1p
		for(i=0;i<5;i++)
			dd.DefSprite(581+i, 40, 250+i*18, 0, 250+(i+1)*18, 70); // 580-586 :  点܂ 1p
		dd.DefSprite(586,40,340,0,360,70); // 586 :  点܂ 1p
		dd.DefSprite(587,40,360,0,420,70); // 587 : Sc 点܂
	}

	dd.DefSprite(508,42,0,0,0,0); // 508 : Q[Wx[X
	dd.DefSprite(509,44,0,0,0,0); // 508 : Q[Wx[X(club)

//	dd.DefSprite(509,42,  0,80,320,160); // 509 : Q[W1P(IύX)
//	dd.DefSprite(510,42,320,80,640,160); // 510 : Q[W2P(IύX)

	dd.DefSprite(511,43, 0,0, 80,30); // 511 : Great(Aj)
	for(i=0;i<4;i++)
		dd.DefSprite(512+i,43, 0,i*30, 80,(i+1)*30); // 512-515 : Great(),Good,Bad,Poor

	for(i=0;i<10;i++)
		dd.DefSprite(520+i,43, i*16,120, (i+1)*16,150); // 520-529 : 0-9 Aj

//	for(i=0;i<2;i++)
//	dd.DefSprite(530, 44, 0,i*12, 192, (i+1)*12); // 530,531 : 胉C1P,2P

	dd.DefSprite(530, 56,   0,  0,  0,  0); // 530 : pԃC

	dd.DefSprite(533, 45, 40,0,60,8); // 533 : White OBJ Aj
	dd.DefSprite(534, 45, 60,0,76,8); // 534 : Blue OBJ Aj
	dd.DefSprite(535, 45,  0,0,40,8); // 535 : Sc OBJ Aj

	dd.DefSprite(536, 46, 0,0,0,20); // 536 : 胉C΃Of(beatsyncAj)

	// 540-547 : 
	for(i=0;i<4;i++)
	{
		int dx = dd.GetBMPX(55)/4;
		int dy = dd.GetBMPY(55)/2;
		dd.DefSprite(540+i,55,i*dx, 0,(i+1)*dx,dy);
		dd.DefSprite(544+i,55,i*dx,dy,(i+1)*dx,dy*2);
	}

	dd.DefSprite(557, 48 ,16,0,36,0); // 557 : AUTOPLAY PART
	dd.DefSprite(558, 48 , 0,0,16,0); // 558 : AUTOPLAY PART(16px)

	for(i=0;i<11;i++)
		dd.DefSprite(560+i,49,i*10,0 ,(i+1)*10,16); // 560-570 : fW^ (570͔\̂)

	dd.DefSprite(571, 50,0,0,0,0); // 571 : ߐ
	dd.DefSprite(572, 51,0,0,0,0); // 572 : c

	dd.DefSprite(573, 53, 0,0,19,340); // 573 : 嗝΃t[1P
	dd.DefSprite(574, 53,19,0,38,340); // 574 : 嗝΃t[2P

	dd.DefSprite(575, 54,  0,0,39,0); // 575 : keydown SC
	dd.DefSprite(576, 54, 40,0,59,0); // 576 : keydown wh
	dd.DefSprite(577, 54, 60,0,75,0); // 577 : keydown bl

	// 580-586 :  点܂ 2P
	// 587 : Sc 点܂

	for(i=0;i<5;i++)
		dd.DefSprite(590+i, 47, i*30, 0, (i+1)*30, 30); // 590-594 : p[eBN

	// 600-609 : VȃZ

	dd.DefSprite(610,60, 0, 0, 310, 210);	// 610 : UgFOẗ

	for(i=0;i<4;i++)
		dd.DefSprite(611+i,58,   0, i*45, 100, (i+1)*45);	// 611-614 : sJO\̈Aj(4) (W100*H45)

	for(i=0;i<4;i++)
		dd.DefSprite(615+i,58, 100, i*45, 200, (i+1)*45);	// 615-618 : ォGREAT,GOOD,BAD,POOR (W100*H45)

	for(i=0;i<2;i++)
		dd.DefSprite(619+i,58, 200, i*40, 350, (i+1)*40);	// 619-620 : TOTALNOTES,MAXCOMBO (W150*H40)
	
	for(i=0;i<2;i++)
		dd.DefSprite(621+i,58, 200, 80+i*60, 350, 80+(i+1)*60);	// 621-622 : SCORE,TOTAL SCORE (W150*H60)

	for(i=0;i<10;i++)
		dd.DefSprite(630+i,59, i*18, 0, (i+1)*18, 30);		// 630-639 : 葍EXRA\tHgiW18*H30j

	dd.DefSprite(640, 57,0,0,0,0); // 640 : Ugwi

	dd.DefSprite(641, 61,0,0,2,2); // 641 : UgOt̓_()
	dd.DefSprite(642, 61,2,0,4,2); // 642 : UgOt̓_()

	for(i=0;i<12;i++)
		dd.DefSprite(650+i,62,  i*3, 0,  (i+1)*3, 0); // 650-661 : Q[W΁

	dd.DefSprite(662,62, 36,20,39,48); // 662,663 : Q[W
	dd.DefSprite(663,62, 39,20,42,48);

	for(i=0;i<4;i++)
	{
		dd.DefSprite(670+i,63,i*64,  0,(i+1)*64, 64); //670-673 : Cʏ()
		dd.DefSprite(674+i,63,i*64, 64,(i+1)*64,128); //674-677 : C@()
	}

	// 680-689 : e|ύX\pfW^(+)
	for(i=0;i<10;i++)
		dd.DefSprite(680+i,80,i*8+8,0 ,(i+1)*8+8,10);

	// 690-699 : e|ύX\pfW^(-)
	for(i=0;i<10;i++)
		dd.DefSprite(690+i,80,i*8+8,10 ,(i+1)*8+8,20);

	// 700 : e|ύX\p"+"
	dd.DefSprite(700,80,0,0,8,10);
	// 701 : e|ύX\p""(+)
	dd.DefSprite(701,80,88,0 ,88+16,10);

	// 702 : e|ύX\p"-"
	dd.DefSprite(702,80,0,10,8,20);
	// 703 : e|ύX\p""(-)
	dd.DefSprite(703,80,88,10 ,88+16,20);

	// 710-855 : L[RtBOACR
	for(i=0;i<146;i++)
	{
		int x = (i/37)*24;
		int y = (i%37)*16;
		dd.DefSprite(710+i, 81, x, y, x+24, y+16);
	}

	// 859 : L[RtBOJ[\
	dd.DefSprite(859, 81, 72,599, 96,615);

	// 860-869 : WCpbh{^ԍ (0,597)牡10 6x6
	for(i=0;i<10;i++)
		dd.DefSprite(860+i, 81, i*6, 597, i*6+6, 603);

	// 870-885 : WCpbhԍ (0,592)牡16 5x5
	for(i=0;i<16;i++)
		dd.DefSprite(870+i, 81, i*5, 592, i*5+5, 597);

	// 890-896 : MIDICDEFGAB (0,609)牡7 5x6
	for(i=0;i<7;i++)
		dd.DefSprite(890+i, 81, i*5, 609, i*5+5, 615);

	// 897     : MIDI (35,609) 5x6
	dd.DefSprite(897, 81, 35, 609, 40, 615);

	// 900-910 : MIDIIN^[uԍ[0-10](5,603)牡11 5x6
	for(i=0;i<11;i++)
		dd.DefSprite(900+i, 81, 5+i*5, 603, 5+(i+1)*5, 609);

	// 920-1100 : O[oV[Ŏgp

	// 1200 : gBGApXvCg

	// 1250-1253 : t[YA[ 4-Arrow
	for(i=0;i<4;i++)
		dd.DefSprite(1250+i, 400, 64*i, 0, 64*(i+1), 64);

	// 1255-1258 : t[YA[ 4-Arrow
	for(i=0;i<4;i++)
		dd.DefSprite(1255+i, 400, 64*i, 128, 64*(i+1), 192);

	// 1260-1263 : t[YA[D 4-Arrow
	for(i=0;i<4;i++)
		dd.DefSprite(1260+i, 400, 64*i, 64*3, 64*(i+1), 64*4);

	// 1280-1285 : t[YA[ 6-Arrow
	dd.DefSprite(1280, 400,    0,  0,   64,   64);
	dd.DefSprite(1281, 400,    0, 64,   64, 64*2);
	dd.DefSprite(1282, 400,   64,  0, 64*2,   64);
	dd.DefSprite(1283, 400, 64*2,  0, 64*3,   64);
	dd.DefSprite(1284, 400,   64, 64, 64*2, 64*2);
	dd.DefSprite(1285, 400, 64*3,  0, 64*4,   64);

	// 1290-1295 : t[YA[ 6-Arrow
	dd.DefSprite(1290, 400,    0, 64*2,   64, 64*3);
	dd.DefSprite(1291, 400, 64*2,   64, 64*3, 64*2);
	dd.DefSprite(1292, 400,   64, 64*2, 64*2, 64*3);
	dd.DefSprite(1293, 400, 64*2, 64*2, 64*3, 64*3);
	dd.DefSprite(1294, 400, 64*3,   64, 64*4, 64*2);
	dd.DefSprite(1295, 400, 64*3, 64*2, 64*4, 64*3);

	// 1300-1305 : t[YA[D 6-Arrow
	// 64*3 = 192
	dd.DefSprite(1300, 400,    0,  0+192,   64,   64+192);
	dd.DefSprite(1301, 400,    0, 64+192,   64, 64*2+192);
	dd.DefSprite(1302, 400,   64,  0+192, 64*2,   64+192);
	dd.DefSprite(1303, 400, 64*2,  0+192, 64*3,   64+192);
	dd.DefSprite(1304, 400,   64, 64+192, 64*2, 64*2+192);
	dd.DefSprite(1305, 400, 64*3,  0+192, 64*4,   64+192);

	// 1310-1329 : ȃZ

	// #define MAX_SPRITE 2048
}

BOOL InitApp(HINSTANCE hInst){

	// st@C̃tH_Jgɂ(P)
	// t@ChbvċNƃJgC:\WindowsɂȂƂ^RȎdl̂߁B
	char szTxt[MAX_PATH];
//	strcpy(szTxt, __argv[0]);

	// scm
	if(GetModuleFileName(NULL, szTxt, MAX_PATH)!=0)
	{
		char* yen = strrchr(szTxt, '\\');
		
		// NULLȂ͂͂Ȃ
		if(yen != NULL)
		{
			// EXEt@C؂̂
			yen[1] = '\0';
			SetCurrentDirectory(szTxt);
			strcpy(szAppDir, szTxt); // JgpXۑ
		}
	}

	// OReport.log폜wb_
	// Jgw肵ĂĂڂ
	InitReportLog();

	WriteLog("InitApp() Started.");

	ReAllocOBJ(); // 񕪂̊蓖
	InitObj();
	InitResult();
	ScoreInfo.lpHeader = NULL;

	randomize();

	pd.vol = GetVolume(); // ̃{[ۑB^ɂƂȂFALSEԂƂɃoCB

	WriteLog("InitApp() : GetVolume() = %d",pd.vol);

	CTimeBase::timeBeginPeriodMin();

	// łӂ
	strcpy(szCfgFile, szConfigFile);
	strcpy(szLstFile, szCacheFile);
	Juke.SetCacheFile(szCacheFile);
	keycfg.SetCfgFile(szKeyConfigFile);

	// ꂵ :-p
    for(int i=0; i<__argc; i++)
    {
//		Notice(__argv[i]);
		char cmdLine[MAX_PATH];
		strcpy(cmdLine, __argv[i]);

		if(CheckType(cmdLine)==TYPE_LNK)
		{
			// V[gJbg̃N
			char buf[MAX_PATH];
			WIN32_FIND_DATA wfd;
			if(SUCCEEDED(GetShortcutLink(cmdLine, buf, MAX_PATH, &wfd)))
			{
				strcpy(cmdLine, buf);
			}
		}

		if(CheckType(cmdLine)==TYPE_CFG)
			strcpy(szCfgFile, cmdLine);

		if(CheckType(cmdLine)==TYPE_DAT)
			keycfg.SetCfgFile(cmdLine);
	}

	LoadConfig();

	BOOL keypShift = GetKeyState(VK_SHIFT)>>15;
	BOOL keypCtrl  = GetKeyState(VK_CONTROL)>>15;

	if(keypShift)
		Cfg["FullScreen"] = opt.bFullScr = TRUE;

	if(keypCtrl)
		Cfg["FullScreen"] = opt.bFullScr = FALSE;

	// EBhENX̍쐬o^
    WNDCLASS wc;
	wc.style			= CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc		= WindowProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInst;
	wc.hIcon			= LoadIcon(hInst, MAKEINTRESOURCE(IDI_ICON1));
	wc.hCursor			= opt.bFullScr ? NULL : LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground	= (HBRUSH)GetStockObject(BLACK_BRUSH);
	wc.lpszMenuName		= NULL;
	wc.lpszClassName	= "Delight_WndClass";

	RegisterClass(&wc);

	DWORD dwStyle;
	if(opt.bFullScr)
		dwStyle = WS_POPUP|WS_VISIBLE;
	else
		dwStyle = WS_VISIBLE|WS_OVERLAPPED|WS_CAPTION|WS_MINIMIZEBOX|WS_SYSMENU;

	// \͈͂640*480Ȃ΁AׂWindowTCÝAȏł
	RECT r;
	r.left    = GetSystemMetrics(SM_CXSCREEN)/2 - SCR_W/2;
	r.right   = GetSystemMetrics(SM_CXSCREEN)/2 + SCR_W/2;
	r.top     = GetSystemMetrics(SM_CYSCREEN)/2 - SCR_H/2;
	r.bottom  = GetSystemMetrics(SM_CYSCREEN)/2 + SCR_H/2;
	AdjustWindowRect(&r,dwStyle,false);

//	Notice("(%d,%d)-(%d,%d)", r.left, r.top, r.right, r.bottom);

    // EBhE̐
	HWND hwnd;
	hwnd = CreateWindow(
        wc.lpszClassName,
        lpszAppName,    // ^Cg
        dwStyle,
        opt.bFullScr ? 0 : r.left,
        opt.bFullScr ? 0 : r.top,
        opt.bFullScr ? GetSystemMetrics(SM_CXSCREEN) : r.right-r.left,  // XN[
        opt.bFullScr ? GetSystemMetrics(SM_CYSCREEN) : r.bottom-r.top,  // XN[
        NULL,
        NULL,
        hInst,
        NULL
    );

	if(hwnd==NULL)
	{
		char buf[1024];
		GetLastErrorStr(buf);
		WriteLog("WinMain() : CreateWindow()Ɏs(Reason:%s)", buf);

		MessageBox(NULL, "EBhE̍쐬ɎsIȂɁH", "G[I", MB_OK);
		return 0;
	}

	if(!opt.bFullScr)
	{
		// Display the window.
		ShowWindow(hwnd, SW_SHOW);
		UpdateWindow(hwnd);

		//	EBhDTCY𑬍Uf邽߂ɂ́AꂪKvB
		::SetWindowPos(hwnd,NULL,
				r.left,r.top,r.right-r.left,r.bottom-r.top,
				SWP_NOZORDER|SWP_NOMOVE);
	}

	hmainwnd = hwnd; // O[oŎĂ

	ImmAssociateContext(hwnd, NULL); // IME𖳌ɂ

	// CD
	cd.Initialize(hmainwnd); //,hInst);

	// ݂CDhCu̗
	for(i=0;i<27;i++)
		szCDDr[i][0] = '\0';

	int j=1; // 0DefaultȂ̂ŋ󂯂Ă
	for(i=0;i<26;i++)
	{
		char szTxt[4];
		szTxt[0] = 'A'+i;
		szTxt[1] = '\0';
		strcat(szTxt,":");

		if(GetDriveType(szTxt) == DRIVE_CDROM)
			strcat(szCDDr[j++], szTxt);
	}
	opt.iCDDrMax = j-1; // vhCu

    // DirectDraw
	if(opt.iScCol==SCCOL_65536)
	{
		// 65536
		if (!dd.Init(hwnd,16,opt.bFullScr, opt.iBuffering+1) )
		{
			Notice("DirectDraw̏Ɏs");
			WriteLog("InitApp() : DirectDraw̏Ɏs");
			return FALSE;
		}
	}
	else if(opt.iScCol==SCCOL_256)
	{
		// 256
		if (!dd.Init(hwnd,8,opt.bFullScr, opt.iBuffering+1) )
		{
			Notice("DirectDraw̏Ɏs");
			WriteLog("InitApp() : DirectDraw̏Ɏs");
			return FALSE;
		}
	}
	else
	{
		// TrueColor
		if (!dd.Init(hwnd,32,opt.bFullScr, opt.iBuffering+1) ) // 32bitŎ
		{
			if (!dd.Init(hwnd,24,opt.bFullScr, opt.iBuffering+1) ) // _Ȃ24bitŃgCcElIɒxȂق
			{
				WriteLog("InitApp() : DirectDraw̏Ɏs");
				Notice("DirectDraw̏Ɏs");
				return FALSE;
			}
		}
	}

	dd.ClearScreen();
	dd.Flip();
	dd.ClearScreen();
	dd.Flip();

	// XvCgBMP݂̂ɃLbVKp
	for(i=0;i<100;i++)
	{
		if(i!=32 && i!=33)
			dd.SetMemCache(i, TRUE);
	}

//	eltime.SetFPS(0); // ւ()
//	dd.SetFlipMode(FLIP_WAITVSYNC);

	if (!LoadBMP(LOAD_DEFAULT))
		return FALSE;

	DefSprite();

	if(DIkey.Initialize(hwnd,hInst)!=0)
	{
		Notice("DirectInput̏Ɏs");
		WriteLog("InitApp() : DirectInput̏Ɏs");
		return FALSE;
	}

	joy1.SelectJoyStick(jsJOYSTICK1);
	joy2.SelectJoyStick(jsJOYSTICK2);

	if(joy1.Initialize(hwnd,hInst)==0)
		WriteLog("InitApp() : JoyStick 1(%u{^)F܂", joy1.GetButtonMax());

	if(joy2.Initialize(hwnd,hInst)==0)
		WriteLog("InitApp() : JoyStick 2(%u{^)F܂", joy2.GetButtonMax());

	if(midiIn.Initialize(hwnd,hInst)==0)
		WriteLog("InitApp() : MIDI-Input̃I[vɐ");

	OptionDispatch(); // dd.GetRefreshRate()̂DDさCDCD
	// SaveConfig(); // ȂłȂƂɂ񂾂(

	keycfg.SetDevice(&VKey, &DIkey, &midiIn, &joy1, &joy2);
	KeycfgDataAddVersion(); // 0.34bȑO΍

	if(!keycfg.LoadCfg())
	{
		// ftHgݒ
		WriteLog("InitApp() : L[RtBOf[^̓ǂݍ݂Ɏs܂BftHgݒgp܂");

		// VKey.AddDevice()OptionDispatch()̒
		keycfg.SetVKey(VK_OK,   0, &DIkey, DIK_RETURN);
		keycfg.SetVKey(VK_ESC,  0, &DIkey, DIK_ESCAPE);

		keycfg.SetVKey(VK_PGUP,     0, &DIkey, DIK_PRIOR);
		keycfg.SetVKey(VK_PGDN,     0, &DIkey, DIK_NEXT);
		keycfg.SetVKey(VK_VOLUP,    0, &DIkey, DIK_2);
		keycfg.SetVKey(VK_VOLDOWN,  0, &DIkey, DIK_1);
		keycfg.SetVKey(VK_TEMPOUP,  0, &DIkey, DIK_4);
		keycfg.SetVKey(VK_TEMPODOWN,0, &DIkey, DIK_3);
		keycfg.SetVKey(VK_MUSICUP,  0, &DIkey, DIK_UP);
		keycfg.SetVKey(VK_MUSICDOWN,0, &DIkey, DIK_DOWN);
		keycfg.SetVKey(VK_PLAYSTOP, 0, &DIkey, DIK_0);
		keycfg.SetVKey(VK_JUKEUP,   0, &DIkey, DIK_2);
		keycfg.SetVKey(VK_JUKEDOWN, 0, &DIkey, DIK_1);
		// keycfg.SetVKey(VK_PLAYER,   0, &DIkey, DIK_LEFT); // 폜܂
		// keycfg.SetVKey(VK_LEVEL,    0, &DIkey, DIK_RIGHT);

		keycfg.SetVKey(VK_CS_L, 0, &DIkey, DIK_LEFT);
		keycfg.SetVKey(VK_CS_R, 0, &DIkey, DIK_RIGHT);
		keycfg.SetVKey(VK_CS_U, 0, &DIkey, DIK_UP);
		keycfg.SetVKey(VK_CS_D, 0, &DIkey, DIK_DOWN);

		keycfg.SetVKey(VK_DDR1P_L, 0, &DIkey, DIK_LEFT);
		keycfg.SetVKey(VK_DDR1P_D, 0, &DIkey, DIK_DOWN);
		keycfg.SetVKey(VK_DDR1P_U, 0, &DIkey, DIK_UP);
		keycfg.SetVKey(VK_DDR1P_R, 0, &DIkey, DIK_RIGHT);

		keycfg.SetVKey(VK_DDR1P_L, 2, &DIkey, DIK_Z);
		keycfg.SetVKey(VK_DDR1P_D, 2, &DIkey, DIK_X);
		keycfg.SetVKey(VK_DDR1P_U, 2, &DIkey, DIK_C);
		keycfg.SetVKey(VK_DDR1P_R, 2, &DIkey, DIK_V);
		keycfg.SetVKey(VK_DDR1P_R, 3, &DIkey, DIK_SPACE);

		keycfg.SetVKey(VK_DDR1P_L, 4, &joy1, 2);
		keycfg.SetVKey(VK_DDR1P_D, 4, &joy1, 1);
		keycfg.SetVKey(VK_DDR1P_U, 4, &joy1, 0);
		keycfg.SetVKey(VK_DDR1P_R, 4, &joy1, 3);

		keycfg.SetVKey(VK_DDR2P_L, 0, &DIkey, DIK_NUMPAD4);
		keycfg.SetVKey(VK_DDR2P_D, 0, &DIkey, DIK_NUMPAD2);
		keycfg.SetVKey(VK_DDR2P_D, 1, &DIkey, DIK_NUMPAD5);
		keycfg.SetVKey(VK_DDR2P_U, 0, &DIkey, DIK_NUMPAD8);
		keycfg.SetVKey(VK_DDR2P_R, 0, &DIkey, DIK_NUMPAD6);

		keycfg.SetVKey(VK_DDR2P_L, 4, &joy2, 2);
		keycfg.SetVKey(VK_DDR2P_D, 4, &joy2, 1);
		keycfg.SetVKey(VK_DDR2P_U, 4, &joy2, 0);
		keycfg.SetVKey(VK_DDR2P_R, 4, &joy2, 3);

		keycfg.SetVKey(VK_DDR6_4, 0, &DIkey, DIK_NUMPAD4);
		keycfg.SetVKey(VK_DDR6_7, 0, &DIkey, DIK_NUMPAD7);
		keycfg.SetVKey(VK_DDR6_2, 0, &DIkey, DIK_NUMPAD2);
		keycfg.SetVKey(VK_DDR6_2, 1, &DIkey, DIK_NUMPAD5);
		keycfg.SetVKey(VK_DDR6_8, 0, &DIkey, DIK_NUMPAD8);
		keycfg.SetVKey(VK_DDR6_9, 0, &DIkey, DIK_NUMPAD9);
		keycfg.SetVKey(VK_DDR6_6, 0, &DIkey, DIK_NUMPAD6);

		keycfg.SetVKey(VK_DDR6_4, 2, &DIkey, DIK_Z);
		keycfg.SetVKey(VK_DDR6_7, 2, &DIkey, DIK_S);
		keycfg.SetVKey(VK_DDR6_2, 2, &DIkey, DIK_X);
		keycfg.SetVKey(VK_DDR6_8, 2, &DIkey, DIK_D);
		keycfg.SetVKey(VK_DDR6_9, 2, &DIkey, DIK_C);
		keycfg.SetVKey(VK_DDR6_6, 2, &DIkey, DIK_SPACE);

		keycfg.SetVKey(VK_BM1P_1,  0, &DIkey, DIK_Z);
		keycfg.SetVKey(VK_BM1P_2,  0, &DIkey, DIK_S);
		keycfg.SetVKey(VK_BM1P_3,  0, &DIkey, DIK_X);
		keycfg.SetVKey(VK_BM1P_4,  0, &DIkey, DIK_D);
		keycfg.SetVKey(VK_BM1P_5,  0, &DIkey, DIK_C);
		keycfg.SetVKey(VK_BM1P_6,  0, &DIkey, DIK_F);
		keycfg.SetVKey(VK_BM1P_7,  0, &DIkey, DIK_V);
		keycfg.SetVKey(VK_BM1P_SC, 0, &DIkey, DIK_LSHIFT);
		keycfg.SetVKey(VK_BM1P_SC, 1, &DIkey, DIK_SPACE);

		//܂JoyPad7,4,1,5,2,6,3,8{^(TChC_[dl)ɑΉĂ܂B
		keycfg.SetVKey(VK_BM1P_1,  2, &joy1, 7+3);
		keycfg.SetVKey(VK_BM1P_2,  2, &joy1, 4+3);
		keycfg.SetVKey(VK_BM1P_3,  2, &joy1, 1+3);
		keycfg.SetVKey(VK_BM1P_4,  2, &joy1, 5+3);
		keycfg.SetVKey(VK_BM1P_5,  2, &joy1, 2+3);
		keycfg.SetVKey(VK_BM1P_6,  2, &joy1, 6+3);
		keycfg.SetVKey(VK_BM1P_7,  2, &joy1, 3+3);
		keycfg.SetVKey(VK_BM1P_SC, 2, &joy1, 8+3);

		keycfg.SetVKey(VK_BM1P_1,  3, &midiIn, 65);
		keycfg.SetVKey(VK_BM1P_2,  3, &midiIn, 66);
		keycfg.SetVKey(VK_BM1P_3,  3, &midiIn, 67);
		keycfg.SetVKey(VK_BM1P_4,  3, &midiIn, 68);
		keycfg.SetVKey(VK_BM1P_5,  3, &midiIn, 69);
		keycfg.SetVKey(VK_BM1P_6,  3, &midiIn, 70);
		keycfg.SetVKey(VK_BM1P_7,  3, &midiIn, 71);
		keycfg.SetVKey(VK_BM1P_SC, 3, &midiIn, 59);
		keycfg.SetVKey(VK_BM1P_SC, 4, &midiIn, 60);
		keycfg.SetVKey(VK_BM1P_SC, 5, &midiIn, 241); //mod.
		keycfg.SetVKey(VK_BM1P_SC, 6, &midiIn, 242); //P.B+
		keycfg.SetVKey(VK_BM1P_SC, 7, &midiIn, 243); //P.B-

		keycfg.SetVKey(VK_BM2P_1,  0, &DIkey, DIK_N);
		keycfg.SetVKey(VK_BM2P_2,  0, &DIkey, DIK_J);
		keycfg.SetVKey(VK_BM2P_3,  0, &DIkey, DIK_M);
		keycfg.SetVKey(VK_BM2P_4,  0, &DIkey, DIK_K);
		keycfg.SetVKey(VK_BM2P_5,  0, &DIkey, DIK_COMMA);
		keycfg.SetVKey(VK_BM2P_6,  0, &DIkey, DIK_L);
		keycfg.SetVKey(VK_BM2P_7,  0, &DIkey, DIK_PERIOD);
		keycfg.SetVKey(VK_BM2P_SC, 0, &DIkey, DIK_RETURN);
		keycfg.SetVKey(VK_BM2P_SC, 1, &DIkey, DIK_RSHIFT);

		keycfg.SetVKey(VK_BM2P_1,  2, &joy2, 7+3);
		keycfg.SetVKey(VK_BM2P_2,  2, &joy2, 4+3);
		keycfg.SetVKey(VK_BM2P_3,  2, &joy2, 1+3);
		keycfg.SetVKey(VK_BM2P_4,  2, &joy2, 5+3);
		keycfg.SetVKey(VK_BM2P_5,  2, &joy2, 2+3);
		keycfg.SetVKey(VK_BM2P_6,  2, &joy2, 6+3);
		keycfg.SetVKey(VK_BM2P_7,  2, &joy2, 3+3);
		keycfg.SetVKey(VK_BM2P_SC, 2, &joy2, 8+3);

	}

	char* szVer = keycfg.GetFileVersion();

	if(szVer!=NULL)
	{
		if(strncmp(szVer, "DDR_Keycfg_034b", strlen("DDR_Keycfg_034b"))==0)
		{
			// 0.34bȑO
			keycfg.SetVKey(VK_TEMPOUP,  0, &DIkey, DIK_4);
			keycfg.SetVKey(VK_TEMPODOWN,0, &DIkey, DIK_3);

			keycfg.SetVKey(VK_MUSICUP,  0, &DIkey, DIK_UP);
			keycfg.SetVKey(VK_MUSICDOWN,0, &DIkey, DIK_DOWN);
		}
	}

	keycfg.SetFileVersion("DDR_Keycfg_035");
	keycfg.SaveCfg();
	keycfg.Dispatch();

	score.Load(szScoreDB);

	//TEh̏
	if(opt.iSoundQlty == SQ_LOW)
	{
		if(!ds.Init(hwnd,22,8,2))
		{
			Notice("DirectSound̏Ɏs");
			WriteLog("InitApp() : DirectSound̏Ɏs");
			return FALSE;
		}
	}
	else
	{
		if(!ds.Init(hwnd,44,16,2))
		{
			Notice("DirectSound̏Ɏs");
			WriteLog("InitApp() : DirectSound̏Ɏs");
			return FALSE;
		}
	}

	// Q[Wt@C̓ǂݍ
	Messages.Load(szLanguageFile);

	WriteLog("InitApp() OK!\n");

	return TRUE;

}

// -1ԂWinMain𔲂
int AppMain(){

	static int iMode  = SC1_TITLE;
	static int nCount = 0; // ĂяoJE^

	int iModeold = iMode;

	static CScene* lpNowScene = NULL; // Iɂ = new CTitle; Ƃ

	static BOOL bFirstCall = TRUE;
	if(bFirstCall)
	{
		lpGlobScene = new CGlobalScene;
		if(lpGlobScene!=NULL)
		{
			lpGlobScene->Init(&gd);
			lpGlobScene->SetSceneNo(iMode);
		}
		bFirstCall = FALSE;
	}

	GetKeyInfo();

	switch(iMode)
	{
//	case SC1_SELMUSIC:
		//iMode = SelectMusic(nCount);
//		break;
	case SC1_GAMEMAIN:
		iMode = GameMain(nCount);
		break;
	case SC1_TITLE:
		iMode = Title(nCount);
		break;
	case SC1_OPTION:
		iMode = OptionMode(nCount);
		break;
	case SC1_QUIT:
		// Alt+F4ŏIƂɗȂ烁[NB
		// Ƃ肠OSɉC邪
		// ̂܂邲ƃNXĉׂ
		DELETE_SAFE(lpGlobScene);
		DELETE_SAFE(lpNowScene);
		QuitGame(hmainwnd);
		return -1;
		break;
	case SC1_RESULT:
		iMode = Result(nCount);
		break;
	case SC1_OPTION_BM:
		iMode = OptionBM(nCount);
		break;
	case SC1_OPTION_2:
		iMode = Option2(nCount);
		break;
	case SC1_KEYCFGSYS:
		iMode = KeyConfigSys(nCount);
		break;
	case SC1_KEYCFGDDR:
		iMode = KeyConfigDDR(nCount);
		break;
	case SC1_KEYCFGBM:
		iMode = KeyConfigBM(nCount);
		break;
	}

	nCount++;

	// V[Pt[
	if(lpNowScene!=NULL)
		lpNowScene->ProcessFrame(); // Iɂ͂{

	// ɓ삷V[
	if(lpGlobScene!=NULL)
	{
		// ȃZIɂStageFileoĂāȀォXe[^Xo[Ƃ܂
		// }uȂ̂ł܂ƂȃR[hɂ悤
		if(lpNowScene==NULL)
			lpGlobScene->ProcessFrame();
		else if(lpNowScene->GetNextScene()!=SC1_GAMEMAIN)
			lpGlobScene->ProcessFrame();
	}

	// ̃V[擾
	if(lpNowScene!=NULL)
	{
		if(lpNowScene->GetNextScene()!=SC_CURRENTSCENE)
			iMode = lpNowScene->GetNextScene();
	}

	if(iModeold!=iMode)
	{
		// ʂ̃V[Ɉڂ
		lpGlobScene->SetSceneNo(iMode);

		// ʂ̃V[ɈړOɃfXgN^Ă
		if(lpNowScene!=NULL)
		{
			// Alt+F4ŏIƂɗȂ烁[NB
			// Ƃ肠OSɉC邪
			// ̂܂邲ƃNXĉׂ
			lpNowScene->Term();
			DELETE_SAFE(lpNowScene); // Iɂ͂{ŕЕt
		}

		// ͂܂case
		switch(iModeold)
		{
//		case SC1_SELMUSIC:
//			SelectMusic(-1);
//			break;
		case SC1_GAMEMAIN:
			GameMain(-1);
			break;
		case SC1_TITLE:
			Title(-1);
			break;
		case SC1_OPTION:
			OptionMode(-1);
			break;
		case SC1_QUIT:
			QuitGame(hmainwnd);
			return -1;
			break;
		case SC1_RESULT:
			Result(-1);
			break;
		case SC1_OPTION_BM:
			OptionBM(-1);
			break;
		case SC1_OPTION_2:
			Option2(-1);
			break;
		case SC1_KEYCFGSYS:
			KeyConfigSys(-1);
			break;
		case SC1_KEYCFGDDR:
			KeyConfigDDR(-1);
			break;
		case SC1_KEYCFGBM:
			KeyConfigBM(-1);
			break;
		}

		// ̃V[RXgNg
		if(iMode==SC1_SELMUSIC)
		{
			lpNowScene = new CSelectMusic;
			if(lpNowScene==NULL)
			{
				// sH̏󋵂WriteLogƂŐVɃ͎Ȃ
				QuitGame(hmainwnd);
				return -1;
			}
			
			lpNowScene->Init(&gd);
		}
		else
		{
			lpNowScene = NULL;
		}

		// ĂяoJE^Oɖ߂
		nCount = 0;

	}

	g_bClub = dp.IsReady(); // ڑ󋵃`FbN

	Debug();
	eltime.WaitFrame();
	dd.Flip();
    dd.ClearScreen();

	return 0;

}

// -1ԂWinMain𔲂
int AppMain(const char* szFile){

	static int iMode = 0;
	static int nCount = 0; // ĂяoJE^

	int iModeold = iMode;

	static CGlobalScene* lpGlobScene = new CGlobalScene;

	static BOOL bFirstCall = TRUE;
	if(bFirstCall)
	{
		if(lpGlobScene!=NULL)
		{
			lpGlobScene->Init(&gd);
			lpGlobScene->SetSceneNo(iMode);
		}
		bFirstCall = FALSE;
	}

	// Pt[ɂP񂪂悢Ǝv
	GetKeyInfo();

	switch(iMode)
	{
	case 0:
		iMode = InitBMS(szFile);
		break;
	case 1:
		iMode = GameMain(nCount);
		break;
	case 2:
		DELETE_SAFE(lpGlobScene);
		QuitGame(hmainwnd);
		return -1; // WinMainI
		break;
	case 5:
		iMode = Result(nCount);
		if(iMode==0)
			iMode = 2;
		break;
	}

	nCount++;

	// ɓ삷V[
	if(lpGlobScene!=NULL)
		lpGlobScene->ProcessFrame();

	if(iModeold!=iMode)
	{
		// ʂ̃V[Ɉڂ
		lpGlobScene->SetSceneNo(iMode);

		// ʂ̃V[ɈړOɃfXgN^Ă
		switch(iModeold)
		{
		case 1:
			GameMain(-1);
			break;
		case 5:
			Result(-1);
			break;
		}

		// ĂяoJE^Oɖ߂
		nCount = 0;
	}

	Debug();

	eltime.WaitFrame();
	dd.Flip();
    dd.ClearScreen();
	
	return 0; // WinMains

}

// t@ChbvċNƂɎg
int InitBMS(const char* szFile){

	static BOOL bLoad=FALSE;
	static BMS bmsH; //bmsHeader擾p

	// BMSÂ߂Ƀpbgݒ
	if(IN(opt.iMode,MD_BM_4,MD_BM_7))
	{
		dd.LoadPalette("Image\\pal_bm.bmp");
	}
	else
	{
		dd.LoadPalette("Image\\pal_ddr.bmp");
	}

#if 0
	LOAD_BMP(17, "Image\\CD_big.bmp");

	LOAD_BMP(78, "Image\\ms_title.bmp");
	LOAD_BMP(72, "Image\\ms_difficulty.bmp");

//	LOAD_BMP(2, "Image\\Door.bmp");

	DefSprite();

	if(!bLoad)
	{
		char szFileName[MAX_PATH];
		char szPath[MAX_PATH];

		GetFileName(szFileName, szFile);
		GetPath    (szPath    , szFile);

		char szErrTxt[1024];
		LoadBMS(szFileName, szPath, szErrTxt, &bmsH, FALSE); //\pɃwb_̂ݎ擾

		bLoad = TRUE;
	}

	CTimer door;
//	while(CloseDoor())
	{
		double time = (double)door.Get();
		DrawTitle(115,50,bmsH.Title, bmsH.Artist, bmsH.Genre);

		int pos = (250-int(time)); RANGE(pos,0,250);
		dd.DrawSprite(369,192-pos, 200-pos); // cd_big
		dd.DrawSprite(369,192+pos, 200-pos); // cd_big
		dd.DrawSprite(369,192-pos, 200+pos); // cd_big
		dd.DrawSprite(369,192+pos, 200+pos); // cd_big

//		double ratio = double(time/250.0);
//		dd.BlendBlt(369,192-pos, 200-pos, ratio); // cd_big
//		dd.BlendBlt(369,192+pos, 200-pos, ratio); // cd_big
//		dd.BlendBlt(369,192-pos, 200+pos, ratio); // cd_big
//		dd.BlendBlt(369,192+pos, 200+pos, ratio); // cd_big
		int width = int(dd.GetSpriteX(390)*bmsH.PlayLevel*time/250.0);
		RANGE(width, 1, dd.GetSpriteX(390)*bmsH.PlayLevel);
		DrawKeyNote(bmsH.PlayLevel,0,width);

		eltime.WaitFrame();
		dd.Flip();
	}
//	wsprintf(szTxt,"End:%d",timeGet());
//	WriteLog(szTxt);
	
	DrawTitle(115,50,bmsH.Title, bmsH.Artist, bmsH.Genre);
	dd.DrawSprite(369,192,200); // cd_big
	DrawKeyNote(bmsH.PlayLevel,0,0);
	dd.Flip();
	dd.SyncScreen();

#endif

/*	while(CloseDoor())
	{
		DrawTitle(20,50,bmsH.Title, bmsH.Artist, bmsH.Genre);
		DrawKeyNote(bmsH.PlayLevel,0,0);
		return(0); //hA`
	}

	DrawTitle(20,50,bmsH.Title, bmsH.Artist, bmsH.Genre);
	DrawKeyNote(bmsH.PlayLevel,0,0);
	dd.Flip();
	dd.DrawSprite(12,0,0,1);	// hȂ΍
	dd.DrawSprite(13,320,0,1);
	DrawTitle(20,50,bmsH.Title, bmsH.Artist, bmsH.Genre);
	DrawKeyNote(bmsH.PlayLevel,0,0);
*/
	char szFileName[MAX_PATH];
	char szPath[MAX_PATH];
	char szFullName[MAX_PATH];

	GetFileName(szFileName, szFile);
	GetPath    (szPath    , szFile);

//	Notice(szFileName);
//	Notice(szPath);

/*	dd.GetLpDD()->FlipToGDISurface();
	MessageBox(hmainwnd, szFile, "Notice", MB_OK);
	MessageBox(hmainwnd, szPath, "Notice", MB_OK);
	MessageBox(hmainwnd, szFileName, "Notice", MB_OK);
*/
	// Ot@Cl[̎擾(ȂłȂɎԂ˂IAPIƂI)
	char szPreDir[MAX_PATH];
	GetCurrentDirectory(sizeof(szPreDir),szPreDir);

	if(!SetCurrentDirectory(szPath))
	{
//		Notice("fffff");
		char szTxt[MAX_PATH];
		szTxt[0]='\0';
		strcat(szTxt, "tH_");
		strcat(szTxt, szPath);
		strcat(szTxt, "\\");
		strcat(szTxt, "܂`");

		dd.GetLpDD()->FlipToGDISurface();
		MessageBox(hmainwnd, szTxt, "G[I", MB_OK);
		return(2);  // ̂܂QuitGame
	}

	WIN32_FIND_DATA wfd;
	HANDLE hFind = FindFirstFile(szFileName,&wfd);

	if(hFind==INVALID_HANDLE_VALUE)
	{
//			Notice("fffff");
		DispLastError();
//			Notice("fffff");
 
		char szTxt[MAX_PATH];
		szTxt[0]='\0';
		strcat(szTxt, "t@C");
		strcat(szTxt, szFileName);
		strcat(szTxt, "܂`");

		dd.GetLpDD()->FlipToGDISurface();
		MessageBox(hmainwnd, szTxt, "G[I", MB_OK);
		return(2);  // ̂܂QuitGame
	}

	strcpy(szFullName,wfd.cFileName);

	FindClose(hFind);
	SetCurrentDirectory(szPreDir);
	// 悤₭擾

	if(CheckType(szFileName) != TYPE_BMS)
	{
		char szTxt[MAX_PATH];
		wsprintf(szTxt,"%s\nABMSt@CȂł",szFullName);

		dd.GetLpDD()->FlipToGDISurface();
		MessageBox(hmainwnd, szTxt, "G[I", MB_OK);
		return(2); //̂܂QuitGame
	}

	BMS bms;
	char szErrTxt[1024];

	// wb_ǂ
//	static HEADER Header;
//	Header.szFile = szFileName;
//	Header.szPath = szPath;
//	ScoreInfo.lpHeader = &Header;

	static MUSIC_DATA Header;
	ScoreInfo.lpHeader = &Header;
	ScoreInfo.fullpath = string(szPath) + "\\" + string(szFileName);

//	if(!LoadBMSHeader(szFileName, szPath, szErrTxt, &bms))
	if(!LoadHeader(ScoreInfo.fullpath, &Header))
	{
		// ǂݍݎs
		WriteLog("InitBMS() : LoadBMSHeader(%s)Ɏs : %s", szFileName, szErrTxt); //sO

		dd.GetLpDD()->FlipToGDISurface();
		MessageBox(hmainwnd, "BMS̃wb_ǂݍ݂Ɏs", "G[I", MB_OK);
		return(2); //̂܂QuitGame
	}

	// Ȗ{̓ǂݍ
	if(LoadBMS(szFileName, szPath, szErrTxt, &bms, TRUE))
	{
		GoBMS(bms);
		if(g_bDoorOpen)
			DRAW_DOOR() // hȂ΍
		else
			dd.ClearScreen();

		dd.UnLoadBMP(17);
		dd.UnLoadBMP(78);
		dd.UnLoadBMP(72);
		dd.UnLoadBMP(2);

		return(1); // Gamemain
	}
	else
	{
		WriteLog("RpCG[ : %s",szErrTxt);
		dd.GetLpDD()->FlipToGDISurface();
		MessageBox(hmainwnd, szErrTxt, "RpCG[I", MB_OK);
		return(2); //̂܂QuitGame
	}

}

// őlAŏl𒴂ꍇۂ߂B
BOOL SetVolume(DWORD dwVol){

    MMRESULT rc;              // Return code.
    HMIXER hMixer;            // Mixer handle used in mixer API calls.
    MIXERCONTROL mxc;         // Holds the mixer control data.
    MIXERLINE mxl;            // Holds the mixer line data.
    MIXERLINECONTROLS mxlc;   // Obtains the mixer control.

    // Open the mixer. This opens the mixer with a deviceID of 0. If you
    // have a single sound card/mixer, then this will open it. If you have
    // multiple sound cards/mixers, the deviceIDs will be 0, 1, 2, and
    // so on.
    rc = mixerOpen(&hMixer, 0,0,0,0);
    if (MMSYSERR_NOERROR != rc) {
		WriteLog("SetVolume() s!(mixerOpen)");
		return(FALSE);
        // Couldn't open the mixer.
    }

    // Initialize MIXERLINE structure.
    ZeroMemory(&mxl,sizeof(mxl));
    mxl.cbStruct = sizeof(mxl);

    // Specify the line you want to get. You are getting the input line
    // here. If you want to get the output line, you need to use
    // MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT.
    mxl.dwComponentType = MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT;

    rc = mixerGetLineInfo((HMIXEROBJ)hMixer, &mxl,
                           MIXER_GETLINEINFOF_COMPONENTTYPE);
    if (MMSYSERR_NOERROR != rc) {
		mixerClose(hMixer);
		WriteLog("SetVolume() s!(mixerGetLineInfo)");
		return(FALSE);
        // Couldn't get the mixer line.
    }

    // Get the control.
    ZeroMemory(&mxlc, sizeof(mxlc));
    mxlc.cbStruct = sizeof(mxlc);
    mxlc.dwLineID = mxl.dwLineID;
    mxlc.dwControlType = MIXERCONTROL_CONTROLTYPE_VOLUME;
    mxlc.cControls = 1;
    mxlc.cbmxctrl = sizeof(mxc);
    mxlc.pamxctrl = &mxc;
    ZeroMemory(&mxc, sizeof(mxc));
    mxc.cbStruct = sizeof(mxc);
    rc = mixerGetLineControls((HMIXEROBJ)hMixer,&mxlc,
                               MIXER_GETLINECONTROLSF_ONEBYTYPE);
    if (MMSYSERR_NOERROR != rc) {
		mixerClose(hMixer);

/*		switch(rc)
		{
		case MIXERR_INVALCONTROL:
			return(-3);
		case MIXERR_INVALLINE:
			return(-4);
		case MMSYSERR_BADDEVICEID:
			return(-5);
		case MMSYSERR_INVALFLAG:
			return(-6);
		case MMSYSERR_INVALHANDLE:
			return(-7);
		case MMSYSERR_INVALPARAM:
			return(-8);
		case MMSYSERR_NODRIVER:
			return(-9);
		}
*/
		WriteLog("SetVolume() s!(mixerGetLineControls)");
		return(FALSE);
        // Couldn't get the control.
    }


    // After successfully getting the peakmeter control, the volume range
    // will be specified by mxc.Bounds.lMinimum to mxc.Bounds.lMaximum.

    MIXERCONTROLDETAILS mxcd;             // Gets the control values.
    MIXERCONTROLDETAILS_SIGNED volStruct; // Gets the control values.
//    long volume;                          // Holds the final volume value.

	// 0ŏlɂƂ
	if(dwVol==0)
		dwVol = (DWORD)mxc.Bounds.lMinimum;

	if( DWORD(mxc.Bounds.lMaximum)<dwVol)   // őlɊۂ߂
		dwVol = (DWORD)mxc.Bounds.lMaximum;

	if( DWORD(mxc.Bounds.lMinimum)>dwVol)   // ŏlɊۂ߂
		dwVol = (DWORD)mxc.Bounds.lMinimum;

	volStruct.lValue = (long)dwVol;

    // Initialize the MIXERCONTROLDETAILS structure
    ZeroMemory(&mxcd, sizeof(mxcd));
    mxcd.cbStruct = sizeof(mxcd);
    mxcd.cbDetails = sizeof(volStruct);
    mxcd.dwControlID = mxc.dwControlID;
    mxcd.paDetails = &volStruct;
    mxcd.cChannels = 1;

    // Get the current value of the peakmeter control. Typically, you
    // would set a timer in your program to query the volume every 10th
    // of a second or so.
    rc = mixerSetControlDetails((HMIXEROBJ)hMixer, &mxcd,
                                 MIXER_GETCONTROLDETAILSF_VALUE);
    if (MMSYSERR_NOERROR != rc) {
		mixerClose(hMixer);
		WriteLog("SetVolume() s!(mixerSetControlDetails)");
		return(FALSE);
        // Couldn't get the current volume.
    }

	mixerClose(hMixer);

	return(TRUE);

}

int GetVolume(void){

    MMRESULT rc;              // Return code.
    HMIXER hMixer;            // Mixer handle used in mixer API calls.
    MIXERCONTROL mxc;         // Holds the mixer control data.
    MIXERLINE mxl;            // Holds the mixer line data.
    MIXERLINECONTROLS mxlc;   // Obtains the mixer control.

    // Open the mixer. This opens the mixer with a deviceID of 0. If you
    // have a single sound card/mixer, then this will open it. If you have
    // multiple sound cards/mixers, the deviceIDs will be 0, 1, 2, and
    // so on.
    rc = mixerOpen(&hMixer, 0,0,0,0);
    if (MMSYSERR_NOERROR != rc) {
		return(-1);
        // Couldn't open the mixer.
    }

    // Initialize MIXERLINE structure.
    ZeroMemory(&mxl,sizeof(mxl));
    mxl.cbStruct = sizeof(mxl);

    // Specify the line you want to get. You are getting the input line
    // here. If you want to get the output line, you need to use
    // MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT.
    mxl.dwComponentType = MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT;

    rc = mixerGetLineInfo((HMIXEROBJ)hMixer, &mxl,
                           MIXER_GETLINEINFOF_COMPONENTTYPE);
    if (MMSYSERR_NOERROR != rc) {
		mixerClose(hMixer);
		return(-1);
        // Couldn't get the mixer line.
    }

    // Get the control.
    ZeroMemory(&mxlc, sizeof(mxlc));
    mxlc.cbStruct = sizeof(mxlc);
    mxlc.dwLineID = mxl.dwLineID;
    mxlc.dwControlType = MIXERCONTROL_CONTROLTYPE_VOLUME;
    mxlc.cControls = 1;
    mxlc.cbmxctrl = sizeof(mxc);
    mxlc.pamxctrl = &mxc;
    ZeroMemory(&mxc, sizeof(mxc));
    mxc.cbStruct = sizeof(mxc);
    rc = mixerGetLineControls((HMIXEROBJ)hMixer,&mxlc,
                               MIXER_GETLINECONTROLSF_ONEBYTYPE);
    if (MMSYSERR_NOERROR != rc) {
		mixerClose(hMixer);

		switch(rc)
		{
		case MIXERR_INVALCONTROL:
			return(-3);
		case MIXERR_INVALLINE:
			return(-4);
		case MMSYSERR_BADDEVICEID:
			return(-5);
		case MMSYSERR_INVALFLAG:
			return(-6);
		case MMSYSERR_INVALHANDLE:
			return(-7);
		case MMSYSERR_INVALPARAM:
			return(-8);
		case MMSYSERR_NODRIVER:
			return(-9);
		}

		return(-2);
        // Couldn't get the control.
    }

    // After successfully getting the peakmeter control, the volume range
    // will be specified by mxc.Bounds.lMinimum to mxc.Bounds.lMaximum.

    MIXERCONTROLDETAILS mxcd;             // Gets the control values.
    MIXERCONTROLDETAILS_SIGNED volStruct; // Gets the control values.
    long volume;                          // Holds the final volume value.

    // Initialize the MIXERCONTROLDETAILS structure
    ZeroMemory(&mxcd, sizeof(mxcd));
    mxcd.cbStruct = sizeof(mxcd);
    mxcd.cbDetails = sizeof(volStruct);
    mxcd.dwControlID = mxc.dwControlID;
    mxcd.paDetails = &volStruct;
    mxcd.cChannels = 1;

    // Get the current value of the peakmeter control. Typically, you
    // would set a timer in your program to query the volume every 10th
    // of a second or so.
    rc = mixerGetControlDetails((HMIXEROBJ)hMixer, &mxcd,
                                 MIXER_GETCONTROLDETAILSF_VALUE);
    if (MMSYSERR_NOERROR != rc) {
		mixerClose(hMixer);
		return(-1);
        // Couldn't get the current volume.
    }
    volume = volStruct.lValue;

    // Get the absolute value of the volume.
    if (volume < 0)
        volume = -volume;

//	char szTxt[1024];
//	wsprintf(szTxt,"Volume = %d",volume);
//	MessageBox(hmainwnd, szTxt, "Notice", MB_OK);

	mixerClose(hMixer);

	return ( (int)volume );

}

//char szFile[512][MAX_PATH];
//char szPath[512][MAX_PATH];

// tH_c[
void DirDiver(const char* DirName, HEADER* lpHeader[], int level, int max, int* files)
{

	if(level<0) // Kw`FbN
		return;

	WIN32_FIND_DATA fd;  // 񋓏擾p

	char Pattern[MAX_PATH];
	Pattern[0] = '\0';
	strcat(Pattern, DirName);  // ChJ[hőSt@C 

//	static int fileCount;

//	if(level == 2)
//		fileCount = *iFileNum;

	char* yen = strrchr(Pattern, '\\');

	if(yen != NULL) // \ĂĂvI
	{
		if(yen[1] == '\0')
		  strcat(Pattern, "*.*");
		else
		  strcat(Pattern, "\\*.*");

	}else
		strcat(Pattern, "\\*.*");

//  char log[MAX_PATH];
//  wsprintf(log, "Start Finding %s...",Pattern);
//  WriteLog(log);

	HANDLE hFind;   // p̃nh 
	hFind = FindFirstFile(Pattern ,&fd); // ŏ̃t@C 

	if(hFind==INVALID_HANDLE_VALUE)
	  return;  // t@C͂P݂Ȃ(ۂ . ..̂ŎsȂ͂)

	do
	{

		if(strcmp(fd.cFileName,".")!=0 && strcmp(fd.cFileName,"..")!=0 ) // . ..͖
		{ 
			if(CheckType(fd.cFileName) == TYPE_MSD ||
			   CheckType(fd.cFileName) == TYPE_BMS    ) // mĂ`
			{

				if((*files) >= max)
				{
					FindClose(hFind);  //nh
					return;
				}

				lpHeader[*files] = new(HEADER);

				if(lpHeader[*files]==NULL)
				{
					WriteLog("DirDiver() : mۂɎsI");
					FindClose(hFind);  //nh
					QuitGame(hmainwnd);
				}

				lpHeader[*files]->szFile = fd.cFileName;
				lpHeader[*files]->szPath = DirName;
				lpHeader[*files]->iDirDepth = level;

//				lpHeader++;
				(*files)++;

			}

			if(fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) // tH_ׂ 
			{ 

				if((*files) >= max)
				{
					FindClose(hFind);  //nh
					return;
				}

				char SubFolder[MAX_PATH];
				SubFolder[0]='\0';

				strcat(SubFolder, DirName);

				char* yen = strrchr(SubFolder, '\\');

				if(yen != NULL)
				{
					if(yen[1] == '\0')
						; /* k:\hoge\ */
					else
						strcat(SubFolder, "\\"); // \ĂȂĂvI /* k:\hoge\hoge */
				}else
					strcat(SubFolder, "\\"); // \ĂȂĂvI(k:)

				strcat(SubFolder, fd.cFileName);  //݂̃tH_ɌtH_ǉ 

//				char log[MAX_PATH];
//				wsprintf(log, "Start Finding %s...",SubFolder);
//				WriteLog(log);
			
				DirDiver(SubFolder , lpHeader, level-1, max, files);  // TutH_

			} //endof tH_ׂ

		} //endof .͖

	}while( FindNextFile(hFind,&fd) == TRUE );  // t@CȂ܂ő

	FindClose(hFind);  //nh

}

// CMusicListpBˑ֌W̉Ȃ̂łƂ肠RRɒu
// path : t@C̃pX
// MSD̏ꍇAMUSIC_DATAmsdDiff̂ݎw肵ĂKvBȊO͒g͋ł
BOOL LoadHeader(string path, MUSIC_DATA* lpHeader){

	lpHeader->crc32 = 0xFFFFFFFF; // vZ

	// tH_ƃpXɕ
	char folder[MAX_PATH];
	char file[MAX_PATH];
	GetPath(folder, path.c_str());
	GetFileName(file, path.c_str());

	if(CheckType(path.c_str())==TYPE_MSD)
	{
		MSD msd;
		ZERO(msd);
		char szErrTxt[512];

		// MSDɊ֌WȂ̂𖄂߂
		lpHeader->bMidi		= FALSE;
		lpHeader->bBMP		= FALSE;
		lpHeader->bPlayable = FALSE;
		lpHeader->genre		= "";
		lpHeader->rank		= 2;
		lpHeader->player	= -1;

		// ܂Short-WAVǂłȂ̂ŌłȂ
		lpHeader->WavCh	= -1;

		if(!LoadMSDData(file, folder, szErrTxt, &msd))
		{
			// ǂݍݎs
			WriteLog("LoadHeader() : %s : %s", file, szErrTxt); //sO
			lpHeader->level		= 0; //msd.level[k];
			lpHeader->CDTr		= -1; //msd.CDtrack;
			lpHeader->bWavBGM	= FALSE;
			// lpHeader->szMSDFile = ""; p~
			lpHeader->title		= "";
			lpHeader->artist	= "";
			// lpHeader->msdAuthor	= ""; p~
			lpHeader->mode		= 0;
			lpHeader->iBMLines  = 0; // 5line
			lpHeader->iDDRLines = 0; // 4arrow
			lpHeader->dBPM		= 120.0;

			return FALSE;
		}
		else
		{
			// ǂݍݐ
/*			if(lpHeader->msdDiff < SINGLE+BASIC || lpHeader->msdDiff > COUPLE+MANIAC)
				assert(0);
			else
				lpHeader->level = msd.level[lpHeader->msdDiff];
*/
			lpHeader->CDTr		= msd.CDtrack;
			lpHeader->bWavBGM	= msd.bWavBGM;

			//lpHeader->szMSDFile = msd.file;

			lpHeader->title		= msd.title;
			lpHeader->artist	= msd.artist;
			// lpHeader->msdAuthor	= msd.msdMaker; p~
			lpHeader->mode		= 0;
			lpHeader->iBMLines  = msd.iBMLines;
			lpHeader->iDDRLines = msd.iDDRLines;
			lpHeader->dBPM		= msd.BPM;

			return TRUE;
		}
	}

	if(CheckType(path.c_str())==TYPE_BMS)
	{
		BMS bms;
		ZERO(bms);

		// BMSɊ֌WȂ𖄂߂
		// lpHeader->szMSDFile = ""; p~
		// lpHeader->msdDiff = -1; p~
		// lpHeader->msdAuthor = ""; p~

		// ܂Short-WAVǂłȂ̂ŌłȂ
		lpHeader->WavCh	= -1;

		char szErrTxt[1024];
		if(!LoadBMSHeader(file, folder, szErrTxt, &bms))
		{
			// ǂݍݎs
			WriteLog("LoadHeader() : %s : %s", file, szErrTxt); //sO

			lpHeader->level		= 0;
			lpHeader->player	= 1;
			lpHeader->rank		= 2;
			lpHeader->bMidi		= FALSE;
			lpHeader->CDTr		= -1;
			lpHeader->bBMP		= FALSE;
			lpHeader->bPlayable = FALSE;
			lpHeader->bWavBGM	= FALSE;
			lpHeader->title		= "";
			lpHeader->artist	= "";
			lpHeader->genre		= "";
			lpHeader->mode		= 0;
			lpHeader->iBMLines  = 0; // 5line
			lpHeader->iDDRLines = 0; // 4arrow
			lpHeader->dBPM		= 130.0;
			lpHeader->bStageFile = FALSE;

			return FALSE;
		}
		else
		{
			// ǂݍݐ
			lpHeader->level = bms.PlayLevel;

			if(bms.MIDIFile[0] == '\0')
				lpHeader->bMidi = FALSE;
			else
				lpHeader->bMidi = TRUE;

			lpHeader->player	= bms.Player;
			lpHeader->rank		= bms.Rank;
			lpHeader->CDTr		= bms.CDtrack;
			lpHeader->bBMP		= bms.bBMP;
			lpHeader->bPlayable = bms.bPlayable;
			lpHeader->bWavBGM	= bms.bWavBGM;
			lpHeader->iBMLines  = bms.iBMLines;
			lpHeader->iDDRLines = bms.iDDRLines;
			lpHeader->dBPM		= bms.BPM;

			lpHeader->title		= bms.Title;
			lpHeader->artist	= bms.Artist;
			lpHeader->genre		= bms.Genre;

			lpHeader->bStageFile = bms.bStageFile;
			lpHeader->stageFile = bms.stageFile;

			// ʂɕ\Փx
			lpHeader->mode = 0;

			if( strmatch(bms.Title, "BASIC")!=NULL ||
				strmatch(bms.Genre, "BASIC")!=NULL    )
					lpHeader->mode = 0;
			else 
				if( strmatch(bms.Title, "ANOTHER")!=NULL ||
					strmatch(bms.Genre, "ANOTHER")!=NULL    )
						lpHeader->mode = 1;
			else 
				if( strmatch(bms.Title, "TRICK")!=NULL ||
					strmatch(bms.Genre, "TRICK")!=NULL    )
						lpHeader->mode = 1;

			else
				if( strmatch(bms.Title, "SSR")!=NULL ||
					strmatch(bms.Genre, "SSR")!=NULL    )
						lpHeader->mode = 2;

			else
				if( strmatch(bms.Title, "MANIAC")!=NULL ||
					strmatch(bms.Genre, "MANIAC")!=NULL    )
						lpHeader->mode = 2;

			return TRUE;
		}

	}

	// t@C`s
	return FALSE;

}

// HEADERɂszFile, szPathݒ肵ĂĂԂ
void LoadHeader(HEADER* lpHeader){

	for(int i=0;i<10;i++)
		lpHeader->crc32[i] = 0xFFFFFFFF; // vZ

	if(CheckType(lpHeader->szFile.c_str())==TYPE_MSD)
	{
		MSD msd;
		ZERO(msd);
		char szErrTxt[512];

		// MSDɊ֌WȂ̂𖄂߂
		lpHeader->bMidi		= FALSE;
		lpHeader->bBMP		= FALSE;
		lpHeader->bPlayable = FALSE;
		lpHeader->genre		= "";
		lpHeader->rank		= 2;
		lpHeader->player	= -1;

		if(!LoadMSDData(lpHeader->szFile.c_str(), lpHeader->szPath.c_str(), szErrTxt,&msd))
		{
			// ǂݍݎs
			WriteLog("LoadHeader() : %s : %s",lpHeader->szFile.c_str(),szErrTxt); //sO
			for(int k=0;k<10;k++)
				lpHeader->level[k] = 0; //msd.level[k];

			lpHeader->CDTr		= -1; //msd.CDtrack;
			lpHeader->WavCh		= -1;
			lpHeader->bWavBGM	= FALSE;
			lpHeader->szMSDFile = "";
			lpHeader->title		= "";
			lpHeader->artist	= "";
			lpHeader->msdAuthor	= "";
			lpHeader->mode		= 0;
			lpHeader->iBMLines  = 0; // 5line
			lpHeader->iDDRLines = 0; // 4arrow
			lpHeader->dBPM		= 120.0;
		}
		else
		{
			// ǂݍݐ
			lpHeader->level[0] = 0;
			for(int k=SINGLE+BASIC;k<=COUPLE+MANIAC;k++)
				lpHeader->level[k+1] = msd.level[k];

			lpHeader->CDTr		= msd.CDtrack;
			lpHeader->WavCh		= -1;
			lpHeader->bWavBGM	= msd.bWavBGM;

			lpHeader->szMSDFile = msd.file;

			lpHeader->title		= msd.title;
			lpHeader->artist	= msd.artist;
			lpHeader->msdAuthor	= msd.msdMaker;
			lpHeader->mode		= 0;
			lpHeader->iBMLines  = msd.iBMLines;
			lpHeader->iDDRLines = msd.iDDRLines;
			lpHeader->dBPM		= msd.BPM;
		}
	}

	if(CheckType(lpHeader->szFile.c_str())==TYPE_BMS)
	{
		BMS bms;
		ZERO(bms);

		// BMSɊ֌WȂ𖄂߂
		lpHeader->WavCh		= -1;
		lpHeader->szMSDFile = "";
		lpHeader->msdAuthor = "";

		char szErrTxt[1024];
		if(!LoadBMSHeader(lpHeader->szFile.c_str(),lpHeader->szPath.c_str(), szErrTxt,&bms))
		{
			// ǂݍݎs
			WriteLog("LoadHeader() : %s : %s",lpHeader->szFile.c_str(),szErrTxt); //sO

			for(int k=0;k<10;k++)
				lpHeader->level[k] = 0;

			lpHeader->player	= 1;
			lpHeader->rank		= 2;
			lpHeader->bMidi		= FALSE;
			lpHeader->CDTr		= -1;
			lpHeader->WavCh		= -1;
			lpHeader->bBMP		= FALSE;
			lpHeader->bPlayable = FALSE;
			lpHeader->bWavBGM	= FALSE;
			lpHeader->title		= "";
			lpHeader->artist	= "";
			lpHeader->genre		= "";
			lpHeader->mode		= 0;
			lpHeader->iBMLines  = 0; // 5line
			lpHeader->iDDRLines = 0; // 4arrow
			lpHeader->dBPM		= 130.0;
		}
		else
		{
			// ǂݍݐ
			lpHeader->level[0] = bms.PlayLevel;
			for(int k=SINGLE+BASIC;k<=COUPLE+MANIAC;k++)
				lpHeader->level[k+1] = bms.PlayLevel;

			if(bms.MIDIFile[0] == '\0')
				lpHeader->bMidi = FALSE;
			else
				lpHeader->bMidi = TRUE;

			lpHeader->player	= bms.Player;
			lpHeader->rank		= bms.Rank;
			lpHeader->CDTr		= bms.CDtrack;
			lpHeader->WavCh		= -1;
			lpHeader->bBMP		= bms.bBMP;
			lpHeader->bPlayable = bms.bPlayable;
			lpHeader->bWavBGM	= bms.bWavBGM;
			lpHeader->iBMLines  = bms.iBMLines;
			lpHeader->iDDRLines = bms.iDDRLines;
			lpHeader->dBPM		= bms.BPM;

			lpHeader->title		= bms.Title;
			lpHeader->artist	= bms.Artist;
			lpHeader->genre		= bms.Genre;

			// ftHg
			lpHeader->mode = 0;

			if( strmatch(bms.Title, "BASIC")!=NULL ||
				strmatch(bms.Genre, "BASIC")!=NULL    )
					lpHeader->mode = 0;
			else 
				if( strmatch(bms.Title, "ANOTHER")!=NULL ||
					strmatch(bms.Genre, "ANOTHER")!=NULL    )
						lpHeader->mode = 1;
			else 
				if( strmatch(bms.Title, "TRICK")!=NULL ||
					strmatch(bms.Genre, "TRICK")!=NULL    )
						lpHeader->mode = 1;

			else
				if( strmatch(bms.Title, "SSR")!=NULL ||
					strmatch(bms.Genre, "SSR")!=NULL    )
						lpHeader->mode = 2;

			else
				if( strmatch(bms.Title, "MANIAC")!=NULL ||
					strmatch(bms.Genre, "MANIAC")!=NULL    )
						lpHeader->mode = 2;

		}

	}

}

int LoadCache(HEADER* lpHeader[]){

	FILE* fp = fopen(szLstFile,"r"); // LbVǂݍ

	if(fp==NULL)
	{
		char szWinDir[MAX_PATH];
		GetWindowsDirectory(szWinDir, MAX_PATH);
		strcat(szWinDir,"\\cache.lst");
		fp = fopen(szWinDir, "r");
	}

	int files=0;

	if(fp!=NULL)
	{
		char sztmp[500];
		GetLine(fp, sztmp, 500);

		if(strcmp(sztmp, "DDR050_CacheFile")!=0)
		{
			fclose(fp);
			return 0;
		}

		fscanf(fp, "%d\n", &files);

		if(files>MAX_JUKE*MAX_FILES) files = MAX_JUKE*MAX_FILES;

		for(int i=0;i<files;i++)
		{
			lpHeader[i] = new(HEADER);
			if(lpHeader[i]==NULL)
			{
				WriteLog("LoadCache() : mۂɎsI");
				fclose(fp);
				QuitGame(hmainwnd);
			}

			if(GetLine(fp,sztmp,MAX_PATH)==0) // ŏ1񂭂炢̓G[`FbN
			{
				fclose(fp);
				DELETE_SAFE(lpHeader[i]);
				return(i);
			}

			lpHeader[i]->szFile = sztmp;

			GetLine(fp,sztmp,MAX_PATH);
			lpHeader[i]->szPath = sztmp;

			GetLine(fp,sztmp,MAX_PATH);
			lpHeader[i]->szMSDFile = sztmp;

			GetLine(fp,sztmp,500);
			lpHeader[i]->title = sztmp;

			GetLine(fp,sztmp,500);
			lpHeader[i]->artist = sztmp;

			GetLine(fp,sztmp,500);
			lpHeader[i]->genre = sztmp;

			GetLine(fp,sztmp,500);
			lpHeader[i]->msdAuthor = sztmp;

			for(int k=0;k<10;k++)
			{
				lpHeader[i]->crc32[k] = 0xFFFFFFFF; // vZ
				fscanf(fp, "%d ", &(lpHeader[i]->level[k]) );
			}

			fscanf(fp, "\n%d %d %d %d %d %d %d %d %d %d %d %lf\n\n", &(lpHeader[i]->CDTr), &(lpHeader[i]->bWavBGM),   &(lpHeader[i]->bMidi),
																	&(lpHeader[i]->bBMP), &(lpHeader[i]->bPlayable), &(lpHeader[i]->iDirDepth),
																	&(lpHeader[i]->rank), &(lpHeader[i]->player),	&(lpHeader[i]->mode),
																	&(lpHeader[i]->iBMLines), &(lpHeader[i]->iDDRLines), &(lpHeader[i]->dBPM) );
			
			lpHeader[i]->WavCh = -1; // 0MSDBGMꂿႤ

/*			// eʂςĂ݂邽߂Ƀ_~[ŃXRAo^
			{
				string filename = AddYen(lpHeader[i]->szPath) + lpHeader[i]->szFile;

				int file_size = score.GetFileSize(filename.c_str());
				if(file_size==-1)
				{
					WriteLog("WriteScore() : t@CTCY擾Ɏs (file:%s)", filename.c_str());
				}

				DWORD file_crc;
				int file_type;
				if(CheckType(lpHeader[i]->szFile.c_str()))
				{
					// BMS
					file_crc = score.CalcCRC32(filename.c_str());
					file_type = TYPE_BMS;
				}
				else
				{
					// MSD
					file_crc = score.CalcCRC32(filename.c_str(), pd.mode);
					file_type = TYPE_MSD;
				}

				if(file_crc==0xFFFFFFFF)
				{
					// t@Cort@CI[vsƌĂł傤
					WriteLog("WriteScore() : CRC擾ɎsH (file:%s)", filename.c_str());
				}

				SCORE sc = { 0 };
				// VKo^
				MUSIC_STAT newMS;
				ZeroMemory(&newMS, sizeof(newMS));
				newMS.filesize = file_size;
				newMS.filetype = file_type;
				newMS.title	 = lpHeader[i]->title;
				newMS.artist = lpHeader[i]->artist;
				newMS.genre	 = lpHeader[i]->genre;
				score.RegistScore(&newMS, &sc, (IsBM() ? MODE_BM : MODE_DDR));
				score.Insert(file_crc, (DWORD)file_size, &newMS);

			} // endof score regist
*/

//			lpHeader++;
		}
		fclose(fp);
		return(files);

	}//endof if(fp!=NULL)

	return 0;

}

BOOL SaveCache(HEADER* lpHeader[], int files){

	return FALSE;

	DWORD oldAttr = GetFileAttributes(szLstFile);

	SetFileAttributes(szLstFile, FILE_ATTRIBUTE_NORMAL);
	FILE* fp = fopen(szLstFile,"w"); // LbV

	if(fp==NULL)
	{
		// WindowstH_ǂł݂
		char szWinDir[MAX_PATH];
		GetWindowsDirectory(szWinDir, MAX_PATH);
		strcat(szWinDir,"\\cache.lst");
		fp = fopen(szWinDir, "w");
	}

	if(fp!=NULL)
	{
		fprintf(fp, "DDR050_CacheFile\n");
		fprintf(fp, "%d\n", files);

		for(int i=0;i<files;i++)
		{

			if(lpHeader[i]==NULL) // ی :-p
				break;

			fprintf(fp, "%s\n", lpHeader[i]->szFile.c_str() );
			fprintf(fp, "%s\n", lpHeader[i]->szPath.c_str() );
			fprintf(fp, "%s\n", lpHeader[i]->szMSDFile.c_str() );
			fprintf(fp, "%s\n", lpHeader[i]->title.c_str() );
			fprintf(fp, "%s\n", lpHeader[i]->artist.c_str() );
			fprintf(fp, "%s\n", lpHeader[i]->genre.c_str() );
			fprintf(fp, "%s\n", lpHeader[i]->msdAuthor.c_str() );

			for(int k=0;k<10;k++)
				fprintf(fp, "%d ", lpHeader[i]->level[k] );

			fprintf(fp,"\n");

			fprintf(fp, "%d %d %d %d %d %d %d %d %d %d %d %lf\n\n",	lpHeader[i]->CDTr, lpHeader[i]->bWavBGM,   lpHeader[i]->bMidi,
																	lpHeader[i]->bBMP, lpHeader[i]->bPlayable, lpHeader[i]->iDirDepth,
																	lpHeader[i]->rank, lpHeader[i]->player,	 lpHeader[i]->mode,
																	lpHeader[i]->iBMLines, lpHeader[i]->iDDRLines, lpHeader[i]->dBPM);

//			lpHeader++;

		}

		fclose(fp);
		if(oldAttr!=0xFFFFFFFF)
			SetFileAttributes(szLstFile, oldAttr);

		return(TRUE);

	}//endof if(fp!=NULL)

	if(oldAttr!=0xFFFFFFFF)
		SetFileAttributes(szLstFile, oldAttr);

	return FALSE;

}

// G[AIFALSE
BOOL SearchMusic(BOOL bUpdateCheck){

	WriteLog("SearchMusic() : Start!");

	{
		// gȂǁASڍs܂ł͗Ȃ悤ɎcƂ
		// JukeBoxf[^
		for(int j=0;j<MAX_JUKE;j++)
		{
			JukeBox[j].iFileNum = 0;
			JukeBox[j].szJuke	= "";
			for(int k=0;k<MAX_FILES;k++)
				DELETE_SAFE(JukeBox[j].Musdat[k]);
		}
		iFolder = 0;
	}

	// VSYNC҂ŒxȂ̖h
	int flipmode = dd.GetFlipMode();
	dd.SetFlipMode(FLIP_DIRECTBLT);

//	dd.DrawText(175, 235, "Please Wait, Searching BMS & MSD Files...");

	// Loading...
	{
		int w = dd.GetSpriteX(404);
		int h = dd.GetSpriteY(404);
		dd.DrawSprite(404, 320-w/2, 240-h/2);
	}
	dd.Flip();

	if(szDropPathArray.size()!=0) // t@CortH_hbvĂ
	{
		Juke.SetSaveCache(FALSE); // LbV܂Ȃݒ

		for(vector<string>::iterator it=szDropPathArray.begin() ; it!=szDropPathArray.end() ; it++)
		{
			const char* path = it->c_str();
			if(IsFolder(path))
			{
				// hbvꂽtH_XL
				WriteLog("MusicData Searching... Target:%s", path);
				Juke.SearchMusic(path);
			}
			else
			{
				// hbvꂽt@CJuke\
				// Ή
				/*
				char buf[MAX_PATH];

				lpHeader[files] = new(HEADER);

				GetFileName(buf, path);
				lpHeader[files]->szFile = buf;

				GetPath(buf, path);
				lpHeader[files]->szPath = buf;

				lpHeader[files]->iDirDepth = 2; // TopDir
				files++;
				*/
			}
		}
		WriteLog("Search OK.");
	}
	else
	{
		// tH_hbvĂȂ

		// LbVǂݍ
		WriteLog("%s Loading...",szLstFile);
		if(Juke.LoadCache())
		{
			WriteLog("%s Load OK.",szLstFile);
		}
		else
		{
			WriteLog("%s Load Failed.",szLstFile);
		}

		// XV`FbNwĂ΁ALbVɏĂȂŁAɑ݂Ȃ̂폜
		if(bUpdateCheck)
			Juke.DeleteNotExist();

		// *.lsthbvꂽLbVACFǦpXȂ
		if(g_bCacheDrop)
		{
			Juke.SetSaveCache(FALSE); // LbV㏑Ȃ
		}
		else
		{
			Juke.SetSaveCache(TRUE);

			// Ȃ̍XV`FbNwĂ邩AȂ1ȂȂ(LbVǂ߂ĂȂ)
			// Ƃ͋Ȍs
			if(bUpdateCheck || Juke.size()==0)
			{
				int i=1;
				while(szSearchPath[i][0]!='\0')
				{
					WriteLog("MusicData Searching... Target:%s", szSearchPath[i]);

					Juke.SearchMusic(szSearchPath[i]);

					WriteLog("Search OK.");

					i++;
				}
			}

			Juke.StartBGScan();

			if(Cfg["AutoRescan"]==AR_AUTO_FGSCAN || Cfg["AutoRescan"]==AR_MANUAL_FGSCAN)
			{
				// BGScanȂݒȂABGScanI܂ł̏ő҂Ƃ
				// BGScanȂ悤Ɍ
				while(!Juke.IsBGScanStopping())
					Sleep(10);
			}
		}

	}

	if(Juke.size() == 0)
	{
		WriteLog("SearchMusic() : No MusicData found");
		dd.GetLpDD()->FlipToGDISurface();
		MessageBox(hmainwnd, "ȃf[^Ȃ`", "`ɂ", MB_OK);
		return FALSE;
	}

/*
	// T|[gȂ
	if(opt.bShortWAV) // TrWAVE,IvVύX͍ċNL
	{
		int iSWavCh = SHORTWAV_START; //Short-WAVE ChJE^

		for(i=0;i<files;i++)
		{
			char szTxt[MAX_PATH];

			if(lpHeader[i]==NULL) //ی
				break;

			if(lpHeader[i]->szMSDFile.empty()==false)
			{
				wsprintf(szTxt,"Bgm\\%ss.wav",lpHeader[i]->szMSDFile.c_str());
				if(ds.LoadWaveFile(iSWavCh,szTxt))
				{
					dd.ClearScreen();
					char szTmp[200];
					wsprintf(szTmp, "Please Wait, Loading Short-WAVE...(%4d/%4d)",i+1,files);
					dd.DrawText(175, 235, szTmp);
					dd.DrawText(175, 253, lpHeader[i]->szFile.c_str());
					dd.Flip();

					char szTxt2[1024];
					sprintf(szTxt2,"Short-WAV No.%d = %s",iSWavCh,szTxt);
					WriteLog(szTxt2);

					lpHeader[i]->WavCh = iSWavCh;
					iSWavCh++;
				}
			}
		}
	}
*/

	dd.SetFlipMode(flipmode);

	// ĂƁ`
/*	Juke.LoadCache();
	DWORD time1 = timeGetTime();
	Juke.SearchMusic(".\\");
	DWORD time2 = timeGetTime();

	WriteLog("Search Time : %u ms", time2-time1);

	for(DWORD i=0;i<list.size();i++)
	{
		WriteLog("JukeBox[%d] : Name : %s, folder : %s", i, list[i].jukeName.c_str(), list[i].folder.c_str());
		for(DWORD j=0;j<list[i].size();j++)
		{
			WriteLog("\tDataSet[%d] : Name : %s, folder : %s", j, list[i][j].musicName.c_str(), list[i][j].folder.c_str());
			for(DWORD k=0;k<list[i][j].size();k++)
			{
				WriteLog("\t\tMusic[%d] : %s", k, list[i][j][k].szFile.c_str());
			}
		}
	}
*/

	WriteLog("SearchMusic() : Done!");

	return TRUE;
}

// lpHeader : NULL-terminated HEADER array
void MakeJukeBox(HEADER* lpHeader[]){

//	JukeBox[0].szJuke = "TOP Directory";
	iFolder=0;

	int i=0,j=0;
	while(lpHeader[j]!=NULL)
	{
		if(FALSE)//lpHeader[j]->iDirDepth == MAX_DEPTH || lpHeader[j]->iDirDepth == MAX_DEPTH-1)
		{
			JukeBox[0].Musdat[JukeBox[0].iFileNum] = lpHeader[j];
			JukeBox[0].iFileNum++;
		}
		else
		{
			int iNum = -1;
			for(int k=0;k<i;k++)
			{
				string temp = lpHeader[j]->szPath;
				if(CYFile::GetParentDir(temp)==1) // Ȃ̂tH_̖O폜
					temp = ".\\";

				if(temp.substr(temp.length()-1,1)=="\\") // Ō\폜
					temp.erase(temp.length()-1,1);

				UINT pos = temp.find(".\\");
				if(pos!=-1)
					temp.erase(pos,2); // 擪".\"폜

				if(JukeBox[k].szJuke==temp)
					iNum = k;
			}

			if(iNum==-1)
			{
				if(i<MAX_JUKE) // JukeBox
				{
					// VJukeBox쐬
					JukeBox[i].szJuke = lpHeader[j]->szPath;

					if(CYFile::GetParentDir(JukeBox[i].szJuke)==1) // Ȃ̂tH_̖O폜
						JukeBox[i].szJuke = ".\\";

					if(JukeBox[i].szJuke.substr(JukeBox[i].szJuke.length()-1,1)=="\\") // Ō\폜
						JukeBox[i].szJuke.erase(JukeBox[i].szJuke.length()-1,1);

					UINT pos = JukeBox[i].szJuke.find(".\\");
					if(pos!=-1)
						JukeBox[i].szJuke.erase(pos,2); // 擪".\"폜

					// JukeBoxɋȂǉ
					JukeBox[i].Musdat[JukeBox[i].iFileNum] = lpHeader[j];
					JukeBox[i].iFileNum++;
					i++;
					iFolder++;
				}
				else
				{
					// JukeBoxI[o[B_R(
					WriteLog("MakeJukeBox() : JukeBox̐(%d)𒴂Ă܂B%s𖳎܂", MAX_JUKE, lpHeader[j]->szFile.c_str());
				}
			}
			else
			{
				if(JukeBox[iNum].iFileNum<MAX_FILES) // Ȑ
				{
					// JukeBoxɋȂǉ
					JukeBox[iNum].Musdat[JukeBox[iNum].iFileNum] = lpHeader[j];
					JukeBox[iNum].iFileNum++;
				}
				else
				{
					// ȐI[o[B_UAƒP(
					WriteLog("MakeJukeBox() : JukeBox(%s)̃t@C(%d)𒴂Ă܂B%s𖳎܂", JukeBox[iNum].szJuke.c_str(), MAX_FILES, lpHeader[j]->szFile.c_str());
				}
			}

		}

		j++;
	}

	for(int k=0;k<i;k++)
	{
		if(JukeBox[k].szJuke==".")
			JukeBox[k].szJuke = "TOP Directory";

		if(JukeBox[k].szJuke[JukeBox[k].szJuke.length()-1] == ':') // "C:" -> "C:\"
			JukeBox[k].szJuke+='\\';
	}

}

// 0:SelectMusic
// 3:OptionMode
// 4:QuitGame
int Title(int nCount){

	static int curPos = 0;
	static BOOL	bFinded = FALSE;
	
	SCENE_INIT{

		if(dd.GetScreenColor()==8)
		{
			// pbgύX̐Fh~
			dd.ClearScreen();
			dd.Flip();
			dd.ClearScreen();
			dd.Flip();

			dd.LoadPalette("Image\\title-palette.bmp");
			lpGlobScene->RemapPalette();
		}


		LOAD_BMP(20, "Image\\Title.bmp");
		LOAD_BMP(25, "Image\\title-menu.bmp");
		LOAD_BMP(26, "Image\\title-mode.bmp");
		LOAD_BMP(27, "Image\\title-loading.bmp");

		LOAD_BMP(22, "Image\\connect.bmp");
//		LOAD_BMP(23, "Image\\eax.bmp");

		DefSprite();

		LoadSoundSet(SS_TITLE);

		g_iOptCaller = SC1_TITLE;
	}

	SCENE_TERM{
		dd.UnLoadBMP(20);
		dd.UnLoadBMP(22);
//		dd.UnLoadBMP(23);
		dd.UnLoadBMP(25);
		dd.UnLoadBMP(26);
		dd.UnLoadBMP(27);

		UnLoadSoundSet(SS_TITLE);

		return 0; //@l̓_~[
	}

	// ȃT[`I
	if(nCount==1)
		PlaySoundSet(SS_TITLE);

	if(!bFinded)
	{
		BOOL bUpdateCheck = FALSE;
		if(Cfg["AutoRescan"]==AR_AUTO_BGSCAN || Cfg["AutoRescan"]==AR_AUTO_FGSCAN)
			bUpdateCheck = TRUE; // RescanݒȂt@C̍XV`FbNł

		if(!SearchMusic(bUpdateCheck))
			return SC1_QUIT; // QuitGame

		bFinded = TRUE;
		bResetList = TRUE;
	}

	dd.DrawSprite(400, 0,0); // wiBMP

	const int nItem = 7; //ڐ

//	if(FALSE)
//		dd.DrawSprite(406,539,211); // EAXACR

	if(g_bClub)
		dd.DrawSprite(405,630-dd.GetSpriteX(405), 10); // ڑACR

	// BM/DDR [hACR
	if(IsBM())
		dd.DrawSprite(402, 265, 310);
	else
		dd.DrawSprite(403, 265, 310);

	int x = 250;
	int y = 120;

	for(int i=0;i<7;i++)
	{
		if(curPos!=i)
			// I΂ĂȂ
			dd.DrawSprite(435+i, 400, y);
		else
			// I΂Ă鍀
			dd.DrawSprite(442+i, 400, y);

		y+=50;
	}
	
//	GetKeyInfo();

	if(KEYPUSH(VK_CS_U)){
		curPos--;
		if(curPos<0)
			curPos = nItem-1;
	}

	if(KEYPUSH(VK_CS_D))
		curPos = ++curPos%nItem;

	int type;
	double data;

	if(dp.Receive(data,type))
	{
		if(type==MES_TITLE_START)
		{
			return SC1_SELMUSIC;
		}
	}

	// ͐擪BɒuƁA
	// T[o̐ڑ҂ESCꂽꍇAt[DelightƏIĂ܂B
	if(KEYPUSH(VK_ESC))
		return SC1_QUIT;

	// Ȃɂ܂H
	int processNo = -1;

	if(KEYPUSH(VK_OK))
	{
		if(g_bClub)
			dp.Send(0.0,MES_TITLE_START,TRUE);

		processNo = curPos; // J[\̏Ăʒȕ
	}

	if(DIkey.IsKeyPushDown(DIK_G)) // Game Start (҂̃V[gJbgYĂ悗
		processNo = 0;

	if(DIkey.IsKeyPushDown(DIK_O)) // Option
		processNo = 1;

	if(DIkey.IsKeyPushDown(DIK_M)) // Common Option
		processNo = 2;

	if(DIkey.IsKeyPushDown(DIK_B)) // BM & DDR Option
		processNo = 3;

	if(DIkey.IsKeyPushDown(DIK_R)) // Rescan Music Data
		processNo = 4;

	if(DIkey.IsKeyPushDown(DIK_S)) // Connect Server
		processNo = 5;

	if(DIkey.IsKeyPushDown(DIK_C)) // Connect Client
		processNo = 6;

	// Ɓ`
	switch(processNo)
	{
		case 0:
		{
			// ȃZ֔
			ClearKeyInfo();

			// ȃZBMPǂݍ݂xȂȂ悤
			// BGScan~߂
			Juke.StopBGScan();

			return SC1_SELMUSIC;
			break;
		}

		case 1: return SC1_OPTION;		break;
		case 2: return SC1_OPTION_2;	break;
		case 3: return SC1_OPTION_BM;	break;

		case 4:
		{
			// Rescan

			// cache.lst폜̂SearchMusic
			ClearKeyInfo();

			SetFileAttributes(szLstFile, FILE_ATTRIBUTE_NORMAL);
			DeleteFile(szLstFile);

			char szWinDir[MAX_PATH];
			GetWindowsDirectory(szWinDir, MAX_PATH);
			strcat(szWinDir,"\\cache.lst");

			SetFileAttributes(szWinDir, FILE_ATTRIBUTE_NORMAL);
			DeleteFile(szWinDir);

			// 蓮RescanȂ̂ŁAȂ̍XV`FbN
			if(!SearchMusic(TRUE))
				return SC1_QUIT; // QuitGame

			break;
		}

		case 5: g_bClub = ConnectSession(CONNECT_SERVER);	break;
		case 6: g_bClub = ConnectSession(CONNECT_CLIENT);	break;
	}

	return SC1_TITLE;

}

// vC[҂̃^CAEg10b
BOOL ConnectSession(int mode){

	if(!dp.Init())
		return FALSE;

	if(g_bClub)
		return TRUE; // ڑς

	if(mode==CONNECT_SERVER)
	{
		static BOOL bConnected = FALSE;

		if(!bConnected)
		{
			if(!dp.Connect(CONNECT_SERVER))
				return FALSE;

			bConnected = TRUE;
		}

		WriteLog("Connect(SERVER) : vC[̐ڑҋ@...");

		dd.SyncScreen();
		dd.FillRect(0, 460, 640, 480); // ʉ̑т

		int length = Messages.Get("WaitingForClient").size();
		dd.DrawText(640-8-8*length, 462, Messages.Get("WaitingForClient").c_str());

		dd.Flip();

		BOOL res = FALSE;
//		CTimer timer;
//		timer.Reset();
//		while(timer.Get()<10000 && !res)
		while(!KEYPUSH(VK_ESC) && !res)
		{
			res = dp.WaitPlayer();
			GetKeyInfo();
		}

		if(res)
			WriteLog("Connect(SERVER) : ڑ܂");
		else
			WriteLog("Connect(SERVER) : LZ܂");

		return res;
	}
	else
	{

		WriteLog("Connect(CLIENT) : T[o֐ڑ...");

		if(!dp.Connect(CONNECT_CLIENT))
		{
			WriteLog("Connect(CLIENT) : ڑɎs܂");
			return FALSE;
		}
		else
		{
			WriteLog("Connect(CLIENT) : ڑ܂");
			return TRUE;
		}
	}

}

void DrawTitle(int x, int y, const char* szTitle, const char* szArtist, const char* szGenre){

	dd.DrawSprite(371,x,y);//,0.5); //waku

//	dd.DrawText(320-chNum3*8/2, y+50,szGenre);
//	dd.DrawText(320-chNum1*8/2, y+80,szTitle);
//	dd.DrawText(320-chNum2*8/2,y+110,szArtist);

//	return;

	int wakuW = dd.GetSpriteX(371);
	int wakuH = dd.GetSpriteY(371);

	HDC hDC;

	LPDIRECTDRAWSURFACE lpBB = dd.GetLpBackBuff();
	HRESULT res = lpBB->GetDC(&hDC);

	if(res==DD_OK)
	{
//		WriteLog("GetDC Succeed");
		// Title  wakuH/2, wakuW/chNum1

		LOGFONT lf;
		ZERO(lf);
		lstrcpy(lf.lfFaceName,"WSVbN");

		lf.lfWeight			 = FW_NORMAL;
		lf.lfEscapement		 = 0;
		lf.lfItalic			 = FALSE;
		lf.lfUnderline		 = FALSE;
		lf.lfStrikeOut		 = FALSE;
		lf.lfCharSet		 = SHIFTJIS_CHARSET;
		lf.lfPitchAndFamily	 = VARIABLE_PITCH|FF_DONTCARE;
		lf.lfQuality		 = PROOF_QUALITY; // ꂢȂ

		SetBkMode(hDC, TRANSPARENT);
		SetTextColor(hDC, RGB(255,255,255));
		SetTextAlign(hDC, TA_CENTER|VTA_CENTER); // w肵_獶EɍL悤ɂȂ

		int chNum1 = lstrlen(szGenre);		RANGE(chNum1,1,500);
		int chNum2 = lstrlen(szTitle);		RANGE(chNum2,1,500);
		int chNum3 = lstrlen(szArtist);		RANGE(chNum3,1,500);

		lf.lfWidth=long(double(wakuW)/double(chNum1)/1.2/1.7);	RANGE(lf.lfWidth,3,100);
		lf.lfHeight=33;
		HFONT hFont=CreateFontIndirect(&lf); // 쐬

		HFONT oldFont;
		oldFont = (HFONT)SelectObject(hDC, hFont); //I

			y+=5;
			if(lstrlen(szGenre)!=0)
				::TextOut(hDC,x+wakuW/2,y+5,szGenre,chNum1); // Genre

		SelectObject(hDC, oldFont); // 
		DeleteObject(hFont);

		lf.lfWidth= long(double(wakuW)/double(chNum2)/1.2);	RANGE(lf.lfWidth,2,110);
		lf.lfHeight=38;
		hFont=CreateFontIndirect(&lf);
		SelectObject(hDC, hFont);

			if(lstrlen(szTitle)!=0)
				TextOut(hDC,x+wakuW/2, y+wakuH/3,szTitle,chNum2); // Title

		SelectObject(hDC, oldFont); // 
		DeleteObject(hFont);

		lf.lfWidth= long(double(wakuW)/double(chNum3)/1.2/1.5);	RANGE(lf.lfWidth,5,35);
		lf.lfHeight=33;
		hFont=CreateFontIndirect(&lf);
		SelectObject(hDC, hFont);

			if(lstrlen(szArtist)!=0)
				TextOut(hDC,x+wakuW/2, y+wakuH/3*2,szArtist,chNum3); //Artist

		SelectObject(hDC, oldFont);
		DeleteObject(hFont);

		lpBB->ReleaseDC(hDC);
	}

}

void DrawMusicList(int x, int y, int width, int height, const char* szTitle){

	LOGFONT lf;
	ZERO(lf);
	lstrcpy(lf.lfFaceName,"lr oSVbN");

	lf.lfWeight			 = FW_NORMAL;
	lf.lfEscapement		 = 0;
	lf.lfItalic			 = FALSE;
	lf.lfUnderline		 = FALSE;
	lf.lfStrikeOut		 = FALSE;
	lf.lfCharSet		 = SHIFTJIS_CHARSET;
//	lf.lfPitchAndFamily	 = VARIABLE_PITCH|FF_DONTCARE;
	lf.lfWidth  = 0;//long(double(width)/double(chNum1));	RANGE(lf.lfWidth,3,100);

	int chNum1 = lstrlen(szTitle);	RANGE(chNum1,1,500);
	
	HDC hDC;
	LPDIRECTDRAWSURFACE lpBB = dd.GetLpBackBuff();
	HRESULT res = lpBB->GetDC(&hDC);

	if(res==DD_OK)
	{
		// |CgsNZϊ(by MFĈǂ)
		POINT pt;
		pt.y = ::GetDeviceCaps(hDC, LOGPIXELSY) * 100; // 10point logFont.lfHeight
		pt.y /= 720;    // 72 points/inch, 10 decipoints/point
		::DPtoLP(hDC, &pt, 1);
		POINT ptOrg = { 0, 0 };
		::DPtoLP(hDC, &ptOrg, 1);
		lf.lfHeight = -abs(pt.y - ptOrg.y);
//		lf.lfHeight = height-3;

		HFONT hFont = CreateFontIndirect(&lf); // 쐬

		SetBkMode(hDC, TRANSPARENT);
		SetTextColor(hDC, RGB(255,255,255));
//		SetTextAlign(hDC, TA_LEFT|VTA_CENTER); // w肵_獶EɍL悤ɂȂ

		HFONT oldFont = (HFONT)SelectObject(hDC, hFont); //I

		if(lstrlen(szTitle)!=0)
			::TextOut(hDC,x,y+1,szTitle,chNum1); // Genre //+height/2

		SelectObject(hDC, oldFont); // 
		DeleteObject(hFont);

		lpBB->ReleaseDC(hDC);
	}


}

// iSwing = U
// width  = Ŝł̕
void DrawKeyNote(int level, int iSwing, int width/* = 0*/, int color/* = 0*/){

	if(level==0)
		return;

	if(width==0)
		width = dd.GetSpriteX(390);
	else
		width/=level;

	int x = 320 - width*level/2; //Z^O

	for(int i=0;i<level;i++)
	{
		int y = 385 + int(sin(double(i)*0.5 + double(timeGetTime())/100.0) * iSwing);
		dd.DrawSprite(390+color,x+i*width,y); //Փx
	}

}

// iSwing = U
// width  = Ŝł̕
void DrawKeyNote(int x, int y, int level, int iSwing, int width/* = 0*/, int color/* = 0*/){

	if(level==0)
		return;

	if(width==0)
		width = dd.GetSpriteX(390);
	else
		width/=level;

	x-=width*level/2; //Z^O

	for(int i=0;i<level;i++)
	{
		int y1 = y + int(sin(double(i)*0.5 + double(timeGetTime())/100.0) * iSwing);
		dd.DrawSprite(390+color,x+i*width,y1); //Փx
	}

}

// bms\̎gplayDataȂǂݒ
void GoBMS(BMS& bms){

	pd.Gap			= 0;
	pd.GapMS		= 0;
	pd.BPM			= bms.BPM;
	pd.DpMS			= bms.BPM * double(g_TimeBase) / 240000.0;	// 1msPixel
	pd.totalObj		= bms.Obj;
	pd.endPix		= bms.endPix;
	pd.endms		= bms.endms;
	pd.bgBMPNum     = bms.bgBMPNum;
	pd.CDTr			= bms.CDtrack;
	ScoreInfo.bUrami = bms.bUrami;


	// YSK̗v]BBIvV "#ExpertGauge"
	pd.gaugeMode	= bms.gaugeMode;

	if(pd.gaugeMode==GAUGE_EXPERT)
	{
		pd.dHP[0] = 100.0;

		if(bms.Player==2)
			pd.dHP[1] = 100.0; // Couple
	}

	switch(bms.Rank)
	{
	case 0: pd.rank = 0.4; break;
	case 1: pd.rank = 0.7; break;
	case 2: pd.rank = 1.0; break;
	case 3: pd.rank = 1.3; break;
	default:pd.rank = 1.0; break;
	}

	if(bms.MIDIFile[0] != '\0')
		pd.bMIDI = TRUE;

	// IsDouble()ɕKvR擪
	switch(bms.Player)
	{
	case 1: pd.mode = SINGLE; break;
	case 2: pd.mode = COUPLE; break;
	case 3: pd.mode = DOUBLE; break;
	}

	if( strmatch(bms.Title, "BASIC")!=NULL ||
		strmatch(bms.Genre, "BASIC")!=NULL    )
			pd.mode += BASIC;
	else
		if( strmatch(bms.Title, "LIGHT")!=NULL ||
			strmatch(bms.Genre, "LIGHT")!=NULL    )
				pd.mode += BASIC;
	else 
		if( strmatch(bms.Title, "ANOTHER")!=NULL ||
			strmatch(bms.Genre, "ANOTHER")!=NULL    )
				pd.mode += ANOTHER;
	else 
		if( strmatch(bms.Title, "TRICK")!=NULL ||
			strmatch(bms.Genre, "TRICK")!=NULL    )
				pd.mode += ANOTHER;
	else
		if( strmatch(bms.Title, "STANDARD")!=NULL ||
			strmatch(bms.Genre, "STANDARD")!=NULL    )
				pd.mode += ANOTHER;
	else
		if( strmatch(bms.Title, "SSR")!=NULL ||
			strmatch(bms.Genre, "SSR")!=NULL    )
				pd.mode += MANIAC;
	else
		if( strmatch(bms.Title, "MANIAC")!=NULL ||
			strmatch(bms.Genre, "MANIAC")!=NULL    )
				pd.mode += MANIAC;
	else
		if( strmatch(bms.Title, "HEAVY")!=NULL ||
			strmatch(bms.Genre, "HEAVY")!=NULL    )
				pd.mode += MANIAC;
	else
		pd.mode += BASIC;

	// NoteArrange()TotalNote邩炱
	pd.totalNote[0] = bms.notes[0];
	pd.totalNote[1] = bms.notes[1];

	NoteArrange(pd.totalObj); //

	// DP̂Ƃ2P̃m[g炵肷邩炱ꂪ
	if(IsDouble())
	{
		pd.totalNote[0]+=pd.totalNote[1]; //DPȂ2l
		pd.totalNote[1]=0;
	}

	if(!opt.bUseTotal)
	{
		// Kappe
		// #3261 ɂl`EEE
		for(int i=0;i<2;i++)
		{
			if(pd.totalNote[i]<400)
				bms.Total[i] = 200 + pd.totalNote[i]/5;
			else if(pd.totalNote[i]<650)
				bms.Total[i] = 280 + (pd.totalNote[i]-400)/2.5;
			else
				bms.Total[i] = 380 + (pd.totalNote[i]-650)/5;
		}
	}

	// NoteArrange()Ńm[gς\邩
	if(bms.Total[0] == 0) // ŁAꂪŌ
	{
		if(pd.totalNote[0]!=0) //divide by 0 ΍
			pd.dHPInc[0] = double(200 + pd.totalNote[0]) / double(pd.totalNote[0]);
		else
			pd.dHPInc[0] = 200.0;

		if(pd.totalNote[1]!=0) //divide by 0 ΍
			pd.dHPInc[1] = double(200 + pd.totalNote[1]) / double(pd.totalNote[1]);
		else
			pd.dHPInc[1] = 200.0;
	}
	else
	{
		if(pd.totalNote[0]!=0) //divide by 0 ΍
			pd.dHPInc[0] = double(bms.Total[0]) / double(pd.totalNote[0]);
		else
			pd.dHPInc[0] = double(bms.Total[0]);

		if(pd.totalNote[1]!=0) //divide by 0 ΍
			pd.dHPInc[1] = double(bms.Total[1]) / double(pd.totalNote[1]);
		else
			pd.dHPInc[1] = double(bms.Total[1]);
	}

	for(int i=0;i<=355;i++) // Xbv
		dd.DrawSprite(i,0,0);

	int oldVol;
	oldVol = GetVolume();

	if(oldVol > 0)
		SetVolume(0);

	int vol[MAX_WAVNUM+32];

	// ɂ
	for(i=101;i<100+MAX_WAVNUM;i++)
	{
		vol[i-100] = ds.GetVolume(i);
		ds.SetVolume(i, -10000);
	}

	Sleep(100);

	for(i=101;i<100+MAX_WAVNUM;i++)
	{
		ds.Play(i); // Xbv
	}

	Sleep(100);

	for(i=101;i<100+MAX_WAVNUM;i++)
		ds.Stop(i);

	Sleep(1000);

	// ߂
	for(i=101;i<100+MAX_WAVNUM;i++)
		ds.SetVolume(i, vol[i-100]);

	pd.vol = oldVol; // ̃{[ۑ
	pd.volrate = bms.VolWAV;

	if(oldVol > 0)
		SetVolume(int(oldVol * (double(bms.VolWAV)/100.0)));

}

// Xbv̂ߗʂr炷Ƃɒ
BOOL GoMSD(const char* szFile, const char* szPath, char* szErrTxt, MSD& msd, int mode){

	if(LoadMSDStep(szFile, szPath, szErrTxt, mode, &msd))
	{

		pd.totalNote[0] = msd.notes[0];  //LoadStepł炦镪
		pd.totalNote[1] = msd.notes[1];
		pd.totalObj		= msd.notes[2];
		pd.endPix		= msd.endPix+int(double(g_TimeBase)*END_DELAY);
		pd.mode			= mode;
		pd.dHPInc[0]	= 0.5;
		pd.dHPInc[1]	= 0.5;
		pd.rank = 1.0;
		ScoreInfo.bUrami = FALSE;

		// YSK̗v]BBIvV "#ExpertGauge"
		// MSDɂ݂͑Ȃ
		pd.gaugeMode	= GAUGE_NORMAL;

		NoteArrange(pd.totalObj);

		// DP̂Ƃ2P̃m[g炵肷邩炱ꂪ
		if(IsDouble())
		{
			pd.totalNote[0]+=pd.totalNote[1]; //DPȂ2l
			pd.totalNote[1]=0;
		}

		// LbV@\ς :-)
		
		if(!LoadMSDData(szFile, szPath, szErrTxt, &msd, TRUE))
		{
			dd.GetLpDD()->FlipToGDISurface();
			MessageBox(hmainwnd, szErrTxt, "RpCG[I", MB_OK);
			ClearKeyInfo();
			return FALSE;
		}

		pd.CDTr = msd.CDtrack;  //LoadDatał炦镪
		pd.BPM  = msd.BPM;
		pd.DpMS = msd.BPM * double(g_TimeBase) / 240000.0;	// 1msPixel
		pd.Gap  = msd.Gap;
		pd.GapMS= DWORD(msd.Gap/pd.DpMS);

		if(pd.DpMS!=0.0)
			pd.endms = DWORD((pd.endPix-pd.Gap) / pd.DpMS);
		else
			pd.endms = 5999 * 1000; // 99:59.0 Ȃ킯邩

		for(int i=100;i<=355;i++) // BMSgĂ
		{
			dd.UnLoadBMP(i);
		}
		for(i=100;i<100+MAX_WAVNUM;i++) // BMSgĂ
		{
			ds.ReleaseWave(i);
		}
			
		dd.UnLoadBMP(33); // BMS#BackBMP

		for(i=0;i<=99;i++) // Xbv
			dd.DrawSprite(i,0,0);

/*		int oldVol;
		oldVol = GetVolume();

		if(oldVol > 0)
			SetVolume(0);
*/
		int oldvol = ds.GetVolume(0);
		ds.SetVolume(0, -10000);

		ds.Play(0); // Xbv

		Sleep(100);

		ds.Stop(0);

		Sleep(1000);

		ds.SetVolume(0, oldvol);

//		if(oldVol > 0)
//			SetVolume(oldVol);

		return TRUE;

	}
	else
		return FALSE;

}

void OptionDispatch(void)
{
	opt.b1PScL   = Cfg["1PScratchLeft"];
	opt.b2PScL   = Cfg["2PScratchLeft"];
	opt.iAutoScr = Cfg["AutoScratch"];
	opt.bIgPoor  = Cfg["IgnorePoor"];
	opt.iCombo	 = Cfg["Combo"];
	opt.bUrami   = Cfg["Urami"];
	opt.bOUCH	 = Cfg["OUCH"];
	opt.bFlat	 = Cfg["Flat"];
	opt.bReverse = Cfg["Reverse"];

	opt.bFullScr	= Cfg["FullScreen"];
	opt.iScCol		= Cfg["ScreenColor"];
	opt.iDrawMethod	= Cfg["DrawMethod"];
	opt.iBuffering	= Cfg["Buffering"];
	opt.iPriority	= Cfg["Priority"];
	opt.bBgAnime	= Cfg["BackGroundAnime"];
	opt.bBMSA		= Cfg["BMSAnime"];
	opt.iSoundQlty	= Cfg["SoundQuality"];
	opt.bJoyPad		= Cfg["JoyPad"];
	opt.iEffect		= Cfg["Effect"];
	opt.bDebug		= Cfg["DebugMode"];
	opt.bFPS		= Cfg["FPS"];
	opt.iCDDrNum	= Cfg["CDDriveNum"];
	opt.bSyncCD		= Cfg["SyncCD"];

	opt.iMode			= Cfg["Mode"];
	opt.iLevel			= Cfg["Level"];
	opt.iAutoPlay		= Cfg["AutoPlay"];
	opt.iBlind			= Cfg["Blind"];
	opt.iNArrange		= Cfg["NoteArrange"];
	opt.iLittle			= Cfg["Little"];
	opt.iHighSpeedMode	= Cfg["HighSpeedMode"];
	opt.iHighSpStyle	= Cfg["HighSpeedStyle"];
	opt.bTCMusical		= Cfg["TempoChangeMusical"];
	opt.iTempoChange	= Cfg["TempoChange"];
	opt.iAutoTempoChange= Cfg["AutoTempoChange"];
	opt.bUseTotal		= Cfg["UseTotal"];

	// vZXDxグBłɃVXe苒()
	HANDLE op = OpenProcess(PROCESS_ALL_ACCESS,TRUE,GetCurrentProcessId());
	if(op!=NULL)
	{
		if(opt.iPriority==PR_HIGH)
		{
			if(SetPriorityClass(op,HIGH_PRIORITY_CLASS)==0)
				WriteLog("OptionDispatch() : SetPriorityClass(HIGH_PRIORITY_CLASS)Ɏs");
		}
		else
		{
			if(SetPriorityClass(op,NORMAL_PRIORITY_CLASS)==0)
				WriteLog("OptionDispatch() : SetPriorityClass(NORMAL_PRIORITY_CLASS)Ɏs");
		}
		CloseHandle(op);
	}
	else
	{
		WriteLog("OptionDispatch() : OpenProcess()Ɏs");
	}

	switch(opt.iAutoPlay)
	{
	case 0: pd.bAutoPlay[0] = FALSE; pd.bAutoPlay[1] = FALSE; break;
	case 1: pd.bAutoPlay[0] = TRUE ; pd.bAutoPlay[1] = FALSE; break;
	case 2: pd.bAutoPlay[0] = FALSE; pd.bAutoPlay[1] = TRUE ; break;

	case 3:
	case 4: pd.bAutoPlay[0] = TRUE ; pd.bAutoPlay[1] = TRUE ; break;
	}

	int rate = dd.GetRefreshRate();
	if(rate<60)
		rate=60;

	switch(opt.iDrawMethod)
	{
		case DM_VSYNC_SLEEP: // WaitVSYNC
		default:
			dd.SetFlipMode(FLIP_WAITVSYNC);
			eltime.SetFPS(rate);
			break;

		case DM_VSYNC_NOSLEEP: // WaitVSYNC & Sleepless
			dd.SetFlipMode(FLIP_WAITVSYNC);
			eltime.SetFPS(0);
			break;

		case DM_DBLT_SLEEP: // DirectBlt & Sleep
			dd.SetFlipMode(FLIP_DIRECTBLT);
			eltime.SetFPS(rate);
			break;

		case DM_DBLT_NOSLEEP: // DirectBlt & Sleepless
			dd.SetFlipMode(FLIP_DIRECTBLT);
			eltime.SetFPS(0);
			break;
	}

	if(IsDDR())
		g_bOUCH = opt.bOUCH;
	else
		g_bOUCH = !opt.bIgPoor;


	double hispt[15] = {0.5, 0.75, 1.0, 1.2, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 6.0, 8.0, 16.0, 256.0};

	if(IsBM())
		g_TimeBase = int(double(TIMEBASE_BM)*hispt[opt.iHighSpeedMode]);
	else
		g_TimeBase = int(double(TIMEBASE)   *hispt[opt.iHighSpeedMode]);

	double hisp = double(g_TimeBase)/double(TIMEBASE);

	// ̈w(ۂmsZĔ)
	// sNZ͉̕ʕ`ƂŎg
	if(IsBM())
	{
		// 32 = 6(pix) 16 = 12 (@TIMEBASE=192)
		JUDGE_PERFECT	= 3.0 * hisp;
		JUDGE_GREAT		= 6.0 * hisp;
		JUDGE_GOOD		= 18.0 * hisp;
		JUDGE_BOO		= 25.0 * hisp;
//		JUDGE_POOR		= 160 * hisp;
		JUDGE_MISS		= JUDGE_BOO;
		JUDGE_OUCH		= double(g_TimeBase); // ʉPoorɂȂ͈

		double DpMs = 0.144; // DpMS(@180BPM)
		// 0.112 = DpMS(@140BPM) 0.128 = 160BPM  0.144 = 180BPM

		JUDGE_PERFECT_MS = 3.0 / DpMs;
		JUDGE_GREAT_MS	 = 6.0 / DpMs;
		JUDGE_GOOD_MS	 = 18.0 / DpMs;
		JUDGE_BOO_MS	 = 25.0 / DpMs;
//		JUDGE_POOR_MS	 = 160 / DpMs;
		JUDGE_MISS_MS	 = JUDGE_BOO_MS;
	}
	else //DDR
	{
		// 32 = 8(pix) 16 = 16 (@TIMEBASE=256)
		JUDGE_PERFECT	= 6.0  * hisp;
		JUDGE_GREAT		= 13.0 * hisp;
		JUDGE_GOOD		= 18.0 * hisp;
		JUDGE_BOO		= 25.0 * hisp;
//		JUDGE_POOR		= 25.0 * hisp; // BOOƓɂƂΏo邱Ƃ͂Ȃ
		JUDGE_MISS		= JUDGE_BOO;
		JUDGE_OUCH		= 999999999.0 * hisp; // 邯ǈꉞ

		double DpMs = 0.144; // DpMS(@180BPM)
		// 0.112 = DpMS(@140BPM) 0.128 = 160BPM  0.144 = 180BPM

		JUDGE_PERFECT_MS = 6.0 / DpMs;
		JUDGE_GREAT_MS	 = 13.0 / DpMs;
		JUDGE_GOOD_MS	 = 18.0 / DpMs;
		JUDGE_BOO_MS	 = 25.0 / DpMs;
//		JUDGE_POOR_MS	 = 25.0 / DpMs; // BOOƓɂƂΏo邱Ƃ͂Ȃ
		JUDGE_MISS_MS	 = JUDGE_BOO_MS;
	}

	if(opt.iMode==MD_DDR_6 || IsBM())
		opt.bAllow6=TRUE;
	else
		opt.bAllow6=FALSE;

	if(opt.bAllow6 && IsDDR())
		pd.bAutoPlay[1] = TRUE;

	bDebug = opt.bDebug;


/*
	static int  bSysRAMbef = !(opt.iBlind==BL_HIDDEN || opt.iBlind==BL_SUDDEN);	// ͂߂Ăɗ遁InitApp()̂Ƃ!ċIɓǂݍ
	static BOOL bIsBMbef   = !IsBM();		// ɓ
	static BOOL bIs4Albef  = !(opt.iMode==MD_DDR_4);

	BOOL bReload = bSysRAMbef!=(opt.iBlind==BL_HIDDEN || opt.iBlind==BL_SUDDEN) || bIsBMbef!=IsBM() || bIs4Albef!=(opt.iMode==MD_DDR_4);

	if(bReload)
	{
		// gƂSystemRAMɓǂݍō
		if(opt.iBlind==BL_HIDDEN || opt.iBlind==BL_SUDDEN)
		{
			if(!LoadBMP(LOAD_RAM))
				QuitGame(hmainwnd);
		}
		else
		{
			if(!LoadBMP(LOAD_DEFAULT))
				QuitGame(hmainwnd);
		}

		bSysRAMbef = (opt.iBlind==BL_HIDDEN || opt.iBlind==BL_SUDDEN);
		bIsBMbef   = IsBM();
		bIs4Albef  = (opt.iMode==MD_DDR_4);
	}

	DefSprite();
*/

	static int icdLetbef = -1;	// QxOpen̖h~p

	if(cd.IsOpen() && icdLetbef!=opt.iCDDrNum)
	{
		cd.Close();
		HRESULT res;
		if(opt.iCDDrNum==0)
			res = cd.Open();
		else
			res = cd.Open(szCDDr[opt.iCDDrNum]);

		WriteLog("cd.Open() : Result = %d", res);

		icdLetbef = opt.iCDDrNum;
	}

	VKey.ClearKeyDevice();

	if(opt.bJoyPad)
	{
		VKey.AddDevice(&joy1);
		VKey.AddDevice(&joy2);
	}

	VKey.AddDevice(&midiIn);
	VKey.AddDevice(&DIkey);

}

void LoadConfig(void)
{
	// DDR.cfgǂ
	if(!Cfg.Load(szCfgFile))
	{
		// ǂ߂ȂWindowsfBNgǂ

		// ̃obt@ɁAWindows fBNg̃pX NULL ŏI镶ƂĊi[܂ (Ƃ΁u C:\WINDOWS v) B
		// Windows fBNg[gfBNgłȂu \ vł͏I܂B
		char szWinDir[MAX_PATH];
		GetWindowsDirectory(szWinDir, MAX_PATH);
		strcat(szWinDir,"\\DDR.cfg");

		Cfg.Load(szWinDir); // ł߂Ȃ炠߂ăftHglݒ
	}

	// ftHglݒ
	typedef struct tagPairStrInt
	{
		char* item;
		int value;
	} PAIR_STR_INT;

	const PAIR_STR_INT defaults[] =
	{
		{ "FullScreen",			TRUE },
		{ "BackGroundAnime",	TRUE },
		{ "BMSAnime",			TRUE },
		{ "DebugMode",			FALSE },
		{ "OUCH",				FALSE },
		{ "AutoPlay",			AP_OFF },
		{ "Mode",				MD_BM_7 },
		{ "DrawMethod",			DM_VSYNC_SLEEP },
		{ "HighSpeedMode",		2 },
		{ "HighSpeedStyle",		HST_OFF },
		{ "SyncCD",				FALSE },
		{ "Effect",				GE_HIGH },
		{ "CDDriveNum",			0 },
		{ "Blind",				BL_OFF },
		{ "Flat",				FALSE },
		{ "Little",				LT_OFF },
		{ "NoteArrange",		NA_OFF },
		{ "1PScratchLeft",		TRUE },
		{ "2PScratchLeft",		FALSE },
		{ "AutoScratch",		AS_OFF },
		{ "Urami",				FALSE },
		{ "IgnorePoor",			FALSE },
		{ "Combo",				CB_GREATGOOD },
		{ "SoundQuality",		SQ_LOW },
		{ "JoyPad",				FALSE },
		{ "Level",				LEVEL_NORMAL },
		{ "FPS",				TRUE },
		{ "ScreenColor",		SCCOL_65536 },
		{ "Priority",			PR_NORMAL },
		{ "Buffering",			0 },
		{ "TempoChange",		0 },
		{ "AutoTempoChange",	0 },
		{ "TempoChangeMusical",	TRUE },
		{ "UseTotal",			TRUE },
		{ "Reverse",			FALSE },
		{ "AutoRescan",			AR_AUTO_BGSCAN },
		{ "WAVStreaming",		WS_SSONLY },

		// 艺̓IvVʂŐݒłA蓮ŏ
		{ "BlackColorRounding",	TRUE },
	};

	int size = sizeof(defaults) / sizeof(defaults[0]);
	for(int i=0;i<size;i++)
	{
		// ݂ȂL[ɃftHglݒ
		if(!Cfg.Exists(defaults[i].item))
		{
			Cfg[defaults[i].item] = defaults[i].value;
		}
	}

	// hCuύXȂǂŁACDhCuԍ͈͊OftHgɂ
	{
		int cdDriveNum = Cfg["CDDriveNum"];
		if(cdDriveNum>=27)
			Cfg["CDDriveNum"] = 0; // sȒlȂ̂Ŗ߂
		else if(szCDDr[cdDriveNum][0] == '\0')
			Cfg["CDDriveNum"] = 0; // ݑ݂ȂhCuȂ̂Ŗ߂
	}

	// opt\̂ɔf
	OptionDispatch();

	// f[^t@CpXݒ
	int pathNum = 1;
	FILE* fp = fopen(szSearchPathFile, "r");
	if(fp!=NULL)
	{
		char buf[MAX_PATH];
		while(fgets(buf, MAX_PATH, fp)!=NULL)
		{
			if(strncmp(buf, "//", 2)==0) // s//̍s̓Rg
				continue;

			if(buf[0]=='\n' || buf[0]=='\0') // s͖
				continue;

			// '\n'폜
			if(buf[strlen(buf)-1]=='\n')
				buf[strlen(buf)-1] = '\0';

			strcpy(szSearchPath[pathNum], buf);
			pathNum++;

			if(pathNum>=100)
				break;
		}

		fclose(fp);
	}

	if(pathNum==1)
		strcpy(szSearchPath[1], ".\\"); // Ȃ΃Jgǉ
}

void SaveConfig(void)
{
	DWORD oldAttr = GetFileAttributes(szCfgFile);

	SetFileAttributes(szCfgFile, FILE_ATTRIBUTE_NORMAL);
	
	if(!Cfg.Save(szCfgFile))
	{
		// Z[uɎs(CDNȂ) WindowsfBNgɕۑ

		// ̃obt@ɁAWindows fBNg̃pX NULL ŏI镶ƂĊi[܂ (Ƃ΁u C:\WINDOWS v) B
		// Windows fBNg[gfBNgłȂu \ vł͏I܂B
		char szWinDir[MAX_PATH];
		GetWindowsDirectory(szWinDir, MAX_PATH);
		strcat(szWinDir,"\\DDR.cfg");

		Cfg.Save(szWinDir); // łs炠߂
	}

	if(oldAttr!=0xFFFFFFFF)
		SetFileAttributes(szCfgFile, oldAttr);
}

int OptionMode(int nCount){

	SCENE_INIT
	{
		if(dd.GetScreenColor()==8)
		{
			// pbgύX̐Fh~
			dd.ClearScreen();
			dd.Flip();
			dd.ClearScreen();
			dd.Flip();

			dd.LoadPalette("Image\\pal_option.bmp");
			lpGlobScene->RemapPalette();
		}

		LOAD_BMP(24, "Image\\cursor.bmp");
		DefSprite();

		LoadSoundSet(SS_OPTION);
		PlaySoundSet(SS_OPTION);
	}

	SCENE_TERM{
		dd.UnLoadBMP(24);
		UnLoadSoundSet(SS_OPTION);
		return 0; //@l̓_~[
	}

	dd.DrawText(50,32,szAppFullName);
	dd.DrawText(50,50,"System Option - Push ESC to Quit");

	// ɍڂǉ/ύXAszCfgVar, szSel, iMax[], iOptNum, nKeyCfg, nCDύXB
	const char* szMenu[]/*==optNum*/ = 
	{
		"Screen Mode",
		"Screen Color",
		"Drawing Method",
		"Screen Buffering",
		"Process Priority",
		"Auto Music Rescan",
		"Background Graphic",
		"BMS Animation",
		"Sound Quality",
		"WAV Streaming",
		"Joy Pad",
		"Graphical Effect",
		"Debug Mode",
		"Information Display",
		"CD Drive",
		"CD-Syncro",
		"KeyConfig(System)",
		"KeyConfig(DDR)",
		"KeyConfig(BM)",
	};

	const char* szCfgVar[]/*==optNum*/ = 
	{
		"FullScreen",
		"ScreenColor",
		"DrawMethod",
		"Buffering",
		"Priority",
		"AutoRescan",
		"BackGroundAnime",
		"BMSAnime",
		"SoundQuality",
		"WAVStreaming",
		"JoyPad",
		"Effect",
		"DebugMode",
		"FPS",
		"CDDriveNum",
		"SyncCD",
		"",
		"",
		"",
	};

	const char* szSel[]/*==optNum*/[4]/*==ő區ڐ*/ =
	{
		//FALSE==0 TRUE==1
		{"Window", "FullScreen"},
		{"256","65536","16777216"},
		{"WaitVSYNC","WaitVSYNC & Sleepless","DirectBlt","DirectBlt & Sleepless"},
		{"Double","Triple"},
		{"Normal","High"},
		{"AutoSearch + BGScan", "ManualSearch + BGScan", "AutoSearch + Non-BGScan", "ManualSearch + Non-BGScan"},
		{"OFF","ON"},
		{"OFF","ON"},
		{"22kHz/8bit/Stereo","44kHz/16bit/Stereo"},
		{"OFF", "SoundSet Only", "ALL (may NOT work)" },
		{"NO USE","USE"},
		{"Low","Middle","High"},
		{"OFF","ON"},
		{"OFF","ON"},
		{"Default"},	//dd.DrawText(300,ypos,szCDDr[opt.iCDDrNum]);
		{"OFF","ON"},
		{""},
		{""},
		{""},
	};

	int iMax[] = {1,2,3,1,1,3,1,1,1,2,1,2,1,1,opt.iCDDrMax-1,1,0,0,0}; //ڐ-1

	static int curPos = 0; // ݂̃J[\ʒu
	const int iOptNum = 19; // IvVڐ
	const int nKeyCfgMin = 16; // KeyConfig̍ŏcurPos
	const int nKeyCfgMax = 18; // KeyConfig̍ŌcurPos
	const int nCD	  = 14; // CDhCu^[\curPos

	const int topX = 100; // ꗗ̈ԏ̍W
	const int topY = 85; // ꗗ̈ԏ̍W
	const int indentX = 200; // ڈꗗƒlꗗ̊Ԃ̃Cfg

	// ꗗ\
	int ypos = topY;

	for(int i=0;i<iOptNum;i++)
	{
		// ڕ\
		dd.DrawText(topX, ypos, szMenu[i]);

		// l\
		if(i==nCD && Cfg["CDDriveNum"]!=0)
		{
			// CDhCu^[̕\
			dd.DrawText(topX+indentX, ypos, szCDDr[Cfg["CDDriveNum"]]);
		}
		else if(nKeyCfgMin<=i && i<=nKeyCfgMax)
		{
			// KeyConfig̍ڂɒl͂Ȃ
		}
		else
		{
			// ʏ퍀
			int value = Cfg[szCfgVar[i]];
			dd.DrawText(topX+indentX, ypos, szSel[i][value]);
		}

		ypos+=18;
	}

	// J[\
	dd.DrawSprite(401, topX-dd.GetSpriteX(401)-6, topY+curPos*18+3);

//	GetKeyInfo();

	if(KEYPUSH(VK_CS_U))
	{
		curPos--;
		LOOP(curPos,0,iOptNum-1);
	}
	if(KEYPUSH(VK_CS_D))
	{
		curPos = ++curPos%iOptNum;
//		LOOP(curPos,0,iOptNum-1);
	}

	if(KEYPUSH(VK_PGUP))
	{
		curPos-=3;
		LOOP(curPos,0,iOptNum-1);
	}
	if(KEYPUSH(VK_PGDN))
	{
		curPos+=3;
		LOOP(curPos,0,iOptNum-1);
	}

	if(KEYPUSH(VK_CS_L))
	{
		if(!IN(curPos, nKeyCfgMin, nKeyCfgMax)) // L[RtBO̍ڂł͒l̑Ȃ
		{
			Cfg[szCfgVar[curPos]]--;
			LOOP(Cfg[szCfgVar[curPos]], 0, iMax[curPos]);
		}
	}

	if(KEYPUSH(VK_CS_R))
	{
		if(!IN(curPos, nKeyCfgMin, nKeyCfgMax)) // L[RtBO̍ڂł͒l̑Ȃ
		{
			Cfg[szCfgVar[curPos]]++;
			LOOP(Cfg[szCfgVar[curPos]], 0, iMax[curPos]);
		}
	}

	if(KEYPUSH(VK_OK))
	{
		if(IN(curPos, nKeyCfgMin, nKeyCfgMax))
		{
			switch(curPos)
			{
			case nKeyCfgMin:	return(SC1_KEYCFGSYS);	break;
			case nKeyCfgMin+1:	return(SC1_KEYCFGDDR);	break;
			case nKeyCfgMin+2:	return(SC1_KEYCFGBM);	break;
			}
		}
	}

	if(KEYPUSH(VK_ESC))
	{
		OptionDispatch();
		SaveConfig();

		if(g_iOptCaller==SC1_SELMUSIC)
		{
			// ȃZɖ߂̂ŁA
			// ȃZBMPǂݍ݂xȂȂ悤
			// BGScan~߂
			Juke.StopBGScan();
		}

		return(g_iOptCaller);
	}

	if(DIkey.IsKeyPushDown(DIK_O))
		return SC1_OPTION;

	if(DIkey.IsKeyPushDown(DIK_B))
		return SC1_OPTION_BM;

	if(DIkey.IsKeyPushDown(DIK_M))
		return SC1_OPTION_2;

	return(SC1_OPTION);

}

int Option2(int nCount){

	SCENE_INIT{
		if(dd.GetScreenColor()==8)
		{
			// pbgύX̐Fh~
			dd.ClearScreen();
			dd.Flip();
			dd.ClearScreen();
			dd.Flip();

			dd.LoadPalette("Image\\pal_option.bmp");
			lpGlobScene->RemapPalette();
		}

		LOAD_BMP(24, "Image\\cursor.bmp");
		DefSprite();

		LoadSoundSet(SS_OPTION);
		PlaySoundSet(SS_OPTION);
	}

	SCENE_TERM{
		dd.UnLoadBMP(24);
		UnLoadSoundSet(SS_OPTION);
		return 0; //@l̓_~[
	}

	dd.DrawText(50,32,szAppFullName);
	dd.DrawText(50,50,"Common Option - Push ESC to Quit");


	//ɍڂǉAszCfgVar, szSel, iMax[], iOptNum, nTemMode, nTemChύXB
	const char* szMenu[]/*==optNum*/ = 
	{
		"Game Mode",
		"Game Level",
		"Auto Play",
		"Blind",
		"Note Arrange",
		"Little",
		"High Speed Mode",
		"High Speed Style",
		"Tempo Change Scale",
		"Tempo Change",
		"Auto Tempo Change",
		"Enable #Total",
	};

	const char* szCfgVar[]/*==optNum*/ = 
	{
		"Mode",
		"Level",
		"AutoPlay",
		"Blind",
		"NoteArrange",
		"Little",
		"HighSpeedMode",
		"HighSpeedStyle",
		"TempoChangeMusical",
		"TempoChange",
		"AutoTempoChange",
		"UseTotal",
	};

	const char* szSel[]/*==optNum*/[40]/*==ڐ*/ =
	{
		//FALSE==0 TRUE==1
		{"BM(4Line)","BM(5Line)","BM(7Line)","DDR(4-Arrow)","DDR(6-Arrow)"},
		{"Easy","Normal","Hard"},
		{"OFF","1P","2P","1P & 2P","Auto"},
		{"OFF","Hidden","Sudden","Stealth"},
		{"OFF","Mirror","Shuffle","Line Shuffle"},
		{"OFF","Little","Minimum"},
		{"x0.5","x0.75","x1.0","x1.2","x1.5","x2.0","x2.5","x3.0","x3.5","x4.0","x6.0","x8.0","x16","x256"},
		{"Normal","Acceleration","Deceleration","Parabolic"},
		{"Linear", "Musical"},
		{"OwnerDraw"},
		{"OFF", "ON", "Softlanding"}, // \t͖
		{"OFF", "ON"},
	};

	int iMax[] = {4,2,4,3,3,2,13,3,1,-1,1,1};

	static int curPos = 0;
	const int iOptNum = 12; // IvVڐ
	const int nTemMode= 8; // Tempo Change Scalëʒu
	const int nTemCh  = 9; // Tempo Changëʒu

	const int topX = 100; // ꗗ̈ԏ̍W
	const int topY = 85; // ꗗ̈ԏ̍W
	const int indentX = 200; // ڈꗗƒlꗗ̊Ԃ̃Cfg

	// ꗗ\
	int ypos = topY;

	for(int i=0;i<iOptNum;i++)
	{
		dd.DrawText(topX, ypos, szMenu[i]);

		if(i==nTemCh)
		{
			// TempoChange̓I[i[h[(H)
			int val = (int)CalcTempo(Cfg["TempoChange"], Cfg["TempoChangeMusical"]);

			char buf[64];
			sprintf(buf, "%+d%%", val-100);
			dd.DrawText(topX+indentX, ypos, buf);
		}
		else
		{
			// ʏ퍀
			int value = Cfg[szCfgVar[i]];
			dd.DrawText(topX+indentX, ypos, szSel[i][value]);
		}

		ypos+=18;
	}

	// J[\
	dd.DrawSprite(401, topX-dd.GetSpriteX(401)-6, topY+curPos*18+3);

//	GetKeyInfo();

	if(KEYPUSH(VK_CS_U))
	{
		curPos--;
		LOOP(curPos,0,iOptNum-1);
	}
	if(KEYPUSH(VK_CS_D))
	{
		curPos = ++curPos%iOptNum;
//		LOOP(curPos,0,iOptNum-1);
	}

	if(KEYPUSH(VK_PGUP))
	{
		curPos-=3;
		LOOP(curPos,0,iOptNum-1);
	}
	if(KEYPUSH(VK_PGDN))
	{
		curPos+=3;
		LOOP(curPos,0,iOptNum-1);
	}

	if(KEYPUSH(VK_CS_L) || KEYPUSH(VK_CS_R))
	{
		if(KEYPUSH(VK_CS_L))
			Cfg[szCfgVar[curPos]]--;
		else
			Cfg[szCfgVar[curPos]]++;

		if(curPos==nTemCh)
		{
			// TempoChange̗O
			if(DIkey.IsKeyPress(DIK_LCONTROL)||DIkey.IsKeyPress(DIK_RCONTROL))
			{
				// CtrlȂ炾Əp[Abv
				if(Cfg["TempoChangeMusical"])
					LOOP(Cfg[szCfgVar[curPos]], -51, 24); // Musical
				else
					LOOP(Cfg[szCfgVar[curPos]], -19, 60); // Linear
			}
			else
			{
				// ʏ̉ϔ͈
				if(Cfg["TempoChangeMusical"])
					LOOP(Cfg[szCfgVar[curPos]], -51, 12); // Musical
				else
					LOOP(Cfg[szCfgVar[curPos]], -19, 20); // Linear
			}
		}
		else if(curPos==nTemMode)
		{
			// Tempo Change Mode̗O
			LOOP(Cfg[szCfgVar[curPos]], 0, iMax[curPos]);

			// Tempo Change ModeύXTempoChange͈̐͂ύX
			if(Cfg["TempoChangeMusical"])
				RANGE(Cfg["TempoChange"], -51, 12); // Musical
			else
				RANGE(Cfg["TempoChange"], -19, 20); // Linear
		}
		else
			LOOP(Cfg[szCfgVar[curPos]], 0, iMax[curPos]); // ʏ
	}

	if(KEYPUSH(VK_ESC))
	{
		OptionDispatch();
		SaveConfig();

		if(g_iOptCaller==SC1_SELMUSIC)
		{
			// ȃZɖ߂̂ŁA
			// ȃZBMPǂݍ݂xȂȂ悤
			// BGScan~߂
			Juke.StopBGScan();
		}

		return(g_iOptCaller);
	}

	if(DIkey.IsKeyPushDown(DIK_O))
		return SC1_OPTION;

	if(DIkey.IsKeyPushDown(DIK_B))
		return SC1_OPTION_BM;

	if(DIkey.IsKeyPushDown(DIK_M))
		return SC1_OPTION_2;

	return(SC1_OPTION_2);

}

int OptionBM(int nCount){

	SCENE_INIT{
		if(dd.GetScreenColor()==8)
		{
			// pbgύX̐Fh~
			dd.ClearScreen();
			dd.Flip();
			dd.ClearScreen();
			dd.Flip();

			dd.LoadPalette("Image\\pal_option.bmp");
			lpGlobScene->RemapPalette();
		}

		LOAD_BMP(24, "Image\\cursor.bmp");
		DefSprite();

		LoadSoundSet(SS_OPTION);
		PlaySoundSet(SS_OPTION);
	}

	SCENE_TERM{
		dd.UnLoadBMP(24);
		UnLoadSoundSet(SS_OPTION);
		return 0; //@l̓_~[
	}

	dd.DrawText(50,32,szAppFullName);
	dd.DrawText(50,50,"Mode Option - Push ESC to Quit");

	//ɍڂǉAszCfgVar, szSel, iMax[], iOptNumύXB
	const char* szMenu[]/*==optNum*/ = 
	{
		//        1         2         3
		"Scratch Layout 1P",
		"Scratch Layout 2P",
		"Auto Scratch",
		"Ignore Poor",
		"Combo",
		"Project 2DX Support",
		"OUCH",
		"Vivid",
		"Reverse",
	};

	const char* szCfgVar[]/*==optNum*/ = 
	{
		"1PScratchLeft",
		"2PScratchLeft",
		"AutoScratch",
		"IgnorePoor",
		"Combo",
		"Urami",
		"OUCH",
		"Flat",
		"Reverse",
	};

	const char* szSel[]/*==optNum*/[4]/*==ڐ*/ =
	{
		//FALSE==0 TRUE==1
		{"Right","Left"},
		{"Right","Left"},
		{"OFF","1P","2P","1P & 2P"},
		{"OFF","ON"},
		{"OFF","Great & Good","Great"},
		{"OFF","ON"},
		{"OFF","ON"},
		{"Vivid","Flat"},
		{"OFF","ON"},
	};

	int iMax[] = {1,1,3,1,2,1,1,1,1};

	static int curPos = 0;
	const int iOptNum = 9; // IvVڐ

	const int topX = 100; // ꗗ̈ԏ̍W
	const int topY = 85; // ꗗ̈ԏ̍W
	const int indentX = 200; // ڈꗗƒlꗗ̊Ԃ̃Cfg

	// ꗗ\
	int ypos = topY;

	for(int i=0;i<iOptNum;i++)
	{
		dd.DrawText(topX, ypos, szMenu[i]); // 

		int value = Cfg[szCfgVar[i]];
		dd.DrawText(topX+indentX, ypos, szSel[i][value]); // l

		ypos+=18;
	}

	// J[\
	dd.DrawSprite(401, topX-dd.GetSpriteX(401)-6, topY+curPos*18+3);

//	GetKeyInfo();

	if(KEYPUSH(VK_CS_U))
	{
		curPos--;
		LOOP(curPos,0,iOptNum-1);
	}
	if(KEYPUSH(VK_CS_D))
	{
		curPos = ++curPos%iOptNum;
//		LOOP(curPos,0,iOptNum-1);
	}

	if(KEYPUSH(VK_PGUP))
	{
		curPos-=3;
		LOOP(curPos,0,iOptNum-1);
	}
	if(KEYPUSH(VK_PGDN))
	{
		curPos+=3;
		LOOP(curPos,0,iOptNum-1);
	}

	if(KEYPUSH(VK_CS_L))
	{
		Cfg[szCfgVar[curPos]]--;
		LOOP(Cfg[szCfgVar[curPos]], 0, iMax[curPos]);
	}

	if(KEYPUSH(VK_CS_R))
	{
		Cfg[szCfgVar[curPos]]++;
		LOOP(Cfg[szCfgVar[curPos]], 0, iMax[curPos]);
	}

	if(KEYPUSH(VK_ESC))
	{
		OptionDispatch();
		SaveConfig();

		if(g_iOptCaller==SC1_SELMUSIC)
		{
			// ȃZɖ߂̂ŁA
			// ȃZBMPǂݍ݂xȂȂ悤
			// BGScan~߂
			Juke.StopBGScan();
		}

		return(g_iOptCaller);
	}

	if(DIkey.IsKeyPushDown(DIK_O))
		return SC1_OPTION;

	if(DIkey.IsKeyPushDown(DIK_B))
		return SC1_OPTION_BM;

	if(DIkey.IsKeyPushDown(DIK_M))
		return SC1_OPTION_2;

	return(SC1_OPTION_BM);

}

int KeyConfigSys(int nCount){

	SCENE_INIT
	{
		if(dd.GetScreenColor()==8)
		{
			// pbgύX̐Fh~
			dd.ClearScreen();
			dd.Flip();
			dd.ClearScreen();
			dd.Flip();
		}
		dd.LoadPalette("Image\\pal_option.bmp");

		if(!dd.LoadBMP( 81, "Image\\KeyInfo.bmp", RGB(255,255,255)) ){
			WriteLog("Image\\KeyInfo.bmp̓ǂݍ݂Ɏs");
		}

		DefSprite();

		LoadSoundSet(SS_KEYCONFIG);
		PlaySoundSet(SS_KEYCONFIG);
	}

	SCENE_TERM
	{
		dd.UnLoadBMP(24);
		UnLoadSoundSet(SS_KEYCONFIG);
		return 0; //@l̓_~[
	}

	dd.DrawText(50,32,szAppFullName);
	dd.DrawText(50,50,"System KeyConfig - Push ESC to Quit");

	char* szMenu[]/*==optNum*/ = 
	{
		//        1         2         3
		"Cursor Left",
		"Cursor Right",
		"Cursor Up",
		"Cursor Down",
		"OK",

		"Cancel",
		"Page Up",
		"Page Down",
		"Volume Up",
		"Volume Down",

		"Tempo Up",
		"Tempo Down",
		"Pause",
		"Music Up",
		"Music Down",

		"JukeBox Up",
		"JukeBox Down",
	};

	int vkeyTbl[] = {VK_CS_L, VK_CS_R, VK_CS_U, VK_CS_D, VK_OK, VK_ESC, VK_PGUP, VK_PGDN,
					VK_VOLUP, VK_VOLDOWN, VK_TEMPOUP, VK_TEMPODOWN, VK_PLAYSTOP,
					VK_MUSICUP, VK_MUSICDOWN, VK_JUKEUP, VK_JUKEDOWN};

	const int iOptNum = sizeof(szMenu) / sizeof(szMenu[0]); // IvVڐ
	static int curPosX = 0, curPosY = 0;

	dd.DrawSprite(859, 180+56*curPosX-25, 100+curPosY*18); //cursle

	int ypos=100;
	for(int i=0;i<iOptNum;i++)
	{
		dd.DrawText(50,ypos,szMenu[i]);

		for(int j=0;j<MAX_KEY;j++)
			DrawKeyIcon(180+56*j,ypos, vkeyTbl[i],j);
//			dd.DrawText(160+56*j, ypos, keycfg.GetKeyName(vkeyTbl[i],j));

		ypos+=18;
	}

//	GetKeyInfo();

	if(DIkey.IsKeyPushDown(DIK_UP))
	{
		curPosY--;
		LOOP(curPosY,0,iOptNum-1);
	}

	if(DIkey.IsKeyPushDown(DIK_DOWN))
	{
		curPosY = ++curPosY%iOptNum;
//		LOOP(curPos,0,iOptNum-1);
	}

	if(DIkey.IsKeyPushDown(DIK_LEFT))
	{
		curPosX--;
		LOOP(curPosX,0,MAX_KEY-1);
	}

	if(DIkey.IsKeyPushDown(DIK_RIGHT))
	{
		curPosX++;
		LOOP(curPosX,0,MAX_KEY-1);
	}

	int keypNow = keycfg.GetKeyPressNum();
	if(keypNow!=-1)
	{
		if(keypNow!=DIK_LEFT && keypNow!=DIK_RIGHT && keypNow!=DIK_UP && keypNow!=DIK_DOWN && //@j[ɎgL[
		   keypNow!=DIK_ESCAPE && keypNow!=DIK_DELETE)
			keycfg.SetVKey(vkeyTbl[curPosY], curPosX, keypNow);
	}

	if(DIkey.IsKeyPushDown(DIK_DELETE))
	{
		keycfg.SetVKey(vkeyTbl[curPosY], curPosX, -1);
	}

	if(DIkey.IsKeyPushDown(DIK_ESCAPE))
	{
		keycfg.SaveCfg();
		keycfg.Dispatch();
		return(SC1_OPTION);
	}

	// ͈ԍŌBESCƂDELL[obt@ɎcȂ
	if(DIkey.IsKeyPushDown(DIK_INSERT))
	{
		// Cӂ̃L[蓖
		dd.DrawText(320-23*8/2, 80, "Press any key to Assign");
		dd.Flip();

		int keypNow = -1;
		while(keypNow==-1)
		{
			KEY_INPUT;
			keypNow = keycfg.GetKeyPressNum();
		}

		keycfg.SetVKey(vkeyTbl[curPosY], curPosX, keypNow);
	}

	return(SC1_KEYCFGSYS);

}

int KeyConfigDDR(int nCount){

	SCENE_INIT
	{
		if(dd.GetScreenColor()==8)
		{
			// pbgύX̐Fh~
			dd.ClearScreen();
			dd.Flip();
			dd.ClearScreen();
			dd.Flip();
		}
		dd.LoadPalette("Image\\pal_option.bmp");
		if(!dd.LoadBMP( 81, "Image\\KeyInfo.bmp", RGB(255,255,255)) ){
			WriteLog("Image\\KeyInfo.bmp̓ǂݍ݂Ɏs");
		}
		DefSprite();

		LoadSoundSet(SS_KEYCONFIG);
		PlaySoundSet(SS_KEYCONFIG);
	}

	SCENE_TERM
	{
		dd.UnLoadBMP(24);
		UnLoadSoundSet(SS_KEYCONFIG);
		return 0; //@l̓_~[
	}

	dd.DrawText(50,32,szAppFullName);
	dd.DrawText(50,50,"DDR-Mode KeyConfig - Push ESC to Quit");

	char* szMenu[]/*==optNum*/ = 
	{
		//        1         2         3
		"1P   Left",
		"1P   Down",
		"1P   Up",
		"1P   Right",
		"2P   Left",
		"2P   Down",
		"2P   Up",
		"2P   Right",
		"6-Ar Left",
		"6-Ar Up-Left",
		"6-Ar Down",
		"6-Ar Up",
		"6-Ar Up-Right",
		"6-Ar Right"
	};

	int vkeyTbl[] = {VK_DDR1P_L, VK_DDR1P_D, VK_DDR1P_U, VK_DDR1P_R, 
					 VK_DDR2P_L, VK_DDR2P_D, VK_DDR2P_U, VK_DDR2P_R,
					 VK_DDR6_4, VK_DDR6_7, VK_DDR6_2, VK_DDR6_8, VK_DDR6_9, VK_DDR6_6};

	const int iOptNum = sizeof(szMenu) / sizeof(szMenu[0]); // IvVڐ
	static int curPosX = 0, curPosY = 0;

	dd.DrawSprite(859, 180+56*curPosX-25, 100+curPosY*18); //cursle

	int ypos=100;
	for(int i=0;i<iOptNum;i++)
	{
		dd.DrawText(50,ypos,szMenu[i]);

		for(int j=0;j<MAX_KEY;j++)
			DrawKeyIcon(180+56*j,ypos, vkeyTbl[i],j);
//			dd.DrawText(160+56*j, ypos, keycfg.GetKeyName(vkeyTbl[i],j));

		ypos+=18;
	}

//	GetKeyInfo();

	if(DIkey.IsKeyPushDown(DIK_UP))
	{
		curPosY--;
		LOOP(curPosY,0,iOptNum-1);
	}

	if(DIkey.IsKeyPushDown(DIK_DOWN))
	{
		curPosY = ++curPosY%iOptNum;
//		LOOP(curPos,0,iOptNum-1);
	}

	if(DIkey.IsKeyPushDown(DIK_LEFT))
	{
		curPosX--;
		LOOP(curPosX,0,MAX_KEY-1);
	}

	if(DIkey.IsKeyPushDown(DIK_RIGHT))
	{
		curPosX++;
		LOOP(curPosX,0,MAX_KEY-1);
	}

	int keypNow = keycfg.GetKeyPressNum();
	if(keypNow!=-1)
	{
		if(keypNow!=DIK_LEFT && keypNow!=DIK_RIGHT && keypNow!=DIK_UP && keypNow!=DIK_DOWN && //@j[ɎgL[
		   keypNow!=DIK_ESCAPE && keypNow!=DIK_DELETE)
			keycfg.SetVKey(vkeyTbl[curPosY], curPosX, keypNow);
	}

	if(DIkey.IsKeyPushDown(DIK_DELETE))
	{
		keycfg.SetVKey(vkeyTbl[curPosY], curPosX, -1);
	}

	if(DIkey.IsKeyPushDown(DIK_ESCAPE))
	{
		keycfg.SaveCfg();
		keycfg.Dispatch();
		return(SC1_OPTION);
	}

	// ͈ԍŌBESCƂDELL[obt@ɎcȂ
	if(DIkey.IsKeyPushDown(DIK_INSERT))
	{
		// Cӂ̃L[蓖
		dd.DrawText(320-23*8/2, 80, "Press any key to Assign");
		dd.Flip();

		int keypNow = -1;
		while(keypNow==-1)
		{
			KEY_INPUT;
			keypNow = keycfg.GetKeyPressNum();
		}

		keycfg.SetVKey(vkeyTbl[curPosY], curPosX, keypNow);
	}

	return(SC1_KEYCFGDDR);

}

int KeyConfigBM(int nCount){

	SCENE_INIT
	{
		if(dd.GetScreenColor()==8)
		{
			// pbgύX̐Fh~
			dd.ClearScreen();
			dd.Flip();
			dd.ClearScreen();
			dd.Flip();
		}
		dd.LoadPalette("Image\\pal_option.bmp");
		if(!dd.LoadBMP( 81, "Image\\KeyInfo.bmp", RGB(255,255,255)) ){
			WriteLog("Image\\KeyInfo.bmp̓ǂݍ݂Ɏs");
		}
		DefSprite();

		LoadSoundSet(SS_KEYCONFIG);
		PlaySoundSet(SS_KEYCONFIG);
	}

	SCENE_TERM
	{
		dd.UnLoadBMP(24);
		UnLoadSoundSet(SS_KEYCONFIG);
		return 0; //@l̓_~[
	}

	dd.DrawText(50,32,szAppFullName);
	dd.DrawText(50,50,"BM-Mode KeyConfig - Push ESC to Quit");

	char* szMenu[]/*==optNum*/ = 
	{
		//        1         2         3
		"1P 1Key",
		"1P 2Key",
		"1P 3Key",
		"1P 4Key",
		"1P 5Key",
		"1P 6Key",
		"1P 7Key",
		"1P Scratch",
		"2P 1Key",
		"2P 2Key",
		"2P 3Key",
		"2P 4Key",
		"2P 5Key",
		"2P 6Key",
		"2P 7Key",
		"2P Scratch",
	};

	int vkeyTbl[] = {VK_BM1P_1, VK_BM1P_2, VK_BM1P_3, VK_BM1P_4, VK_BM1P_5, VK_BM1P_6, VK_BM1P_7, VK_BM1P_SC,
				  	 VK_BM2P_1, VK_BM2P_2, VK_BM2P_3, VK_BM2P_4, VK_BM2P_5, VK_BM2P_6, VK_BM2P_7, VK_BM2P_SC};

	const int iOptNum = sizeof(szMenu) / sizeof(szMenu[0]); // IvVڐ
	static int curPosX = 0, curPosY = 0;

	dd.DrawSprite(859, 180+56*curPosX-25, 100+curPosY*18); //cursle

	int ypos=100;
	for(int i=0;i<iOptNum;i++)
	{
		dd.DrawText(50,ypos,szMenu[i]);

		for(int j=0;j<MAX_KEY;j++)
			DrawKeyIcon(180+56*j,ypos, vkeyTbl[i],j);
//			dd.DrawText(160+56*j, ypos, keycfg.GetKeyName(vkeyTbl[i],j));

		ypos+=18;
	}

//	GetKeyInfo();

	if(DIkey.IsKeyPushDown(DIK_UP))
	{
		curPosY--;
		LOOP(curPosY,0,iOptNum-1);
	}

	if(DIkey.IsKeyPushDown(DIK_DOWN))
	{
		curPosY = ++curPosY%iOptNum;
//		LOOP(curPos,0,iOptNum-1);
	}

	if(DIkey.IsKeyPushDown(DIK_LEFT))
	{
		curPosX--;
		LOOP(curPosX,0,MAX_KEY-1);
	}

	if(DIkey.IsKeyPushDown(DIK_RIGHT))
	{
		curPosX++;
		LOOP(curPosX,0,MAX_KEY-1);
	}

	int keypNow = keycfg.GetKeyPressNum();
	if(keypNow!=-1)
	{
		if(keypNow!=DIK_LEFT && keypNow!=DIK_RIGHT && keypNow!=DIK_UP && keypNow!=DIK_DOWN && //@j[ɎgL[
		   keypNow!=DIK_ESCAPE && keypNow!=DIK_DELETE && keypNow!=DIK_INSERT)
			keycfg.SetVKey(vkeyTbl[curPosY], curPosX, keypNow);
	}

	if(DIkey.IsKeyPushDown(DIK_DELETE))
	{
		keycfg.SetVKey(vkeyTbl[curPosY], curPosX, -1);
	}

	if(DIkey.IsKeyPushDown(DIK_ESCAPE))
	{
		keycfg.SaveCfg();
		keycfg.Dispatch();
		return(SC1_OPTION);
	}

	// ͈ԍŌBESCƂDELL[obt@ɎcȂ
	if(DIkey.IsKeyPushDown(DIK_INSERT))
	{
		// Cӂ̃L[蓖
		dd.DrawText(320-23*8/2, 80, "Press any key to Assign");
		dd.Flip();

		int keypNow = -1;
		while(keypNow==-1)
		{
			KEY_INPUT;
			keypNow = keycfg.GetKeyPressNum();
		}

		keycfg.SetVKey(vkeyTbl[curPosY], curPosX, keypNow);
	}

	return(SC1_KEYCFGBM);

}

void DrawJudgeLine(BOOL bFlush){

	for(int i=0;i<8;i++)
	{
		if(pd.iLightTime[i]>0)
		{
			int tim = JUDGE_LIGHTTIME-pd.iLightTime[i];

			int x = int(double(tim)/(JUDGE_LIGHTTIME/5)) * 100;

			if(pd.iLightCol[i]==LC_PERFECT)
				dd.DefSprite(80+i, 14, x,0,x+100,100);
			else
				dd.DefSprite(80+i, 14, x,100,x+100,200);
		}else
			dd.DefSprite(80+i, 14, 0,0,2,2); // Dummy

	}

	int y;
	if(opt.bReverse)
		y = 480 - TIMEBASE/4 - PLAYAREA_Y; // Reverse
	else
		y = PLAYAREA_Y; // Normal

	if(!opt.bAllow6)
	{
//		static int iPushTime[8] = {0,0,0,0,0,0,0,0};

	//	GetKeyInfo();

		if(pd.bPush)
		{
			for(int i=0;i<4;i++)
			{
				if(KEYPUSH(VK_DDR1P_L+i))
					pd.iPushTime[i] = JUDGE_PUSHTIME;
			}
			
			if(IsCouple() || IsDouble())
			{
				for(int i=0;i<4;i++)
				{
					if(KEYPUSH(VK_DDR2P_L+i))
						pd.iPushTime[4+i] = JUDGE_PUSHTIME;
				}
			}
		}

		if(opt.iEffect<=GE_LOW)
		{
			for(int i=0;i<8;i++)
				pd.iPushTime[i] = 0;
		}
		
//		RECT rect;
		int iFlush = bFlush ? 4 : 0;
		int SpX = dd.GetSpriteX(4);

		if(IsDouble())
		{
			for(int i=0;i<8;i++) // DP
			{
				// ̂ڂ[
				dd.DrawSprite(80+i, PLAYAREA_DP_X + SpX*i-18, y-18);

				// 胉C
				if(pd.iPushTime[i]==0)
					dd.DrawSprite(4 + iFlush + i%4, PLAYAREA_DP_X + SpX*i, y);
				else
				{
					double size = (JUDGE_PUSHTIME - pd.iPushTime[i]) / double(JUDGE_PUSHTIME) * 0.3 + 0.7;
					dd.StretchBltFast(4 + iFlush + i%4, PLAYAREA_DP_X + SpX*i, y, size);
				}

			}

		}
		else
		{

			for(int i=0;i<4;i++) // 1P
			{
				// ̂ڂ[
				dd.DrawSprite(80+i, PLAYAREA_1P_X + SpX*i-18, y-18);

				// 胉C
				if(pd.iPushTime[i]==0)
					dd.DrawSprite(4 + iFlush + i%4, PLAYAREA_1P_X + SpX*i, y);
				else
				{
					double size = (JUDGE_PUSHTIME - pd.iPushTime[i]) / double(JUDGE_PUSHTIME) * 0.3 + 0.7;
					dd.StretchBltFast(4 + iFlush + i%4, PLAYAREA_1P_X + SpX*i, y, size);
				}

			}

			if(IsCouple()) // COUPLE[hȂ2P`
			{
				for(int i=4;i<8;i++) // 2P
				{
					// ̂ڂ[
					dd.DrawSprite(80+i, PLAYAREA_2P_X + SpX*(i-4)-18, y-18);

					// 胉C
					if(pd.iPushTime[i]==0)
						dd.DrawSprite(4 + iFlush + i%4, PLAYAREA_2P_X + SpX*(i-4), y);
					else
					{
						double size = (JUDGE_PUSHTIME - pd.iPushTime[i]) / double(JUDGE_PUSHTIME) * 0.3 + 0.7;
						dd.StretchBltFast(4 + iFlush + i%4, PLAYAREA_2P_X + SpX*(i-4), y, size);
					}
				}
			}

		}

	}//endof if(!opt.bAllow6)
	else
	{
		// 6Arrow[h
		if(pd.bPush)
		{
			for(int i=0;i<6;i++)
			{
				if(KEYPUSH(VK_DDR6_4+i))
					pd.iPushTime[i] = JUDGE_PUSHTIME;
			}
		}

		if(opt.iEffect<=GE_LOW)
		{
			for(int i=0;i<6;i++)
				pd.iPushTime[i] = 0;
		}

//		RECT rect;
		int iFlush = bFlush ? 4 : 0;
		int SpX = dd.GetSpriteX(4);

		for(int i=0;i<6;i++) // 6Allow
		{
			// ̂ڂ[
			dd.DrawSprite(80+i, PLAYAREA_X_6 + SpX*i-18, y-18);

			if(pd.iPushTime[i]==0)
			{
				switch(i)
				{
				case 0:	dd.DrawSprite(4 + iFlush  , PLAYAREA_X_6 + SpX*i, y); break;
				case 1:	dd.DrawSprite(21+ iFlush/2, PLAYAREA_X_6 + SpX*i, y); break;
				case 2:	dd.DrawSprite(5 + iFlush  , PLAYAREA_X_6 + SpX*i, y); break;
				case 3:	dd.DrawSprite(6 + iFlush  , PLAYAREA_X_6 + SpX*i, y); break;
				case 4:	dd.DrawSprite(22+ iFlush/2, PLAYAREA_X_6 + SpX*i, y); break;
				case 5:	dd.DrawSprite(7 + iFlush  , PLAYAREA_X_6 + SpX*i, y); break;
				}
			}
			else
			{
				// 胉C
				double size = (JUDGE_PUSHTIME - pd.iPushTime[i]) / double(JUDGE_PUSHTIME) * 0.3 + 0.7;
				switch(i)
				{
				case 0:	dd.StretchBltFast(4 + iFlush  , PLAYAREA_X_6 + SpX*i, y, size); break;
				case 1:	dd.StretchBltFast(21+ iFlush/2, PLAYAREA_X_6 + SpX*i, y, size); break;
				case 2:	dd.StretchBltFast(5 + iFlush  , PLAYAREA_X_6 + SpX*i, y, size); break;
				case 3:	dd.StretchBltFast(6 + iFlush  , PLAYAREA_X_6 + SpX*i, y, size); break;
				case 4:	dd.StretchBltFast(22+ iFlush/2, PLAYAREA_X_6 + SpX*i, y, size); break;
				case 5:	dd.StretchBltFast(7 + iFlush  , PLAYAREA_X_6 + SpX*i, y, size); break;
				}
			}
		
		}

	}

	static CTimer timer;

	if(timer.Get()>2000)	// ʂ̋ȂƂ̑΍
		timer.Reset();

	while(timer.Get()>16)
	{
		for(i=0;i<8;i++)
		{
			if(pd.iPushTime[i]>0)
				pd.iPushTime[i]--;
			if(pd.iLightTime[i]>0)
				pd.iLightTime[i]--;
		}
		timer.Adjust(-16);
	}

	if(!pd.bPush)
		pd.bPush = TRUE;

}

double SetPixNow(DWORD timeNow){

	g_dPixNow += double(timeNow-g_BeforeTime) * pd.DpMS;
	g_BeforeTime = timeNow;

	return(g_dPixNow);

}

int LineNum2X(int num){

	int whXw = dd.GetSpriteX(533);
	int blXw = dd.GetSpriteX(534);
	int scXw = dd.GetSpriteX(535);

	int keyX,scX,keyX2,scX2;

	if(opt.b1PScL)
		keyX = BM_1P_X + scXw  , scX = BM_1P_X ;
	else
		keyX = BM_1P_X         , scX = BM_1P_X + whXw*4 + blXw*3 ;
	
	if(opt.b2PScL)
		keyX2 = BM_2P_X + scXw   , scX2 = BM_2P_X ;
	else
		keyX2 = BM_2P_X             , scX2 = BM_2P_X + whXw*4 + blXw*3 ;

	keyX +=3; //[̓dɂ␳
	keyX2+=3;
	scX  +=3;
	scX2 +=3;

	if(IN(num,0,6))
		return(keyX + int(ceil(double(num)/2.0))*whXw + (num/2)*blXw);

	if(num==7)
		return(scX);

	if(IN(num,8,14))
		return(keyX2 + int(ceil(double(num-8)/2.0))*whXw + ((num-8)/2)*blXw);

	if(num==15)
		return(scX2);

	return(-100);

}

int LineCh2X(int ch){

	int whXw = dd.GetSpriteX(533);
	int blXw = dd.GetSpriteX(534);
	int scXw = dd.GetSpriteX(535);

	int keyX,scX,keyX2,scX2;

	if(opt.b1PScL)
		keyX = BM_1P_X + scXw  , scX = BM_1P_X ;
	else
		keyX = BM_1P_X         , scX = BM_1P_X + whXw*4 + blXw*3 ;
	
	if(opt.b2PScL)
		keyX2 = BM_2P_X + scXw , scX2 = BM_2P_X ;
	else
		keyX2 = BM_2P_X        , scX2 = BM_2P_X + whXw*4 + blXw*3 ;

	keyX +=3; //[̓dɂ␳
	keyX2+=3;
	scX  +=3;
	scX2 +=3;

	if(IN(ch,11,19) && ch!=16 && ch!=17)
	{
		//             21  22      23           24          25          26  27     28               29
		int table[] = { 0,whXw, whXw+blXw, whXw*2+blXw, whXw*2+blXw*2,-100,-100,whXw*3+blXw*2, whXw*3+blXw*3 };
		return(keyX+table[ch-11]);
	}

	if(ch==16)
		return(scX);

	if(IN(ch,21,29) && ch!=26 && ch!=27)
	{
		//             21  22      23           24          25          26  27     28               29
		int table[] = { 0,whXw, whXw+blXw, whXw*2+blXw, whXw*2+blXw*2,-100,-100,whXw*3+blXw*2, whXw*3+blXw*3 };
		return(keyX2+table[ch-21]);
	}

	if(ch==26)
		return(scX2);

	return(-100);

}

void DrawBMScreen(DWORD timeNow){

	int iPixNow = (int)SetPixNow(timeNow);
	iPixNow = iPixNow<0 ? 0 : iPixNow;

	//C
	DrawFan();

	int iFlush = (iPixNow%(g_TimeBase/4))/(g_TimeBase/20); // 胉COf

	RANGE(iFlush,0,4);
	dd.DefSprite(536,46,0,iFlush*20,0,(iFlush+1)*20);

	static int keyAn[16] = {40,40,40,40,40,40,40,40,
							40,40,40,40,40,40,40,40};

	for(int i=0;i<7;i++)
		dd.DefSprite(500+i, keyAn[i]); // 500-506 :  点܂ 1p
	dd.DefSprite(507,keyAn[7]); // 507 : Sc 点܂

	for(i=0;i<7;i++)
		dd.DefSprite(580+i, keyAn[i+8]); // 500-506 :  点܂ 2p
	dd.DefSprite(587,keyAn[15]); // 507 : Sc 点܂

	
	dd.DrawSprite(536, BM_1P_X, BM_Y-dd.GetSpriteY(536)-4); // ΃Of1p

	if(IsCouple() || IsDouble())
		dd.DrawSprite(536, BM_2P_X, BM_Y-dd.GetSpriteY(536)-4); // ΃Of2p

	//	GetKeyInfo();
	for(i=0;i<7;i++)
	{
		if(KEYPRESS(VK_BM1P_1+i))
		{
			if(i%2==0)
				dd.DrawSprite(576,LineNum2X(i),BM_Y-dd.GetSpriteY(576)-4); //key1p
			else
				dd.DrawSprite(577,LineNum2X(i),BM_Y-dd.GetSpriteY(577)-4);
		}

		if(KEYPRESS(VK_BM2P_1+i))
		{
			if(i%2==0)
				dd.DrawSprite(576,LineNum2X(i+8),BM_Y-dd.GetSpriteY(576)-4); //key2p
			else
				dd.DrawSprite(577,LineNum2X(i+8),BM_Y-dd.GetSpriteY(577)-4);
		}
	}

	static CTimer sc1, sc2;
	static BOOL bFirst = TRUE;
	if(bFirst)
	{
		sc1.Set(10000);
		sc2.Set(10000);
		bFirst = FALSE;
	}

	// 莞Ԃŏ
	if(KEYPUSH(VK_BM1P_SC))
		sc1.Reset();
	if(sc1.Get()<350 && KEYPRESS(VK_BM1P_SC))
		dd.DrawSprite(575,LineNum2X(7) ,BM_Y-dd.GetSpriteY(575)-4); // Sc1P

	if(KEYPUSH(VK_BM2P_SC))
		sc2.Reset();
	if(sc2.Get()<350 && KEYPRESS(VK_BM2P_SC))
		dd.DrawSprite(575,LineNum2X(15),BM_Y-dd.GetSpriteY(575)-4); // Sc2P

	for(i=0;i<16;i++)
		keyAn[i]=40;

	for(int p=0;p<2;p++)
	{
		int  bx,bx2;
		BOOL scL;
		int spnum;

		if(p==0){
			bx  = BM_1P_X;
			bx2 = -19;
			scL = opt.b1PScL;
			spnum = 0;
		}else{
			bx  = BM_2P_X;
			bx2 = -18;
			scL = opt.b2PScL;
			spnum = 80;
		}

//		dd.DrawSprite(530, bx,  BM_Y-4); // 胉C

		int dy = 0;//-4; //՗pW␳
		if(scL)
		{
			dd.DrawSprite(572,bx  ,0);  //c
			dd.DrawSprite(572,bx+2,0);

			dd.DrawSprite(507+spnum,bx+bx2,BM_Y+dy); //Sc Base

			int x;
			for(int i=0;i<7;i++)
			{
				//               Sc                   keyWh
				// 0,1,2,3,4,5,6

				// 0,1,1,2,2,3,3 ceil(i/2)
				// 0,0,1,1,2,2,3 i/2
//				x = bx + dd.GetSpriteX(507) + int(ceil(double(i)/2.0))*dd.GetSpriteX(533) + (i/2)*dd.GetSpriteX(534);
				x = LineNum2X(i+p*8);

				dd.DrawSprite(572   ,x-1,   0); //c
				dd.DrawSprite(500+spnum+i ,bx+bx2+dd.GetSpriteX(507+spnum)+dd.GetSpriteX(503)*i,BM_Y+dy); //
			}

			if(p==0)
				x = bx+bx2+dd.GetSpriteX(507+spnum)+dd.GetSpriteX(503)*7+5;
			else
				x = bx+bx2+dd.GetSpriteX(507+spnum)+dd.GetSpriteX(503)*7+4;
			dd.DrawSprite(572,x-2,0); //c
			dd.DrawSprite(572,x,0); //c
		}
		else
		{
			dd.DrawSprite(572,bx  ,0);  //c
			dd.DrawSprite(572,bx+2,0);

			dd.DrawSprite(500+spnum ,bx+bx2,BM_Y+dy); //1

			for(int i=0;i<6;i++)
				dd.DrawSprite(501+spnum+i ,bx+bx2+dd.GetSpriteX(500+spnum)+dd.GetSpriteX(503)*i,BM_Y+dy); //2-7

			int x = bx+dd.GetSpriteX(500+spnum)+dd.GetSpriteX(503)*6+5;
			dd.DrawSprite(507+spnum,x+bx2-3 ,BM_Y+dy); //Sc

			//int x;
			for(i=0;i<7;i++)
			{
				x = LineNum2X(i+p*8);
				dd.DrawSprite(572   ,x-1,   0); //c
			}
			x = LineNum2X(7+p*8);
			dd.DrawSprite(572,x-1 ,0); //c

			x += dd.GetSpriteX(535)-1;
			dd.DrawSprite(572,x,0); //c
			dd.DrawSprite(572,x+2,0); //c
		}

	}//endof for(int p=0;p<2;p++)

	dd.DrawSprite(573,  0,0); //嗝
	dd.DrawSprite(574,621,0);

	dd.DrawSprite(530, BM_1P_X, BM_Y-4); //judgeline
	dd.DrawSprite(530, BM_2P_X, BM_Y-4);

	int k = (timeNow/100)%4;
	dd.DefSprite(533, 45, 40,k*8,60,(k+1)*8); // 533 : White OBJ Aj
	dd.DefSprite(534, 45, 60,k*8,76,(k+1)*8); // 534 : Blue OBJ Aj
	dd.DefSprite(535, 45,  0,k*8,40,(k+1)*8); // 535 : Sc OBJ Aj

	for(i=g_OBJScanMin;i<pd.totalObj;i++) // ߐ
	{
		if(obj[i].iChannel != 2) // ߐȊO͖
			continue;

		int y = BM_Y - (int(obj[i].dPixel)-iPixNow);//dd.GetSpriteY(533);

		// ʊO̊֌WȂƂɗ烋[v
		// y<0Ȃ̂HST_PARAl
		if(y<-1000)
			break;

		// BM_Y == 300ƂčœKĂ
		if(opt.iHighSpStyle==HST_ACCEL)
		{
			// 90000 = pow(BM_Y,2)
			if(y>0)
				y = int(double(pow(double(y),3)) / 90000.0); //xt
		}

		if(opt.iHighSpStyle==HST_DECEL)
		{
			if(y>0)
			{
				// 44.814047465571647087474820140215 = pow(pow(double(BM_Y),1.0/3.0),2.0)
				// 67.221071198357470631212230210323 = pow(pow(double(BM_Y),1.0/3.0),2.0)*1.5
				y = int(double(pow(double(y),1.0/3.0))*67.2210711983574)-150; //xt
			}
		}

		if(opt.iHighSpStyle==HST_PARA)
		{
			// 27000000 = pow(BM_Y,3)
			y = int(double(pow(double(y),4)) / 27000000.0); //t
		}

		if(obj[i].iChannel == 2 && y<=BM_Y)
		{
			dd.DrawSprite(571,BM_1P_X,y);
			
			if(IsCouple()||IsDouble())
				dd.DrawSprite(571,BM_2P_X,y);
		}
	}

	for(i=g_OBJScanMin;i<pd.totalObj;i++) // IuWF
	{
		int ch = obj[i].iChannel;

		if(!IN(ch,11,16) && !IN(ch,18,19) && !IN(ch,21,26) && !IN(ch,28,29))
			continue; // IuWFȊO͖

		int y = BM_Y - (int(obj[i].dPixel)-iPixNow);//dd.GetSpriteY(533);

		// ʊO̊֌WȂƂɗ烋[v
		// y<0Ȃ̂HST_PARAl
		if(y<-1000)
			break;

		// BM_Y == 300ƂčœKĂ
		if(opt.iHighSpStyle==HST_ACCEL)
		{
			// 90000 = pow(BM_Y,2)
			if(y>0)
				y = int(double(pow(double(y),3)) / 90000.0); //xt
		}

		if(opt.iHighSpStyle==HST_DECEL)
		{
			if(y>0)
			{
				// 44.814047465571647087474820140215 = pow(pow(double(BM_Y),1.0/3.0),2.0)
				// 67.221071198357470631212230210323 = pow(pow(double(BM_Y),1.0/3.0),2.0)*1.5
				y = int(double(pow(double(y),1.0/3.0))*67.2210711983574)-150; //xt
			}
		}

		if(opt.iHighSpStyle==HST_PARA)
		{
			// 27000000 = pow(BM_Y,3)
			y = int(double(pow(double(y),4)) / 27000000.0); //t
		}

		y-=6;

		// 胉C点
		if(abs(int(obj[i].dPixel-iPixNow))<=g_TimeBase/30)//IN(y,BM_Y-6,BM_Y+g_TimeBase/30))
		{
			if(IN(ch,11,15))
				keyAn[ch-11] = 41;
			if(IN(ch,18,19))
				keyAn[ch-13] = 41;

			if(ch==16)
				keyAn[7] = 41;

			if(IN(ch,21,25))
				keyAn[ch-13] = 41;
			if(IN(ch,28,29))
				keyAn[ch-15] = 41;

			if(ch==26)
				keyAn[15] = 41;

		}

		if(obj[i].bDraw &&
		    (opt.iBlind==BL_HIDDEN && y < BM_Y-TIMEBASE_BM*0.75 ||
		     opt.iBlind==BL_SUDDEN && y > BM_Y-TIMEBASE_BM*0.75 ||
			 opt.iBlind==0									       ) )
		{

			if(opt.iHighSpStyle!=HST_PARA)
			{
				if( BM_Y - (int(obj[i].dPixel)-iPixNow) - 6 > BM_Y-6+JUDGE_MISS)
					y=1000;
				else
					RANGE(y,-10,BM_Y-6);
			}
			else
			{
				if( y - 6 > BM_Y-6+JUDGE_MISS)
					y=1000;
				else
					RANGE(y,-10,BM_Y-6);
			}

//			const int fltime = g_TimeBase/19;

			int ch = obj[i].iChannel;
			if(IN(ch,11,15) || IN(ch,18,19))
			{

				//             11  12      13          14           15          16  17     18               19
//				int table[] = { 0,whXw, whXw+blXw, whXw*2+blXw, whXw*2+blXw*2,-100,-100,whXw*3+blXw*2, whXw*3+blXw*3 };
				
				int x = LineCh2X(ch);//(keyX+table[ch-11]);
				
				if(ch==11 || ch==13 || ch==15 || ch==19)
					dd.DrawSprite(533,x,y);

				if(ch==12 || ch==14 || ch==18)
					dd.DrawSprite(534,x,y);
			}

			if(ch==16)
			{
				dd.DrawSprite(535,LineCh2X(ch),y);
			}

			// 2P
			if(IN(ch,21,25) || IN(ch,28,29))
			{
				//             21  22      23          24           25          26  27     28               29
//				int table[] = { 0,whXw, whXw+blXw, whXw*2+blXw, whXw*2+blXw*2,-100,-100,whXw*3+blXw*2, whXw*3+blXw*3 };
				
				int x = LineCh2X(ch);//(keyX2+table[ch-21]);
				
				if(ch==21 || ch==23 || ch==25 || ch==29)
					dd.DrawSprite(533,x,y);

				if(ch==22 || ch==24 || ch==28)
					dd.DrawSprite(534,x,y);
			}

			if(ch==26)
			{
				dd.DrawSprite(535,LineCh2X(ch),y);
			}

		}//endof if(obj[i].bDraw && opt.iBlind!=BL_STEALTH)

	}//endof for(int i=0;i<pd.totalObj;i++)

/*	int whXw = dd.GetSpriteX(533);
	int blXw = dd.GetSpriteX(534);
	int scXw = dd.GetSpriteX(535);

	int keyX,keyX2;
	if(opt.b1PScL)
		keyX = BM_1P_X + scXw+3;
	else
		keyX = BM_1P_X;
	
	if(opt.b2PScL)
		keyX2 = BM_2P_X + scXw+3;
	else
		keyX2 = BM_2P_X;
*/
	if(opt.iMode==MD_BM_4) //AUTOPLAY PART
	{
		for(int i=0;i<3;i++)
		{
			dd.DrawSprite(558,LineNum2X(1+i*2),0); //1p
			dd.DrawSprite(558,LineNum2X(9+i*2),0); //2p
		}
	}

	if(opt.iMode==MD_BM_5)
	{
		dd.DrawSprite(558,LineNum2X(5),0); //1p
		dd.DrawSprite(557,LineNum2X(6),0);

		dd.DrawSprite(558,LineNum2X(13),0); //2p
		dd.DrawSprite(557,LineNum2X(14),0);

	}

	int y = 320;

	if(g_bClub)
	{
		dd.DrawSprite(509, 0, y); //Q[Wg
		DrawBMGaugeClub(0,y,int(pd.dHP[0]), int(pd.dHP[1]), int(pd.dClubHP[0]), int(pd.dClubHP[1]));
	}
	else
	{
		dd.DrawSprite(508, 0, y); //Q[Wg
		DrawBMGauge(0,y,int(pd.dHP[0]),int(pd.dHP[1]));
	}

	for(i=0;i<3;i++)
	{
		int spX = dd.GetSpriteX(570);
		dd.DrawSprite(570,312+i*spX,398); // BPM
		dd.DrawSprite(570, 51+i*spX,440); // REST fW^n
		dd.DrawSprite(570,577+i*spX,440);
	}
	char szTxt[10];
	wsprintf(szTxt,"%3d",int(pd.BPM+0.5)); // +0.5 : ľܓ
	DrawDigit(560,312,398,szTxt);		//BPM

	// e|ύX\
	int tempoCh = opt.iAutoTempoChange==0 ? (int)CalcTempo(pd.tempoUP, opt.bTCMusical) : pd.tempoUP2;
	if(tempoCh!=100)
	{
		if(tempoCh>100)
		{
			int x = 296, y = 424;
			dd.DrawSprite(700, x,y); x+=dd.GetSpriteX(700); // +

			char buf[10];
			sprintf(buf, "%3d", tempoCh-100);
			DrawDigit(680, x,y, buf, FALSE); // 
			x+=dd.GetSpriteX(680)*3;

			dd.DrawSprite(701, x,y); // '%'
		}
		else
		{
			int x = 296, y = 424;
			dd.DrawSprite(702, x,y); x+=dd.GetSpriteX(700); // -

			char buf[10];
			sprintf(buf, "%3d", 100-tempoCh);
			DrawDigit(690, x,y, buf, FALSE); // 
			x+=dd.GetSpriteX(690)*3;

			dd.DrawSprite(703, x,y); // '%'
		}
	}

	// HP1p
	if(g_bClub)
		wsprintf(szTxt,"%3d",int(pd.dHP[0]/2.0+pd.dClubHP[0]/2.0));
	else
		wsprintf(szTxt,"%3d",int(pd.dHP[0]));

	DrawDigit(560,51,440,szTxt);

	// HP2p
	if(IsCouple())
	{
		if(g_bClub)
			wsprintf(szTxt,"%3d",int(pd.dHP[1]/2.0+pd.dClubHP[1]/2.0));
		else
			wsprintf(szTxt,"%3d",int(pd.dHP[1]));
	}
	else
	{
			wsprintf(szTxt,"%3d",0);
	}
	DrawDigit(560,577,440,szTxt);


	for(i=0;i<6;i++)
	{
		int spX = dd.GetSpriteX(570);
		dd.DrawSprite(570,124+i*spX,378); // fW^n
		dd.DrawSprite(570,522+i*spX,378);
	}

	wsprintf(szTxt,"%6d",(int)pd.dBMScore[0]);
	DrawDigit(560,124,378,szTxt);

	wsprintf(szTxt,"%6d",(int)pd.dBMScore[1]);
	DrawDigit(560,522,378,szTxt);

	int anm = (timeNow/100)%5;

	if(anm==0) //sJO
		dd.DefSprite(511,43,0,0,80,30);
	else
		dd.DefSprite(511,43,80,(anm-1)*30,160,anm*30);

	// ER{
	if(random(5)<4)
	{
		for(int i=0;i<2;i++)
		{
			if(result[i].judgeNow==PERFECT)
			{
				for(int j=0;j<10;j++)
					dd.DefSprite(520+j,43, j*16,120+anm*30, (j+1)*16,150+anm*30); // 520-529 : 0-9 Aj
			}
			else
			{
				for(int j=0;j<10;j++)
					dd.DefSprite(520+j,43, j*16,120, (j+1)*16,150); // 520-529 : 0-9
			}

			static CTimer timer2[2];

			if(timer2[0].Get()>2000)	// ʂ̋ȂƂ̑΍
			{
				timer2[0].Reset();
				timer2[1].Reset();
			}

			while(timer2[i].Get()>32)
			{
				result[i].dispTime--;
				timer2[i].Adjust(-32);
			}

			if(result[i].dispTime>0)
			{
				int x;
				if(i==0)
					x = JUDGE_BM_1P_X;
				else
					x = JUDGE_BM_2P_X;

				if(IN(result[i].judgeNow,PERFECT,MISS))
					dd.DrawSprite(510+result[i].judgeNow, x, JUDGE_BM_Y); //
				if(result[i].judgeNow==OUCH)
					dd.DrawSprite(515, x, JUDGE_BM_Y); //POOR

				if(result[i].comboNow>0 && result[i].judgeNow!=OUCH)
				{
					char szTxt[10];
					wsprintf(szTxt,"%3d",result[i].comboNow);
					DrawDigit(520, x+80, JUDGE_BM_Y,szTxt); //
				}


			}//if(result[i].dispTime>0)
			else
			{
				result[i].dispTime = 0;
			}

		}


	}

	// 
	int whXw = dd.GetSpriteX(533);
	int blXw = dd.GetSpriteX(534);
	int scXw = dd.GetSpriteX(535);

	int expw = dd.GetSpriteX(540);
	int exph = dd.GetSpriteY(540);

	int parw = dd.GetSpriteX(590);
	int parh = dd.GetSpriteY(590);

	const int NUM_PAR = 128;
	static CParticle par[NUM_PAR];
	static int parnum = 0;

	if(opt.iEffect>=GE_HIGH)
	{
		for(i=0;i<NUM_PAR;i++)
			par[i].Draw();
	}

	for(i=0;i<7;i++)
	{
		int dx;
		if(i%2==0)
			dx = whXw/2;
		else
			dx = blXw/2;

		if(pd.iLightTime[i]>0)//1P
		{
			int an  = (JUDGE_EXPLTIME-pd.iLightTime[i])/(JUDGE_EXPLTIME/8);

			if(opt.iEffect<=GE_MID)
				dd.DrawSprite(540+an, LineNum2X(i)   + dx-expw/2,BM_Y-exph/2);//,0.5);
			else
				dd.AddBlt(540+an, LineNum2X(i)   + dx-expw/2,BM_Y-exph/2);//,0.5);

			if(an==0)
			{
				par[parnum].Init(&dd, 3+random(3), 590,594);
				par[parnum].SetPos(LineNum2X(i)+dx-parw/2, BM_Y-parh/2);
				par[parnum].SetRndParam();
				parnum++;
				LOOP(parnum,0,NUM_PAR-1);
			}
		}

		if(pd.iLightTime[i+8]>0)//2P
		{
			int an = (JUDGE_EXPLTIME-pd.iLightTime[i+8])/(JUDGE_EXPLTIME/8);

			if(opt.iEffect<=GE_MID)
				dd.DrawSprite(540+an, LineNum2X(8+i) + dx-expw/2,BM_Y-exph/2);//,0.5);
			else
				dd.AddBlt(540+an, LineNum2X(8+i) + dx-expw/2,BM_Y-exph/2);//,0.5);

			if(an==0)
			{
				par[parnum].Init(&dd, 3+random(3), 590,594);
				par[parnum].SetPos(LineNum2X(8+i)+dx-parw/2, BM_Y-parh/2);
				par[parnum].SetRndParam();
				parnum++;
				LOOP(parnum,0,NUM_PAR-1);
			}
		}
	}

	if(pd.iLightTime[7]>0)//1P-Sc
	{
		int an = (JUDGE_EXPLTIME-pd.iLightTime[7])/(JUDGE_EXPLTIME/8);

		if(opt.iEffect<=GE_MID)
			dd.DrawSprite(540+an,LineNum2X(7) + scXw/2-expw/2,BM_Y-exph/2);//,0.5);
		else
			dd.AddBlt(540+an,LineNum2X(7) + scXw/2-expw/2,BM_Y-exph/2);//,0.5);

		if(an==0)
		{
			par[parnum].Init(&dd, 3+random(3), 590,594);
			par[parnum].SetPos(LineNum2X(7)+scXw/2-parw/2, BM_Y-parh/2);
			par[parnum].SetRndParam();
			parnum++;
			LOOP(parnum,0,NUM_PAR-1);
		}
	}

	if(pd.iLightTime[15]>0)//2P-Sc
	{
		int an  = (JUDGE_EXPLTIME-pd.iLightTime[15])/(JUDGE_EXPLTIME/8);

		if(opt.iEffect<=GE_MID)
			dd.DrawSprite(540+an,LineNum2X(15) + scXw/2-expw/2,BM_Y-exph/2);//,0.5);
		else
			dd.AddBlt(540+an,LineNum2X(15) + scXw/2-expw/2,BM_Y-exph/2);//,0.5);

		if(an==0)
		{
			par[parnum].Init(&dd, 3+random(3), 590,594);
			par[parnum].SetPos(LineNum2X(15)+scXw/2-parw/2, BM_Y-parh/2);
			par[parnum].SetRndParam();
			parnum++;
			LOOP(parnum,0,NUM_PAR-1);
		}
	}

	// Aj
	static CTimer timer;

	while(timer.Get()>16)
	{
		for(i=0;i<16;i++)
		{
			if(pd.iLightTime[i]>0)
			{
				pd.iLightTime[i]-=timer.Get()/16;
				if(pd.iLightTime[i]<0)
					pd.iLightTime[i] = 0;
			}
		}
		timer.Set(timer.Get()%16);
	}

}

void DrawFan(void){

	if(IsBM())
	{
		for(int i=0;i<2;i++) // C
		{
			static int spNum[2] = {670,670};

			static CTimer wait[2];

			if(wait[i].Get()>106-pd.dHP[i])
			{
				spNum[i]++;
				//LOOP(spNum[i],670,673);
				if(spNum[i]>673)spNum[i]=670;
				wait[i].Reset();
			}

			int x;
			if(i==0)
				x=188;
			else
				x=387;

			if(pd.dHP[i]<10.0)
				dd.DrawSprite(spNum[i]+4,x,333);
			else
				dd.DrawSprite(spNum[i],x,333);

		}
	}
	else //DDR
	{
		static int spNum = 410;
		static CTimer wait;

		int HP;
		
		if(IsCouple())
			HP = int((pd.dHP[0]+pd.dHP[1])/2.0);
		else
			HP = int(pd.dHP[0]);

		if(wait.Get()>(unsigned)(106-HP))
		{
			spNum++;
//			LOOP(spNum,410,413);
			if(spNum>413)spNum=410;
			wait.Reset();
		}

		int x,y;
		
		if(opt.bAllow6 || IsDouble())
		{
			x = 320 - dd.GetSpriteX(410)/2; //Z^O
//			y = PLAYAREA_Y - dd.GetSpriteY(410);
//			0ȉɂȂ̂
			y=0;

		}
		else
		{
			x = PLAYAREA_1P_X + dd.GetSpriteX(4)*4; //̊ sp(4) = 胉C̖
			y = PLAYAREA_Y;
		}

		if(HP<=13)
			dd.DrawSprite(spNum+4,x,y);
		else
			dd.DrawSprite(spNum,x,y);
	}

}

void DrawBMGauge(int x, int y, int value1, int value2){
// 0 <= value <= 100

/*	int rnd = random(10);

	int dx = int(218.0*(pd.dHP[0]/100.0))-rnd;
	RANGE(dx,0,218);
	dd.DefSprite(509,42,      0,80, 8+dx,160); //1P

	dx = int(218.0*(pd.dHP[1]/100.0))-rnd;
	RANGE(dx,0,218);
	dd.DefSprite(510,42, 630-dx,80, 640, 160); //2P
	
	dd.DrawSprite(509,                      0, y); //Q[W1P
	dd.DrawSprite(510, 640-dd.GetSpriteX(510), y); //Q[W2P
*/

	RANGE(value1,0,100);
	RANGE(value2,0,100);

	x+=6; // o[߂̍W␳
	y+=61;

	for(int k=0;k<2;k++)
	{

		int i=0;

		int x1,value;
		if(k==0)
			value = value1;
		else
		{
			// 1PȂ2P̃Q[W͂Ȃ
			if(!IsCouple())
				break;

			value = value2;
		}

		int rnd=random(10); // 0`9̗
		while( i <= value*(139.0/100.0)-rnd ) // _ŌZăAjBۂ̃Q[W140{(0-139)B100ϊ
		{
			if(value!=0)
			{
				if(k==0)
					x1 = (i*2+x);
				else
					x1 = 637 - (i*2+x);

				if(i<111)			dd.DrawSprite(650, x1, y);			// 1{ڂ112{ڂ܂ŗ
				else if(i<116)		dd.DrawSprite(651, x1, y);			// 113{ڂ117{ڂ܂Őԁi͓j
				else if(i<126)		dd.DrawSprite(652+(i-116), x1, y);	// 118{ڂ126{ڂ܂ł͈ڐɂQhbg
				else				dd.DrawSprite(661, x1, y);			// Q[Wԗ̈(99`110{)`
			}
			i++;
		}

		i = int( value*(139.0/100.0) ); // ̌Œʒu`
		if(k==0)
			x1 = (i*2+x);
		else
			x1 = 637 - (i*2+x);

		if(i!=0)
		{
			if(i<111)			dd.DrawSprite(650, x1, y);			// 1{ڂ112{ڂ܂ŗ
			else if(i<116)		dd.DrawSprite(651, x1, y);			// 113{ڂ117{ڂ܂Őԁi͓j
			else if(i<126)		dd.DrawSprite(652+(i-116), x1, y);	// 118{ڂ126{ڂ܂ł͈ڐɂQhbg
			else				dd.DrawSprite(661, x1, y);			// Q[Wԗ̈(99`110{)`
		}
	}

}

// 1p,2p : [J1p,2p
// 3p,4p : ʐM1p,2p
void DrawBMGaugeClub(int x, int y, int HP1p, int HP2p, int HP3p, int HP4p){

	RANGE(HP1p,0,100);
	RANGE(HP2p,0,100);
	RANGE(HP3p,0,100);
	RANGE(HP4p,0,100);

	x+=284; // o[߂̍W␳
	y+=100;

	for(int k=0;k<2;k++)
	{

		int i=0;

		int x1,value1,value2;

		if(k==0)
		{
			value1 = HP1p;
			value2 = HP3p;
		}
		else
		{
			value1 = HP2p;
			value2 = HP4p;
		}

		value1/=2;
		value2/=2;

		while( i <= value1*(139.0/100.0)) // ۂ̃Q[W140{(0-139)B100ϊ
		{
			if(value1!=0)
			{
				if(k==0)
					x1 = x-i*2;
				else
					x1 = 637 - (x-i*2);

				if(i<=15)			dd.DrawSprite(663, x1, y);	// 1{ڂ112{ڂ܂ŗ
				else if(i<=24)		dd.DrawSprite(663, x1, y-((i-15)*2));	// 113{ڂ117{ڂ܂Őԁi͓j
				else if(i==25)		dd.DrawSprite(663, x1, y-18);	// 118{ڂ126{ڂ܂ł͈ڐɂQhbg
				else				dd.DrawSprite(663, x1, y-19);	// Q[Wԗ̈(99`110{)`
			}
			i++;
		}

		if(value1==0)
			i--;

		while( i <= value1*(139.0/100.0)+value2*(139.0/100.0)) // ۂ̃Q[W140{(0-139)B100ϊ
		{
			if(value2!=0)
			{
				if(k==0)
					x1 = x-i*2;
				else
					x1 = 637 - (x-i*2);

				if(i<=15)			dd.DrawSprite(662, x1, y);	// 1{ڂ112{ڂ܂ŗ
				else if(i<=24)		dd.DrawSprite(662, x1, y-((i-15)*2));	// 113{ڂ117{ڂ܂Őԁi͓j
				else if(i==25)		dd.DrawSprite(662, x1, y-18);	// 118{ڂ126{ڂ܂ł͈ڐɂQhbg
				else				dd.DrawSprite(662, x1, y-19);	// Q[Wԗ̈(99`110{)`
			}
			i++;
		}

	}

}

void DrawDDRScreen(DWORD timeNow){

	int iPixNow2 = (int)SetPixNow(timeNow);
	int iPixNow = iPixNow2<0 ? 0 : iPixNow2;

	BOOL bFlush = (iPixNow%(g_TimeBase/4))<g_TimeBase/24 && iPixNow>0; // 胉C邩ǂ

	// 胉C`
	DrawJudgeLine(bFlush);

	//C
	DrawFan();

	// IuWF`
	int spX = dd.GetSpriteX(0);
	int x1,x2;
	if(IsDouble())
	{
		x1 = PLAYAREA_DP_X;
		x2 = PLAYAREA_DP_X + (dd.GetSpriteX(0))*4;
	}
	else
	{
		x1 = PLAYAREA_1P_X;
		x2 = PLAYAREA_2P_X;
	}

	for(int i=g_OBJScanMin;i<pd.totalObj;i++)
	{
		if(opt.iBlind==BL_STEALTH)
			break; // n܂Ƃbreak(

		if(obj[i].bDraw)
		{
			int y = int(obj[i].dPixel)-iPixNow;
			y = CalcObjYDDR(y);

			// ʊO̊֌WȂƂɗ烋[v
			if(y>480 && opt.iHighSpStyle!=HST_PARA)
				break;
			
			// ̐FAj
			int k;
			if(opt.bFlat)
				k = (timeNow/100)%12;
			else
				k = (timeNow/100+obj[i].iAnime)%12;

			for(int j=0;j<=3;j++)
				dd.DefSprite(j   , 0, j*64,  0+k*64, 64+j*64, 64+k*64);	// 0-3    : ()

			for(j=0;j<=1;j++)
				dd.DefSprite(j+19, 4, j*64,  0+k*64, 64+j*64, 64+k*64);	// 19,20  : (,E)

//			if(opt.iBlind==0									     ||
//			   opt.iBlind==BL_HIDDEN && y-PLAYAREA_Y > g_TimeBase*0.75 ||
//			   opt.iBlind==BL_SUDDEN && y-PLAYAREA_Y < g_TimeBase*0.75    )
//			{
				float bright = 1.0F;

				if(opt.iBlind==BL_HIDDEN)
					bright = float((y-PLAYAREA_Y)-TIMEBASE*0.33)/150.0F;

				if(opt.iBlind==BL_SUDDEN)
					bright = float(TIMEBASE*0.75-(y-PLAYAREA_Y))/150.0F;

				if(opt.iEffect<=GE_MID){
					if(bright>=0.5F)
						bright=1.0F;
					else
						bright=0.0F;
				}

				if(opt.bReverse)
					y = 480 - TIMEBASE/4 - y; // Reverse

				// EޑÕt[YA[
				if(!opt.bAllow6)
				{
					switch(obj[i].iChannel) // Allow4
					{
					case 11: case 13: case 15: case 16:
						{
							// [DDR:1P (,,,) = (11,13,15,16)]
							// 0-3: ,,,

							//            10 11  12 13  14 15 16
							int tbl[] = { -1, 0, -1, 1, -1, 2, 3 };
							int of = tbl[obj[i].iChannel-10];
							dd.BlendBlt(of, x1 + spX*of	,y,bright);

							if(bDebug)
							{
								// IuWFԍ\
								char buf[16];
								sprintf(buf, "%d", i);
								dd.DrawText(x1 + spX*of, y, buf);
							}
							break;
						}

					case 21: case 23: case 25: case 26:
						{
							// [DDR:2P (,,,) = (21,23,25,26)]
							// 0-3: ,,,

							//            20 21  22 23  24 25 26
							int tbl[] = { -1, 0, -1, 1, -1, 2, 3 };
							int of = tbl[obj[i].iChannel-20];
							dd.BlendBlt(of, x2 + spX*of	,y,bright);

							if(bDebug)
							{
								// IuWFԍ\
								char buf[16];
								sprintf(buf, "%d", i);
								dd.DrawText(x2 + spX*of, y, buf);
							}
							break;
						}

					case 51: case 53: case 55: case 56:
					case 61: case 63: case 65: case 66:
						{
							int spNum;
							if(obj[i].bJudge)
							{
								// ʂ߂O

								// ̐FŒ(
								spNum  = 1255;
							}
							else
							{
								// ʂ߂B
								
								// łpd.f_Arrow̕ŕ`
								if(pd.f_Arrow[obj[i].iChannel-50].pushed)
									break;

								// ̐FŒ(D
								spNum  = 1260;
							}

							int sy = int(obj[i].dPixel - iPixNow);
							int ey = int(obj[i].dPixel+obj[i].dLength - iPixNow);
							int dy = TIMEBASE/16;

							for(int j=sy;j<=ey;j+=dy)
							{
								int cy = CalcObjYDDR(j);

								float bright = 1.0F;

								if(opt.iBlind==BL_HIDDEN)
									bright = float((cy-PLAYAREA_Y)-TIMEBASE*0.33)/150.0F;

								if(opt.iBlind==BL_SUDDEN)
									bright = float(TIMEBASE*0.75-(cy-PLAYAREA_Y))/150.0F;

								if(opt.iEffect<=GE_MID){
									if(bright>=0.5F)
										bright=1.0F;
									else
										bright=0.0F;
								}

								if(opt.bReverse)
									cy = 480 - TIMEBASE/4 - cy; // Reverse

								// 4-Arrow
								//		[DDR:1P (,,,) = (11,13,15,16)]
								//		[DDR:2P (,,,) = (21,23,25,26)]
								//            50 51  52 53  54 55 56
								int tbl[] = { -1, 0, -1, 1, -1, 2, 3 };

								if(Is1PLongNote(obj[i].iChannel))
								{
									int of = tbl[obj[i].iChannel-50];
									dd.BlendBlt(spNum+of, x1+spX*of, cy, bright);

									if(j==sy && bDebug)
									{
										// IuWFԍ\
										char buf[16];
										sprintf(buf, "%d", i);
										dd.DrawText(x1 + spX*of, cy, buf);
									}
								}
								else
								{
									int of = tbl[obj[i].iChannel-60];
									dd.BlendBlt(spNum+of, x2+spX*of, cy, bright);

									if(j==sy && bDebug)
									{
										// IuWFԍ\
										char buf[16];
										sprintf(buf, "%d", i);
										dd.DrawText(x2 + spX*of, cy, buf);
									}
								}

							}

						}
						
	//				default:
	//					break;
					} // end of case(ch)
				}
				else
				{
					x1 = PLAYAREA_X_6;
					int spX = dd.GetSpriteX(0);

					switch(obj[i].iChannel) // Allow6
					{
					case 11: case 12: case 13: case 14: case 15: case 16:
						{
							// [DDR:1P (,_,,,^,) = (11,12,13,14,15,16)]
							// 0-3: ,,, (_, ^) = (19,20)
							int of = obj[i].iChannel-11;
							int tbl[] = { 0, 19, 1, 2, 20, 3 };
							dd.BlendBlt(tbl[of], x1+spX*of, y, bright);
							break;
						}

					case 51: case 52: case 53: case 54: case 55: case 56: 
						{
							int spNum;
							if(obj[i].bJudge)
							{
								// ʂ߂O

								// ̐FŒ(
								spNum = 1290;
							}
							else
							{
								// ʂ߂B
								
								// łpd.f_Arrow̕ŕ`
								if(pd.f_Arrow[obj[i].iChannel-50].pushed)
									break;

								// ̐FŒ(D
								spNum = 1300;
							}

							int sy = int(obj[i].dPixel - iPixNow);
							int ey = int(obj[i].dPixel+obj[i].dLength - iPixNow);
							int dy = TIMEBASE/16;

							for(int j=sy;j<=ey;j+=dy)
							{
								int cy = CalcObjYDDR(j);

								float bright = 1.0F;

								if(opt.iBlind==BL_HIDDEN)
									bright = float((cy-PLAYAREA_Y)-TIMEBASE*0.33)/150.0F;

								if(opt.iBlind==BL_SUDDEN)
									bright = float(TIMEBASE*0.75-(cy-PLAYAREA_Y))/150.0F;

								if(opt.iEffect<=GE_MID){
									if(bright>=0.5F)
										bright=1.0F;
									else
										bright=0.0F;
								}

								if(opt.bReverse)
									cy = 480 - TIMEBASE/4 - cy; // Reverse

								// 6-Arrow
								// [DDR:1P (,_,,,^,) = (11,12,13,14,15,16)]
								int of = obj[i].iChannel-51;
								dd.BlendBlt(spNum+of, x1+spX*of, cy, bright);
							}
						}

	//				default:
	//					break;
					}

				}//endof if(!opt.bAllow6)
				
//			}

		}//endof if(obj[i].bDraw && opt.iBlind!=BL_STEALTH)
	}

	// ݓłorNGɂȂt[YA[
	for(i=0;i<20;i++)
	{
		if(opt.iBlind==BL_STEALTH)
			break; // n܂Ƃbreak(

		if(pd.f_Arrow[i].start==-1.0)
			continue;

		int sy;
		int spNum, spNum6;

		if(pd.f_Arrow[i].fail==-1.0)
		{
			// ΂Ă
			sy = int(pd.f_Arrow[i].start - iPixNow);

			// pd.f_Arrow[i].start̓t[YA[̊JnʒuA
			// TIMEBASE/16̔{ɂKv͂ȂB
			// ނ{ɂƊJnʒu16PʂŁA16PʂłȂꍇ̕\

			if(IsDDR() && pd.f_Arrow[i].pushed)
			{
				// ςȂ
				SetLight(i+10, LC_PERFECT);
			}

			if(pd.f_Arrow[i].pushNow)
			{
				// ̐FŒ(
				spNum  = 1255;
				spNum6 = 1290;
			}
			else
			{
				// ̐FŒ(D
				spNum  = 1260;
				spNum6 = 1300;
			}
		}
		else
		{
			// s
			// \Jnʒu(TIMEBASE/16)̔{ɍ킹ȂƏIʒuČ
			sy = int(pd.f_Arrow[i].fail);
			int num = sy / (TIMEBASE/16);
			int mod = sy % (TIMEBASE/16);

			sy = num * (TIMEBASE/16);
			if(mod != 0) sy += (TIMEBASE/16);

			sy = sy - iPixNow;

			// ̐FŒ(D
			spNum  = 1260;
			spNum6 = 1300;
		}

		int ey = (int)ceil(pd.f_Arrow[i].end - iPixNow); // ؂グƂȂƏIʒu̖󂪂PH
		int dy = TIMEBASE/16;

		for(int y=sy;y<=ey;y+=dy)
		{
			if(pd.f_Arrow[i].fail==-1.0 && pd.f_Arrow[i].pushed && y<0)
			{
				// ݂ÂĂȂ画胉CO͕`悵Ȃ
				continue;
			}
			
			float bright = 1.0F;
			int cy = CalcObjYDDR(y);

			if(opt.iBlind==BL_HIDDEN)
				bright = float((cy-PLAYAREA_Y)-TIMEBASE*0.33)/150.0F;

			if(opt.iBlind==BL_SUDDEN)
				bright = float(TIMEBASE*0.75-(cy-PLAYAREA_Y))/150.0F;

			if(opt.iEffect<=GE_MID){
				if(bright>=0.5F)
					bright=1.0F;
				else
					bright=0.0F;
			}

			if(opt.bReverse)
				cy = 480 - TIMEBASE/4 - cy; // Reverse

			if(!opt.bAllow6)
			{
				// 4-Arrow
				switch(i+50)
				{
		//		[DDR:1P (,,,) = (11,13,15,16) (_, ^) = (12,14)]
		//		0-3: ,,, (_, ^) = (19,20)
		//		[DDR:2P (,,,) = (21,23,25,26) (_, ^) = (22,24)]
				case 51: case 53: case 55: case 56:
					{
						//            10 11  12 13  14 15 16
						int tbl[] = { -1, 0, -1, 1, -1, 2, 3 };
						int of = tbl[i];
						dd.BlendBlt(spNum+of, x1 + spX*of, cy, bright);
						break;
					}

				case 61: case 63: case 65: case 66:
					{
						//            20 21  22 23  24 25 26
						int tbl[] = { -1, 0, -1, 1, -1, 2, 3 };
						int of = tbl[i-10];
						dd.BlendBlt(spNum+of, x2 + spX*of, cy, bright);
						break;
					}
				}
			}
			else
			{
				// 6-Arrow
				if(IN(i, 1, 6))
				{
					x1 = PLAYAREA_X_6;
					int spX = dd.GetSpriteX(0);
					dd.BlendBlt(spNum6+(i-1), x1 + spX*(i-1), cy, bright);
				}
			}//endof if(!opt.bAllow6)

		} // endof while(1)
	}


	if(bDebug)
	{
//		int y;//   - pd.Gap; // `悷W
//		int y2 = pd.endPix;// - pd.Gap;
//		int bar = y/g_TimeBase;			// ݂̏ߔԍ

		int x = PLAYAREA_1P_X;
		int dx = dd.GetSpriteX(0)*4; // 

		if(IsDouble())
		{
			x = PLAYAREA_DP_X;
			dx = dd.GetSpriteX(0)*8;
		}

		if(IsCouple())
		{
			x = PLAYAREA_1P_X;
			dx = (PLAYAREA_2P_X + dd.GetSpriteX(0)*4) - PLAYAREA_1P_X;
		}

		if(opt.bAllow6)
		{
			x = PLAYAREA_X_6;
			dx = dd.GetSpriteX(0)*6;
		}

		LPDIRECTDRAWSURFACE lpBB = dd.GetLpBackBuff();
		HDC hDC;
		if(lpBB->GetDC(&hDC) == DD_OK)
		{
			HPEN hPen    = ::CreatePen(PS_SOLID,1,RGB(255,255,255));
			HPEN hOldPen = (HPEN)::SelectObject(hDC,hPen);
			for(int i=g_OBJScanMin;i<pd.totalObj;i++)
			{
				int y = int(obj[i].dPixel)-iPixNow2;
				y = CalcObjYDDR(y);

				// ʊO̊֌WȂƂɗ烋[v
				if(y>480)
					break;

				if(opt.bReverse)
					y = 480 - TIMEBASE/4 - y + dd.GetSpriteY(0); // Reverse

				if(obj[i].iChannel == 2 && 0<=y && y <= SCR_H)
				{
					::MoveToEx(hDC, x   , y ,NULL);
					::LineTo(  hDC, x+dx, y );
				}
			}
			::SelectObject(hDC,hOldPen);
			::DeleteObject(hPen);
			lpBB->ReleaseDC(hDC);
		}

/*		for(i=bar-1;i<bar+3;i++)
		{
			if(i>=0)
			{
				char szTxt[50];
				sprintf(szTxt,"%d",i);
				dd.DrawText(PLAYAREA_1P_X+256, PLAYAREA_Y+(i*g_TimeBase)-y-8,szTxt);
			}
		}*/
	}//endof if(bDebug)

	// XRA`
	char szScore[50];
	sprintf(szScore,"%9d",pd.iScoreCount[0]);
	DrawDigit(70, SCORE_1P_X, SCORE_Y, szScore);

	sprintf(szScore,"%9d",pd.iScoreCount[1]);
	DrawDigit(70, SCORE_2P_X, SCORE_Y, szScore);

	// AR{`
	if(IsDDR())
		DrawJudge();

	// Q[W`
	if(g_bClub)
	{
		DrawGaugeClub(GAUGE_1P_X,GAUGE_Y,(int)pd.dHP[0],(int)pd.dClubHP[0]);

		if(IsCouple() && !opt.bAllow6)
			DrawGaugeClub(GAUGE_2P_X,GAUGE_Y,(int)pd.dHP[1],(int)pd.dClubHP[1]);
	}
	else
	{
		DrawGauge(GAUGE_1P_X,GAUGE_Y,(int)pd.dHP[0]);

		if(IsCouple() && !opt.bAllow6)
			DrawGauge(GAUGE_2P_X,GAUGE_Y,(int)pd.dHP[1]);
	}

	DrawMode();

}

void AutoPlay(DWORD timeNow){

	double PixNow = SetPixNow(timeNow);

	if(timeNow > pd.restartTime)
	{
		// V[PX~畜A
		pd.BPM = pd.oldBPM;
		pd.DpMS = pd.BPM * double(g_TimeBase) / 240000.0;	// 1msPixel

		// ]vɎ~܂Ă␳
		g_dPixNow += double(timeNow-pd.restartTime) * pd.DpMS;
		pd.stopTime = pd.restartTime = NOT_STOPED;

		// STOP̃t[YA[̂SɎgϐZbg
		for(int i=0;i<20;i++)
		{
			pd.f_Arrow[i].nextJudgeInSTOP = -1.0;
		}
	}

	// t[YA[
	{
		for(int i=0;i<20;i++)
		{
			// ݃`FbNJudge()ɂ

			// Im
			if(pd.f_Arrow[i].end<=PixNow)
			{
				if(pd.f_Arrow[i].fail==-1.0 && pd.f_Arrow[i].pushed==TRUE)
				{
					// OK!
					pd.f_Arrow[i].start = pd.f_Arrow[i].end = pd.f_Arrow[i].fail = -1.0;
					pd.f_Arrow[i].pushed = FALSE;

					int pl = IsDouble() ? 0 : i/10; // DoubleȂ1PɉZ
					result[pl].ok++;

					// `Doubleł2P
					result[i/10].isOK[i%10] = TRUE;
					result[i/10].dispTimeOK[i%10] = JUDGE_DISPTIME;
				}
				else
				{
					// ʊOɏoWXƏI
					if(pd.f_Arrow[i].end<=PixNow-(PLAYAREA_Y+dd.GetSpriteY(0)))
					{
						pd.f_Arrow[i].start = pd.f_Arrow[i].end = pd.f_Arrow[i].fail = -1.0;
						pd.f_Arrow[i].pushed = FALSE;
					}
				}
			}

			// SƂɓł邩`FbNBSTOPSTOPOBPMɊÂēl̃`FbN
			BOOL bNG = FALSE;
			if(pd.restartTime!=NOT_STOPED)
			{
				// STOP
				double oldDpMS = pd.oldBPM * double(g_TimeBase) / 240000.0;
				double stoppedPix = (g_lpPlayTime->Get() - pd.stopTime)*oldDpMS; // STOP
				double dx = (JUDGE_PERFECT_MS*pd.rank)*oldDpMS;

				bNG = pd.f_Arrow[i].nextJudgeInSTOP+dx < PixNow+stoppedPix;
			}
			else
			{
				// ʏ
				double dx = (JUDGE_PERFECT_MS*pd.rank)*pd.DpMS;
				bNG = pd.f_Arrow[i].nextJudge+dx < PixNow;
			}

			if(bNG && pd.f_Arrow[i].fail==-1.0 && pd.f_Arrow[i].pushed==TRUE)
			{
				// S𓥂܂ɒʂ߂
				assert(pd.f_Arrow[i].nextJudgeInSTOP!=-1.0 || pd.restartTime==NOT_STOPED);

				pd.f_Arrow[i].fail = PixNow;
				pd.f_Arrow[i].pushed = FALSE;

				int pl = IsDouble() ? 0 : i/10; // DoubleȂ1PɉZ
				result[pl].ng++;
				pd.dHP[pl]-=2.0;

				// `Doubleł2P
				result[i/10].isOK[i%10] = FALSE;
				result[i/10].dispTimeOK[i%10] = JUDGE_DISPTIME;
			}

		}
	}

	// g_OBJScanMin𑝂₵Ă󋵂
	BOOL canIncOSM = TRUE;

	for(int i=g_OBJScanMin;i<pd.totalObj;i++)
	{
		if(pd.restartTime!=NOT_STOPED)
			canIncOSM = FALSE; // /pd.DpMSɂOZ(doubleƗOoȂȂ)

		if(IsDDR())
		{
			// ֌WȂƂO
			if(CalcObjYDDR(int(obj[i].dPixel-PixNow)) >= 480)
				break;
		}
		else if(IsBM())
		{
			// ֌WȂƂO
			if(obj[i].dPixel > PixNow)
				break;
		}

		if(canIncOSM)
		{
			assert(pd.DpMS != 0.0);

			if(IsDDR())
			{
				double pos1 = -(PLAYAREA_Y+dd.GetSpriteY(0))/pd.DpMS; // ȉȂʊO
				double pos2 = -JUDGE_MISS_MS*2;						  // ȉȂMISSO

				// 2̂A̗p
				double pos = pos1<pos2 ? pos1 : pos2;

				if(IsLongNote(obj[i].iChannel))
				{
					double objpos = obj[i].dPixel + obj[i].dLength - PixNow;

					if(objpos/pd.DpMS < pos)
						g_OBJScanMin = i+1;
					else
					{
						// ܂ʊOɍsĂȂA̒ʏIuWFg_OBJScanMinȂ悤
						// i   : |--------------| (Om[g)
						// i+1 :        |         (ʏIuWF)
						// Ƃ󋵂
						canIncOSM = FALSE;
					}
				}
				else
				{
					double objpos = obj[i].dPixel - PixNow;

					if(objpos/pd.DpMS < pos)
						g_OBJScanMin = i+1;
				}
			}

			if(IsBM())
			{
				if( (obj[i].dPixel-PixNow)/pd.DpMS < -JUDGE_MISS_MS*2.0) // *2ȂƌPooroȂȂ
					g_OBJScanMin = i+1;
			}
		}

		if(obj[i].dPixel <= PixNow && !obj[i].bIsPlayed)
		{
			if(obj[i].bAutoPlay || obj[i].iChannel == 1) // obNR[Xt
			{
				obj[i].bIsPlayed = TRUE;
				ds.Play(obj[i].iWaveCh);
			}

			if(obj[i].iChannel == 2) // ߐ
			{
				obj[i].bIsPlayed = TRUE;
				pd.iBarNow  = i;
				pd.iBarNext = i; // ݂Ȃ瓯ԍ

				for(int j=i+1;j<pd.totalObj;j++)
				{
					if(obj[j].iChannel == 2) // ̏ߐ
					{
						pd.iBarNext = j;
						break;
					}
				}
			}

// #define PS2_AUTOPLAY

			if(pd.bAutoPlay[0] && (Is1PNote(obj[i].iChannel)||Is1PLongNote(obj[i].iChannel))) // I[gvC1P
			{
				obj[i].bIsPlayed = TRUE;
//				obj[i].bJudge    = FALSE;

				if(Is1PNote(obj[i].iChannel))
					obj[i].bDraw = FALSE; // Om[g͏Ȃ悤ɂ

				ds.Play(obj[i].iWaveCh);

#ifdef PS2_AUTOPLAY
				// PS2IAutoPlay
				SetJudge(PERFECT,FALSE);
				SetLight(obj[i].iChannel, LC_PERFECT);
				obj[i].bDraw = FALSE;
				obj[i].bJudge = FALSE;
#endif
			}

			if(pd.bAutoPlay[1] && (Is2PNote(obj[i].iChannel)||Is2PLongNote(obj[i].iChannel))) // I[gvC2P
			{
				obj[i].bIsPlayed = TRUE;
//				obj[i].bJudge    = FALSE;

				if(Is2PNote(obj[i].iChannel))
					obj[i].bDraw = FALSE; // Om[g͏Ȃ悤ɂ

				ds.Play(obj[i].iWaveCh);

#ifdef PS2_AUTOPLAY
				// PS2IAutoPlay
				SetJudge(PERFECT,TRUE);
				SetLight(obj[i].iChannel, LC_PERFECT);
				obj[i].bDraw = FALSE;
				obj[i].bJudge = FALSE;
#endif
			}

			if( Is1pAutoSc() && (obj[i].iChannel==16) ) // I[gSc1P
			{
				obj[i].bIsPlayed = TRUE;
//				obj[i].bJudge    = FALSE;
				obj[i].bDraw	 = FALSE;
				ds.Play(obj[i].iWaveCh);

#ifdef PS2_AUTOPLAY
				// PS2IAutoPlay
				SetJudge(PERFECT,TRUE);
				SetLight(obj[i].iChannel, LC_PERFECT);
				obj[i].bDraw = FALSE;
				obj[i].bJudge = FALSE;
#endif
			}

			if( Is2pAutoSc() && (obj[i].iChannel==26) ) //I[gSc2P
			{
				obj[i].bIsPlayed = TRUE;
//				obj[i].bJudge    = FALSE;
				obj[i].bDraw	 = FALSE;
				ds.Play(obj[i].iWaveCh);

#ifdef PS2_AUTOPLAY
				// PS2IAutoPlay
				SetJudge(PERFECT,TRUE);
				SetLight(obj[i].iChannel, LC_PERFECT);
				obj[i].bDraw = FALSE;
				obj[i].bJudge = FALSE;
#endif
			}

			// e|`FW
			// RpCCh08̊gBPM߂Ch03Ɉړ
			if(obj[i].iChannel == 3)
			{
				obj[i].bIsPlayed = TRUE;

				if(opt.iAutoTempoChange)
					pd.BPM = (double)obj[i].iBPM * pd.tempoUP2/100.0;
				else
					pd.BPM = (double)obj[i].iBPM * CalcTempo(pd.tempoUP, opt.bTCMusical)/ 100.0;

				pd.DpMS = pd.BPM * double(g_TimeBase) / 240000.0;	// 1msPixel
			}

			if(obj[i].iChannel == 4) // BGA`FW
			{
				// ݂BMPύX
				pd.iBMPObj = i;
				obj[i].bIsPlayed = TRUE;
			}

			if(obj[i].iChannel == 7) // Layer`FW
			{
				// ݂LayerύX
				pd.iBMPLayObj = i;
				obj[i].bIsPlayed = TRUE;
			}

			if(obj[i].iChannel == 6) // POOR-ANIME`FW
			{
				obj[i].bIsPlayed = TRUE;
				pd.iPoorAnimeObj = i;
			}

			if(obj[i].iChannel == CH_STOP && obj[i].dLength>0.0) // V[PX~
			{
				obj[i].bIsPlayed = TRUE;
				double offset = (PixNow-obj[i].dPixel)/pd.DpMS;
				g_dPixNow -= (PixNow-obj[i].dPixel); // ɒʂ߂߂Ă

//				g_lpPlayTime->AdjustTime(-offset);
//				g_BeforeTime = g_lpPlayTime->Get(); //-= offset;

				pd.stopTime = DWORD(g_lpPlayTime->Get() - offset);
				pd.restartTime = DWORD(g_lpPlayTime->Get() + obj[i].dLength/pd.DpMS - offset);
				pd.oldBPM = pd.BPM;
				pd.DpMS = pd.BPM = 0.0;

//				WriteLog("OFFSET : %lu ms", offset);

				for(int j=0;j<20;j++)
					pd.f_Arrow[j].nextJudgeInSTOP = pd.f_Arrow[j].nextJudge;
			}
		}
	
	}

}

// #BGAxx̕`
void BMSA_DrawBGA(int animeObj, int px, int py, BOOL bLayer)
{
	int i = animeObj;

	// gAj(BGA)
	int num = obj[i].bmp.num+100;
	int x = obj[i].bmp.x;
	int y = obj[i].bmp.y;
	int tx = obj[i].bmp.tx + 1; // BM98ł(tx,ty)`͈͂Ɋ܂܂
	int ty = obj[i].bmp.ty + 1;
	int ox = obj[i].bmp.ox;
	int oy = obj[i].bmp.oy;

	int w = dd.GetBMPX(num);
	int h = dd.GetBMPY(num);

	if(x>tx || y>ty || x>=w || y>=h)
	{
		// sȒl
		return;
	}
	else
	{
		// NbsO݂
		if(tx>w) tx = w;
		if(ty>h) ty = h;

		if(x<0) x=0;
		if(y<0) y=0;

		// ̒l
		if(ox<0) x+=(-ox), ox=0;
		if(oy<0) y+=(-oy), oy=0;

		dd.DefSprite(1200, num, x, y, tx, ty);
		dd.DrawSprite(1200, px+ox, py+oy, 1.0, bLayer); // LayerȂ瓧
	}
}

// BM[hBMSA#BMP/#BGAʂĕ`
// x,y͕`_BBMP̍
void BMSA_BM(int animeObj, int x, int y, BOOL bLayer)
{
	int i = animeObj;
	if(obj[i].bmp.num==-1)
	{
		// ʏAj
		int dx = (256 - dd.GetBMPX(obj[i].iBMPCh))/2;
		dd.DrawSprite(obj[i].iBMPCh, x+dx, y, 1.0, bLayer);
	}
	else
	{
		// gAj(BGA)
		BMSA_DrawBGA(i, x, y, bLayer);
	}
}

// DDR[hBMSA#BMP/#BGAʂĕ`
// x,y͕`_B̓Z^ÔBMP̒S
void BMSA_DDR(int animeObj, int x, int y, BOOL bLayer)
{
	int i = animeObj;
	if(obj[i].bmp.num==-1)
	{
		// ʏAj
		int sx = x - dd.GetBMPX(obj[i].iBMPCh)/2;
		int sy = y - dd.GetBMPY(obj[i].iBMPCh)/2;
		dd.DrawSprite(obj[i].iBMPCh, sx, sy, 1.0, bLayer);
	}
	else
	{
		// gAj(BGA)
		int sx = x - 256/2;
		int sy = y - 256/2;
		BMSA_DrawBGA(i, sx, sy, bLayer);
	}
}

void BMSA(DWORD timeNow){

	if(opt.bBgAnime)
	{
		if(pd.bgBMPNum!=-1)
			dd.DrawSprite(pd.bgBMPNum,0,0,1); //BG-BMP
	}

	if(!opt.bBMSA)
		return;

	if(IsBM())
	{
		int x = BMSA_BM_X; // BMP̍w
		int y = BMSA_BM_Y;

		if(pd.iPoorTime>0)
		{
			pd.iPoorTime--;

			if(pd.iPoorAnimeObj==-1)
			{
				// #BMP00POORAj
				int dx = (256 - dd.GetBMPX(100))/2;
				dd.DrawSprite(100, x+dx, y, 1.0, FALSE);
			}
			else
			{
				// #BMPxx or #BGAxxPOORAj
				BMSA_BM(pd.iPoorAnimeObj, x, y, FALSE);
			}

			return;
		}

		if(pd.iBMPObj!=-1)
		{
			// BGA
			BMSA_BM(pd.iBMPObj, x, y, FALSE);
		}

		if(pd.iBMPLayObj!=-1)
		{
			// C[Aj
			BMSA_BM(pd.iBMPLayObj, x, y, TRUE);
		}
	}
	else // DDR
	{
		int x = SCR_W/2; // Z^ÔBMP̒S_w
		int y = SCR_H/2;

		if(pd.iPoorTime>0)
		{
			pd.iPoorTime--;

			if(pd.iPoorAnimeObj==-1)
			{
				// #BMP00POORAj
				int sx = x - dd.GetBMPX(100)/2;
				int sy = y - dd.GetBMPY(100)/2;
				dd.DrawSprite(100, sx, sy, 1.0, FALSE);
			}
			else
			{
				// #BMPxx or #BGAxxPOORAj
				BMSA_DDR(pd.iPoorAnimeObj, x, y, FALSE);
			}

			return;
		}

		if(pd.iBMPObj!=-1)
		{
			// BGA
			BMSA_DDR(pd.iBMPObj, x, y, FALSE);
		}

		if(pd.iBMPLayObj!=-1)
		{
			// C[Aj
			BMSA_DDR(pd.iBMPLayObj, x, y, TRUE);
		}
	}
}

void DrawMode(void){

	int x=285;
	int y=350;
	int yInc=25;

	int count=2;
	count += (opt.iBlind   != 0	? 1 : 0);
	count += (opt.iNArrange!= 0	? 1 : 0);
	count += (opt.iLittle  != 0	? 1 : 0);
	count += (opt.bFlat			? 1 : 0);

	if(count>4)
		yInc=20;

	// DP&6AlloŵƂSINGLE DOUBLEƂoႤŔr
	if(IsSingle())
		dd.DrawSprite(90,x,y), y+=yInc;
	else
	{
		if(IsDouble())
			dd.DrawSprite(91,x,y), y+=yInc;
		if(IsCouple())
			dd.DrawSprite(92,x,y), y+=yInc;
	}

	if(IsBasic())
		dd.DrawSprite(94,x,y), y+=yInc;
	if(IsAnother())
		dd.DrawSprite(95,x,y), y+=yInc;
	if(IsManiac())
		dd.DrawSprite(96,x,y), y+=yInc;


	if(opt.iBlind==BL_HIDDEN)
		dd.DrawSprite(360,x,y), y+=yInc;
	if(opt.iBlind==BL_SUDDEN)
		dd.DrawSprite(361,x,y), y+=yInc;
	if(opt.iBlind==BL_STEALTH)
		dd.DrawSprite(362,x,y), y+=yInc;

	if(opt.iNArrange==NA_SHUFFLE || opt.iNArrange==NA_LINESHUFFLE)
		dd.DrawSprite(363,x,y), y+=yInc;
	if(opt.iNArrange==NA_MIRROR)
		dd.DrawSprite(364,x,y), y+=yInc;

	if(opt.iLittle==LT_LITTLE)
		dd.DrawSprite(365,x,y), y+=yInc;
	if(opt.iLittle==LT_MINIMUM)
		dd.DrawSprite(366,x,y), y+=yInc;

	if(opt.bFlat)
		dd.DrawSprite(367,x,y), y+=yInc;

}

int GameMain(int nCount){

	static BOOL bBgmPlaying = FALSE;
	static BOOL bDoorOpen	= FALSE;
	static BOOL bClose		= FALSE;
	static int iFailed		= 1; //0:None 1:Cleared 2:Failed
	static CTimer	g_PlayTime; // ȍĐ^C}[
	g_lpPlayTime = &g_PlayTime;

	static int oldTempo; // ɑȂVXe

	SCENE_INIT{

/*		// pbgݒ  SelectMusicłĂ
		if(IN(opt.iMode,MD_BM_4,MD_BM_7))
		{
			dd.LoadPalette("Image\\pal_bm.bmp");
		}
		else
		{
			dd.LoadPalette("Image\\pal_ddr.bmp");
		}
*/
		// BMSA,BGɂSysRAMɍsĂ炨B
		// XvCgVRAMɏ悹̂
		if(IsDDR())
			AllocVRAM(1024); // Ȃ葽߁BBMP̂̂650KB傢B
		
		if(IsBM())
			AllocVRAM(1024); // Ȃ葽߁BBMP̂̂650KB傢B

		if(IsDDR())
		{
			int mem;
			if(opt.iBlind==BL_HIDDEN || opt.iBlind==BL_SUDDEN)
				mem = LOAD_RAM;
			else
				mem = LOAD_DEFAULT;

			LoadDDRBMP(mem);

		}// endof if(IsDDR())

		if(IsBM())
		{
			LoadBMBMP(LOAD_DEFAULT);//mem);
		}

//		LOAD_BMP(2, "Image\\Door.bmp");

		LOAD_BMP(12, "Image\\Cleared.bmp");
		LOAD_BMP(13, "Image\\Failed.bmp");

		DefSprite();

		// XvCg͓ǂ񂾁B
		// \ȌVRAMցI
		for(int i=100;i<=355;i++)
			dd.MoveTo(i,TRUE);

		dd.MoveTo(32, TRUE);
		dd.MoveTo(33, TRUE);

		bPaused = FALSE;
		g_PlayTime.Restart();
		g_PlayTime.Reset();

		oldTempo = 100;

		if(g_EventMode)
		{
			PauseSequence(SEQ_PAUSE);
			g_BeforeTime = 0;
			g_dPixNow    = (double)pd.Gap;
		}

		// Auto AutoPlayBGƉ
		if(opt.iAutoPlay==4)
		{
			pd.bAutoPlay[0] = TRUE;
			pd.bAutoPlay[1] = TRUE;
		}

	}

	SCENE_TERM{

		if(IsDDR())
		{
			dd.UnLoadBMP(0);
			dd.UnLoadBMP(1);
			dd.UnLoadBMP(3);
			dd.UnLoadBMP(4);
			dd.UnLoadBMP(5);
			dd.UnLoadBMP(6);
			dd.UnLoadBMP(7);
			dd.UnLoadBMP(10);
			dd.UnLoadBMP(14);
			dd.UnLoadBMP(15);
			dd.UnLoadBMP(21);
			dd.ReleaseStretchInstanceAll();
		}

		if(IsBM())
		{
			for(int i=40;i<=56;i++)
				dd.UnLoadBMP(i);

			dd.UnLoadBMP(47);
			dd.UnLoadBMP(62);
			dd.UnLoadBMP(63);
		}

		dd.UnLoadBMP(2);
		dd.UnLoadBMP(12);
		dd.UnLoadBMP(13);
		dd.UnLoadBMP(80);

		// BMSA,BGɂSysRAMɍsĂ炨B
		// XvCgVRAMɏ悹̂
		if(IsDDR())
			AllocVRAM(2300); // ۂ187.5kb(Result) & 600kb(SelMus)

		if(IsBM())
			AllocVRAM(2300); // 254kb(ResultBM) & 600kb(SelMus)

		return 0; //@l̓_~[
	}

	// main

	if(!IsCouple() && g_bClub)
	{
		pd.dHP[1]     = pd.dHP[0];	// ߂ǂ痼ȂɂƂ
		pd.bFailed[1] = TRUE;
		pd.bAlive[1]  = FALSE;
	}

	if(!bBgmPlaying && !bPaused)
	{
		if(g_bClub)
		{
			dd.SyncScreen();
			dd.FillRect(0, 460, 640, 480); // ʉ̑т

			int length = Messages.Get("WaitingForReady").size();
			dd.DrawText(640-8-8*length, 462, Messages.Get("WaitingForReady").c_str());

			dd.Flip();

			if(dp.GetMode()==CONNECT_SERVER)
			{
//				dp.Send(0,MES_GAMESTART);

				static CTimer interval; // staticOȂƁBȂ܂Ƃɓ삵ȂȂ
				BOOL res = FALSE;
				while(!KEYPUSH(VK_ESC) && !res)
				{
					res = dp.WaitMessage(MES_GAMESTART_OK,0);
					GetKeyInfo();

					if(interval.Get()>1000)
					{
						dp.Send(0,MES_GAMESTART);
						interval.Reset();
					}
				}
			}
			else
			{
				BOOL res = FALSE;
				while(!KEYPUSH(VK_ESC) && !res)
				{
					res = dp.WaitMessage(MES_GAMESTART, 0);
					GetKeyInfo();
				}

				dp.Send(0,MES_GAMESTART_OK);
			}

			GetKeyInfo();

			// lM
			dp.Send(pd.dHP[0]   ,MES_1P_GAUGE ,TRUE);
			dp.Send(pd.dHP[1]   ,MES_2P_GAUGE ,TRUE);
			dp.Send(pd.bAlive[0],MES_1P_BALIVE,TRUE);
			dp.Send(pd.bAlive[1],MES_2P_BALIVE,TRUE);

		}

		if(pd.bMIDI)
			midi.PlayMIDI();

		if(pd.CDTr == -1)
		{
			cd.Stop();
			ds.Play(0);
		}
		else
		{
//			if(!cd.IsOpen())
//				cd.Open(szCDDr[opt.iCDDrNum]);

			if(cd.Play(pd.CDTr)!=0) // CDĐɎs
				ds.Play(0);
		}

		bBgmPlaying  = TRUE;
//		g_StartTime  = timeGetTime();

		g_PlayTime.Reset();

//		if(g_EventMode)
//			g_PlayTime.Restart();

		g_BeforeTime = 0;
		g_dPixNow    = (double)pd.Gap;

		if(opt.iAutoTempoChange==0)
		{
			// IvVBPMςƂ̃tH[
			pd.BPM = pd.BPM * CalcTempo(pd.tempoUP, opt.bTCMusical) / 100.0; // 
			pd.DpMS = pd.BPM * double(g_TimeBase) / 240000.0;	// 1msPixel

			// gύX
			if(pd.tempoUP==0)
			{
				ds.SetFreq(0, -1);
				for(int i=101;i<100+MAX_WAVNUM;i++)
					ds.SetFreq(i, -1);
			}
			else
			{
				ds.SetFreq(0, CalcTempo(pd.tempoUP, opt.bTCMusical));
				for(int i=101;i<100+MAX_WAVNUM;i++)
					ds.SetFreq(i,CalcTempo(pd.tempoUP, opt.bTCMusical));
			}
		}

		// IԌvZ
		double pix = 0; // SetPixNow(g_PlayTime.Get());
		double bpm = pd.BPM;
		pd.endms = g_PlayTime.Get();

		for(int i=0;i<pd.totalObj;i++)
		{
			if(obj[i].iChannel==3 && obj[i].dPixel>=pix)
			{
				double DpMS = bpm * double(g_TimeBase) / 240000.0;
				pd.endms += int((obj[i].dPixel-pix)/DpMS);
				pix = obj[i].dPixel;
				bpm = (double)obj[i].iBPM * CalcTempo(pd.tempoUP, opt.bTCMusical) / 100.0;
			}

			if(obj[i].iChannel==CH_STOP && obj[i].dPixel>=pix)
			{
				double DpMS = bpm * double(g_TimeBase) / 240000.0;
				pd.endms += DWORD(obj[i].dLength/DpMS);
			}

		}
		double DpMS = bpm * double(g_TimeBase) / 240000.0;
		pd.endms += int((pd.endPix-pix)/DpMS);
		pd.endms += int(-pd.Gap / pd.DpMS);

//		char szTxt[1024];
//		wsprintf(szTxt,"Start:%d",timeGetTime());
//		WriteLog(szTxt);
	}

	DWORD timeNow;

	if(opt.bSyncCD && cd.IsPlay())
	{
		cd.GetCurrentPos(timeNow);
		debug.timeNow = timeNow-=cd.m_dwSongStart[pd.CDTr]; // tgbNł̎Ԃ擾
	}
	else
		debug.timeNow = timeNow = g_PlayTime.Get();

	if(timeNow<0 || timeNow>3600000)
		timeNow=0;

	int iPixNow = (int)SetPixNow(timeNow);
	iPixNow = iPixNow<0 ? 0 : iPixNow;
	debug.iPixNow = iPixNow;

	int per = int(300.0 * (double(iPixNow)/double(pd.endPix)));
	if(IN(per,0,300))
	{
		pd.dHPRec[0][per] = pd.dHP[0];
		pd.dHPRec[1][per] = pd.dHP[1];
	}

	BMSA(timeNow);

	if(IsBM())
		DrawBMScreen(timeNow);

	if(IsDDR())
		DrawDDRScreen(timeNow);

	// XRAo^邩ǂ\
	if(!IsValidScore())
	{
		char* mes = "Score not saved";
		int width = lpGlobScene->DrawFont(0,0,mes,FONT_WHITE,FALSE);
		lpGlobScene->DrawFont(320-width/2, BM_Y+20, mes, FONT_WHITE);
	}

	// |[Y͔肾̃I[gvCȂ
	if(!bPaused)
	{
		Judge(timeNow);
		AutoPlay(timeNow);
	}

	if(!bDoorOpen && g_bDoorOpen && (bBgmPlaying||g_EventMode))
	{
//		if(!OpenDoor())
			bDoorOpen = TRUE;
	}

	double data;
	int type;

	if(dp.Receive(data,type))
	{
		switch(type)
		{
		case MES_1P_GAUGE  : pd.dClubHP[0] = data; break;
		case MES_2P_GAUGE  : pd.dClubHP[1] = data; break;
		case MES_GAUGEDOWN : pd.dHP[0]+=data; RANGE(pd.dHP[0],0.0,100.0);
							 pd.dHP[1]+=data; RANGE(pd.dHP[1],0.0,100.0); break;
		case MES_QUIT	   : bClose = TRUE; iFailed = (int)data; break;
		case MES_1P_BALIVE : pd.bAlive[0] = (BOOL)data; break;
		case MES_2P_BALIVE : pd.bAlive[1] = (BOOL)data; break;
		case SYS_DISCONNECT: bClose = TRUE; iFailed = 0; g_bClub=FALSE; break;
		}
	}

	BOOL bAlive = pd.bAlive[0] || pd.bAlive[1] || !pd.bFailed[0] || !pd.bFailed[1];
	if(!bAlive)
	{
		if(g_bClub)
		{
			dp.Send(2,MES_QUIT,TRUE);
		}
		bClose = TRUE;
		iFailed = 2;
	}

	if(KEYPUSH(VK_ESC))
	{
		// I`
		if(g_bClub)
		{
			dp.Send(0,MES_QUIT,TRUE);
		}

		bClose = TRUE;
		iFailed = 0;
	}

	// {[㉺
	if(KEYPUSH(VK_VOLDOWN))
	{
		pd.volrate-=10;
		if(pd.volrate<0) pd.volrate=0;
		SetVolume(DWORD(pd.vol * (double(pd.volrate)/100.0)));
	}

	if(KEYPUSH(VK_VOLUP))
	{
		pd.volrate+=10;
		SetVolume(DWORD(pd.vol * (double(pd.volrate)/100.0)));
	}

	// e|㉺
	if(KEYPUSH(VK_TEMPODOWN) && opt.iAutoTempoChange==0)
	{
		ScoreInfo.bTempoChanged = TRUE;
		int oldTempo = pd.tempoUP;

		pd.tempoUP--;
		if(CalcTempo(pd.tempoUP, opt.bTCMusical)<5.0) pd.tempoUP++;

		double dtRate = CalcTempo(pd.tempoUP, opt.bTCMusical) / CalcTempo(oldTempo, opt.bTCMusical);

		pd.BPM  = pd.BPM * dtRate; // 
		pd.DpMS = pd.BPM * double(g_TimeBase) / 240000.0;	// 1msPixel

		// gύX
		if(pd.tempoUP==0)
		{
			ds.SetFreq(0, -1);
			for(int i=101;i<100+MAX_WAVNUM;i++)
				ds.SetFreq(i, -1);
		}
		else
		{
			ds.SetFreq(0, CalcTempo(pd.tempoUP, opt.bTCMusical));
			for(int i=101;i<100+MAX_WAVNUM;i++)
				ds.SetFreq(i, CalcTempo(pd.tempoUP, opt.bTCMusical));
		}

		// IԌvZ
		double pix = SetPixNow(g_PlayTime.Get());
		double bpm;
		
		if(pd.restartTime==NOT_STOPED)
		{
			bpm = pd.BPM;
			pd.endms = g_PlayTime.Get();
		}
		else
		{
			DWORD stopLength = pd.restartTime-g_PlayTime.Get();
			stopLength = DWORD(stopLength * (1.0 / dtRate));
			pd.restartTime = g_PlayTime.Get() + stopLength;

			pd.oldBPM *= dtRate;
			bpm = pd.oldBPM;
			pd.endms = pd.restartTime;
		}

		for(int i=0;i<pd.totalObj;i++)
		{
			if(obj[i].iChannel==3 && !obj[i].bIsPlayed && obj[i].dPixel>=pix)
			{
				double DpMS = bpm * double(g_TimeBase) / 240000.0;
				pd.endms += int((obj[i].dPixel-pix)/DpMS);
				pix = obj[i].dPixel;
				bpm = (double)obj[i].iBPM * CalcTempo(pd.tempoUP, opt.bTCMusical) / 100.0;
			}

			if(obj[i].iChannel==CH_STOP && !obj[i].bIsPlayed && obj[i].dPixel>=pix)
			{
				double DpMS = bpm * double(g_TimeBase) / 240000.0;
				pd.endms += DWORD(obj[i].dLength/DpMS);
			}
		}
		double DpMS = bpm * double(g_TimeBase) / 240000.0;
		pd.endms += int((pd.endPix-pix)/DpMS);
		pd.endms -= pd.GapMS;

	}

	if(KEYPUSH(VK_TEMPOUP) && opt.iAutoTempoChange==0)
	{
		ScoreInfo.bTempoChanged = TRUE;
		int oldTempo = pd.tempoUP;

		pd.tempoUP++;
		if(CalcTempo(pd.tempoUP, opt.bTCMusical)>200.0) pd.tempoUP--;

		double dtRate = CalcTempo(pd.tempoUP, opt.bTCMusical) / CalcTempo(oldTempo, opt.bTCMusical);

		pd.BPM  = pd.BPM * dtRate; // 
		pd.DpMS = pd.BPM * double(g_TimeBase) / 240000.0;	// 1msPixel

		// gύX
		if(pd.tempoUP==0)
		{
			ds.SetFreq(0, -1);
			for(int i=101;i<100+MAX_WAVNUM;i++)
				ds.SetFreq(i, -1);
		}
		else
		{
			ds.SetFreq(0, CalcTempo(pd.tempoUP, opt.bTCMusical));
			for(int i=101;i<100+MAX_WAVNUM;i++)
				ds.SetFreq(i, CalcTempo(pd.tempoUP, opt.bTCMusical));
		}

		// IԌvZ
		double pix = SetPixNow(g_PlayTime.Get());
		double bpm;
		
		if(pd.restartTime==NOT_STOPED)
		{
			bpm = pd.BPM;
			pd.endms = g_PlayTime.Get();
		}
		else
		{
			DWORD stopLength = pd.restartTime-g_PlayTime.Get();
			stopLength = DWORD(stopLength * (1.0 / dtRate));
			pd.restartTime = g_PlayTime.Get() + stopLength;

			pd.oldBPM *= dtRate;
			bpm = pd.oldBPM;
			pd.endms = pd.restartTime;
		}

		for(int i=0;i<pd.totalObj;i++)
		{
			if(obj[i].iChannel==3 && !obj[i].bIsPlayed && obj[i].dPixel>pix)
			{
				double DpMS = bpm * double(g_TimeBase) / 240000.0;
				pd.endms += int((obj[i].dPixel-pix)/DpMS);
				pix = obj[i].dPixel;
				bpm = (double)obj[i].iBPM * CalcTempo(pd.tempoUP, opt.bTCMusical) / 100.0;
			}

			if(obj[i].iChannel==CH_STOP && !obj[i].bIsPlayed && obj[i].dPixel>=pix)
			{
				double DpMS = bpm * double(g_TimeBase) / 240000.0;
				pd.endms += DWORD(obj[i].dLength/DpMS);
			}
		}
		double DpMS = bpm * double(g_TimeBase) / 240000.0;
		pd.endms += int((pd.endPix-pix)/DpMS);
		pd.endms -= pd.GapMS;
	}

	// Ƀe|オVXe
//	static int oldTempo = 100; ֐̓Ɉړ
	int scale = opt.iAutoTempoChange==1 ? int(CalcTempo(pd.tempoUP, opt.bTCMusical))-100 : 0;
	// *1.01͋Ȃ̍Ō99%Ȃ100%ŏI悤ɂ邽߁BႾ߂
	int nowTempo = int(scale*pow(double(g_PlayTime.Get())*1.01/pd.endms,2.0));
	nowTempo+=100;
	if(scale<0 && nowTempo<scale+100) nowTempo=scale+100;
	if(scale>0 && nowTempo>scale+100) nowTempo=scale+100;

	if(scale<0 && nowTempo<=oldTempo || scale>0 && nowTempo>=oldTempo)
	{
		double dtRate = double(nowTempo) / double(oldTempo);
		pd.BPM  = pd.BPM * dtRate; // 
		pd.DpMS = pd.BPM * double(g_TimeBase) / 240000.0;	// 1msPixel

		oldTempo = nowTempo;
		pd.tempoUP2 = nowTempo;

		// gύX
		ds.SetFreq(0, nowTempo);
		for(int i=101;i<100+MAX_WAVNUM;i++)
			ds.SetFreq(i, nowTempo);

		// IԌvZ
		double pix = SetPixNow(g_PlayTime.Get());
		double bpm;
		
		if(pd.restartTime==NOT_STOPED)
		{
			bpm = pd.BPM;
			pd.endms = g_PlayTime.Get();
		}
		else
		{
			DWORD stopLength = pd.restartTime-g_PlayTime.Get();
			stopLength = DWORD(stopLength * (1.0 / dtRate));
			pd.restartTime = g_PlayTime.Get() + stopLength;

			pd.oldBPM *= dtRate;
			bpm = pd.oldBPM;
			pd.endms = pd.restartTime;
		}

		for(i=0;i<pd.totalObj;i++)
		{
			if(obj[i].iChannel==3 && !obj[i].bIsPlayed && obj[i].dPixel>pix)
			{
				double DpMS = bpm * double(g_TimeBase) / 240000.0;
				pd.endms += int((obj[i].dPixel-pix)/DpMS);
				pix = obj[i].dPixel;
				bpm = (double)obj[i].iBPM * nowTempo / 100.0;
			}

			if(obj[i].iChannel==CH_STOP && !obj[i].bIsPlayed && obj[i].dPixel>=pix)
			{
				double DpMS = bpm * double(g_TimeBase) / 240000.0;
				pd.endms += DWORD(obj[i].dLength/DpMS);
			}
		}
		double DpMS = bpm * double(g_TimeBase) / 240000.0;
		pd.endms += int((pd.endPix-pix)/DpMS);
		pd.endms -= pd.GapMS;
	}

	// |[YEĊJ
	if(KEYPUSH(VK_PLAYSTOP))
	{
		PauseSequence(SEQ_TOGGLE);
	}

	if(bPaused)
	{
		dd.DrawText(300,328,"Pause");
	}

	// pixnowCD-DAgpɏIȂƂ
	// ȏIMCĨ^C}[XgbvĂ܂̂
	// CD-SyncroLƂ̉e󂯂āAV[PX~܂
//	if(pd.endPix<iPixNow)
	if(g_PlayTime.Get()>pd.endms)
	{
		bClose = TRUE;
		if(IsDDR())
			iFailed = 1; // Cleared
		else
		if(int(pd.dHP[0])>=BM_BORDER || int(pd.dHP[1])>=BM_BORDER || g_bClub)
			iFailed = 1; // Cleared
		else
			iFailed = 2; // Failed
	}
	
	if(!g_bClub && pd.bFailed[0] && (IsSingle() || IsDouble()) && IsDDR() && opt.iLevel!=LEVEL_EASY)
		bClose = TRUE, iFailed = 2; // Failed

	if(!g_bClub && pd.dHP[0]==0 && pd.dHP[1]==0 && IsCouple() && IsDDR() && opt.iLevel!=LEVEL_EASY)
		bClose = TRUE, iFailed = 2; // Failed

//	char szTxt[1024];
//	wsprintf(szTxt,"iPix = %d",iPixNow);
//	WriteLog(szTxt);

	if(bClose)
	{
//		if(!CloseDoor())
		{
			// hA܂I܂
			ScoreInfo.playtime = g_PlayTime.Get(); // ۑ

			// hAJ؂ĂȂƎuŊJ炻
//			OpenDoor(DOOR_RESET);

//			if(iFailed==0) // rގ(

			if(iFailed==1)
				dd.DrawSprite(34, 320-dd.GetSpriteX(34)/2, 190); // Cleared
			if(iFailed==2)
				dd.DrawSprite(35, 320-dd.GetSpriteX(35)/2, 190); // Failed
			dd.Flip();

			// ESCŔA͕ȂBGM~߂
			if(g_PlayTime.Get()<pd.endms )
			{
				STOP_BGM();
			}

			bBgmPlaying = bDoorOpen = bClose = FALSE;

			// |[Y܂ESCƂÂ܂܂ŎȊJnResetTime()Ƃ܂ƂɂȂ
			if(bPaused)
			{
				// DirectSoundRestartȂ
				bPaused = FALSE;
				g_PlayTime.Restart();
			}

//			WriteLog("Volume Set");

			// 200000ɂȂ悤ɐ؂グ
//			pd.dBMScore[0] = ceil(pd.dBMScore[0]);
//			pd.dBMScore[1] = ceil(pd.dBMScore[1]);

			pd.eValu[0] = N;
			pd.eValu[1] = N;

			for(int i=0;i<2;i++)
			{
				
				if(i==0 || IsCouple())// || IsDouble())
				{
					double rate;
					if(pd.totalNote[i]!=0) // ꉞ0`FbN
						rate = double(result[i].perfect + result[i].great) / double(pd.totalNote[i]);
					else
						rate = 1.0;
					
					if(pd.bFailed[i])
						pd.eValu[i] = F;
					else
						if(iFailed==0)
							pd.eValu[i] = N;
						else
							if(result[i].maxCombo >= pd.totalNote[i]) // ꉞ ">="B vƎvEEE
								pd.eValu[i] = SS;
							else
								if(rate >= 0.95)
									pd.eValu[i] = S;
								else
									if(rate >= 0.9)
										pd.eValu[i] = A;
									else
										if(rate >= 0.8)
											pd.eValu[i] = B;
										else
											if(rate>=0.7)
												pd.eValu[i] = C;
											else
												pd.eValu[i] = D;
				}

			}

//			WriteLog("Rank Set");

			if(iFailed != 0)
				Sleep(1000); // ANȀ
			else
				Sleep(500); // ESC̏

			iFailed = 1;

//			WriteLog("Return to Result");
			DRAW_DOOR();	// hA̖h~

			return(SC1_RESULT);
		}

		if(iFailed==1)
			dd.DrawSprite(34, 320-dd.GetSpriteX(34)/2, 190); // Cleared
		if(iFailed==2)
			dd.DrawSprite(35, 320-dd.GetSpriteX(35)/2, 190); // Failed
	}

	if(opt.bFPS)
	{
		// vC / Ȏ
		char szTxt[100];
		DWORD time = g_PlayTime.Get();

		int endm = ms2min(pd.endms);
		int ends = ms2sec(pd.endms);

		if(ms2ms(pd.endms)>=500) // 500msȏ͐؂グ
		{
			ends++;
			if(ends>=60) // 60b𒴂番Ɉʏグ
				ends-=60, endm++;
		}

		if(endm>=10)
		{
			// 10ȏ
			wsprintf(szTxt,"%2d:%02d / %2d:%02d",ms2min(time),ms2sec(time),endm,ends);
		}
		else
		{
			// 10
			wsprintf(szTxt,"%1d:%02d / %1d:%02d",ms2min(time),ms2sec(time),endm,ends);
		}
		dd.DrawText(276,462,szTxt);

//		int w = lpGlobScene->DrawFont(0, 0, szTxt, FONT_WHITE, FALSE);
//		lpGlobScene->DrawFont(320-w/2, 473, szTxt, FONT_WHITE);

	}

	return(SC1_GAMEMAIN);

}

int Result(int nCount){

	static int res[2][9] = { 0,0,0,0,0,0,0,0,0,
							 0,0,0,0,0,0,0,0,0  };

	static BOOL bEnd = FALSE;
	static int timer = 60;

	double data;
	int type;

	if(g_bClub)
	{
		if(dp.Receive(data,type))
		{
			if(type==MES_EXITRESULT)
			{
				for(int i=0;i<2;i++)
				{
					for(int j=0;j<9;j++)
						res[i][j]=0;
				}

				bEnd = FALSE;
				timer = 60;

				// BGM~߂
				STOP_BGM();

				return SC1_SELMUSIC; // Select Music
			}
		}
	}

	if(IsBM())
		return (ResultBM(nCount));

	SCENE_INIT{

/*		if(dd.GetScreenColor()==8)
		{
			// pbgύX̐Fh~
			dd.ClearScreen();
			dd.Flip();
		}

		dd.LoadPalette("Image\\pal_result.bmp");
*/
//		LOAD_BMP( 2, "Image\\Door.bmp");
		LOAD_BMP( 6, "Image\\Judgment.bmp");
		LOAD_BMP( 8, "Image\\Total.bmp");
		LOAD_BMP( 9, "Image\\valuation.bmp");
		LOAD_BMP(10, "Image\\score.bmp");
		LOAD_BMP(11, "Image\\result.bmp");

		DefSprite();

		WriteScore();
		WriteScoreDB();

		if(pd.eValu[0]!=N && pd.eValu[0]!=F || pd.eValu[1]!=N && pd.eValu[1]!=F)
		{
			LoadSoundSet(SS_DDR_CLEARED);
			PlaySoundSet(SS_DDR_CLEARED);
		}
		else
		{
			LoadSoundSet(SS_DDR_FAILED);
			PlaySoundSet(SS_DDR_FAILED);
		}
	}

	SCENE_TERM{
		dd.UnLoadBMP(2);
		dd.UnLoadBMP(6);
		dd.UnLoadBMP(8);
		dd.UnLoadBMP(9);
		dd.UnLoadBMP(10);
		dd.UnLoadBMP(11);

		UnLoadSoundSet(SS_DDR_CLEARED);
		UnLoadSoundSet(SS_DDR_FAILED);

		SetVolume(pd.vol); // {[ɖ߂

		return 0; //@l̓_~[
	}

	DRAW_DOOR();	// hA`

	dd.DrawSprite(59,320-dd.GetSpriteX(59)/2,20); // "RESULT"̕

//	int num = (timeGetTime()/100)%3;
//	dd.DefSprite(51, 9,   num*100,   0, (num+1)*100, 100); // 51 : SS Aj܂
//	dd.DefSprite(52, 9,   num*100, 100, (num+1)*100, 200); // 52 : S  Aj܂

	char szScore[50];
	sprintf(szScore,"%9d",pd.iScore[0]);
	DrawDigit(70, SCORE_1P_X, SCORE_Y, szScore);

	sprintf(szScore,"%9d",pd.iScore[1]);
	DrawDigit(70, SCORE_2P_X, SCORE_Y, szScore);

	for(int i=0;i<2;i++)
	{
		for(int j=0;j<9;j++)
		{
			res[i][j]+=3;
		}
	}

	int iCheck = 0;
	for(i=0;i<2;i++)
	{
		if(res[i][0]>result[i].perfect){
			iCheck++;
			res[i][0]=result[i].perfect;
		}

		if(res[i][1]>result[i].great){
			iCheck++;
			res[i][1]=result[i].great;
		}

		if(res[i][2]>result[i].good){
			iCheck++;
			res[i][2]=result[i].good;
		}

		if(res[i][3]>result[i].boo){
			iCheck++;
			res[i][3]=result[i].boo;
		}

		if(res[i][4]>result[i].miss){
			iCheck++;
			res[i][4]=result[i].miss;
		}

		if(res[i][5]>result[i].ouch){
			iCheck++;
			res[i][5]=result[i].ouch;
		}

		if(res[i][6]>result[i].ok){
			iCheck++;
			res[i][6]=result[i].ok;
		}

		if(res[i][7]>result[i].ng){
			iCheck++;
			res[i][7]=result[i].ng;
		}

		if(res[i][8]>result[i].maxCombo){
			iCheck++;
			res[i][8]=result[i].maxCombo;
		}

	}

	if(iCheck==18)
		bEnd = TRUE;

	int spX25 = dd.GetSpriteX(25);
	int spY25 = dd.GetSpriteY(25);
	int spX60 = dd.GetSpriteX(60);

	const int TOP_Y = 80; // ԏ̍W

	int x = (SCR_W-spX25)/2;

	for(i=0;i<9;i++) // PerfectƂ
	{
		if(i!=5 || g_bOUCH) // OUCH͕Kvɉ
		{
			int y = TOP_Y+(spY25*i);

			if(IN(i,0,5))
				dd.DrawSprite(25+i, x, y);
			else if(IN(i,6,7))
				dd.DrawSprite(36+(i-6), x, y); // OK, NG
			else
				dd.DrawSprite(31, x, y+20); // MAXCOMBO͏
		}
	}

	for(i=0;i<2;i++)
	{
		x = (SCR_W-spX25)/2 - spX60*4;

		if(i==1)
			x = (SCR_W-spX25)/2 + spX25 + spX60;

		for(int j=0;j<9;j++)
		{
			if(j!=5 || g_bOUCH)
			{
				char szTxt[6];
				wsprintf(szTxt, "%3d", res[i][j]); // 

				int y = TOP_Y+(spY25*j);

				if(j==8)	// MAXCOMBO͏
					y+=20;

				DrawDigit(60, x, y, szTxt, TRUE);
			}
		}
	}

	if(bEnd)
	{
		// ]̕\

		if(opt.iEffect==GE_LOW)
			timer=10;

		static CTimer timer1;

		if(timer1.Get()>2000)	// ʂ̃V[炫Ƃ̑΍
		{
			timer1.Reset();
		}

		while(timer1.Get()>16)
		{
			if(timer>10)
				timer--;
			timer1.Adjust(-16);
		}

		dd.DrawSprite(51+pd.eValu[0],  10,300,double(timer)/10.0);

		if(IsCouple())
			dd.DrawSprite(51+pd.eValu[1], 530,300,double(timer)/10.0);

	}

//	GetKeyInfo();

	if(KEYPUSH(VK_ESC) || KEYPUSH(VK_OK))
	{
		if(bEnd)
		{
			for(int i=0;i<2;i++)
			{
				for(int j=0;j<9;j++)
					res[i][j]=0;
			}

			bEnd = FALSE;
			timer = 60;

			if(g_bClub)
				dp.Send(0.0,MES_EXITRESULT,TRUE);

			// BGM~߂
			STOP_BGM();

			return SC1_SELMUSIC; // Select Music
		}
		else
		{
			for(int i=0;i<2;i++) // JEgESCJEgXLbv
			{
				for(int j=0;j<9;j++)
				{
					res[i][j]=9999;
				}
			}
		}
	}

	return SC1_RESULT;
}

int ResultBM(int nCount){

	SCENE_INIT{

		if(dd.GetScreenColor()==8)
		{
			// pbgύX̐Fh~
			dd.ClearScreen();
			dd.Flip();
			dd.ClearScreen();
			dd.Flip();

			dd.LoadPalette("Image\\pal_resultBM.bmp");
			lpGlobScene->RemapPalette();
		}

		LOAD_BMP(57, "Image\\BM\\result-back.bmp");
		LOAD_BMP(58, "Image\\BM\\result-box.bmp");
		LOAD_BMP(59, "Image\\BM\\result-font.bmp");
		LOAD_BMP(60, "Image\\BM\\result-graph.bmp");
		LOAD_BMP(61, "Image\\BM\\result-point.bmp");

		DefSprite();

		WriteScore();
		WriteScoreDB();

		// {[_[zāAȂ̍Ō܂ł΃NA
		DWORD time = ScoreInfo.playtime;
		if(time>pd.endms) time = pd.endms;
		BOOL bClear1P = (int)pd.dHP[0]>=BM_BORDER && time==pd.endms;
		BOOL bClear2P = (int)pd.dHP[1]>=BM_BORDER && time==pd.endms;
		if(bClear1P || bClear2P)
		{
			LoadSoundSet(SS_BM_CLEARED);
			PlaySoundSet(SS_BM_CLEARED);
		}
		else
		{
			LoadSoundSet(SS_BM_FAILED);
			PlaySoundSet(SS_BM_FAILED);
		}

	}

	SCENE_TERM
	{

		dd.UnLoadBMP(57);
		dd.UnLoadBMP(58);
		dd.UnLoadBMP(59);
		dd.UnLoadBMP(60);
		dd.UnLoadBMP(61);

		UnLoadSoundSet(SS_BM_CLEARED);
		UnLoadSoundSet(SS_BM_FAILED);

		SetVolume(pd.vol); // {[ɖ߂

		return 0; //@l̓_~[
	}

	dd.DrawSprite(640,0,0);	// wi

	//Oẗ ] 1P(5,5) 2P(325,5)
	dd.DrawSprite(610,  5,5);
	dd.DrawSprite(610,325,5);

	static int counter = 0;

	for(int i=0;i<counter;i++)
	{
		if(i<300)
		{
			int y = 5+205-int(pd.dHPRec[0][i])*2-2;
			RANGE(y,5+5, 5+203);
			if(int(pd.dHPRec[0][i])>=BM_BORDER)
				dd.DrawSprite(641,5+5+i,y);
			else
				dd.DrawSprite(642,5+5+i,y);

			if(IsCouple())
			{
				int y = 5+205-int(pd.dHPRec[1][i])*2-2;
				RANGE(y,5+6, 5+203);
				if(int(pd.dHPRec[1][i])>=BM_BORDER)
					dd.DrawSprite(641,325+5+i,y);
				else
					dd.DrawSprite(642,325+5+i,y);
			}
		}
	}

	static CTimer timer;
	if(timer.Get()>2000)	// ʂ̋ȂƂ̑΍
		timer.Reset();

	while(timer.Get()>16)
	{
		counter+=3;
		timer.Adjust(-16);
	}

	static int res[2][6] = {0,0,0,0,0,0,
							0,0,0,0,0,0};

	static int iProg = 0;

	if(counter>300)
	{
		for(int i=0;i<2;i++)
		{
			for(int j=0;j<6;j++)
			{
				res[i][j]+=3;
			}
		}
	}

	int iCheck = 0;
	for(i=0;i<2;i++)
	{
		if(res[i][0]>result[i].perfect){
			iCheck++;
			res[i][0]=result[i].perfect;
		}

		if(res[i][1]>result[i].great){
			iCheck++;
			res[i][1]=result[i].great;
		}

		if(res[i][2]>result[i].good){
			iCheck++;
			res[i][2]=result[i].good;
		}

		if(res[i][3]>result[i].boo){
			iCheck++;
			res[i][3]=result[i].boo;
		}

		if(res[i][4]>result[i].miss+result[i].ouch){
			iCheck++;
			res[i][4]=result[i].miss+result[i].ouch;
		}

		if(res[i][5]>result[i].maxCombo){
			iCheck++;
			res[i][5]=result[i].maxCombo;
		}
	}

	if(iCheck==12 && iProg==0)
		iProg = 1;

	static int scTemp[2]={0,0},totScTemp[2]={0,0};

	if(iProg==1)
	{
		scTemp[0]+=(int)pd.dBMScore[0]/133;
		scTemp[1]+=(int)pd.dBMScore[1]/133;
		RANGE(scTemp[0],0,(int)pd.dBMScore[0]);
		RANGE(scTemp[1],0,(int)pd.dBMScore[1]);

		if(scTemp[0]==(int)pd.dBMScore[0] && scTemp[1]==(int)pd.dBMScore[1])
		{
			scTemp[0]	 = (int)pd.dBMScore[0];
			scTemp[1]	 = (int)pd.dBMScore[1];
			totScTemp[0] = 0;
			totScTemp[1] = 0;
			iProg=2;
		}
	}

	if(iProg==2)
	{
		scTemp[0]-=(int)pd.dBMScore[0]/133;
		scTemp[1]-=(int)pd.dBMScore[1]/133;
		RANGE(scTemp[0],0,(int)pd.dBMScore[0]);
		RANGE(scTemp[1],0,(int)pd.dBMScore[1]);
		totScTemp[0]+=(int)pd.dBMScore[0]/133;
		totScTemp[1]+=(int)pd.dBMScore[1]/133;
		RANGE(totScTemp[0],0,(int)pd.dBMScore[0]);
		RANGE(totScTemp[1],0,(int)pd.dBMScore[1]);

		if(totScTemp[0]==(int)pd.dBMScore[0] && totScTemp[1]==(int)pd.dBMScore[1])
		{
			scTemp[0]	 = 0;
			scTemp[1]	 = 0;
			totScTemp[0] = (int)pd.dBMScore[0];
			totScTemp[1] = (int)pd.dBMScore[1];
			iProg=3;
		}
	}

	//] 1P(20, 230) 2P(340,230):GREAT(sJO)
	int num = (timeGetTime()/100)%4;
	dd.DrawSprite(611+num, 20,230,1.0,FALSE); // sJOBOX Aj܂
	dd.DrawSprite(611+num,340,230,1.0,FALSE); // sJOBOX Aj܂

	char szTxt[16];
	int dx = 100-dd.GetSpriteX(630)*4, dy = 45-dd.GetSpriteY(630);

	wsprintf(szTxt, "%4d", res[0][0]); // 
	DrawDigit(630, 20+dx,230+dy, szTxt);
	wsprintf(szTxt, "%4d", res[1][0]); // 
	DrawDigit(630,340+dx,230+dy, szTxt);

	for(i=0;i<4;i++)
	{
		dd.DrawSprite(615+i, 20,280+i*50,1.0,FALSE); //GREAT,GOOD,BAD,POOR
		dd.DrawSprite(615+i,340,280+i*50,1.0,FALSE);

		wsprintf(szTxt, "%4d", res[0][i+1]); // 
		DrawDigit(630, 20+dx,280+i*50+dy, szTxt);
		wsprintf(szTxt, "%4d", res[1][i+1]); // 
		DrawDigit(630,340+dx,280+i*50+dy, szTxt);
	}

	dx = 150-dd.GetSpriteX(630)*4;
	dy = 40-dd.GetSpriteY(630);

	dd.DrawSprite(619,155,230,1.0,FALSE); //m[g1P
	dd.DrawSprite(619,475,230,1.0,FALSE); //m[g2P
	wsprintf(szTxt, "%4d", pd.totalNote[0]); // 
	DrawDigit(630,155+dx,230+dy, szTxt);
	wsprintf(szTxt, "%4d", pd.totalNote[1]); // 
	DrawDigit(630,475+dx,230+dy, szTxt);

	dd.DrawSprite(620,155,275,1.0,FALSE);
	dd.DrawSprite(620,475,275,1.0,FALSE); //l`wR{

	if(opt.iCombo!=CB_OFF)
	{
		wsprintf(szTxt, "%4d", result[0].maxCombo); // 
		DrawDigit(630,155+dx,275+dy, szTxt);
		wsprintf(szTxt, "%4d", result[1].maxCombo); // 
		DrawDigit(630,475+dx,275+dy, szTxt);
	}

	dx = 150-dd.GetSpriteX(630)*6;
	dy = 60-dd.GetSpriteY(630);

	dd.DrawSprite(621,155,350,1.0,FALSE);
	dd.DrawSprite(621,475,350,1.0,FALSE); //_iXe[Wj
	wsprintf(szTxt, "%6d", scTemp[0]); // 
	DrawDigit(630,155+dx,350+dy, szTxt);
	wsprintf(szTxt, "%6d", scTemp[1]); // 
	DrawDigit(630,475+dx,350+dy, szTxt);

	dd.DrawSprite(622,155,415,1.0,FALSE);
	dd.DrawSprite(622,475,415,1.0,FALSE); //_ig[^j
	wsprintf(szTxt, "%6d", totScTemp[0]); // 
	DrawDigit(630,155+dx,415+dy, szTxt);
	wsprintf(szTxt, "%6d", totScTemp[1]); // 
	DrawDigit(630,475+dx,415+dy, szTxt);

//	GetKeyInfo();

	BOOL keypAny = 0;
	for(i=0;i<7;i++)
	{
		keypAny |= (BOOL)KEYPUSH(VK_BM1P_1+i);
		keypAny |= (BOOL)KEYPUSH(VK_BM2P_1+i);
	}

	// Nu̓ÍAResult()łĂ̂őv
	if(KEYPUSH(VK_ESC) || KEYPUSH(VK_OK) || keypAny)
	{
		if(iProg==3)
		{
			for(int i=0;i<2;i++)
			{
				scTemp[i] = 0;
				totScTemp[i] = 0;

				for(int j=0;j<6;j++)
					res[i][j]=0;
			}

			counter=0;
			iProg=0;

			if(g_bClub)
				dp.Send(0.0,MES_EXITRESULT,TRUE);

			// BGM~߂
			STOP_BGM();
			return SC1_SELMUSIC; // Select Music
		}
		else
		{
			for(int i=0;i<2;i++) // JEgESCJEgXLbv
			{
				for(int j=0;j<6;j++)
				{
					res[i][j]=9999;
				}

				scTemp[i] = 0;
				totScTemp[i] = (int)pd.dBMScore[i];
			}
			counter=40000;
			iProg=3;
		}
	}

	return SC1_RESULT;
}

void InitObj(void){

	for(int i=0;i<MAX_OBJ;i++)
	{
		obj[i].bAutoPlay = FALSE;
		obj[i].bIsPlayed = FALSE;
		obj[i].bDraw	 = FALSE;
		obj[i].bJudge	 = FALSE;
//		obj[i].dsMS		 = -50000;
		obj[i].iBMPCh	 = -1;
//		obj[i].iBMPOfX	 = 0;
//		obj[i].iBMPOfY	 = 0;
		obj[i].iChannel	 = -1;
		obj[i].dPixel	 = -500;
		obj[i].iWaveCh	 = -1;
//		obj[i].iLevel	 = 1;
		obj[i].bmp.num = -1; 
	}

	g_OBJScanMin = 0;

//	ZERO(pd);
	pd.iBMPObj		= -1;
	pd.iBMPLayObj	= -1;
	pd.iPoorAnimeObj= -1;
//	pd.bgBMPNum		= -1;
	pd.iPoorTime	= 0;
	pd.bMIDI		= FALSE;
	pd.bPush		= TRUE;
	pd.totalObj		= 0;
	pd.rank			= 1.0;
	pd.restartTime  = NOT_STOPED;
	pd.gaugeMode	= GAUGE_NORMAL;

	for(i=0;i<16;i++)
	{
		pd.iLightTime[i] = 0;
	}

	for(i=0;i<20;i++)
	{
		pd.f_Arrow[i].start = pd.f_Arrow[i].end = pd.f_Arrow[i].fail = -1.0;
		pd.f_Arrow[i].pushed = FALSE;
		pd.f_Arrow[i].nextJudge = -1.0;
	}

	for(i=0;i<pd.totalObj;i++)
	{
		if(obj[i].iChannel == 2) // ߐ
		{
			obj[i].bIsPlayed = TRUE;
			pd.iBarNow  = i;
			pd.iBarNext = i; // ݂Ȃ瓯ԍ

			for(int j=i+1;j<pd.totalObj;j++)
			{
				if(obj[j].iChannel == 2) // ̏ߐ
				{
					pd.iBarNext = j;
					break;
				}
			}

			break;
		}
	}

	// IvVBPMύXf
//	pd.tempoUP		= 100;
	pd.tempoUP		= opt.iTempoChange;
	pd.tempoUP2		= 100;

	// g߂
	ds.SetFreq(0, -1);
	for(i=101;i<100+MAX_WAVNUM;i++)
		ds.SetFreq(i, -1);

	for(i=0;i<30;i++)
		bPoorStock[i] = FALSE;

	for(i=0;i<2;i++)
	{
		if(g_bClub)
			pd.dHP[i] = 100.0;
		else
		{
			if(IsDDR())
				pd.dHP[i] = 50.0;
			else
				pd.dHP[i] = 20.0;
		}

		for(int j=0;j<300;j++)
			pd.dHPRec[i][j] = 0.0;

		pd.totalNote[i]		= 0;

		pd.iScore[i]		= 0;
		pd.dBMScore[i]		= 0.0;

		pd.iScoreCount[i]	= 0;
		pd.bFailed[i]		= FALSE;
		pd.bAlive[i]		= TRUE;
	}

	ScoreInfo.bTempoChanged = FALSE;
	ScoreInfo.bObjSkiped = FALSE;

	InitResult();

}

// MSDBMS
int CheckType(const char* szFileName){

	if(szFileName==NULL)
		return -1;

	const char* szExtPos = strrchr(szFileName,'.'); // ԍŌ.̈ʒu

	if(szExtPos == NULL) // gq
		return -1;

	szExtPos++;

	if(*szExtPos == '\0')
		return -1;			// gq̍ŌオhbgH

	char szExt[MAX_PATH];
	strcpy(szExt,szExtPos); // gq̎擾

	int i=0;
	while(szExt[i]!='\0' && i<10)
		i++;

	if(i!=3) // gq3H
		return(-1);

	if(_stricmp(szExt,"bms") == 0) // gqbms(ɕϊĂr)
	{
//		char szTxt[1024];
//		wsprintf(szTxt,"%s is BMS",szFileName);
//		WriteLog(szTxt);
		return(TYPE_BMS);
	}

	if(_stricmp(szExt,"bme") == 0) // gqbms(ɕϊĂr)
	{
		return(TYPE_BMS);
	}

/*
	// p~ւ̏́c
	if(_stricmp(szExt,"msd") == 0) // gqmsd(ɕϊĂr)
	{
//		char szTxt[1024];
//		wsprintf(szTxt,"%s is MSD",szFileName);
//		WriteLog(szTxt);
		return(TYPE_MSD);
	}
*/
	if(_stricmp(szExt,"cfg") == 0) // gqcfg(ɕϊĂr)
	{
		return(TYPE_CFG);
	}

	if(_stricmp(szExt,"lst") == 0) // gqlst(ɕϊĂr)
	{
		return(TYPE_LST);
	}

	if(_stricmp(szExt,"dat") == 0) // gqdat(ɕϊĂr)
	{
		return(TYPE_DAT);
	}

	if(_stricmp(szExt,"lnk") == 0) // gqlnk(ɕϊĂr)
	{
		return(TYPE_LNK);
	}

//	char szTxt[1024];
//	wsprintf(szTxt,"%s is Unknown",szFileName);
//	WriteLog(szTxt);
	return(-1);

}

void QuitGame(HWND hwnd){

//	delete(pMIDI);
//	delete(pDS);

	cd.Stop();
	cd.Close();
	cd.Terminate();

	joy1.Terminate();
	joy2.Terminate();

	DIkey.Terminate();

	dp.Close();

	for(int j=0;j<MAX_JUKE;j++)
	{
		for(int k=0;k<MAX_FILES;k++)
			DELETE_SAFE(JukeBox[j].Musdat[k]);
	}

//	ds.Terminate();

//	ds.~CWaveControl();
//	ShowWindow(hwnd,SW_HIDE); // ^XNo[ɔc̖h~ by yaneurao
//	PostMessage(hwnd,WM_SYSCOMMAND,SC_CLOSE,NULL);

	SetVolume(pd.vol); // ̃{[

	CTimeBase::timeEndPeriodMin();

	if(dd.bReady)	//DirectDrawłĂȂ
		dd.GetLpDD()->RestoreDisplayMode();	// ʂ̃`h~

	dd.~nsDraw(); // EBhEjODirectDrawIƂȂƕ`悵悤ƂInvalid HWNDH炤

	ShowWindow(hwnd,SW_HIDE); // ^XNo[ɔc̖h~ by yaneurao

	Sleep(500);
	DestroyWindow(hwnd);

	// obNOEhXLobjgĂ̂ŁA
	// objOɕKXbh~߂
	Juke.StopBGScan();

	// IɊmۂ悤ɂȏタfree
	free(obj);
	obj = NULL;
}

// CMusicList::ScanThread()Ă΂̂ōē΍
void WriteLog(const char* Format,...){

//	return;

	// O[oNX̃fXgN^ĂяoĂiKł́A
	// CCriticalSection̍ς݂̏ꍇ̂
	// WriteLogĂяoȂ悤
	static CCriticalSection cs;

	cs.Enter();
	{
		char szPath[MAX_PATH];
		strcpy(szPath, szAppDir);
		strcat(szPath, "Report.log");

		DWORD oldAttr = GetFileAttributes(szPath);
		SetFileAttributes(szPath, FILE_ATTRIBUTE_NORMAL);

		FILE* fp = fopen(szPath,"a+");

		if(fp==NULL)
		{
	//		Notice("G[ȌoɎs");

			if(oldAttr!=0xFFFFFFFF)
				SetFileAttributes(szPath, oldAttr);

			cs.Leave();
			return;
		}

		static char szOld[1024]; // O񏑂񂾃bZ[W
		char Buffer[1024];

		vsprintf(Buffer,Format,(char*)(&Format+1));

		if(strcmp(Buffer,szOld)==0)
		{
			// OƓbZ[WȂ珑܂Ȃ
			fclose(fp);
		
			if(oldAttr!=0xFFFFFFFF)
				SetFileAttributes(szPath, oldAttr);

			cs.Leave();
			return;
		}
		else
			strcpy(szOld,Buffer);

		SYSTEMTIME st;
		GetLocalTime(&st);

		char szText[1024];
		wsprintf(szText,"%d/%02d/%02d %d:%02d:%02d : %s\n",st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, st.wSecond, Buffer);
		fputs(szText, fp);

		fclose(fp);

		if(oldAttr!=0xFFFFFFFF)
			SetFileAttributes(szPath, oldAttr);
	}
	cs.Leave();

}

void Notice(const char* Format,...){

	if(dd.bReady)
		dd.GetLpDD()->FlipToGDISurface();

	char Buffer[1024];
	vsprintf(Buffer,Format,(char*)(&Format+1));

	MessageBox(hmainwnd, Buffer, "G[I", MB_OK);
}

void DispLastError(void){

	LPVOID lpMsgBuf;

	FormatMessage( 

		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,

		NULL,

		GetLastError(),

		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // ftHg

		(LPTSTR) &lpMsgBuf,

		0,

		NULL 

	);

	//ŕKvɉ lpMsgBuf Ɋւ鏈s
	// ...

	Notice((LPTSTR)lpMsgBuf);
	LocalFree( lpMsgBuf );

	return;

}

void GetKeyInfo(){

/*	// Ȃ񂩍rۂC邯ǁc
	MSG msg;
	if (PeekMessage(&msg, NULL, WM_KEYFIRST, WM_KEYLAST, PM_REMOVE)) // L[ɃbZ[W΃L[{[hbZ[Ŵ݂Eď
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	keyo = key;

	BYTE KeySt[256];
	//L[{[h̉擾
	if(!GetKeyboardState(KeySt))
	{
		WriteLog("KeyBoardGetKeyState()Ɏs");
		ZERO(key);
		ZERO(keyp);
		return;
	}
*/
	KEY_INPUT;

//	midiIn.GetKeyState();

/*	if(KeySt[VK_LEFT] & 0x80)		//[]ꂽ
		key.left = TRUE;
	else
		key.left = FALSE;
*/

	// >> 7 = ŏʃrbgBOOLɕϊ

/*	key.z = KeySt['Z'] >> 7 || midiIn.IsKeyPress(65);
	key.s = KeySt['S'] >> 7 || midiIn.IsKeyPress(66);
	key.x = KeySt['X'] >> 7 || midiIn.IsKeyPress(67);
	key.d = KeySt['D'] >> 7 || midiIn.IsKeyPress(68);
	key.c = KeySt['C'] >> 7 || midiIn.IsKeyPress(69);
	key.f = KeySt['F'] >> 7 || midiIn.IsKeyPress(70);
	key.v = KeySt['V'] >> 7 || midiIn.IsKeyPress(71);
	key.space	= KeySt[VK_SPACE] >> 7;
	key.lshift	= KeySt[VK_SHIFT] >> 7 ||
				  midiIn.IsKeyPress(59)  || midiIn.IsKeyPress(60) || midiIn.IsKeyPress(62) || // ̕ӂ̔R()
				  midiIn.IsKeyPress(242) || midiIn.IsKeyPress(243)|| // pitch bend
				  midiIn.IsKeyPress(241); // mod.

	key.left	= KeySt[VK_LEFT]	>> 7;
	key.right	= KeySt[VK_RIGHT]	>> 7;
	key.up		= KeySt[VK_UP]		>> 7;
	key.down	= KeySt[VK_DOWN]	>> 7;

	key.ret		= KEYPRESS(VK_OK); //KeySt[VK_RETURN]	>> 7;

	if(opt.bJoyPad)
	{
		key.left	|= (BOOL)joy1.IsKeyPress(2);
		key.right	|= (BOOL)joy1.IsKeyPress(3);
		key.up		|= (BOOL)joy1.IsKeyPress(0);
		key.down	|= (BOOL)joy1.IsKeyPress(1);

		key.ret		|= (BOOL)joy1.IsKeyPress(4);

		key.z		|= (BOOL)joy1.IsKeyPress(10);
		key.s		|= (BOOL)joy1.IsKeyPress(7);
		key.x		|= (BOOL)joy1.IsKeyPress(4);
		key.d		|= (BOOL)joy1.IsKeyPress(8);
		key.c		|= (BOOL)joy1.IsKeyPress(5);
		key.f		|= (BOOL)joy1.IsKeyPress(9);
		key.v		|= (BOOL)joy1.IsKeyPress(6);

		key.space	|= (BOOL)joy1.IsKeyPress(11);

	}

	key.NUM2	= KeySt[VK_NUMPAD2] >> 7;
	key.NUM4	= KeySt[VK_NUMPAD4] >> 7;
	key.NUM5	= KeySt[VK_NUMPAD5] >> 7;
	key.NUM6	= KeySt[VK_NUMPAD6] >> 7;
	key.NUM8	= KeySt[VK_NUMPAD8] >> 7;
	key.NUM7	= KeySt[VK_NUMPAD7] >> 7;
	key.NUM9	= KeySt[VK_NUMPAD9] >> 7;

	key.ESC		= KeySt[VK_ESCAPE]	>> 7;

	key.shift	= KeySt[VK_SHIFT]	>> 7;
	key.ctrl	= KeySt[VK_CONTROL]	>> 7;
	key.alt		= KeySt[VK_MENU]	>> 7;

	key.F5		= KeySt[VK_F5]		>> 7;

	key.o = KeySt['O'] >> 7;

	key.n		= KeySt['N'] >> 7;
	key.j		= KeySt['J'] >> 7;
	key.m		= KeySt['M'] >> 7;
	key.k		= KeySt['K'] >> 7;
	key.comma	= KeySt[188] >> 7;
	key.l		= KeySt['L'] >> 7;
	key.dot		= KeySt[190] >> 7;
	key.rshift	= KeySt[VK_RSHIFT]	>> 7;

	key.f1		= KeySt['1'] >> 7;
	key.f2		= KeySt['2'] >> 7;
	key.f3		= KeySt['3'] >> 7;
	key.f4		= KeySt['4'] >> 7;
	key.f5		= KeySt['5'] >> 7;
	key.f6		= KeySt['6'] >> 7;
	key.f7		= KeySt['7'] >> 7;
	key.f8		= KeySt['8'] >> 7;
	key.f9		= KeySt['9'] >> 7;
	key.f0		= KeySt['0'] >> 7;

	key.pgUp	= KeySt[VK_PRIOR] >> 7;
	key.pgDn	= KeySt[VK_NEXT] >> 7;


	keyp.left  = key.left  && !keyo.left;
	keyp.right = key.right && !keyo.right;
	keyp.up    = key.up    && !keyo.up;
	keyp.down  = key.down  && !keyo.down;
	keyp.ret   = key.ret   && !keyo.ret;
	keyp.ESC   = key.ESC   && !keyo.ESC;;
	keyp.shift = key.shift && !keyo.shift;
	keyp.NUM2  = key.NUM2  && !keyo.NUM2;
	keyp.NUM4  = key.NUM4  && !keyo.NUM4;
	keyp.NUM5  = key.NUM5  && !keyo.NUM5;
	keyp.NUM6  = key.NUM6  && !keyo.NUM6;
	keyp.NUM8  = key.NUM8  && !keyo.NUM8;
	keyp.NUM7  = key.NUM7  && !keyo.NUM7;
	keyp.NUM9  = key.NUM9  && !keyo.NUM9;
	keyp.o     = key.o     && !keyo.o;
	keyp.ctrl  = key.ctrl  && !keyo.ctrl;
	keyp.alt   = key.alt   && !keyo.alt;
	keyp.F5	   = key.F5    && !keyo.F5;

	keyp.z		= key.z    && !keyo.z;
	keyp.s		= key.s    && !keyo.s;
	keyp.x		= key.x    && !keyo.x;
	keyp.d		= key.d    && !keyo.d;
	keyp.c		= key.c    && !keyo.c;
	keyp.f		= key.f    && !keyo.f;
	keyp.v		= key.v    && !keyo.v;
	keyp.space	= key.space&& !keyo.space;
	keyp.lshift = key.lshift&& !keyo.lshift;

	keyp.n		= key.n		&& !keyo.n;
	keyp.j		= key.j		&& !keyo.j;		
	keyp.m		= key.m		&& !keyo.m;		
	keyp.k		= key.k		&& !keyo.k;		
	keyp.comma	= key.comma	&& !keyo.comma;
	keyp.l		= key.l		&& !keyo.l;
	keyp.dot	= key.dot	&& !keyo.dot;
	keyp.rshift	= key.rshift&& !keyo.rshift;

	keyp.f1		= key.f1 && !keyo.f1;
	keyp.f2		= key.f2 && !keyo.f2;
	keyp.f3		= key.f3 && !keyo.f3;
	keyp.f4		= key.f4 && !keyo.f4;
	keyp.f5		= key.f5 && !keyo.f5;
	keyp.f6		= key.f6 && !keyo.f6;
	keyp.f7		= key.f7 && !keyo.f7;
	keyp.f8		= key.f8 && !keyo.f8;
	keyp.f9		= key.f9 && !keyo.f9;
	keyp.f0		= key.f0 && !keyo.f0;

	keyp.pgUp	= key.pgUp && !keyo.pgUp;
	keyp.pgDn	= key.pgDn && !keyo.pgDn;
*/
}

void Debug(void){

	char szTxt[1024];

/*	if(opt.bFPS)
	{
		// FPS (CPU)
		wsprintf(szTxt,"%3d FPS (CPU:%3d%%)",eltime.GetRealFPS(),eltime.GetCPUPower());
		dd.DrawText(10,462,szTxt);

		//274

		// v
		SYSTEMTIME st;
		GetLocalTime(&st);

		if(st.wHour>=12)
			wsprintf(szTxt, "PM %2d:%02d:%02d", st.wHour-12, st.wMinute, st.wSecond);
		else
			wsprintf(szTxt, "AM %2d:%02d:%02d", st.wHour   , st.wMinute, st.wSecond);

		dd.DrawText(540,462,szTxt);

	}
*/
//	if(g_bClub)
//		dd.DrawText(200,460,"[Club Kit]");

	if(!bDebug)
		return;

	wsprintf(szTxt,"timeGetTime = %9d",timeGetTime());
	dd.DrawText(438,18,szTxt);

	DWORD pos;

	if(cd.IsPlay()){
		cd.GetCurrentPos(pos); // ̂łƒx
		pos-=cd.m_dwSongStart[cd.GetCurrentTrack()];
	}else
		pos = 0;

//	pos = debug.timeNow;

	if(cd.IsPlay()){
		wsprintf(szTxt,"CD[%2d] Time =  %01d:%02d.%03d",cd.GetCurrentTrack(),ms2min(pos),ms2sec(pos),ms2ms(pos) );
		dd.DrawText(438,36,szTxt);
	}

	wsprintf(szTxt,"PlayTime    =  %01d:%02d.%03d",ms2min(debug.timeNow), ms2sec(debug.timeNow), ms2ms(debug.timeNow));
	dd.DrawText(438,54,szTxt);

	wsprintf(szTxt,"MusicLength =  %01d:%02d.%03d",ms2min(pd.endms), ms2sec(pd.endms), ms2ms(pd.endms));
	dd.DrawText(438,72,szTxt);

	if(cd.IsPlay())
	{
		int gap = (int)debug.timeNow - (int)pos; // CD̉tƓƂ̍B0.03ȏ゠Ƒ̊IɂĂ

		if(debug.timeNow < pos)
			wsprintf(szTxt,"CDTime-Time = -%01d:%02d.%03d",ms2min(gap), ms2sec(gap), ms2ms(gap));
		else
			wsprintf(szTxt,"CDTime-Time = +%01d:%02d.%03d",ms2min(gap), ms2sec(gap), ms2ms(gap));

		if(abs(gap)>=30 && debug.timeNow!=0)
			dd.DrawText(438,90,szTxt,RGB(255,0,0));
		else
			dd.DrawText(438,90,szTxt);
	}

	wsprintf(szTxt,"Pixel       = %9d",debug.iPixNow);
	dd.DrawText(438,108,szTxt);

	switch(dd.GetFlipMode())
	{
	case FLIP_DIRECTBLT:
		dd.DrawText(438,126,"FlipMode:DirectBlt");
		break;
	case FLIP_WAITVSYNC:
		dd.DrawText(438,126,"FlipMode:WaitVSYNC");
		break;
	}

/*	wsprintf(szTxt,"Perfect :%03d",result.perfect);
	dd.DrawText(438,126,szTxt);
	wsprintf(szTxt,"Great   :%03d",result.great);
	dd.DrawText(438,144,szTxt);
	wsprintf(szTxt,"Good    :%03d",result.good);
	dd.DrawText(438,162,szTxt);
	wsprintf(szTxt,"Boo     :%03d",result.boo);
	dd.DrawText(438,180,szTxt);
	wsprintf(szTxt,"Miss    :%03d",result.miss);
	dd.DrawText(438,198,szTxt);
	wsprintf(szTxt,"OUCH    :%03d",result.ouch);
	dd.DrawText(438,216,szTxt);
	wsprintf(szTxt,"MaxCombo:%03d",result.maxCombo);
	dd.DrawText(438,234,szTxt);
*/
	int y = debug.iPixNow<0 ? 0 : debug.iPixNow;
	int y2 = pd.endPix;

	int dy=162;

	sprintf(szTxt,"BPM:%6.2f",pd.BPM);
	dd.DrawText(438,dy,szTxt);
	dy+=18;

	sprintf(szTxt,"Bar:%4d/%4d",y/g_TimeBase,y2/g_TimeBase);
	dd.DrawText(438,dy,szTxt);
	dy+=18;

	sprintf(szTxt,"Gap:%d(%d)",pd.Gap, pd.Gap-DDR99_GAP);
	dd.DrawText(438,dy,szTxt);
	dy+=18;	dy+=18;

	sprintf(szTxt,"Notes  : %5d / %5d",pd.totalNote[0], pd.totalNote[1]);
	dd.DrawText(438,dy,szTxt);
	dy+=18;

	sprintf(szTxt,"HP/obj : %5.3f / %5.3f",pd.dHPInc[0], pd.dHPInc[1]);
	dd.DrawText(438,dy,szTxt);
	dy+=18;

	sprintf(szTxt,"sumDown: %5.2lf / %5.2lf", debug.sumDown[0], debug.sumDown[1]);
	dd.DrawText(438,dy,szTxt);

	dy+=18;
	dy+=18;

	sprintf(szTxt,"Volume : %d%%", pd.volrate);
	dd.DrawText(438,dy,szTxt);
	dy+=18;

	if(opt.iAutoTempoChange==0)
		sprintf(szTxt,"Tempo  : %+3d (%3.2lf%%)", pd.tempoUP, CalcTempo(pd.tempoUP, opt.bTCMusical));
	else
		sprintf(szTxt,"Tempo  : %+3d (%3.2lf%%)", 0, (double)pd.tempoUP2);
	dd.DrawText(438,dy,szTxt);
	dy+=18;

	sprintf(szTxt,"Pix/ms : %.3lf%", pd.DpMS);
	dd.DrawText(438,dy,szTxt);
	dy+=18;
	dy+=18;

	sprintf(szTxt,"PR / GR / GD / BD // MS / OC");
	dd.DrawText(438,dy,szTxt);
	dy+=18;

	sprintf(szTxt,"%d / %d / %d / %d // %d / %d", result[0].perfect, result[0].great, result[0].good, result[0].boo, result[0].miss, result[0].ouch);
	dd.DrawText(438,dy,szTxt);
	dy+=18;

	dy+=18;

//	sprintf(szTxt,"PB : %3d",midiIn.GetVelocity(252));
//	dd.DrawText(438,dy,szTxt);

	if(dp.IsReady())
	{
		dd.DrawText(438,dy,"DirectPlay : [Ready]");
		dy+=18;
		sprintf(szTxt,"Send %d / Receive %d",dp.GetPacketsSend(), dp.GetPacketsReceive());
		dd.DrawText(438,dy,szTxt);
	}

//	sprintf(szTxt,"Slept %d ms",(int)eltime.GetElapseTimeCounter());
//	dd.DrawText(438,dy,szTxt);
//	dy+=18;

}

// ܂
// ch1͉L[ɑΉ`lBt[YA[ł5x, 6xł͂Ȃ
void PlayNear(double iPixNow, int ch1){

	int JUDGE_2P;
	if(IN(ch1,21,29) && IsCouple())
		JUDGE_2P = TRUE;
	else
		JUDGE_2P = FALSE;

	// Auto AutoPlaỷB
	if(opt.iAutoPlay==4)
	{
		if(IN(ch1,21,29))
			pd.bAutoPlay[1] = FALSE; // 2P
		else
			pd.bAutoPlay[0] = FALSE; // 1P
	}

/*	if( JUDGE_2P && !pd.bAutoPlay[1] ||
		!JUDGE_2P && !pd.bAutoPlay[0]   )
		IsDouble() && !pd.bAutoPlay[1]    ) //AutoPlayȂ特͖炳Ȃ */
	if( IN(ch1,11,19) && pd.bAutoPlay[0]==FALSE ||
		IN(ch1,21,29) && pd.bAutoPlay[1]==FALSE    )
	{
		if( Is1pAutoSc() && ch1==16) // 1PAutoSc
			goto skip;

		if( Is2pAutoSc() && ch1==26) // 2PAutoSc
			goto skip;

		// s܂߂Ĉԋ߂IuWFTĉ炷
		int nearCh = -1;
		double distmin = 99999999;
		for(int i=0;i<pd.totalObj;i++) // i=g_OBJScanMinȂ͕̂ʂʂ߂ƂɍŌ̃IuWF̉炷
		{
			// +20 == sIuWF +40 == Om[gIuWF
			if( obj[i].iChannel == ch1 || obj[i].iChannel == ch1+20 || obj[i].iChannel == ch1+40)
			{
				double dist = fabs( obj[i].dPixel - iPixNow );
				if(dist<distmin)
				{
					distmin = dist;
					nearCh = obj[i].iWaveCh;
				}
				else
					break; // ŏTdist͂ǂǂ񏬂ȂāAłȂ͑傫Ȃ邾̂͂
			}
		}

		if(nearCh!=-1)
			ds.Play(nearCh);
	}

skip:

	// pɈԋ߂IuWFT
	int nearNum = -1;
	double distmin = 99999999;
	for(int i=g_OBJScanMin;i<pd.totalObj;i++)
	{
		// +40 == Om[gIuWF
		if(obj[i].iChannel == ch1 || obj[i].iChannel == ch1+40)
		{
			double dist = fabs( obj[i].dPixel - iPixNow );
			if(dist<distmin)
			{
				distmin = dist;
				nearNum = i;
			}
			else
				break; // ŏTdist͂ǂǂ񏬂ȂāAłȂ͑傫Ȃ邾̂͂

		}
	}

	if(nearNum==-1)
		return;

	i=nearNum;

	// STOPSTOPĂ̎Ԃl
	if(pd.restartTime!=NOT_STOPED)
	{
		// STOP
		double oldDpMS = pd.oldBPM * double(g_TimeBase) / 240000.0;

		double stoppedPix = (g_lpPlayTime->Get() - pd.stopTime)*oldDpMS; // STOP
		double restPix = (pd.restartTime - g_lpPlayTime->Get())*oldDpMS; // STOP̎c莞

		double pixdif;
		if(obj[i].dPixel > iPixNow)
		{
			// STOP̌ɃIuWF
			pixdif = obj[i].dPixel - (iPixNow - restPix);
		}
		else
		{
			// STOP̑OʒuɃIuWF
			pixdif = obj[i].dPixel - (iPixNow + stoppedPix);
		}

		distmin = fabs(pixdif/oldDpMS);
	}
	else
		distmin /= pd.DpMS; //msɕϊ

	// 肾
	assert(IN(ch1, 11, 29));
	BOOL bPoor = TRUE; // ʉPoor邩ǂ

	if(obj[i].bJudge)
	{
		if(distmin<JUDGE_PERFECT_MS*pd.rank || distmin<JUDGE_GREAT_MS*pd.rank)
		{
			if(distmin<JUDGE_PERFECT_MS*pd.rank)
			{
				SetJudge(PERFECT, JUDGE_2P);
				SetLight(ch1, LC_PERFECT);
			}
			else if(distmin<JUDGE_GREAT_MS*pd.rank)
			{
				SetJudge(GREAT, JUDGE_2P);
				SetLight(ch1, LC_GREAT);
			}

			obj[i].bDraw = FALSE; // IuWF͂̏uԂɏ
			obj[i].bJudge = FALSE;
			bPoor = FALSE;
			bPoorStock[ch1] = FALSE;

			if(IsLongNote(obj[i].iChannel))
			{
				// Om[gX^[g
				int iCh = obj[i].iChannel - 50;
				pd.f_Arrow[iCh].start  = obj[i].dPixel;
				pd.f_Arrow[iCh].end    = obj[i].dPixel + obj[i].dLength;
				pd.f_Arrow[iCh].fail   = -1.0;
				pd.f_Arrow[iCh].pushed = TRUE;

				double pos = obj[pd.iBarNow].dPixel;
				while(pos <= pd.f_Arrow[iCh].start) // ҂S̈ʒu玟̂Sŏ̔
					pos += g_TimeBase/4.0;

				pd.f_Arrow[iCh].nextJudge = pos;

				// STOP̏uԂɂ͂܂łȂāASTOPɓ񂾏ꍇ΍
				if(pd.restartTime!=NOT_STOPED)
					pd.f_Arrow[iCh].nextJudgeInSTOP = pd.f_Arrow[iCh].nextJudge;
			}
		}
		else if(distmin<JUDGE_GOOD_MS*pd.rank || distmin<JUDGE_BOO_MS*pd.rank)
		{
			if(distmin<JUDGE_GOOD_MS*pd.rank)
			{
				SetJudge(GOOD, JUDGE_2P);
			}
			else if(distmin<JUDGE_BOO_MS*pd.rank)
			{
				SetJudge(BOO, JUDGE_2P);
			}

//			obj[i].bDraw = FALSE; IuWF͏ɏ̕ɗĂ
			obj[i].bJudge = FALSE;
			bPoor = FALSE;
			bPoorStock[ch1] = FALSE;

			if(IsLongNote(obj[i].iChannel))
			{
				// Om[gX^[gs
				pd.f_Arrow[obj[i].iChannel-50].fail = iPixNow;
				pd.f_Arrow[obj[i].iChannel-50].pushed = FALSE;

				result[JUDGE_2P].ng++;

				// NG\
				int pl = Is1PLongNote(obj[i].iChannel) ? 0 : 1;
				int idx = pl==0 ? obj[i].iChannel-50 : obj[i].iChannel-60;
				assert(IN(idx, 0, 9));
				result[pl].isOK[idx] = FALSE;
				result[pl].dispTimeOK[idx] = JUDGE_DISPTIME;
			}
		}
	} // endof if(obj[i].bJudge)

	// ʉ
	if(bPoor && g_bOUCH)
	{
		// ł߂uÓvIuWF
		double dist;
		BOOL bFound = FALSE;
		for(int i=g_OBJScanMin;i<pd.totalObj;i++)
		{
			// +40 == Om[gIuWF
			if(obj[i].iChannel==ch1 || obj[i].iChannel==ch1+40)
			{
				dist = obj[i].dPixel - iPixNow;
				if(dist>=0.0)
				{
					bFound = TRUE;
					break;
				}
			}
		}

		if(!bFound)
			return; // OɃIuWFȂBA

		if(IsBM())
		{
			if(dist<JUDGE_OUCH)
				SetJudge(OUCH,JUDGE_2P); //BMȂ苗ȓ

			// 3/4߈ȓȂPoorXgbN
			if(dist<JUDGE_OUCH*0.75)
				bPoorStock[ch1] = TRUE;
		}
		else
		{
			SetJudge(OUCH,JUDGE_2P); // DDR͂ǂł
		}
	}

}

// ڂ[̌Zbg
// Ch = BMSCh
void SetLight(int iCh, int Col){

	int lCh = -1;

	if(IsDDR())
	{
		if(opt.bAllow6 && IN(iCh,11,16))
			lCh = iCh-11;
		else
		{
			if(IN(iCh,11,16))
			{
				int table[] = {0,-1,1,-1,2,3};
				lCh = table[iCh-11];
			}
				
			if(IN(iCh,21,26))
			{
				int table[] = {4,-1,5,-1,6,7};
				lCh = table[iCh-21];
			}
		}
				
		if(lCh!=-1)
		{
	//		WriteLog("lCh = %d",lCh);
			pd.iLightTime[lCh] = JUDGE_LIGHTTIME;
			pd.iLightCol[lCh]  = Col;
			pd.iPushTime[lCh]  = 0;
		}
		pd.bPush = FALSE;
	}
	else
	{
		if(IN(iCh,11,15))
			pd.iLightTime[iCh-11] = JUDGE_EXPLTIME;
		if(IN(iCh,18,19))
			pd.iLightTime[iCh-13] = JUDGE_EXPLTIME;
		if(iCh==16)
			pd.iLightTime[7] = JUDGE_EXPLTIME;

		if(IN(iCh,21,25))
			pd.iLightTime[iCh-13] = JUDGE_EXPLTIME;
		if(IN(iCh,28,29))
			pd.iLightTime[iCh-15] = JUDGE_EXPLTIME;
		if(iCh==26)
			pd.iLightTime[15] = JUDGE_EXPLTIME;

	}

}

void Judge(DWORD timeNow){

	double iPixNow = SetPixNow(timeNow);

//	BOOL JUDGE_2P = FALSE;

	if(IsDDR())
	{
		if(!opt.bAllow6) //4Allow
		{
			// 1P
			if(KEYPUSH(VK_DDR1P_L))
				PlayNear(iPixNow,11);

			if(KEYPUSH(VK_DDR1P_D))
				PlayNear(iPixNow,13);

			if(KEYPUSH(VK_DDR1P_U))
				PlayNear(iPixNow,15);

			if(KEYPUSH(VK_DDR1P_R))
				PlayNear(iPixNow,16);

			if(IsDouble() || IsCouple())
			{
				// 2P
				if(KEYPUSH(VK_DDR2P_L))
					PlayNear(iPixNow,21);

				if(KEYPUSH(VK_DDR2P_D))
					PlayNear(iPixNow,23);

				if(KEYPUSH(VK_DDR2P_U))
					PlayNear(iPixNow,25);

				if(KEYPUSH(VK_DDR2P_R))
					PlayNear(iPixNow,26);
			}
		}
		else //6Allow
		{
			for(int i=0;i<6;i++)
			{
				if(KEYPUSH(VK_DDR6_4+i))
					PlayNear(iPixNow,11+i);
			}
		}
	}
	else //BM
	{
		if(KEYPUSH(VK_BM1P_1))
			PlayNear(iPixNow,11);

		if(KEYPUSH(VK_BM1P_2) && opt.iMode!=MD_BM_4)
			PlayNear(iPixNow,12);

		if(KEYPUSH(VK_BM1P_3))
			PlayNear(iPixNow,13);

		if(KEYPUSH(VK_BM1P_4) && opt.iMode!=MD_BM_4)
			PlayNear(iPixNow,14);

		if(KEYPUSH(VK_BM1P_5))
			PlayNear(iPixNow,15);

//		if(opt.iAutoScr==0 || opt.iAutoScr==2) // 1PAutoScłȂ
//		{
			if(KEYPUSH(VK_BM1P_SC))
				PlayNear(iPixNow,16);
//		}

		if(KEYPUSH(VK_BM1P_6) && opt.iMode==MD_BM_7)
			PlayNear(iPixNow,18);

		if(KEYPUSH(VK_BM1P_7) && opt.iMode!=MD_BM_5)
			PlayNear(iPixNow,19);

		if(IsDouble() || IsCouple())
		{
			//2P
			if(KEYPUSH(VK_BM2P_1))
				PlayNear(iPixNow,21);

			if(KEYPUSH(VK_BM2P_2) && opt.iMode!=MD_BM_4)
				PlayNear(iPixNow,22);

			if(KEYPUSH(VK_BM2P_3))
				PlayNear(iPixNow,23);

			if(KEYPUSH(VK_BM2P_4) && opt.iMode!=MD_BM_4)
				PlayNear(iPixNow,24);

			if(KEYPUSH(VK_BM2P_5))
				PlayNear(iPixNow,25);

//			if(opt.iAutoScr==0 || opt.iAutoScr==1) // 2PAutoScłȂ
//			{
				if(KEYPUSH(VK_BM2P_SC))
					PlayNear(iPixNow,26);
//			}

			if(KEYPUSH(VK_BM2P_6) && opt.iMode==MD_BM_7)
				PlayNear(iPixNow,28);

			if(KEYPUSH(VK_BM2P_7) && opt.iMode!=MD_BM_5)
				PlayNear(iPixNow,29);
		}

	}

	// MISS
	for(int i=g_OBJScanMin;i<pd.totalObj;i++) //pd.totalNote[0]
	{

/*		if(21<=obj[i].iChannel && obj[i].iChannel<=29 && IsCouple())
			JUDGE_2P = TRUE;
		else
			JUDGE_2P = FALSE;
*/

		// STOPSTOPĂ̎Ԃl
		double msdif;
		if(pd.restartTime!=NOT_STOPED)
		{
			double oldDpMS = pd.oldBPM * double(g_TimeBase) / 240000.0;

			double stoppedPix = (g_lpPlayTime->Get() - pd.stopTime)*oldDpMS; // STOP
			double restPix = (pd.restartTime - g_lpPlayTime->Get())*oldDpMS; // STOP̎c莞

			double pixdif;
			if(obj[i].dPixel > iPixNow)
			{
				// STOP̌ɃIuWF
				pixdif = obj[i].dPixel - (iPixNow - restPix);
			}
			else
			{
				// STOP̑OʒuɃIuWF
				pixdif = obj[i].dPixel - (iPixNow + stoppedPix);
			}

			msdif = pixdif/oldDpMS;
		}
		else
		{
			msdif = (obj[i].dPixel - iPixNow)/pd.DpMS;

			// ƂO
			if(msdif >= -JUDGE_MISS_MS)
				break;
		}

		if(msdif < -JUDGE_MISS_MS && obj[i].bJudge && !obj[i].bAutoPlay) //MISS
		{
			if(Is1PNote(obj[i].iChannel) || Is1PLongNote(obj[i].iChannel) ) //1p
			{
				obj[i].bJudge = FALSE;
				if(pd.bAutoPlay[0])
				{
					ScoreInfo.bObjSkiped = TRUE;
				}
				else
				{
					// AutoSc
					if(obj[i].iChannel==16 && Is1pAutoSc())
						continue;

					BOOL poorStock;
					if(IsLongNote(obj[i].iChannel))
					{
						assert(IN(obj[i].iChannel-50, 0, 9));
						pd.f_Arrow[obj[i].iChannel-50].fail = iPixNow;
						pd.f_Arrow[obj[i].iChannel-50].pushed = FALSE;

						result[0].ng++;

						assert(IN(obj[i].iChannel-40, 10, 19));
						poorStock = bPoorStock[obj[i].iChannel-40];
					}
					else
						poorStock = bPoorStock[obj[i].iChannel];
					
					if(poorStock)
					{
						// PoorXgbNKp

						// PoorQ[W͌炳Ȃ
						result[0].miss++;
						result[0].comboNow=0;
						result[0].judgeNow=MISS;

						if(IsLongNote(obj[i].iChannel))
							bPoorStock[obj[i].iChannel-40] = FALSE;
						else
							bPoorStock[obj[i].iChannel] = FALSE;
					}
					else
					{
						// ʂɌ
						SetJudge(MISS,FALSE);
					}
				}
			}

			if((Is2PNote(obj[i].iChannel)||Is2PLongNote(obj[i].iChannel)) && (IsCouple() || IsDouble()) ) //2p
			{
				obj[i].bJudge = FALSE;
				if(pd.bAutoPlay[1])
				{
					ScoreInfo.bObjSkiped = TRUE;
				}
				else
				{
					// AutoSc
					if(obj[i].iChannel==26 && Is2pAutoSc())
						continue;

					BOOL poorStock;
					if(IsLongNote(obj[i].iChannel))
					{
						assert(IN(obj[i].iChannel-50, 10, 19));
						pd.f_Arrow[obj[i].iChannel-50].fail = iPixNow;
						pd.f_Arrow[obj[i].iChannel-50].pushed = FALSE;

						if(IsCouple())
							result[1].ng++; // Couple2P
						else					
							result[0].ng++; // Double2PȂ̂1PɉZ

						assert(IN(obj[i].iChannel-40, 20, 29));
						poorStock = bPoorStock[obj[i].iChannel-40];
					}
					else
						poorStock = bPoorStock[obj[i].iChannel];
						
					if(poorStock)
					{
						// PoorXgbNKp

						// PoorQ[W͌炳Ȃ
						if(IsCouple())
						{
							// Couple2P
							result[1].miss++;
							result[1].comboNow=0;
							result[1].judgeNow=MISS;
						}
						else
						{
							// Double2PȂ̂1PɉZ
							result[0].miss++;
							result[0].comboNow=0;
							result[0].judgeNow=MISS;
						}

						if(IsLongNote(obj[i].iChannel))
							bPoorStock[obj[i].iChannel-40] = FALSE;
						else
							bPoorStock[obj[i].iChannel] = FALSE;
					}
					else
					{
						// ʂɌ
						SetJudge(MISS,TRUE);
					}
				}
			}
		}

	}//endof for

	// MaxComboXV
	for(int i=0;i<2;i++)
	{
		if(result[i].maxCombo<result[i].comboNow)
			result[i].maxCombo=result[i].comboNow;
	}

	// t[YA[݃`FbN
	BOOL key[20] = { FALSE };
	
	if(IsDDR())
	{
		if(!opt.bAllow6)
		{
			// 4Arrow
			key[1] = KEYPRESS(VK_DDR1P_L);
			key[3] = KEYPRESS(VK_DDR1P_D);
			key[5] = KEYPRESS(VK_DDR1P_U);
			key[6] = KEYPRESS(VK_DDR1P_R);

			if(IsDouble() || IsCouple())
			{
				// 2P
				key[11] = KEYPRESS(VK_DDR2P_L);
				key[13] = KEYPRESS(VK_DDR2P_D);
				key[15] = KEYPRESS(VK_DDR2P_U);
				key[16] = KEYPRESS(VK_DDR2P_R);
			}
		}
		else
		{
			// 6Arrow
			for(int i=0;i<6;i++)
			{
				key[1+i] = KEYPRESS(VK_DDR6_4+i);
			}
		}
	}
	else
	{
		//BM
		key[1] = KEYPRESS(VK_BM1P_1);
		key[2] = KEYPRESS(VK_BM1P_2) && opt.iMode!=MD_BM_4;
		key[3] = KEYPRESS(VK_BM1P_3);
		key[4] = KEYPRESS(VK_BM1P_4) && opt.iMode!=MD_BM_4;
		key[5] = KEYPRESS(VK_BM1P_5);
		key[6] = KEYPRESS(VK_BM1P_SC);
		key[8] = KEYPRESS(VK_BM1P_6) && opt.iMode==MD_BM_7;
		key[9] = KEYPRESS(VK_BM1P_7) && opt.iMode!=MD_BM_5;

		if(IsDouble() || IsCouple())
		{
			key[11] = KEYPRESS(VK_BM2P_1);
			key[12] = KEYPRESS(VK_BM2P_2) && opt.iMode!=MD_BM_4;
			key[13] = KEYPRESS(VK_BM2P_3);
			key[14] = KEYPRESS(VK_BM2P_4) && opt.iMode!=MD_BM_4;
			key[15] = KEYPRESS(VK_BM2P_5);
			key[16] = KEYPRESS(VK_BM2P_SC);
			key[18] = KEYPRESS(VK_BM2P_6) && opt.iMode==MD_BM_7;
			key[19] = KEYPRESS(VK_BM2P_7) && opt.iMode!=MD_BM_5;
		}
	}

	// SƂ̓ݔ
	for(i=0;i<20;i++)
	{
		pd.f_Arrow[i].pushNow = key[i];
		if(pd.f_Arrow[i].pushed==TRUE && pd.f_Arrow[i].fail==-1.0 && key[i])
		{
			// t[YA[̓ANeBuŁAƂ肠ł

			if(pd.restartTime==NOT_STOPED)
			{
				// ʏ펞
				double dist = fabs(iPixNow - pd.f_Arrow[i].nextJudge)/pd.DpMS; //msɕϊ

				// Perfectȓœł
				if(dist<JUDGE_PERFECT_MS*pd.rank)
				{
					pd.f_Arrow[i].nextJudge += g_TimeBase/4.0; // ʒûS
					if(pd.f_Arrow[i].nextJudge >= obj[pd.iBarNext].dPixel)
						pd.f_Arrow[i].nextJudge = obj[pd.iBarNext].dPixel; // ϔq̏ꍇA߂̓
				}
			}
			else
			{
				// STOP
				double oldDpMS = pd.oldBPM * double(g_TimeBase) / 240000.0;
				double stoppedPix = (g_lpPlayTime->Get() - pd.stopTime)*oldDpMS; // STOP
				double dist = fabs(iPixNow+stoppedPix - pd.f_Arrow[i].nextJudgeInSTOP)/oldDpMS; //msɕϊ

				// Perfectȓœł
				if(dist<JUDGE_PERFECT_MS*pd.rank)
				{
					pd.f_Arrow[i].nextJudgeInSTOP += g_TimeBase/4.0; // ʒûS

					// STOPĂ񂾂ϔqȂɂȂ
				}
			}
		}
	}

	return;

}

void SetJudge(int judge, BOOL is2P){

	int pl;

	if(IsCouple() && is2P)
		pl = 1;
	else
		pl = 0;

	result[pl].dispTime = JUDGE_DISPTIME;

	int temp = (result[pl].comboNow+1)/4*10;
	int	scoreDDR	= 100 + temp*temp;	// (combo/4*10)^2 + 100

	double HPinc = pd.dHPInc[pl];

	if(opt.iLevel==LEVEL_HARD)
		HPinc *= 0.7;

	static double sumDown[2] = {0,0}; // PbԂɌQ[WʂJEg
	static CTimer downTime; // ̂߂̃^C}[

	switch(judge)
	{
	case PERFECT:
		result[pl].perfect++;
		if(opt.iCombo!=CB_OFF || IsDDR())
			result[pl].comboNow++;
		result[pl].judgeNow=PERFECT;
		pd.iPoorTime = 0;
		pd.iScore[pl]	+= scoreDDR*3;

		// #ExpertGaugeDDR͑Ȃ
		if(pd.gaugeMode==GAUGE_NORMAL)
			pd.dHP[pl]+=HPinc; //0.5;//2.0;

		if(pd.gaugeMode==GAUGE_EXPERT && IsBM())
			pd.dHP[pl]+=(HPinc/10.0); //0.5;//2.0;

		break;

	case GREAT:
		result[pl].great++;
		if(opt.iCombo!=CB_OFF || IsDDR())
			result[pl].comboNow++;
		result[pl].judgeNow=GREAT;
		pd.iPoorTime = 0;
		pd.iScore[pl] += scoreDDR;

		// #ExpertGaugeDDR͑Ȃ
		if(pd.gaugeMode==GAUGE_NORMAL)
			pd.dHP[pl]+=HPinc; //0.5; //1.0;

		if(pd.gaugeMode==GAUGE_EXPERT && IsBM())
			pd.dHP[pl]+=(HPinc/10.0); //0.5;//2.0;

		break;

	case GOOD:
		result[pl].good++;
		if(opt.iCombo==CB_GREATGOOD && IsBM())
			result[pl].comboNow++; //=0;
		else
			result[pl].comboNow=0;
		result[pl].judgeNow=GOOD;
		pd.iPoorTime = 0;

		// #ExpertGauge͑Ȃ
		if(pd.gaugeMode==GAUGE_NORMAL)
			pd.dHP[pl]+=HPinc/2.0; //0.1; //0.5

		if(pd.gaugeMode==GAUGE_EXPERT && IsBM())
			pd.dHP[pl]+=(HPinc/20.0); //0.5;//2.0;

		break;

	case BOO:
		result[pl].boo++;
		result[pl].comboNow=0;
		result[pl].judgeNow=BOO;
		pd.iPoorTime = 0;
		pd.dHP[pl]-=2.0, sumDown[pl]+=2.0;
		break;

/*	// IuWF牓ʉȂPoor
	case POOR:
		result[pl].miss++; // Ƃ肠
//		result[pl].comboNow=0;
		result[pl].judgeNow=MISS; // Ƃ肠
		pd.iPoorTime = 0;
		pd.dHP[pl]-=2.0, sumDown[pl]+=2.0;
		break;
*/
	case MISS:
		result[pl].miss++;
		result[pl].comboNow=0;
		result[pl].judgeNow=MISS;
		pd.iPoorTime = POORBMP_TIME;

		if(pd.gaugeMode==GAUGE_EXPERT && IsBM())
		{
			pd.dHP[pl]-=2.0, sumDown[pl]+=2.0;
		}
		else
		{
			if(opt.iLevel==LEVEL_EASY)
				pd.dHP[pl]-=4.0, sumDown[pl]+=4.0;
			else if(opt.iLevel==LEVEL_NORMAL)
				pd.dHP[pl]-=6.0, sumDown[pl]+=6.0;
			else
				pd.dHP[pl]-=8.0, sumDown[pl]+=8.0;
		}

		break;

	case OUCH:
		result[pl].ouch++;
		if(IsDDR())
			result[pl].comboNow=0;
		result[pl].judgeNow=OUCH;
		pd.iPoorTime = POORBMP_TIME;
		pd.dHP[pl]-=2.0, sumDown[pl]+=2.0;
		break;

	default:
		break;
	}

/*
	// Q[W߂Ȃ悤ɂ[u
	for(int i=0;i<2;i++)
	{
		double limit; // 0.5bԂɌőQ[W
		if(opt.iLevel==LEVEL_EASY)
			limit=12.0;
		else if(opt.iLevel==LEVEL_NORMAL)
			limit=18.0;
		else
			limit=24.0;

		if(sumDown[i]>limit)
		{
//			POOR𓱓Ƃ肠ۗ
//			pd.dHP[i] += (sumDown[i]-limit); // ~bgz񕜂
			sumDown[i] = limit;
		}

		sumDown[i] -= (downTime.Get()/500.0)*limit;
		if(sumDown[i]<0.0)
			sumDown[i] = 0.0;
	}
	debug.sumDown[0] = sumDown[0];
	debug.sumDown[1] = sumDown[1];
	downTime.Reset();
*/

	pd.dBMScore[pl] = CalcBMScore(pl);

	if(pd.iScore[pl]>999999999)
		pd.iScore[pl]=999999999;

	if(pd.dHP[pl]>100)
		pd.dHP[pl]=100;

	if(g_bClub)
	{
		// Q[Wf[^M
		if(IsSingle())
		{
			dp.Send(pd.dHP[0],MES_1P_GAUGE,TRUE);
			dp.Send(pd.dHP[0],MES_2P_GAUGE,TRUE);
		}
		else
		{
			if(pl==0)
				dp.Send(pd.dHP[pl],MES_1P_GAUGE,TRUE);
			else
				dp.Send(pd.dHP[pl],MES_2P_GAUGE,TRUE);
		}

	}

	if(pd.dHP[pl]<0)
	{
		// Q[W
		if(g_bClub)
		{
			dp.Send(pd.dHP[pl],MES_GAUGEDOWN,TRUE);

			if(pl==0)
			{
				if(opt.iLevel==LEVEL_EASY)
					dp.Send((double)TRUE,MES_1P_BALIVE,TRUE);
				else
					dp.Send((double)FALSE,MES_1P_BALIVE,TRUE);
			}
			else
			{
				if(opt.iLevel==LEVEL_EASY)
					dp.Send((double)TRUE,MES_2P_BALIVE,TRUE);
				else
					dp.Send((double)FALSE,MES_2P_BALIVE,TRUE);
			}
		}
		pd.bFailed[pl]=TRUE;
		pd.dHP[pl]=0;
	}

	if(pd.bFailed[pl] && g_bClub) // NuȂ1xʂƕłȂ
		pd.dHP[pl]=0;

}

void DrawGauge(int x,int y,int value){
// 0 <= value <= 100

	if(value>100) value=100;	//101ȏ؂̂
	if(value<0)   value=0;		//0؂̂

	dd.DrawSprite(14, x, y);	// Q[Wg`

	x+=5; // o[߂̍W␳
	y+=6;

	int i=0;
	int rnd=random(10); // 0`9̗

	while( i <= value*(123.0/100.0)-rnd ) // _ŌZăAjBۂ̃Q[W124{(0-123)B100ϊ
	{
		if(value!=0)
		{
			if(i<=15)      dd.DrawSprite(15, x+(i*2), y); // Q[W  `
			else if(i<=39) dd.DrawSprite(16, x+(i*2), y); // Q[W΂P`
			else if(i>=40) dd.DrawSprite(17, x+(i*2), y); // Q[W΂Q`
		}
		i++;
	}
		
	i = int( value*(123.0/100.0) ); // ̌Œʒu`

	if(i!=0)
	{
			if(i<=15)      dd.DrawSprite(15, x+(i*2), y); // Q[W  `
			else if(i<=39) dd.DrawSprite(16, x+(i*2), y); // Q[W΂P`
			else if(i>=40) dd.DrawSprite(17, x+(i*2), y); // Q[W΂Q`
	}

}

void DrawGaugeClub(int x, int y, int value1, int value2){
// 0 <= value <= 100

	RANGE(value1,0,100);
	RANGE(value2,0,100);

	value1/=2;
	value2/=2;

	dd.DrawSprite(14, x, y);	// Q[Wg`

	x+=5; // o[߂̍W␳
	y+=6;

	int i=0;

	while( i <= value1*(123.0/100.0) ) // ۂ̃Q[W124{(0-123)B100ϊ
	{
		if(value1!=0)
		{
			if(i<=39)		dd.DrawSprite(432, x+(i*2), y); // Q[WP`
			else if(i>=40)	dd.DrawSprite(433, x+(i*2), y); // Q[WQ`
		}
		i++;
	}

	if(value1==0)
		i--;

	while( i <= value1*(123.0/100.0)+value2*(123.0/100.0) ) // ۂ̃Q[W124{(0-123)B100ϊ
	{
		if(value2!=0)
		{
			if(i<=39)		dd.DrawSprite(430, x+(i*2), y); // Q[WP`
			else if(i>=40)	dd.DrawSprite(431, x+(i*2), y); // Q[WQ`
		}
		i++;
	}
		

}

/*
void DrawGauge(int x,int y,int value){

	if(value>100) value=100;	//101ȏ؂̂
	if(value<0)   value=0;		//0؂̂

	dd.DrawSprite(14, x, y);	// Q[Wg`

	x+=5; // o[߂̍W␳
	//y+=6; Ă͂̂܂܁

	int i=0;
	int rnd=random(10); // 0`9̗

	while( i <= value*(79.0/100.0)-rnd ) // 
	{
		if(value!=0)
		{
			if(i<=16)      dd.DrawSprite(15, x+(i*3), y); // Q[W  `恖
			else if(i<=24) dd.DrawSprite(16, x+(i*3), y); // Q[W΂P`恖
			else if(i>=25) dd.DrawSprite(17, x+(i*3), y); // Q[W΂Q`恖
		}
		i++;
	}
		
	i = int( value*(79.0/100.0) ); // ̌Œʒu`恖

	if(i!=0) // value[̂Ƃ͍ŏ̈{`悵Ȃ
	{
		if(i<=16)      dd.DrawSprite(15, x+(i*3), y); // Q[W  `恖
		else if(i<=24) dd.DrawSprite(16, x+(i*3), y); // Q[W΂P`恖
		else if(i>=25) dd.DrawSprite(17, x+(i*3), y); // Q[W΂Q`恖
	}

}
*/

void DrawJudge(){

	for(int i=0;i<2;i++)
	{
		if(IsCouple() || i==0)
		{

			// 
			int x;
			if(i==0)
			{
				if(IsDouble() || opt.bAllow6)
					x = JUDGE_DP_X;
				else
					x = JUDGE_1P_X;
			}
			else
				x = JUDGE_2P_X;

			static CTimer timer[2];

			if(timer[0].Get()>2000)	// ʂ̋ȂƂ̑΍
			{
				timer[0].Reset();
				timer[1].Reset();
			}

			while(timer[i].Get()>16)
			{
				result[i].dispTime--;
				timer[i].Adjust(-16);
			}

			if(result[i].dispTime>0)
			{

				double size = double(result[i].dispTime)/double(JUDGE_DISPTIME); //ő1Aŏ0

				switch(result[i].judgeNow)
				{
				case PERFECT:
					if(opt.iEffect>=GE_MID)
					{
						size*=1.4;
						if(size<1.0)
							dd.DrawSprite(25, x, JUDGE_Y);
						else
							dd.StretchBltFast(25, x, JUDGE_Y, size,TRUE);
					}
					else
						dd.DrawSprite(25, x, JUDGE_Y);

					break;

				case GREAT:
					if(opt.iEffect>=GE_MID)
					{
						size*=1.3;
						if(size<1.0)
							dd.DrawSprite(26, x, JUDGE_Y);
						else
							dd.StretchBltFast(26, x, JUDGE_Y, size,TRUE);
					}
					else
						dd.DrawSprite(26, x, JUDGE_Y);

					break;

				case GOOD:
					dd.DrawSprite(27, x, JUDGE_Y);
					break;
				case BOO:
					dd.DrawSprite(28, x+int(sin(size*8.0*PAI)*5.0) , JUDGE_Y);
					break;
				case MISS:
					dd.DrawSprite(29, x, JUDGE_Y-int(size*30.0));
					break;
				case OUCH:
					dd.DrawSprite(30, x, JUDGE_Y-int(size*30.0));
					break;
				}
			}
			else
			{
				result[i].dispTime = 0;
			}

			// R{
			if(result[i].comboNow>3)
			{
				char sztxt[1024];
				wsprintf(sztxt,"%4d",result[i].comboNow);

				int y;
				if(opt.bReverse)
					y = JUDGE_Y-60;
				else
					y = JUDGE_Y+60;

				DrawDigit    (40, x-10,                       y,sztxt);
				dd.DrawSprite(50, x-10+dd.GetSpriteX(40)*4+5, y);
			}
		}
	}

	for(i=0;i<2;i++)
	{
		// t[YA[̔(OK or NG)
		if(i==1 && IsSingle())
			break;

		for(int j=0;j<10;j++)
		{
			static CTimer timer[2][10];

			if(timer[0][0].Get()>2000)	// ʂ̋ȂƂ̑΍
			{
				for(int i=0;i<2;i++)
					for(int j=0;j<10;j++)
						timer[i][j].Reset();
			}

			while(timer[i][j].Get()>16)
			{
				result[i].dispTimeOK[j]--;
				timer[i][j].Adjust(-16);
			}

			if(result[i].dispTimeOK[j]>0)
			{
				// WvZ
				int x;

				//           10    11 12    13 14    15    16 17 18 19 20
				int tbl[] = { 0, 64*0, 0, 64*1, 0, 64*2, 64*3, 0, 0, 0, 0 };

				if(i==0)
				{
					// 1P
					if(opt.bAllow6)
					{
						// 6-Arrow Mode
						x = PLAYAREA_X_6 + 64*(j-1) + 32;
					}
					else if(IsDouble())
					{
						// Double1P
						x = PLAYAREA_DP_X + tbl[j] + 32;
					}
					else
					{
						// 4-Arrow Mode
						x = PLAYAREA_1P_X + tbl[j] + 32;
					}
				}
				else
				{
					// 2P
					if(IsDouble())
					{
						// Double2P
						x = PLAYAREA_DP_X + 64*4 + tbl[j] + 32;
					}
					else
					{
						// Couple2P
						x = PLAYAREA_2P_X + tbl[j] + 32;
					}
				}

				// `
				int spNum = result[i].isOK[j] ? 36 : 37;

				x -= dd.GetSpriteX(spNum)/2;

				if(opt.bReverse)
					dd.DrawSprite(spNum, x, 480-PLAYAREA_Y-TIMEBASE/4-80);
				else
					dd.DrawSprite(spNum, x, PLAYAREA_Y+80);

			}
			else
				result[i].dispTimeOK[j] = 0;
		}
	}

	// XRAJEgAbv
	for(i=0;i<=1;i++)
	{
		pd.iScoreCount[i] += (pd.iScore[i]-pd.iScoreCount[i])/7 < 200 ? 193 : (pd.iScore[i]-pd.iScoreCount[i])/7;

		if(pd.iScore[i]<pd.iScoreCount[i])
			pd.iScoreCount[i] = pd.iScore[i];
	}

}

void DrawDigit(int baseNum, int x, int y, char* szTxt, BOOL bDrawZero/* = FALSE*/){

	int nowX = x;

	while(*szTxt != '\0')
	{
		if('0' <= *szTxt && *szTxt<='9')
		{
			dd.DrawSprite(baseNum+(*szTxt-'0'), nowX, y);
		}

		if(*szTxt == ' ' && bDrawZero)
			dd.DrawSprite(baseNum, nowX, y);

		nowX+=dd.GetSpriteX(baseNum);
		szTxt++;
	}

}

void InitResult(void)
{
	ZERO(result);
}

// chɂ邩Ԃ
int FindChar(const char* pStart, char ch){

	int i=0;

	while(*(pStart+i)!=ch)
		i++;

	return(i);

}

int DifStrToInt(const char* dif){

//	WriteLog("StrToInt");
//	WriteLog(dif);
	if(_stricmp(dif,"BASIC") == 0)
		return(BASIC);

	if(_stricmp(dif,"ANOTHER") == 0)
		return(ANOTHER);

	if(_stricmp(dif,"MANIAC") == 0)
		return(MANIAC);

	return(-1);

}

// MSD̑̓ǂݍ݁B
// pMsdnotes,endPixi[B
BOOL LoadMSDStep(const char* szFile, const char* szPath, char* szErrTxt, int mode, MSD* pMsd){

	int mod = mode;
	int dif;

	if(IsSingle(mod))
		dif = mod-SINGLE, mode = SINGLE;
	if(IsDouble(mod))
		dif = mod-DOUBLE, mode = DOUBLE;
	if(IsCouple(mod))
		dif = mod-COUPLE, mode = COUPLE;

	if(szErrTxt!=NULL)
		szErrTxt[0]='\0';

	if(mode<SINGLE || COUPLE<mode)
	{
		if(szErrTxt != NULL)
			strcpy(szErrTxt,"[hւ񂾂`");
		return FALSE;
	}

	if(dif<BASIC || MANIAC<dif)
	{
		if(szErrTxt != NULL)
			strcpy(szErrTxt,"ŵˁAՓxςȂ́x");
		return FALSE;
	}

//	WriteLog("MSD Step Loading...");

	char szCurrentDir[MAX_PATH];
	
	if(GetCurrentDirectory(MAX_PATH,szCurrentDir) == 0)
	{
		if(szErrTxt!=NULL)
			wsprintf(szErrTxt,"JgtH_擾ł܂");
		return(FALSE);
	}

	if(!SetCurrentDirectory(szPath))
	{
		if(szErrTxt!=NULL)
			wsprintf(szErrTxt,"JgtH_ύXł܂`:%s",szFile);
		return(FALSE);
	}

	FILE* fp = fopen(szFile,"r");

	if(fp == NULL){
		if(szErrTxt!=NULL)
			wsprintf(szErrTxt,"%sJ܂`",szFile);
		SetCurrentDirectory(szCurrentDir);
		return(FALSE);
	}

	char strDif[500];
	char strMode[500];

	if(!GetMSDMethod(fp,strMode))
	{
		if(szErrTxt != NULL)
			strcpy(szErrTxt,"̃t@Cւ񂾂HĂȂH");
		fclose(fp);
		SetCurrentDirectory(szCurrentDir);
		return FALSE;

	}

	while(TRUE)
	{

		while(!(_stricmp(strMode,"#SINGLE:") == 0 && mode==SINGLE ||
				_stricmp(strMode,"#DOUBLE:") == 0 && mode==DOUBLE ||
				_stricmp(strMode,"#COUPLE:") == 0 && mode==COUPLE    ) )
		{
			if(!GetMSDMethod(fp,strMode))
			{
				if(szErrTxt != NULL)
					strcpy(szErrTxt,"MSDɂ͂̃[h͂Ȃ݂ł");
				fclose(fp);
				SetCurrentDirectory(szCurrentDir);
				return FALSE;
			}
		}

		if(_stricmp(strMode,"#SINGLE:") == 0)
		{
			GetMSDData(fp,strDif);
			if(dif == DifStrToInt(strDif))
				break;
		}

		if(_stricmp(strMode,"#DOUBLE:") == 0)
		{
			GetMSDData(fp,strDif);
			if(dif == DifStrToInt(strDif))
				break;
		}

		if(_stricmp(strMode,"#COUPLE:") == 0)
		{
			GetMSDData(fp,strDif);
			if(dif == DifStrToInt(strDif))
				break;
		}

		if(!GetMSDMethod(fp,strMode)) // breakȂ
		{
			if(szErrTxt != NULL)
				strcpy(szErrTxt,"Invaild MSD File");
			fclose(fp);
			SetCurrentDirectory(szCurrentDir);
			return FALSE;
		}

	}

	GetMSDData(fp,strDif); // ̐ǂݔ΂

//	char str[102400];
	char* str = new char[102400];

	int num = GetStr(fp,str,';');

	if(num==0)
	{
		if(szErrTxt != NULL)
			strcpy(szErrTxt,"t@C̏Iɂ`");
		fclose(fp);
		SetCurrentDirectory(szCurrentDir);
		return FALSE;
	}

	InitObj();

	int i=0;
	double pixNow=0, pixInc=double(g_TimeBase)/8.0;
	int notesNow=0;

	int ch = 0;

//	WriteLog(str);

	// notesNow̃IuWFI[o[`FbNĂȂc
	// MSD10000ςȐl͂Ȃv
	while(str[i] != ';')
	{
		int iAnime;

		// }1.0ȓȂ͉̂Z덷΍BĂP256PixelTimeBaseIɂ낵Ȃc
		if(fmod(pixNow,double(g_TimeBase)/4.0) < 1.0 ||
		   fmod(pixNow,double(g_TimeBase)/4.0) > double(g_TimeBase)/4.0-1.0) // OfAj炵
			iAnime = 6; // 4
		else if(fmod(pixNow,double(g_TimeBase)/8.0) < 1.0 ||
				fmod(pixNow,double(g_TimeBase)/8.0) > double(g_TimeBase)/8.0-1.0)
			iAnime = 12; // 8
		else if(fmod(pixNow,double(g_TimeBase)/16.0) < 1.0 ||
				fmod(pixNow,double(g_TimeBase)/16.0) > double(g_TimeBase)/16.0-1.0)
			iAnime = 9; // 16
		else
			iAnime = 3; // ȊO

		// V[PXɃXy[XĂl܂B
		// ̃R[hȂv
		switch(str[i])
		{

		case ':': // 2P̊Jn
			ch=10;
			pixNow = 0;
			pMsd->notes[0] = notesNow;
			break;

		case '0':
			pixNow+=pixInc;
			break;

		//1P (,,,) = (11,13,15,16ch)
		//2P (,,,) = (21,23,25,26ch)

		case '4': // 
			obj[notesNow].iChannel	= 11 + ch;
			obj[notesNow].iAnime	= iAnime;
			obj[notesNow++].dPixel	= pixNow;
			pixNow+=pixInc;
			break;
		case '2': // 
			obj[notesNow].iChannel	= 13 + ch;
			obj[notesNow].iAnime	= iAnime;
			obj[notesNow++].dPixel	= pixNow;
			pixNow+=pixInc;
			break;
		case '8': // 
			obj[notesNow].iChannel	= 15 + ch;
			obj[notesNow].iAnime	= iAnime;
			obj[notesNow++].dPixel	= pixNow;
			pixNow+=pixInc;
			break;
		case '6': // 
			obj[notesNow].iChannel	= 16 + ch;
			obj[notesNow].iAnime	= iAnime;
			obj[notesNow++].dPixel	= pixNow;
			pixNow+=pixInc;
			break;

		case '7': // 
			obj[notesNow].iChannel	= 11 + ch;
			obj[notesNow].iAnime	= iAnime;
			obj[notesNow++].dPixel	= pixNow;
			obj[notesNow].iChannel	= 15 + ch;
			obj[notesNow].iAnime	= iAnime;
			obj[notesNow++].dPixel	= pixNow;
			pixNow+=pixInc;
			break;
		case '9': // 
			obj[notesNow].iChannel	= 15 + ch;
			obj[notesNow].iAnime	= iAnime;
			obj[notesNow++].dPixel	= pixNow;
			obj[notesNow].iChannel	= 16 + ch;
			obj[notesNow].iAnime	= iAnime;
			obj[notesNow++].dPixel	= pixNow;
			pixNow+=pixInc;
			break;
		case '1': // 
			obj[notesNow].iChannel	= 11 + ch;
			obj[notesNow].iAnime	= iAnime;
			obj[notesNow++].dPixel	= pixNow;
			obj[notesNow].iChannel	= 13 + ch;
			obj[notesNow].iAnime	= iAnime;
			obj[notesNow++].dPixel	= pixNow;
			pixNow+=pixInc;
			break;
		case '3': // 
			obj[notesNow].iChannel	= 13 + ch;
			obj[notesNow].iAnime	= iAnime;
			obj[notesNow++].dPixel	= pixNow;
			obj[notesNow].iChannel	= 16 + ch;
			obj[notesNow].iAnime	= iAnime;
			obj[notesNow++].dPixel	= pixNow;
			pixNow+=pixInc;
			break;

		case 'A': // 
			obj[notesNow].iChannel	= 13 + ch;
			obj[notesNow].iAnime	= iAnime;
			obj[notesNow++].dPixel	= pixNow;
			obj[notesNow].iChannel	= 15 + ch;
			obj[notesNow].iAnime	= iAnime;
			obj[notesNow++].dPixel	= pixNow;
			pixNow+=pixInc;
			break;
		case 'B': // 
			obj[notesNow].iChannel	= 11 + ch;
			obj[notesNow].iAnime	= iAnime;
			obj[notesNow++].dPixel	= pixNow;
			obj[notesNow].iChannel	= 16 + ch;
			obj[notesNow].iAnime	= iAnime;
			obj[notesNow++].dPixel	= pixNow;
			pixNow+=pixInc;
			break;

		case '(': // PÅJn
			pixInc = double(g_TimeBase)/4.0/double( FindChar(str+i,')')-1 );
			break;
		case '[': // QÅJn
			pixInc = double(g_TimeBase)/2.0/double( FindChar(str+i,')')-1 );
			break;
		case '{': // QhbgPʏo͂̊Jn
			pixInc = 2.0;
			break;

		case ')': // LR̏I
		case ']':
		case '}':
			pixInc = double(g_TimeBase)/8.0;
			break;

		default:
			break;

		}//endof switch

		i++;

	}//endof while

	DELETEPTR_SAFE(str);

//	char szTxt[1024];
//	wsprintf(szTxt, "Totalnotes = %d",notesNow);
//	WriteLog(szTxt);

	for(i=0;i<notesNow;i++){
		obj[i].bDraw  = TRUE;
		obj[i].bJudge = TRUE;

//		char szTxt[1024];
//		sprintf(szTxt,"obj[%d].iCh = %d", i, obj[i].iChannel);
//		WriteLog(szTxt);
	}

//	totalNote = totalObj = notesNow;
	if(mode != SINGLE)
		pMsd->notes[1] = notesNow - pMsd->notes[0];
	else
		pMsd->notes[0] = notesNow;

	pMsd->endPix = int(pixNow);

	for(i=0;i<=pixNow/g_TimeBase;i++)
	{
		obj[notesNow+1+i].iChannel = 2; // ߐ
		obj[notesNow+1+i].dPixel   = double(i*g_TimeBase);
		obj[notesNow+1+i].bDraw    = TRUE;
	}

	notesNow+=(i+1);
	qsort(obj,notesNow,sizeof(tagObj),compare); // Pixel̏Ƀ\[g

	pMsd->notes[2] = notesNow; // MAXOBJ

//	NoteArrange(notesNow);

//	wsprintf(szTxt, "endPix = %d",pixNow);
//	WriteLog(szTxt);

	fclose(fp);

	if(!SetCurrentDirectory(szCurrentDir))
	{
		if(szErrTxt!=NULL)
			wsprintf(szErrTxt,"JgtH_ύXłȂ`:%s",szCurrentDir);
		return(FALSE);
	}

//	WriteLog("MSD Step Load OK!");
	return(TRUE);

}

// MSD̖߂ЂƂǂݍނ܂Ńooi
// ǂݍ񂾂strɕԂBfp:̈ꕶ
// sfp߂FALSE
BOOL GetMSDMethod(FILE* fp, char* str){

	long InitPos = ftell(fp);
	if(InitPos == -1L)
		return FALSE;

	if(str == NULL)
		return FALSE;

retry: //Ȃ`

	SeekTo(fp,'#'); // #܂Ői

	str[0] = fgetc(fp);

	if(str[0]==EOF){
		str[0]='\0';
		fseek(fp,InitPos,SEEK_SET);
		return FALSE; //}W
	}

	int i=1;

	while(TRUE)
	{
		str[i] = fgetc(fp);

		if(str[i]==':')
			break;		//I

		if(str[i]==';')
			goto retry; //߂

		if(str[i]=='#')
			goto retry; //Ƒ҂āI

		if(str[i]==EOF){
			str[0]='\0';
			fseek(fp,InitPos,SEEK_SET);
			return FALSE; //}W
		}
		i++;
	}

	str[i+1]='\0';

//	char szTxt[1024];
//	wsprintf(szTxt,"GetMSDMethod() : %s",str);
//	WriteLog(szTxt);
	return(TRUE);
	
}

// MSD̃f[^ЂƂǂݍ(EOFłIƂ݂Ȃ)
// ǂݍ񂾂strɕԂBfp:or;̈ꕶor#̂Ƃ
// s(fp,strsȂƂ)FALSE
BOOL GetMSDData(FILE* fp,char* str){

	if(ftell(fp) == -1L){
		WriteLog("fp == NULL in GetMSDData()");
		return FALSE;
	}

	if(str == NULL){
		WriteLog("str == NULL in GetMSDData()");
		return FALSE;
	}

	int i=0;
	BOOL bSharp = FALSE;
	long befPos;

	while(TRUE)
	{
		befPos = ftell(fp);
		str[i] = fgetc(fp);

		if(str[i]==':')
			break;		//I

		if(str[i]==';')
			break;		//I

		if(str[i]=='#')
		{
			bSharp = TRUE; //ƂȂc
			break;
		}

		if(str[i]==EOF)
			break;		//ǁ[Ȃc

		i++;
	}

	str[i]='\0';
	if(str[i-1]=='\n' || str[i-1]=='\r')
		str[i-1]='\0';

	if(bSharp)
		fseek(fp,befPos,SEEK_SET); //#ꕶǂ

//	WriteLog(str);
	return(TRUE);

}

// szFileNameǂݍ݁AsszErrTxtɃG[bZ[WԂB
// pMsdɃx(̐)ȂǂԂB
BOOL LoadMSDData(const char* szFileName, const char* szPath, char* szErrTxt,MSD* pMsd, BOOL bLoadFile){

	if(pMsd != NULL)
		ZERO((*pMsd));

	// ftHgl
	if(pMsd!=NULL)
	{
		pMsd->BPM = 120.0;
		pMsd->Gap = DDR99_GAP;
		pMsd->CDtrack = -1;

		pMsd->iBMLines  = 0; // 5line
		pMsd->iDDRLines = 0; // 4arrow

		for(int i=0;i<9;i++)
			pMsd->level[i] = -1; // SINGLE:0,1,2 DOUBLE:3,4,5 COUPLE:6,7,8  -1ƋȃZ"-"ɂȂ
	}

	char szCurrentDir[MAX_PATH];
	
	if(GetCurrentDirectory(MAX_PATH,szCurrentDir) == 0)
	{
		if(szErrTxt!=NULL)
			wsprintf(szErrTxt,"JgtH_擾ł܂cȂŁH");
		return(FALSE);
	}

	if(!SetCurrentDirectory(szPath))
	{
		if(szErrTxt!=NULL)
			wsprintf(szErrTxt,"JgtH_ύXł܂:%s",szFileName);
		return(FALSE);
	}

	if(bLoadFile)
		WriteLog("%s (%s)̓ǂݍݒ...", szFileName, szPath);

	FILE* fp;
	fp = fopen(szFileName,"r");

	if(fp == NULL){
		if(szErrTxt!=NULL)
			wsprintf(szErrTxt,"%sJ܂`",szFileName);
		return(FALSE);
	}

//	WriteLog("Loading MSD Data...");

	char str[1024];

	while(GetMSDMethod(fp,str)) // EOFɒB܂
	{
		int  Num=0;
		char str2[1024];

//		WriteLog(str);

		if(_stricmp(str,"#FILE:") == 0) // gpftHg̃t@C(BMP,WAVE)łBgq͕sKvłB
		{
			GetMSDData(fp,str2);

			char* pos;
			if( (pos = strchr( str2,'.')) != NULL) // gq
				*pos = '\0';

			if(pMsd != NULL)
			{
				strcpy(pMsd->file,str2);
				pMsd->bWavBGM = TRUE;
			}

		}

		if(_stricmp(str,"#TITLE:") == 0) // Ȃ̃^CgłB
		{
			GetMSDData(fp,str2);
			if(pMsd != NULL)
				strcpy(pMsd->title,str2);
		}

		if(_stricmp(str,"#ARTIST:") == 0) // Ȃ̃A[eBXgłB
		{
			GetMSDData(fp,str2);
			if(pMsd != NULL)
				strcpy(pMsd->artist,str2);
		}

		if(_stricmp(str,"#MSD:") == 0) // MSD҂łB
		{
			GetMSDData(fp,str2);
			if(pMsd != NULL)
				strcpy(pMsd->msdMaker,str2);
		}

		if(_stricmp(str,"#TRACK:") == 0) // tCDgbN
		{
			GetMSDData(fp,str2);

			if(pMsd != NULL)
				pMsd->CDtrack = atoi(str2);

		}

		if(_stricmp(str,"#BPM:") == 0) // ȂBPM(Beats per Minute)łB܂őΉĂ܂B
		{
			GetMSDData(fp,str2);

			if(pMsd != NULL)
			{
				pMsd->BPM = atof(str2);
				if(pMsd->BPM == 0.0)
					pMsd->BPM = 120;

			}

//			g_DpMS = g_BPM * double(g_TimeBase) / 240000.0;	// 1msPixel
//			WriteLog("BPM Loaded");

		}

		if(_stricmp(str,"#GAP:") == 0) // r̃hbgPʂł̃YC܂B̒l͂ł܂B
		{
			GetMSDData(fp,str2);
			if(pMsd != NULL)
				pMsd->Gap = int( (atof(str2))*(double(g_TimeBase)/256.0) ) + DDR99_GAP;

		}

		if(_stricmp(str,"#SINGLE:") == 0)// ̐̓ǂݍ
		{
			GetMSDData(fp,str2); // xǂݍ

			char str3[4];
			GetMSDData(fp,str3); // ̐ǂݍ

			if(_stricmp(str2,"BASIC") == 0)
			{
				if(pMsd != NULL)
					pMsd->level[SINGLE+BASIC] = atoi(str3);
			}

			if(_stricmp(str2,"ANOTHER") == 0)
			{
				if(pMsd != NULL)
					pMsd->level[SINGLE+ANOTHER] = atoi(str3);
			}

			if(_stricmp(str2,"MANIAC") == 0)
			{
				if(pMsd != NULL)
					pMsd->level[SINGLE+MANIAC] = atoi(str3);
			}
		}
		
		if(_stricmp(str,"#DOUBLE:") == 0)// ̐̓ǂݍ
		{
			GetMSDData(fp,str2); // xǂݍ

			char str3[4];
			GetMSDData(fp,str3); // ̐ǂݍ

			if(_stricmp(str2,"BASIC") == 0)
			{
				if(pMsd != NULL)
					pMsd->level[DOUBLE+BASIC] = atoi(str3);
			}

			if(_stricmp(str2,"ANOTHER") == 0)
			{
				if(pMsd != NULL)
					pMsd->level[DOUBLE+ANOTHER] = atoi(str3);
			}

			if(_stricmp(str2,"MANIAC") == 0)
			{
				if(pMsd != NULL)
					pMsd->level[DOUBLE+MANIAC] = atoi(str3);
			}
		}

		if( _stricmp(str,"#COUPLE:") == 0 ) // ̐̓ǂݍ
		{
			GetMSDData(fp,str2); // xǂݍ

			char str3[4];
			GetMSDData(fp,str3); // ̐ǂݍ

			if(_stricmp(str2,"BASIC") == 0)
			{
				if(pMsd != NULL)
					pMsd->level[COUPLE+BASIC] = atoi(str3);
			}

			if(_stricmp(str2,"ANOTHER") == 0)
			{
				if(pMsd != NULL)
					pMsd->level[COUPLE+ANOTHER] = atoi(str3);
			}

			if(_stricmp(str2,"MANIAC") == 0)
			{
				if(pMsd != NULL)
					pMsd->level[COUPLE+MANIAC] = atoi(str3);
			}
		}

	}//endof while

	fclose(fp);

	if(!SetCurrentDirectory(szCurrentDir))
	{
		if(szErrTxt!=NULL)
			wsprintf(szErrTxt,"JgtH_ύXł܂:%s",szCurrentDir);
		return(FALSE);
	}

	if(bLoadFile)
	{
		char szTxt[MAX_PATH];

//		if(pMsd->CDtrack==-1 || !cd.IsOpen()) // CDĐłȂꍇ̂WAVǂ
//		{
		wsprintf(szTxt,"Bgm\\%s.wav",pMsd->file);
		BOOL res = ds.LoadWaveFile(0,szTxt);
/*			if(!res)
			{
				if(szErrTxt!=NULL)
					wsprintf(szErrTxt,"%sǂݍ߂܂c",szTxt);
				SetCurrentDirectory(szCurrentDir);
				return(FALSE);
			}
*/
			pd.wavCh = 0;
//		}

		if(opt.bBgAnime)
		{
			wsprintf(szTxt,"Back\\%s.bmp",pMsd->file);
			if( !dd.LoadBMP(32,szTxt,RGB(0,0,0)) )
			{
				wsprintf(szTxt,"Back\\%s.jpg",pMsd->file);
				if( !dd.LoadBMP(32,szTxt,RGB(0,0,0)) )
				{
					wsprintf(szTxt,"Back\\%s.gif",pMsd->file);
					if( !dd.LoadBMP(32,szTxt,RGB(0,0,0)) )
					{
						wsprintf(szTxt,"Back\\%s.png",pMsd->file);
						dd.LoadBMP(32,szTxt,RGB(0,0,0));
					}
				}
			}

			dd.DefSprite(32,32,0,0,0,0);
			pd.bgBMPNum = 32;
		}
	}

	if(bLoadFile)
		WriteLog("%s (%s)̓ǂݍ݊", szFileName, szPath);

	return(TRUE);

}

// char16iint10iB߂ǂ2p()
// char10iint10i2pɎgƈĊO֗?
int HexToInt(const char* pStr){

	int temp=0;

	for(int i=0;i<2;i++)
	{
		int val;
		if(i==0)
			val=16;
		else
			val=1;

		if( '0' <= (*pStr) && (*pStr) <= '9')
			temp += (*pStr-'0')*val;

		if( 'a' <= (*pStr) && (*pStr) <= 'f')
			temp += (*pStr-'a'+10)*val;

		if( 'A' <= (*pStr) && (*pStr) <= 'F')
			temp += (*pStr-'A'+10)*val;
			
		pStr++;
	}
	return temp;
}

// char36iint10iB߂ǂ2p()
// char10iint10i2pɎgƈĊO֗?
int Hex36ToInt(const char* pStr){

	int temp=0;

	for(int i=0;i<2;i++)
	{
		int val;
		if(i==0)
			val=36;
		else
			val=1;

		if( '0' <= (*pStr) && (*pStr) <= '9')
			temp += (*pStr-'0')*val;

		if( 'a' <= (*pStr) && (*pStr) <= 'z')
			temp += (*pStr-'a'+10)*val;

		if( 'A' <= (*pStr) && (*pStr) <= 'Z')
			temp += (*pStr-'A'+10)*val;
			
		pStr++;
	}
	return temp;
}

// qsortpr֐
// o^C~OɃ\[g
// ʒuȂ`lԍ̏Ƀ\[g
// - : arg1 < arg2
// 0 : arg1 == arg2
// + : arg1 > arg2
int compare( const void *arg1, const void *arg2 ){

	tagObj* obj1 = (tagObj*)arg1;
	tagObj* obj2 = (tagObj*)arg2;

	if(obj1->dPixel == obj2->dPixel)
	{
		return obj1->iChannel - obj2->iChannel;
	}
	else
	{
		if(obj1->dPixel < obj2->dPixel)
			return -1;
		if(obj1->dPixel == obj2->dPixel)
			return 0;
		if(obj1->dPixel > obj2->dPixel)
			return 1;
	}

	// ɂ͗ȂƎv
	return 0;

}

// Ōオ'\'ȂΕtĕԂB'\'Ȃ炻̂܂ܕԂ
string AddYen(string path)
{
	// Q̃`FbNōς܂悤ƂƁA"\"̂悤ȂƂ
	// second byteɑ΂IsDBCSLeadByte邱ƂɂȂāA̕ŃoOB
	// ƂƂŁAŏ炷ׂĒH邵Ȃc
	char ch = '\0';
	for(DWORD i=0;i<path.size();i++)
	{
		if(IsDBCSLeadByte((BYTE)path[i]))
			i++;
		else
			ch = path[i];
	}

	if(ch=='\\')
		return path;
	else
		return path + '\\';
}

// szFullPatḧԌ'\'ȑOԂ('\'͊܂܂Ȃ)
// '\'܂܂ĂȂ""ԂB
void GetPath(char* szPath, const char* szFullPath){

	const char* pos = szFullPath;
	const char* yenPos = NULL;

	while(*pos!='\0')
	{
		if(IsDBCSLeadByte(BYTE(*pos)))
			pos+=2;
		else
		{
			if(*pos=='\\')
				yenPos = pos;

			pos++;
		}
	}

	if(yenPos==NULL)
	{
		szPath[0] = '\0';
		return;
	}

	strncpy(szPath, szFullPath, yenPos-szFullPath);
	szPath[yenPos-szFullPath] = '\0';

}

// szFullPatḧԌ'\'ȍ~ԂB'\'܂܂ĂȂ΂̂܂ܕԂB
// '\'ŏIĂ""Ԃ
void GetFileName(char* szFile, const char* szFullPath){

	const char* pos = szFullPath;
	const char* yenPos = NULL;

	while(*pos!='\0')
	{
		if(IsDBCSLeadByte(BYTE(*pos)))
			pos+=2;
		else
		{
			if(*pos=='\\')
				yenPos = pos;

			pos++;
		}
	}

	if(yenPos==NULL)
	{
		// '\'܂܂ĂȂ
		strcpy(szFile, szFullPath);
		return;
	}

	if(yenPos+1 == pos)
	{
		// '\'ŏIĂ
		szFile[0] = '\0';
		return;
	}

	strcpy(szFile, yenPos+1);

}

// fileName̊gqԂB
string GetFileExtension(const string& fileName)
{
	// Ō'.'oĂʒuT
	int dotPos = -1;

	for(DWORD i=0;i<fileName.size();i++)
	{
		if(IsDBCSLeadByte(BYTE(fileName[i])))
			i++;
		else if(fileName[i]=='.')
			dotPos = i;
	}

	if(dotPos==-1)
	{
		// '.'܂܂ĂȂgqȂ
		return "";
	}

	if(dotPos+1 == fileName.size())
	{
		// '.'ŏIĂ遁gqȂƂNULL
		return "";
	}

	return fileName.substr(dotPos+1);

}

BOOL IsFolder(const char* szFolder){

	if(szFolder[0]=='\0')
		return FALSE;

	if(szFolder==NULL)
		return FALSE;

	char szPrePath[MAX_PATH];

	GetCurrentDirectory(sizeof(szPrePath), szPrePath);

	if(!SetCurrentDirectory(szFolder))
		return FALSE;
	else
	{
		SetCurrentDirectory(szPrePath);
		return TRUE;
	}

}

// t@CȂ̂CodecȂ̂SPIȂ̂Ȃ̂
// S҂ɂ̂ւڂ :-p
void GetDetailFileErr(const string& fileName, string& messageBuf)
{
	DWORD attr = GetFileAttributes(fileName.c_str());

	if(attr==0xFFFFFFFF)
	{
		// t@CȂAȂ񂩂̗Rœǂ߂Ȃ
		char buf[1024];
		GetLastErrorStr(buf);
		messageBuf = buf;
	}
	else
	{
		// CodecȂSPIȂt@CĂ邩
		// ANZXȂĂɂ݂cƂ肠
		string ext = GetFileExtension(fileName);

		if(_strnicmp(ext.c_str(), "mp3", 3)==0)
		{
			// mp3
			messageBuf = Messages.Get("Err_Can'tReadMP3");
		}
		else if(_strnicmp(ext.c_str(), "jpg", 3)==0)
		{
			// jpg
			messageBuf = Messages.Get("Err_Can'tReadJPG");
		}
		else if(_strnicmp(ext.c_str(), "gif", 3)==0)
		{
			// gif
			messageBuf = Messages.Get("Err_Can'tReadGIF");
		}
		else if(_strnicmp(ext.c_str(), "png", 3)==0)
		{
			// png
			messageBuf = Messages.Get("Err_Can'tReadPNG");
		}
		else
		{
			// ȊO
			messageBuf = Messages.Get("Err_Can'tReadFile");
		}
	}
}

// szFileNameǂݍ݁AsszErrTxtɃG[bZ[WԂB
// pBmsɂ낢ƕԂB
BOOL LoadBMS(const char* szFileName, const char* path, char* szErrTxt, BMS* pBMS, BOOL bReadFiles, int dif){

	if(pBMS != NULL)
	{
		ZERO((*pBMS));
	}
	else
		return FALSE;

	if(szErrTxt==NULL)
	{
		WriteLog("LoadBMS() : szErrTxtNULLł");
		return FALSE;
	}

	if(bReadFiles)
		WriteLog("LoadBMS() : %s (%s)̓ǂݍݒ...", szFileName, path);

	char szCurrentDir[MAX_PATH];
	
	if(GetCurrentDirectory(MAX_PATH,szCurrentDir) == 0)
	{
		if(szErrTxt!=NULL)
		{
			wsprintf(szErrTxt,"JgtH_擾ł܂cȂŁ`H");
		}
		WriteLog("LoadBMS() : JgtH_擾ł܂");
		return(FALSE);
	}

	char file[MAX_PATH];
	if(bReadFiles)
	{
		if(path!=NULL)
		{
			if(!SetCurrentDirectory(path))
			{
				if(szErrTxt!=NULL)
				{
					wsprintf(szErrTxt,"JgtH_ύXł܂:%s",path);
				}

				WriteLog("LoadBMS() : JgtH_ύXł܂:%s",path);
				return(FALSE);
			}
		}

		strcpy(file,szFileName);

	}
	else
	{
		strcpy(file,path);

		char* yen = strrchr(file, '\\');

		if(yen != NULL) // \ĂĂvI
		{
			if(yen[1] == '\0')
			  ;
			else
			  strcat(file, "\\");

		}else
			strcat(file, "\\");

		strcat(file,szFileName);
	}

	if(pBMS != NULL)
		strcpy(pBMS->path, path);

//		Notice("x1");
	FILE* fp;
	fp = fopen(file,"r");

	if(fp == NULL)
	{
		if(szErrTxt!=NULL)
		{
			wsprintf(szErrTxt,"%sJ܂`",file);
		}
		WriteLog("LoadBMS() : %sJ܂`",file);
		WriteLog("Root:%s Current:%s",szCurrentDir, path); // Ȃ̂o͂Ă݂

		if(!SetCurrentDirectory(szCurrentDir))
		{
			// DDR.exẽtH_ɖ߂ȂBȍ~SẴt@Cǂ߂ȂȂ
			WriteLog("LoadBMS() : JgtH_ɖ߂܂(%s) I܂", szCurrentDir);
			QuitGame(hmainwnd);
		}
		return(FALSE);
	}
//		Notice("fopen=TRUE");

	// for ch.08 extended BPM change
	double dBPMtbl[256];
	for(int i=0;i<256;i++)
	{
		dBPMtbl[i] = 130.0;
	}

	// for ch.CH_STOP sequence stopping
	int iStopTime[256];
	for(i=0;i<256;i++)
	{
		iStopTime[i] = 0;
	}

	// for LongNote 1P : 5x, 2P : 6x
	int iLongNoteObj[20];   // Om[g̃IuWFԍۑƂďIɒl̂Ɏg
	for(i=0;i<20;i++)
	{
		iLongNoteObj[i] = -1;
	}

	// for extended BGA system
	// #BGAn1 n2 x y tx ty ox oy
	EXBMP exbmp[1296]; // 1296 = 36*36

	for(i=0;i<1296;i++)
	{
		exbmp[i].num = exbmp[i].x = exbmp[i].y = exbmp[i].tx = exbmp[i].ty = exbmp[i].ox = exbmp[i].oy = -1;
	}

	// ftHgl
	if(pBMS!=NULL)
	{
		pBMS->Player	= 1;
		pBMS->Rank		= 2;
		pBMS->PlayLevel = 3;
		pBMS->VolWAV	= 100;
		pBMS->BPM		= 130.0;
		pBMS->MIDIFile[0] = '\0';
		pBMS->CDtrack	= -1;
		pBMS->bBMP		= FALSE;
		pBMS->bPlayable = FALSE;
		pBMS->bWavBGM	= FALSE;
		pBMS->Total[0]	= 0;
		pBMS->Total[1]	= 0;
		pBMS->bgBMPNum	= -1;
		pBMS->gaugeMode	= GAUGE_NORMAL;

		for(int i=0;i<256;i++)
		{
			pBMS->BMP[i][0] = '\0';
		}

		for(i=0;i<MAX_WAVNUM;i++)
		{
			pBMS->Wav[i][0] = '\0';
		}
	}

	InitObj();

//	WriteLog("Loading BMS Data...");

	char str[1024];
	double ShortBar[1001]; // ߂̒Zk{BftHg:1

	for(i=0;i<1000;i++) // Zk{
		ShortBar[i] = 1.0;

	int iLine = 0;
	int Obj = 0;
	int notes[2]={0,0};
	int maxBar = 0;

	BOOL bSkip = FALSE; // ifpXLbvtO
	int rndVal = -1;	// 
	BOOL bUrami = FALSE; // ݂f[^ϊp
	BOOL bStageFile = FALSE;

//	char szPath[MAX_PATH];
//	GetPath(szPath, szFileName);

exit:

	while( GetLine(fp,str,1024) != 0) // EOFɂ܂ && feof(fp)==0
	{
//		Notice("GetLine()");
		iLine++;

//		WriteLog(str);
		// #if𖳎ēǂݍޖ߂
		if( _strnicmp(str,"#PLAYER ",8) == 0 ) // vC[h̓ǂݍ
		{
			if(pBMS!=NULL)
				pBMS->Player = atoi(&str[8]);
			if(!IN(pBMS->Player, 1, 4))
				pBMS->Player = 1; // ͈͊O͂P
		}

		if( _strnicmp(str,"#GENRE ",7) == 0 ) // W̓ǂݍ
		{
			if(pBMS!=NULL)
				strcpy(pBMS->Genre, SeekToChar(&str[7]));
		}

		if( _strnicmp(str,"#TITLE ",7) == 0 ) // ^Cg̓ǂݍ
		{
			if(pBMS!=NULL)
				strcpy(pBMS->Title, SeekToChar(&str[7]));
		}

		if( _strnicmp(str,"#ARTIST ",8) == 0 ) // A[eBXg̓ǂݍ
		{
			if(pBMS!=NULL)
				strcpy(pBMS->Artist, SeekToChar(&str[8]));
		}

		if( _strnicmp(str,"#PLAYLEVEL ",11) == 0 ) // vCx̓ǂݍ
		{
			if(pBMS!=NULL)
				pBMS->PlayLevel = atoi(&str[11]);
		}

		if( _strnicmp(str,"#RANK ",6) == 0 ) // 胉N̓ǂݍ
		{
			if(pBMS!=NULL)
				pBMS->Rank = atoi(&str[6]);
		}

		if( _strnicmp(str,"#VOLWAV ",8) == 0 ) // WAVE{[̓ǂݍ
		{
			if(pBMS!=NULL)
				pBMS->VolWAV = atoi(&str[8]);
		}

		if( //_strnicmp(str,"// 2DX 1P Convert Header",24      ) == 0 ||
			//_strnicmp(str,"// substream 1P Convert Header",30) == 0 ||
			//_strnicmp(str,"// 2ndStyle 1P Convert Header",29 ) == 0 ||
			_strnicmp(str,"#ExtChr 730 -1 245 1 257 18 201 140",35) == 0  ||
			_strnicmp(str,"#ExtChr 774 -1 259 64 271 81 201 140",36) == 0 ||
			_strnicmp(str,"#ExtChr 780 -1 335 64 347 81 201 140",36) == 0 ||
			_strnicmp(str,"#ExtChr 779 -1 325 64 333 81 201 140",36) == 0 ||
			_strnicmp(str,"#ExtChr 745 -1 275 20 287 37 201 140",36) == 0 ||
			_strnicmp(str,"#ExtChr 771 -1 400 41 404 58 201 140",36) == 0 ||
			_strnicmp(str,"#ExtChr 760 -1 259 41 271 58 201 140",36) == 0 ||
			_strnicmp(str,"#ExtChr 784 -1 399 64 411 87 201 140",36) == 0    ) // ݃`FbN()
		{
			if(pBMS!=NULL)
				pBMS->bUrami = TRUE;

			bUrami = TRUE;
		}

		if( _strnicmp(str,"#ENDIF",6) == 0 ) // ENDIF
		{
			bSkip = FALSE;
		}

		if(str[0]=='#' && !bSkip) // #̂ĂȂs͖ #if̗LȖ߂
		{

			if( _strnicmp(str,"#BPM ",5) == 0 ) // BPM̓ǂݍ
			{
				if(pBMS!=NULL)
					pBMS->BPM = atof(&str[5]);
				if(pBMS->BPM<=0.0)
					pBMS->BPM = 130.0;
			}
			else if( _strnicmp(str,"#BPM",4) == 0 ) // Ch.08gBPM̓ǂݍ
			{
				double bpm = atof(&str[7]);
				if(bpm<=0.0)
					bpm = 130.0;

				dBPMtbl[ HexToInt(&str[4]) ] = bpm;
			}

			if( _strnicmp(str,"#STOP",5) == 0 ) // Ch.CH_STOP V[PX~߂̓ǂݍ
			{
				int time = atoi(&str[8]);
				if(time<=0)
					time = 0;

				iStopTime[ HexToInt(&str[5]) ] = time;
			}

			if( _strnicmp(str,"#MIDIFILE ",10) == 0 ) // MIDIt@C̓ǂݍ
			{
				if(pBMS!=NULL)
				{
					strcpy(pBMS->MIDIFile, SeekToChar(&str[10]));
				}
				if(bReadFiles)
					midi.InitMIDI(hmainwnd, &str[10]);
			}
						
			if( _strnicmp(str,"#TOTAL ",7) == 0 ) // Q[Wʂ̓ǂݍ
			{
				if(pBMS!=NULL)
				{
					pBMS->Total[0] = atof(&str[7]);
					pBMS->Total[1] = atof(&str[7]);
				}
			}

			if( _strnicmp(str,"#WAV",4) == 0 ) // WAVt@C̓ǂݍ
			{
				int wavNum;
				char* fileName;

				// WAVԍLɂւȂƂANZX̖h~
				if(strlen(str)>=6)
					wavNum = Hex36ToInt(&str[4]);
				else
				{
					wsprintf(szErrTxt,"Line:%d #WAVxx̎w肪sł", iLine);
					fclose(fp);
					SetCurrentDirectory(szCurrentDir);
					return(FALSE);
				}

				// t@CLɂւȂƂANZX̖h~
				if(strlen(str)>=8)
					fileName = SeekToChar(&str[7]);
				else
					fileName = "";

				if(wavNum >= MAX_WAVNUM)
				{
					// ߋ#WAVG0Ƃw肵Ăf[^₪c
					wsprintf(szErrTxt,"Line:%d #WAVxx̎w肪sł(xx = %c%c)", iLine, str[4], str[5]);
					fclose(fp);
					SetCurrentDirectory(szCurrentDir);
					return(FALSE);
				}

				// t@C̕ۑ
				if(pBMS!=NULL)
				{
					strcpy(pBMS->Wav[wavNum], fileName);
				}

				if(bReadFiles)
				{
					BOOL res;
					if(Cfg["WAVStreaming"]==WS_ALL)
						res = ds.LoadWaveFile(100+wavNum, fileName, TRUE); // Xg[~O(mCY邯ǁc)
					else
						res = ds.LoadWaveFile(100+wavNum, fileName, FALSE); // Ȃ

					if(!res)
					{
						// [hs
						char wavxx[10];
						strncpy(wavxx, str, 6); // #WAVxxRs[
						wavxx[6]='\0';

						string detailErr;
						GetDetailFileErr(fileName, detailErr);

						wsprintf(szErrTxt,"Line:%d %s(%s)ǂݍ߂܂\n%s", iLine, fileName, wavxx, detailErr.c_str());

						fclose(fp);
						SetCurrentDirectory(szCurrentDir);
						return(FALSE);
					}
				}

			}

			if( _strnicmp(str,"#BMP",4) == 0 ) // BMPt@C̓ǂݍ
			{
				int bmpNum;
				char* fileName;

				// BMPԍLɂւȂƂANZX̖h~
				if(strlen(str)>=6)
					bmpNum = HexToInt(&str[4]);
				else
				{
					wsprintf(szErrTxt,"Line:%d #BMPxx̎w肪sł", iLine);
					fclose(fp);
					SetCurrentDirectory(szCurrentDir);
					return(FALSE);
				}

				// t@CLɂւȂƂANZX̖h~
				if(strlen(str)>=8)
					fileName = SeekToChar(&str[7]);
				else
					fileName = "";

				strcpy(pBMS->BMP[bmpNum], fileName);
				pBMS->bBMP = TRUE;

				if(bReadFiles && opt.bBMSA)
				{
					if(Cfg["BlackColorRounding"]) // RGB(0,0,0)ƔɈႤFFƂ
						dd.SetBlackColorRounding(TRUE);

					BOOL res  = dd.LoadBMP(100+bmpNum, fileName);

					if(Cfg["BlackColorRounding"])
						dd.SetBlackColorRounding(FALSE);


					BOOL res2 = dd.DefSprite(100+bmpNum, 100+bmpNum, 0,0,0,0);

					if(!res || !res2)
					{
						// #BMPxxRs[
						char bmpxx[10];
						strncpy(bmpxx, str, 6);
						bmpxx[6]='\0';

						// ڍ׃G[擾
						string detailErr;
						GetDetailFileErr(fileName, detailErr);

						wsprintf(szErrTxt,"Line:%d %s(%s)ǂݍ߂܂\n%s", iLine, fileName, bmpxx, detailErr.c_str());

						fclose(fp);
						SetCurrentDirectory(szCurrentDir);
						return(FALSE);
					}
				}
			}

			/*
			#BGAn1 n2 x y tx ty ox oy
			̃f[^ŎgpgBGÄݒ肵܂B

			"n1"@01`ZẐRUii0`9AA`Zj܂B
			"n2"@04chŎw肳ꂽBMPuPOiŁv܂B
			"x,y"@BGÄw肷鍶̍Wx,yw肵܂B
			"tx,ty"@BGÄw肷E̍Wx,yw肵܂B
			"ox,oy"@ݒ肵BGÄ\Wx,yw肵܂B
			*/
			// 012345678901234567890123456789
			// #BGA01 01 192 112 448 368 0 0
			// #BGA01 1 192 112 448 368 0 0 // ɂ͂p^[
			if( _strnicmp(str,"#BGA",4) == 0 )
			{
				int num = Hex36ToInt(&str[4]);
				int res = sscanf(&str[7], "%d %d %d %d %d %d %d", &exbmp[num].num, &exbmp[num].x,  &exbmp[num].y,
																  &exbmp[num].tx,  &exbmp[num].ty,
																  &exbmp[num].ox,  &exbmp[num].oy);

				if(res!=7 || exbmp[num].tx < exbmp[num].x || exbmp[num].ty < exbmp[num].y)
				{
					// Error
					if(szErrTxt!=NULL)
					{
						char temp[10];
						strncpy(temp, str, 6); // #BGAn1Rs[
						temp[6]='\0';
						wsprintf(szErrTxt,"Line:%d %s̈sł", iLine, temp);
//						MessageBox(hmainwnd, szErrTxt, "RpCG[I",MB_OK);
					}
					fclose(fp);
					SetCurrentDirectory(szCurrentDir);
					return(FALSE);
				}
			}

			if( _strnicmp(str,"#BackBMP ",9) == 0 ) // Ⴂ܂()
			{
				if(opt.bBgAnime && bReadFiles)
				{
					if(dd.LoadBMP(33,SeekToChar(&str[9]),RGB(0,0,0)))
					{
						dd.DefSprite(33,33,0,0,0,0);
						if(pBMS!=NULL)
							pBMS->bgBMPNum = 33;
					}
					else
					{
						if(szErrTxt!=NULL)
						{
							wsprintf(szErrTxt,"Line:%d %s(#BackBMP)ǂݍ߂܂", iLine, SeekToChar(&str[9]));
//							MessageBox(hmainwnd, szErrTxt, "RpCG[I",MB_OK);
						}
						fclose(fp);
						SetCurrentDirectory(szCurrentDir);
						return(FALSE);
					}
				}
			}

			if( _strnicmp(str,"#CDDA ",6) == 0 ) // Ⴂ܂()
			{
				if(pBMS!=NULL)
					pBMS->CDtrack = atoi(&str[6]);
			}

			if( _strnicmp(str,"#RANDOM ",8) == 0 ) // 
			{
				rndVal = random(atoi(&str[8]))+1;
			}

			if( _strnicmp(str,"#IF ",4) == 0 ) // IF
			{
				if(rndVal!=-1)
				{
					if(rndVal == atoi(&str[4]) )
						bSkip = FALSE;
					else
						bSkip = TRUE;
				}
			}

			// YSK̗v]BBIvV "#ExpertGauge"
			if( _strnicmp(str,"#ExpertGauge",12) == 0 )
			{
				if(pBMS!=NULL)
					pBMS->gaugeMode	= GAUGE_EXPERT;
			}

			if( _strnicmp(str,"#StepFile ",10) == 0 && IsDDR() && bReadFiles) // // Nupʕʓǂ݂
			{
				if(	 _strnicmp(&str[10],"SB" ,2)==0 && dif == SINGLE+BASIC   ||
					 _strnicmp(&str[10],"SA" ,2)==0 && dif == SINGLE+ANOTHER ||
					 _strnicmp(&str[10],"SM" ,2)==0 && dif == SINGLE+MANIAC  ||

					 _strnicmp(&str[10],"CB" ,2)==0 && dif == COUPLE+BASIC   ||
					 _strnicmp(&str[10],"CA" ,2)==0 && dif == COUPLE+ANOTHER ||
					 _strnicmp(&str[10],"CM" ,2)==0 && dif == COUPLE+MANIAC  ||

					 _strnicmp(&str[10],"DB" ,2)==0 && dif == DOUBLE+BASIC   ||
					 _strnicmp(&str[10],"DA" ,2)==0 && dif == DOUBLE+ANOTHER ||
					 _strnicmp(&str[10],"DM" ,2)==0 && dif == DOUBLE+MANIAC	    )
				{

					char szPath[MAX_PATH];
					char szFile[MAX_PATH];

					GetFileName(szFile, &str[13]);
					GetPath(szPath, &str[13]);

					if(szPath[0]=='\0' || szPath[0]==' ')
					{
						szPath[0]='.';
						szPath[1]='\\';
						szPath[2]='\0';
					}

					char szErr[1024];
//					BMS dummy = *pBMS;
					if(!LoadBMS(szFile, szPath, szErr, pBMS, TRUE))//bReadFiles)) //szPath
					{
						if(szErrTxt!=NULL)
						{
							strcpy(szErrTxt,szErr);
						}
						fclose(fp);
						SetCurrentDirectory(szCurrentDir);
						return(FALSE);
					}
					else
					{
/*						pBMS->Total[0] = dummy.Total[0];
						pBMS->Total[1] = dummy.Total[1];
						pBMS->notes[0] = dummy.notes[0];
						pBMS->notes[1] = dummy.notes[1];
						pBMS->Obj	   = dummy.Obj;
						pBMS->endPix   = dummy.endPix;
*/
/*						strcpy(pBMS->Genre, dummy.Genre);
						strcpy(pBMS->Title, dummy.Title);
						strcpy(pBMS->Artist, dummy.Artist);
						pBMS->Rank = dummy.Rank;
//						pBMS->bBMP = dummy.bBMP;
//						pBMS->bWavBGM = dummy.bWavBGM;
//						pBMS->bPlayable = dummy.bPlayable;
						pBMS->CDtrack	= dummy.CDtrack;
*/
						fclose(fp);
						SetCurrentDirectory(szCurrentDir);
						return(TRUE);
					}
				}

			}

			if(atoi(&str[1]) != 0)// && bReadFiles)// && str[6] == ':')// && bReadFiles) // atoilԂ(f[^) & ʒuɃR
			{
				char barNum[5];

				for(int i=0;i<3;i++)
					barNum[i]=str[1+i]; // ߔԍ()擾

				barNum[3] = '\0';
				int iBar = atoi(barNum); // 悤₭ɂȂ
				int iCh  = atoi(&str[4]); // `lԍBx͊y

//				char szTxt[50];
//				wsprintf(szTxt,"iBar = %d",iBar);
//				WriteLog(szTxt);

				if(iBar>maxBar)
					maxBar = iBar;

				if(iCh == 2) //[߂̒ZkiPOi^j] ꂾO
				{
					ShortBar[iBar] = atof(&str[7]);
					if(ShortBar[iBar] == 0.0)
						ShortBar[iBar] = 1.0;
//					char szTxt[50];
//					sprintf(szTxt,"Bar %d = %5.3f",iBar,atof(&str[7]) );
//					WriteLog(szTxt);

					goto exit; // :p
				}

				i=0;
				while(isalpha(str[7+i]) || isdigit(str[7+i])) // f[^̐𐔂
					i++;

				if(i%2 != 0) // 2̔{ɂȂĂȂ
				{
					if(!bReadFiles)
						goto exit; // ̍s͖BRpCG[ɂƃwb_ǂ߂ȂȂB

					char szErr[1024];	
					wsprintf(szErr,"Line:%d IuWFzu̕ɂȂĂ܂",iLine);
					WriteLog(szErr);
					WriteLog(str);
					Notice(szErr);
					dd.Flip();

					goto exit; // rۂȂ(^^;)
				}

				double iDiv = double(i)/2.0; //

				if(iDiv==0.0)
					goto exit; // ȂƎvB

				double iPixInc  = double(g_TimeBase) / iDiv; // 2oCgƂPixel
				double msInc = (60000.0 / (pBMS->BPM / 4.0))/double(iDiv);

//					char szTxt[50];
//					sprintf(szTxt,"iDiv = %d  iPixInc = %d",iDiv,iPixInc );
//					WriteLog(szTxt);

				double iPix = 0;
				double ms = 0;
				for(i=0;i<iDiv;i++)
				{
					int val;
					
					if(iCh==1 || iCh==4 || iCh==6 || iCh==7 || IN(iCh, 11, 19) || IN(iCh, 21, 29) || IN(iCh, 31, 39) || IN(iCh, 41, 49) || IsLongNote(iCh))
						val = Hex36ToInt(&str[7+i*2]);
					else
						val = HexToInt(&str[7+i*2]);

//					char szTxt[50];
//					sprintf(szTxt,"%d ",val );
//					WriteLog(szTxt);

					if(val!=0)
					{
						obj[Obj].dPixel		= iPix; // ł͏߂̓PixelɂĂ
						obj[Obj].dMS		= ms;	// 
						obj[Obj].iBar		= iBar; // ߒZk̂߂ɕۑƂ
						obj[Obj].iChannel	= iCh;

						// ȂłvalɂAǁ[channelŋʂ:p
						obj[Obj].iBPM		= val;
						obj[Obj].dLength	= val; // ƂŃe[upixelPʂɕϊ
						obj[Obj].iWaveCh	= val+100;
						obj[Obj].iBMPCh		= HexToInt(&str[7+i*2])+100; // val+100;
						obj[Obj].bmp.num	= Hex36ToInt(&str[7+i*2]); // #BGAxx

						//17,27:FreeSc͂܂ƂΉ
						// [hɂTotalNotěNoteArrangeŏ
						if(11<=iCh && iCh<=16 || 21<=iCh && iCh<=26)
						{
							obj[Obj].bDraw  = TRUE;
							obj[Obj].bJudge = TRUE;

							if(iCh<=16)
								notes[0]++; //1Pnotes++
							else
								notes[1]++; //2Pnotes++

						}

						if((IN(iCh,18,19)||IN(iCh,28,29)) ) //IsBM() && 
						{
							obj[Obj].bDraw  = TRUE;
							obj[Obj].bJudge = TRUE;

							if(iCh<=19)
								notes[0]++; //1Pnotes++
							else
								notes[1]++; //2Pnotes++
						}
					
						// LongNote
						if(IsLongNote(iCh))
						{

							if(iLongNoteObj[iCh-50]==-1)
							{
								// start
								iLongNoteObj[iCh-50] = Obj;
								obj[Obj].bDraw  = TRUE;
								obj[Obj].bJudge = TRUE;
								obj[Obj].dLength = -1.0; // ƕ`FbNp

								if(Is1PLongNote(iCh))
									notes[0]++; //1Pnotes++
								else
									notes[1]++; //2Pnotes++
							}
							else
							{
								// end (#LNTYPE 1)
								obj[iLongNoteObj[iCh-50]].dLength = iPix; // ł͏߂̓PixelɂĂ
								obj[iLongNoteObj[iCh-50]].iBarEnd = iBar; // ߒZk̂߂ɕۑƂ
								iLongNoteObj[iCh-50] = -1;

								// Iʒu̓IuWFƂĈȂ
								// ŏI߈ʒumaxBar͍XVĂ
								obj[Obj].iChannel = 0;
							}

						}

//						if(opt.bAllow6 && (21<=iCh && iCh <= 26)) //6AllowȂ2P̓I[gvC
//							obj[Obj].bAutoPlay = TRUE;

						Obj++;

						if(Obj>=MAX_OBJ)
						{
							ReAllocOBJ();
							/*
							wsprintf(szErrTxt,"Line:%d Pȓ̃IuWF̐(%d)𒴂܂", iLine, MAX_OBJ);
							fclose(fp);
							SetCurrentDirectory(szCurrentDir);
							return(FALSE);
							*/
						}

					}//endof if val!=0

					iPix+=iPixInc;
					ms+=msInc;

				}//endof for i<iDiv

			}//endof f[^ǂݍ

		} //endof if(str[0]=='#')

	} //endof while(EOFɂ܂)


//	if(bReadFiles)
//	{
		maxBar++; // Ō̏߁{P

//		WriteLog("ߒZkvZ...");

//			Notice("EOF");

		// ߒZkvZɓꂽIuWFʒu & So on
		// ms̓e|`FWlĂȂ̂ŎgȂ(
		for(int j=0;j<Obj;j++)
		{
			double Pix = 0.0;
			double ms = 0.0;

			for(int i=0;i<obj[j].iBar;i++)
			{
				Pix += double(g_TimeBase) * ShortBar[i]; // ߂̎n߂Pixel̎Zo
				ms += ( 60000.0 / (pBMS->BPM/4.0) ) * ShortBar[i];		 // ~b
			}

			// OfAj炵B̎_Ȃobj[j].dPixel͏߂̓̒Ȃ̂ŌvZ₷
			double glid;
			if(8.0*ShortBar[i]==0.0) // 0Z΍
				glid = double(g_TimeBase)/8.0;
			else
				glid = double(g_TimeBase)/(8.0*ShortBar[i]); // 8̈ʒu

			// }1.0ȓȂ͉̂Z덷΍BĂP256PixelTimeBaseIɂ낵Ȃc
			if(fmod(obj[j].dPixel,glid*2.0) < 1.0 ||
			   fmod(obj[j].dPixel,glid*2.0) > glid*2.0-1.0) // OfAj炵
				obj[j].iAnime = 6; // 4
			else
			{
				if(fmod(obj[j].dPixel,glid) < 1.0 ||
				   fmod(obj[j].dPixel,glid) > glid-1.0) // OfAj炵
					obj[j].iAnime = 12; // 8
				else
					if(fmod(obj[j].dPixel,glid/2.0) < 1.0 ||
					   fmod(obj[j].dPixel,glid/2.0) > glid/2.0-1.0) // OfAj炵
						obj[j].iAnime = 9; // 16
					else
						obj[j].iAnime = 3; // ȊO
			}

			obj[j].dPixel = Pix + obj[j].dPixel * ShortBar[obj[j].iBar]; // ۂPixel
			obj[j].dMS    = ms  + obj[j].dMS    * ShortBar[obj[j].iBar];

			// Om[g̏IʒuZo
			if(IsLongNote(obj[j].iChannel))
			{
				if(obj[j].dLength==-1.0)
				{
					// Om[gIĂȂ
					wsprintf(szErrTxt,"Om[g(Ch.%d)̏Iʒu܂", obj[j].iChannel);
					fclose(fp);
					SetCurrentDirectory(szCurrentDir);
					return(FALSE);
				}

				double Pix = 0.0;
				double ms = 0.0;
				for(int i=0;i<obj[j].iBarEnd;i++)
				{
					Pix += double(g_TimeBase) * ShortBar[i]; // ߂̎n߂Pixel̎Zo
					ms += ( 60000.0 / (pBMS->BPM/4.0) ) * ShortBar[i];		 // ~b
				}
				obj[j].dLength = (Pix + obj[j].dLength * ShortBar[obj[j].iBarEnd]) - obj[j].dPixel; // Iʒu - Jnʒu
				obj[j].dLength = ceil(obj[j].dLength); // ؂グƂȂƖ̍Ō̂PH
			}

			if(IsBM() && IN(obj[j].iChannel,21,22) && bUrami && opt.bUrami) // ݂f[^Ή
			{
				obj[j].iChannel-=3;
				pBMS->Player = 1;
				notes[0]++; //1Pnotes++
				notes[1]--; //2Pnotes--
			}

			if(IsBM() && obj[j].iChannel==26 && bUrami && opt.bUrami) // ݂f[^Ή
			{
				obj[j].iChannel = 0; // 
				notes[1]--; //2Pnotes--
			}

			int iCh = obj[j].iChannel;
			if(iCh==1 && pBMS->Wav[obj[j].iWaveCh-100][0]!='\0')
				pBMS->bWavBGM = TRUE;

			if( (IN(iCh,11,16) || IN(iCh,18,19) || IN(iCh,21,26) || IN(iCh,28,29)) && pBMS->Wav[obj[j].iWaveCh-100][0]!='\0')
				pBMS->bPlayable = TRUE;

			// Ch08pBPM̓e[uT
			if(iCh==8)
			{
				obj[j].iChannel = 3; // ʏ̃e|`FWƂ܂Ƃ߂ď
				obj[j].iBPM	= dBPMtbl[int(obj[j].iBPM)];
			}

			// #BGA̒lۑ
			if(iCh==4 || iCh==6 || iCh==7)
			{
				int i = obj[j].bmp.num;
				if(exbmp[i].num!=-1)
				{
//					int bmpnum = obj[j].iBMPCh-100;
					obj[j].bmp = exbmp[i]; // #BGA`Ȃobj[j].bmp.num==-1Ȃ̂Ŏs͂ē
				}
				else
				{
					obj[j].bmp.num = -1;
				}
			}

			// V[PX~
			if(iCh==CH_STOP)
			{
				int val = iStopTime[int(obj[j].dLength)];
				obj[j].dLength = double(g_TimeBase) * double(val) / 192.0;
			}

		}//endof for(int j=0;j<Obj;j++)

		// d`nގ
		for(j=0;j<Obj;j++)
		{
			int ch = obj[j].iChannel;

			// IuWFAobNR[X͋CɂȂ
			if(ch==0 || ch==1)
				continue;

			// ʒũIuWF͌낪D
			// Ȃ蓪̈[vcx͖ɂȂ炵BPbȂ
			for(int k=j+1;k<Obj;k++)
			{
				// ʂɏd
				if(obj[j].dPixel==obj[k].dPixel && obj[k].iChannel==ch)
				{
					WriteLog("LoadBMS() : d`̃IuWF(Ch = %d, Pix = %lf, Bar = %d)폜܂", obj[j].iChannel, obj[j].dPixel, obj[j].iBar);

					obj[j].iChannel = 0; // O폜
					if(Is1PNote(ch)) notes[0]--;
					if(Is2PNote(ch)) notes[1]--;
					if(Is1PLongNote(ch)) notes[0]--;
					if(Is2PLongNote(ch)) notes[1]--;
					
					break; // Ƃ΂RȏdĂĂm[g]vɌ炳Ȃ
				}
			}

			// Om[g̒ɂm[gr
			// Om[gƒʏIuWF̊JnʒuAIʒudꍇAO֌WȂɃOm[gD
			// Om[gƃOm[gdꍇAɎn܂ĂD
			if(IsLongNote(ch))
			{
				double start = obj[j].dPixel;
				double end = obj[j].dPixel + obj[j].dLength;

				// BMSŃOm[gɍ폜ׂIuWF`Ă悤ɁAOT[`
				for(int k=0;k<Obj;k++)
				{
					if(k==j) continue; // IuWFmr܂

					if(IN(obj[k].dPixel, start, end))
					{
						if(obj[k].iChannel==ch-40)
						{
							// Om[g̒̒ʏm[g
							if(Is1PNote(obj[k].iChannel)) notes[0]--;
							if(Is2PNote(obj[k].iChannel)) notes[1]--;

							WriteLog("LoadBMS() : Om[g̒̃IuWF(Ch = %d, Pix = %lf, Bar = %d)폜܂", obj[k].iChannel, obj[k].dPixel, obj[k].iBar);
							obj[k].iChannel = 0; // 
						}
						else if(obj[k].iChannel==ch)
						{
							// Om[g̒̃Om[g
							if(Is1PLongNote(obj[k].iChannel)) notes[0]--;
							if(Is2PLongNote(obj[k].iChannel)) notes[1]--;

							WriteLog("LoadBMS() : Om[g̒̃Om[g(Ch = %d, Pix = %lf, Bar = %d)폜܂", obj[k].iChannel, obj[k].dPixel, obj[k].iBar);
							obj[k].iChannel = 0; // 
						}
					}
				}
			}

		}

//		WriteLog("ߐObjݒ蒆...");

		if(Obj + maxBar+2 > MAX_OBJ)
		{
			// ߐ܂߂ƃIuWF𒴂
			while(Obj + maxBar+2 > MAX_OBJ)
				ReAllocOBJ();

			/*
			wsprintf(szErrTxt,"ߐIuWF̒ǉɂPȓ̃IuWF̐(%d)𒴂܂", MAX_OBJ);
			fclose(fp);
			SetCurrentDirectory(szCurrentDir);
			return(FALSE);
			*/
		}

		double dPix = 0.0;
		double ms = 0.0;
		for(i=0;i<=maxBar+1;i++) //ߐObj̒`
		{
			obj[Obj+i].iChannel = 2; //ߐ
			obj[Obj+i].dPixel   = dPix;
			obj[Obj+i].dMS		= ms;
			obj[Obj+i].iBar		= i;
			obj[Obj+i].bDraw	= TRUE;
			obj[Obj+i].bIsPlayed= FALSE;
			dPix += (double(g_TimeBase) * ShortBar[i]); // ߂̎n߂Pixel̎Zo
			ms += ( 60000.0 / (pBMS->BPM/4.0) ) * ShortBar[i];		 // ~b
		}
		Obj += maxBar+2;

//		WriteLog("Obj\[g...");

		// IuWFdPixelchɃ\[g
		// NoteArrangeƃ`lɂȂȂƂ邯ǁcɉeȂ͂
		qsort(obj,Obj,sizeof(tagObj),compare);

//		for(i=0;i<Obj;i++)
//		{
//			char szTxt[1024];
//			sprintf(szTxt,"obj[%d].dMS = %f",i,obj[i].dMS);
//			WriteLog(szTxt);
//		}
//		WriteLog("");

//		pd.endPix		  = iPix;
//		pd.totalNote[0] = notes[0];
//		pd.totalNote[1] = notes[1];
//		pd.totalObj	  = Obj;
	
		pBMS->notes[0] = notes[0];
		pBMS->notes[1] = notes[1];
		pBMS->endPix   = (int)dPix + int(double(g_TimeBase)*END_DELAY); //END_DELAYߕx点
		pBMS->Obj      = Obj;

		// IԌvZ
		double pix = 0;
		pBMS->endms = 0;
		double bpm = pBMS->BPM;
		for(i=0;i<Obj;i++)
		{
			if(obj[i].iChannel==3)
			{
				double DpMS = bpm * double(g_TimeBase) / 240000.0;
				pBMS->endms += int((obj[i].dPixel-pix)/DpMS);
				pix = obj[i].dPixel;
				bpm = obj[i].iBPM;
			}

			if(obj[i].iChannel==CH_STOP && obj[i].dPixel>=pix)
			{
				double DpMS = bpm * double(g_TimeBase) / 240000.0;
				pd.endms += DWORD(obj[i].dLength/DpMS);
			}
		}
		double DpMS = bpm * double(g_TimeBase) / 240000.0;
		pBMS->endms += int((pBMS->endPix-pix)/DpMS);

//		char szTxt[1024];
//		sprintf(szTxt,"Obj = %d",Obj);
//		Notice(szTxt);

//		NoteArrange(Obj);

//	}//endof if(bReadFiles)

//	WriteLog("BMS Load Complete!");

	fclose(fp);

/*	for(i=0;i<MAX_OBJ;i++)
	{
		if(obj[i].iChannel==4)
		{
			WriteLog("obj[%d] : %lfpix (Bar:%d) BMPch:%d / %d (%d,%d)-(%d,%d) --> (%d,%d)", i, obj[i].dPixel, obj[i].iBar, obj[i].iBMPCh, obj[i].bmp.num,
																							obj[i].bmp.x, obj[i].bmp.y, obj[i].bmp.tx, obj[i].bmp.ty,
																							obj[i].bmp.ox, obj[i].bmp.oy);
		}
	}
*/
	// svt@C̉
	if(pBMS!=NULL)
	{
		for(int i=0;i<256;i++)
		{
			if(pBMS->BMP[i][0] == '\0')
				dd.UnLoadBMP(i+100);
		}

		for(i=0;i<MAX_WAVNUM;i++)
		{
			if(pBMS->Wav[i][0] == '\0')
				ds.ReleaseWave(i+100);
		}
	}

	if(!SetCurrentDirectory(szCurrentDir))
	{
		// DDR.exẽtH_ɖ߂ȂBȍ~SẴt@Cǂ߂ȂȂ
		if(szErrTxt!=NULL)
		{
			wsprintf(szErrTxt,"JgtH_ύXł܂`:%s",szCurrentDir);
		}
		WriteLog("LoadBMS() : JgtH_ɖ߂܂(%s) I܂", szCurrentDir);
		QuitGame(hmainwnd);
		return(FALSE);
	}

	if(bReadFiles)
		WriteLog("LoadBMS() : %s (%s)̓ǂݍݐ", szFileName, path);

	if(bStageFile)
	{
/*		CTimer door;
		// StageFilehAŉBI
		while(CloseDoor())
		{
			dd.Flip();
			if(opt.iDrawMethod==2) // DirectBltȂ
			{
				// Ȃ悤ԑ҂
				while(door.Get()<16);
				door.Reset();
			}
		}
*/
		CTimer stage;
		for(int i=0;i<SCR_H;i+=2)
		{
			dd.PrimaryWipeErase(i);
			
			GetKeyInfo();
			if(KEYPUSH(VK_OK)||KEYPUSH(VK_ESC))
			{
				dd.ClearScreen();
				dd.Flip();
				dd.ClearScreen();
				break;
			}

			// Ȃ悤ԑ҂
			while(stage.Get()<8);
			stage.Reset();
		}

		g_bDoorOpen = FALSE; // hA͊JȂ

//		dd.Flip();
//		Sleep(500); // d񂶂() ƎvǃXbvŏ邩炢B
	}
	else
	{
		g_bDoorOpen = TRUE;
	}

	return(TRUE);

}

// szFileNameǂݍ݁AsszErrTxtɃG[bZ[WԂB
// pBmsɂ낢ƕԂB
BOOL LoadBMSHeader(const char* szFileName, const char* path, char* szErrTxt, BMS* pBMS){

	if(pBMS==NULL || szErrTxt==NULL)
		return FALSE;

	ZERO(*pBMS);
	strcpy(pBMS->path, path);

	// tpX
	char file[MAX_PATH];
	strcpy(file,path);

	char* yen = strrchr(file, '\\');

	if(yen != NULL) // \ĂĂvI
	{
		if(yen[1] == '\0')
		  ;
		else
		  strcat(file, "\\");

	}else
		strcat(file, "\\");

	strcat(file,szFileName);

	// ǂł݂悤
	FILE* fp;
	fp = fopen(file,"r");

	if(fp == NULL)
	{
		wsprintf(szErrTxt,"%sJ܂`",file);
		WriteLog("LoadBMSHeader() : %sJ܂`",file);
		return(FALSE);
	}

	// for ch.08 extended BPM change
	double dBPMtbl[256];
	for(int i=0;i<256;i++)
	{
		dBPMtbl[i] = 130.0;
	}

	// ftHgl
	pBMS->Player	= 1;
	pBMS->Rank		= 2;
	pBMS->PlayLevel = 3;
	pBMS->VolWAV	= 100;
	pBMS->BPM		= 130.0;
	pBMS->MIDIFile[0] = '\0';
	pBMS->CDtrack	= -1;
	pBMS->bBMP		= FALSE;
	pBMS->bPlayable = FALSE;
	pBMS->bWavBGM	= FALSE;
	pBMS->Total[0]	= 0;
	pBMS->Total[1]	= 0;
	pBMS->bgBMPNum	= -1;
	pBMS->iBMLines  = 0; // 5line
	pBMS->iDDRLines = 0; // 4Arrow

	BOOL bWavUse[MAX_WAVNUM];
	for(i=0;i<MAX_WAVNUM;i++)
	{
		bWavUse[i] = FALSE;
	}

	char str[1024];

	int iLine = 0;
	int Obj = 0;
	int notes[2]={0,0};
	int maxBar = 0;

	BOOL bSkip = FALSE; // ifpXLbvtO
	int rndVal = -1;	// 
	BOOL bUrami = FALSE; // ݂f[^ϊp
	BOOL bStageFile = FALSE;

exit:

	while( GetLine(fp,str,1024) != 0) // EOFɂ܂ && feof(fp)==0
	{
		iLine++;

		if(str[0]=='#') // #̂ĂȂs͖
		{

			if( _strnicmp(str,"#STAGEFILE ",10) == 0 ) // StageFileT
			{
				if(str[11]=='\0')
					goto exit; // BMS Creator΍
				
				strncpy(pBMS->stageFile, SeekToChar(&str[10]), MAX_PATH);
				pBMS->stageFile[MAX_PATH-1] = '\0';
				Trim(pBMS->stageFile, strlen(pBMS->stageFile)); // 󔒂ĂꍇɑΏ

				if(strlen(pBMS->stageFile) != 0)
					pBMS->bStageFile = TRUE;
			}

			// #if𖳎ēǂݍޖ߂
			if( _strnicmp(str,"#PLAYER ",8) == 0 ) // vC[h̓ǂݍ
			{
				pBMS->Player = atoi(&str[8]);
				if(!IN(pBMS->Player, 1, 4))
					pBMS->Player = 1; // ͈͊O͂P
			}

			if( _strnicmp(str,"#GENRE ",7) == 0 ) // W̓ǂݍ
			{
				strcpy(pBMS->Genre, SeekToChar(&str[7]));
			}

			if( _strnicmp(str,"#TITLE ",7) == 0 ) // ^Cg̓ǂݍ
			{
				strcpy(pBMS->Title, SeekToChar(&str[7]));
			}

			if( _strnicmp(str,"#ARTIST ",8) == 0 ) // A[eBXg̓ǂݍ
			{
				strcpy(pBMS->Artist, SeekToChar(&str[8]));
			}

			if( _strnicmp(str,"#PLAYLEVEL ",11) == 0 ) // vCx̓ǂݍ
			{
				pBMS->PlayLevel = atoi(&str[11]);
			}

			if( _strnicmp(str,"#RANK ",6) == 0 ) // 胉N̓ǂݍ
			{
				pBMS->Rank = atoi(&str[6]);
			}

			if( _strnicmp(str,"#VOLWAV ",8) == 0 ) // WAVE{[̓ǂݍ
			{
				pBMS->VolWAV = atoi(&str[8]);
			}

			if( //_strnicmp(str,"// 2DX 1P Convert Header",24      ) == 0 ||
				//_strnicmp(str,"// substream 1P Convert Header",30) == 0 ||
				//_strnicmp(str,"// 2ndStyle 1P Convert Header",29 ) == 0 ||
				_strnicmp(str,"#ExtChr 730 -1 245 1 257 18 201 140",35) == 0  ||
				_strnicmp(str,"#ExtChr 774 -1 259 64 271 81 201 140",36) == 0 ||
				_strnicmp(str,"#ExtChr 780 -1 335 64 347 81 201 140",36) == 0 ||
				_strnicmp(str,"#ExtChr 779 -1 325 64 333 81 201 140",36) == 0 ||
				_strnicmp(str,"#ExtChr 745 -1 275 20 287 37 201 140",36) == 0 ||
				_strnicmp(str,"#ExtChr 771 -1 400 41 404 58 201 140",36) == 0 ||
				_strnicmp(str,"#ExtChr 760 -1 259 41 271 58 201 140",36) == 0 ||
				_strnicmp(str,"#ExtChr 784 -1 399 64 411 87 201 140",36) == 0    ) // ݃`FbN()
			{
				bUrami = TRUE;
			}

			if( _strnicmp(str,"#ENDIF",6) == 0 ) // ENDIF
			{
				bSkip = FALSE;
			}

			if(!bSkip) // #if̗LȖ߂
			{

				if( _strnicmp(str,"#BPM ",5) == 0 ) // BPM̓ǂݍ
				{
					pBMS->BPM = atof(&str[5]);
					if(pBMS->BPM<=0.0)
						pBMS->BPM = 130.0;
				}
				else if( _strnicmp(str,"#BPM",4) == 0 ) // Ch.08gBPM̓ǂݍ
				{
					double bpm = atof(&str[7]);
					if(bpm<=0.0)
						bpm = 130.0;

					dBPMtbl[ HexToInt(&str[4]) ] = bpm;
				}

				if( _strnicmp(str,"#MIDIFILE ",10) == 0 ) // MIDIt@C̓ǂݍ
				{
					strcpy(pBMS->MIDIFile, SeekToChar(&str[10]));
				}
							
				if( _strnicmp(str,"#TOTAL ",7) == 0 ) // Q[Wʂ̓ǂݍ
				{
					pBMS->Total[0] = atof(&str[7]);
					pBMS->Total[1] = atof(&str[7]);
				}

				if( _strnicmp(str,"#WAV",4) == 0 ) // WAVt@C̓ǂݍ
				{
					if(Hex36ToInt(&str[4]) < MAX_WAVNUM)
						bWavUse[ Hex36ToInt(&str[4]) ] = TRUE;
					else
					{
						// ߋ#WAVG0Ƃw肵Ăf[^₪c
						wsprintf(szErrTxt,"Line:%d #WAVxx̎w肪sł(xx = %c%c)", iLine, str[4], str[5]);
						fclose(fp);
						return(FALSE);
					}
				}

				if( _strnicmp(str,"#BMP",4) == 0 ) // BMPt@C̓ǂݍ
				{
					pBMS->bBMP = TRUE;
				}

	//			if( _strnicmp(str,"#BackBMP ",9) == 0 ) // Ⴂ܂()
	//				;

				if( _strnicmp(str,"#CDDA ",6) == 0 ) // Ⴂ܂()
				{
					pBMS->CDtrack = atoi(&str[6]);
				}

				if( _strnicmp(str,"#RANDOM ",8) == 0 ) // 
				{
					rndVal = random(atoi(&str[8]))+1;
				}

				if( _strnicmp(str,"#IF ",4) == 0 ) // IF
				{
					if(rndVal!=-1)
					{
						if(rndVal == atoi(&str[4]) )
							bSkip = FALSE;
						else
							bSkip = TRUE;
					}
				}

				if(atoi(&str[1]) != 0) // atoilԂ(f[^) & ʒuɃR
				{
					char barNum[5];

					for(int i=0;i<3;i++)
						barNum[i]=str[1+i]; // ߔԍ()擾

					barNum[3] = '\0';
					int iBar = atoi(barNum); // 悤₭ɂȂ
					int iCh  = atoi(&str[4]); // `lԍBx͊y

					if(iBar>maxBar)
						maxBar = iBar;

					if(iCh == 2) //[߂̒ZkiPOi^j] ꂾO
						goto exit; // :p

					i=0;
					while(isalpha(str[7+i]) || isdigit(str[7+i])) // f[^̐𐔂
						i++;

					if(i%2 != 0) // 2̔{ɂȂĂȂ
						goto exit; // ̍s͖BRpCG[ɂƃwb_ǂ߂ȂȂB

					double iDiv = double(i)/2.0; //

					if(iDiv==0.0)
						goto exit; // ȂƎvB

					double iPixInc  = double(g_TimeBase) / iDiv; // 2oCgƂPixel
					double msInc = (60000.0 / (pBMS->BPM / 4.0))/double(iDiv);

					double iPix = 0;
					double ms = 0;
					for(i=0;i<iDiv;i++)
					{
						int val;
						
						if(iCh==1 || IN(iCh, 11, 19) || IN(iCh, 21, 29) || IN(iCh, 31, 39) || IN(iCh, 41, 49))
							val = Hex36ToInt(&str[7+i*2]);
						else
							val = HexToInt(&str[7+i*2]);

						if(val!=0)
						{
							obj[Obj].dPixel		= iPix; // ł͏߂̓PixelɂĂ
							obj[Obj].dMS		= ms;	// 
							obj[Obj].iBar		= iBar; // ߒZk̂߂ɕۑƂ
							obj[Obj].iChannel	= iCh;

							// ȂłvalɂAǁ[channelŋʂ:p
							obj[Obj].iWaveCh	= val+100;
							obj[Obj].iBPM		= val;
							obj[Obj].iBMPCh		= val+100;

							//17,27:FreeSc͂܂ƂΉ
							if(11<=iCh && iCh<=16 || 21<=iCh && iCh<=26)
							{
								obj[Obj].bDraw  = TRUE;
								obj[Obj].bJudge = TRUE;

								if(iCh<=16)
									notes[0]++; //1Pnotes++
								else
									notes[1]++; //2Pnotes++

							}

							if((IN(iCh,18,19)||IN(iCh,28,29)) ) //IsBM() && 
							{
								obj[Obj].bDraw  = TRUE;
								obj[Obj].bJudge = TRUE;

								if(iCh<=19)
									notes[0]++; //1Pnotes++
								else
									notes[1]++; //2Pnotes++
							}

							Obj++;

							if(Obj>=MAX_OBJ)
							{
								ReAllocOBJ();

								/*
								wsprintf(szErrTxt,"Line:%d Pȓ̃IuWF̐(%d)𒴂܂", iLine, MAX_OBJ);
								fclose(fp);
								return(FALSE);
								*/
							}

						}//endof if val!=0

						iPix+=iPixInc;
						ms+=msInc;

					}//endof for i<iDiv

				}//endof f[^ǂݍ

			} //endof if(!bSkip)

		} //endof if(str[0]=='#')

	} //endof while(EOFɂ܂)

	fclose(fp);

	maxBar++; // Ō̏߁{P

	// ߒZkvZɓꂽIuWFʒu & So on
	// ms̓e|`FWlĂȂ̂ŎgȂ(
	for(int j=0;j<Obj;j++)
	{
		double Pix = 0.0;
		double ms = 0.0;

		if(IsBM() && IN(obj[j].iChannel,21,22) && bUrami && opt.bUrami) // ݂f[^Ή
		{
			obj[j].iChannel-=3;
			pBMS->Player = 1;
			notes[0]++; //1Pnotes++
			notes[1]--; //2Pnotes--
		}

		if(IsBM() && obj[j].iChannel==26 && bUrami && opt.bUrami) // ݂f[^Ή
		{
			obj[j].iChannel = 0; // 
			notes[1]--; //2Pnotes--
		}

		int iCh = obj[j].iChannel;
		if(iCh==1 && bWavUse[obj[j].iWaveCh-100])
			pBMS->bWavBGM = TRUE;

		if( (IN(iCh,11,16) || IN(iCh,18,19) || IN(iCh,21,26) || IN(iCh,28,29)) && bWavUse[obj[j].iWaveCh-100])
			pBMS->bPlayable = TRUE;

		if(IN(iCh,18,19) || IN(iCh,28,29))
			pBMS->iBMLines = 1; // 7line

		if(iCh==12 || iCh==14 || iCh==22 || iCh==24)
			pBMS->iDDRLines = 1; // 6Arrow

		// Ch08pBPM̓e[uT
		if(iCh==8)
		{
			obj[j].iChannel = 3; // ʏ̃e|`FWƂ܂Ƃ߂ď
			obj[j].iBPM	= dBPMtbl[int(obj[j].iBPM)];
		}

	}//endof for(int j=0;j<Obj;j++)

	pBMS->notes[0] = notes[0];
	pBMS->notes[1] = notes[1];
//	pBMS->endPix   = (int)dPix + int(double(g_TimeBase)*END_DELAY); //END_DELAYߕx点
	pBMS->Obj      = Obj;
	pBMS->endms	   = 0;

	return(TRUE);

}

void NoteArrangeShuffle(tagObj& obj, int (&dLongNoteEndPix)[20], int (&dInvisibleNotePix)[20])
{
	// More Shufflȅ
	// sNZʒuɂق̃IuWFƏdȂȂ悤ɂ邩
	// ₽珈Gc

	// VbtΏۃ`l̃e[uƂ̗vf
	int chTbl[10], chTblNum;

	if(IsBM())
	{
		if(opt.iMode==MD_BM_5)
		{
			// 5Key[hȂ5Key͈݂͂̂ŃVbt
			chTbl[0] = 11; chTbl[1] = 12; chTbl[2] = 13; chTbl[3] = 14; chTbl[4] = 15;
			chTblNum = 5;
		}
		else
		{
			// 7Key
			chTbl[0] = 11; chTbl[1] = 12; chTbl[2] = 13; chTbl[3] = 14; chTbl[4] = 15;
			chTbl[5] = 18; chTbl[6] = 19;
			chTblNum = 7;
		}
	}
	else
	{
		// DDR
		if(opt.bAllow6)
		{
			// 6-Arrow
			chTbl[0] = 11; chTbl[1] = 12; chTbl[2] = 13; chTbl[3] = 14; chTbl[4] = 15; chTbl[5] = 16;
			chTblNum = 6;
		}
		else
		{
			// 4-Arrow
			chTbl[0] = 11; chTbl[1] = 13; chTbl[2] = 15; chTbl[3] = 16;
			chTblNum = 4;
		}
	}

	// VbtΏۂ`FbN
	// łɃIuWF1P̂2P̂`FbN
	int chOffset = -1; // 1PIuWFȂ0, 2PIuWFȂ10
	{
		for(int i=0;i<=10;i+=10)
		{
			for(int j=0;j<chTblNum;j++)
			{
				if(obj.iChannel==chTbl[j]+i    || // Normal note
				   obj.iChannel==chTbl[j]+i+20 || // Invisible note
				   obj.iChannel==chTbl[j]+i+40)   // LongNote
				{
					chOffset = i;
				}
			}
		}

		if(chOffset==-1)
			return; // VbtΏۊO
	}

	// 󂫃Xy[X`FbN
	{
		BOOL check = TRUE;

		if(IsInvisibleNote(obj.iChannel))
		{
			for(int k=0;k<chTblNum;k++)
				check &= (int(obj.dPixel) == dInvisibleNotePix[chTbl[k]+chOffset-10]);
		}
		else
		{
			for(int k=0;k<chTblNum;k++)
				check &= (int(obj.dPixel) <= dLongNoteEndPix[chTbl[k]+chOffset-10]);
		}

		if(check)
		{
			// S܂ĂXLbv([vh~)
			// IuWF̏d`ƂȂƂ蓾Ȃǁc
			WriteLog("NoteArrange() : obj (Ch = %d, Pix = %lf, Bar = %d)őS`l܂Ă܂",
			         obj.iChannel, obj.dPixel, obj.iBar);
			obj.iChannel = 0; // 
			assert(0);
			return;
		}
	}

	// Vbt
	if(IsVisibleNote(obj.iChannel))
	{
		// ʏIuWF
		do{
			obj.iChannel = chTbl[random(chTblNum)] + chOffset; // _ňړ挈
		}while(int(obj.dPixel) <= dLongNoteEndPix[obj.iChannel-10]); // ɔzuĂ瑼̏ꏊ

		dLongNoteEndPix[obj.iChannel-10] = int(obj.dPixel);
	}
	else if(IsInvisibleNote(obj.iChannel))
	{
		// sIuWF
		do{
			obj.iChannel = chTbl[random(chTblNum)] + 20 + chOffset; // _ňړ挈
		}while(int(obj.dPixel) == dInvisibleNotePix[obj.iChannel-30]); // ɔzuĂ瑼̏ꏊ

		dInvisibleNotePix[obj.iChannel-30] = int(obj.dPixel);
	}
	else if(IsLongNote(obj.iChannel))
	{
		// Om[g
		do{
			obj.iChannel = chTbl[random(chTblNum)] + 40 + chOffset; // _ňړ挈
		}while(int(obj.dPixel) <= dLongNoteEndPix[obj.iChannel-50]); // ɔzuĂ瑼̏ꏊ

		// ؂グƂȂƏIʒuɒʏIuWFdȂĂH
		dLongNoteEndPix[obj.iChannel-50] = (int)ceil(obj.dPixel + obj.dLength);
	}
}

void NoteArrangeMirror(tagObj& obj)
{
	vector<int> swapTblA, swapTblB;

	if(IsDDR())
	{
		// DDR
		if(!opt.bAllow6)
		{
			// 4-Arrow
			if(IsDouble())
			{
				// (11,13,15,16, 21,23,25,26) -> (26,25,23,21, 16,15,13,11)
				swapTblA.push_back(11); swapTblB.push_back(26);
				swapTblA.push_back(13); swapTblB.push_back(25);
				swapTblA.push_back(15); swapTblB.push_back(23);
				swapTblA.push_back(16); swapTblB.push_back(21);
			}
			else
			{
				// 1P : (11,13,15,16) -> (16,15,13,11)
				swapTblA.push_back(11); swapTblB.push_back(16);
				swapTblA.push_back(13); swapTblB.push_back(15);
			}
		}
		else
		{
			// 6-Arrow
			// (11,12,13,14,15,16) -> (16,15,14,13,12,11)
			swapTblA.push_back(11); swapTblB.push_back(16);
			swapTblA.push_back(12); swapTblB.push_back(15);
			swapTblA.push_back(13); swapTblB.push_back(14);
		}
	}
	else
	{
		// BM
		if(opt.iMode==MD_BM_5)
		{
			// 5Key͓ʈ
			if(IsDouble())
			{
				// (11,12,13,14,15, 21,22,23,24,25) -> (25,24,23,22,21, 15,14,13,12,11)
				swapTblA.push_back(11); swapTblB.push_back(25);
				swapTblA.push_back(12); swapTblB.push_back(24);
				swapTblA.push_back(13); swapTblB.push_back(23);
				swapTblA.push_back(14); swapTblB.push_back(22);
				swapTblA.push_back(15); swapTblB.push_back(21);
			}
			else
			{
				// 1P : (11,12,13,14,15) -> (15,14,13,12,11)
				swapTblA.push_back(11); swapTblB.push_back(15);
				swapTblA.push_back(12); swapTblB.push_back(14);
			}
		}
		else
		{
			// 7Key
			if(IsDouble())
			{
				// (11,12,13,14,15,18,19, 21,22,23,24,25,28,29) -> (29,28,25,24,23,22,21, 19,18,15,14,13,12,11)
				swapTblA.push_back(11); swapTblB.push_back(29);
				swapTblA.push_back(12); swapTblB.push_back(28);
				swapTblA.push_back(13); swapTblB.push_back(25);
				swapTblA.push_back(14); swapTblB.push_back(24);
				swapTblA.push_back(15); swapTblB.push_back(23);
				swapTblA.push_back(18); swapTblB.push_back(22);
				swapTblA.push_back(19); swapTblB.push_back(21);
			}
			else
			{
				// 1P : (11,12,13,14,15,18,19) -> (19,18,15,14,13,12,11)
				swapTblA.push_back(11); swapTblB.push_back(19);
				swapTblA.push_back(12); swapTblB.push_back(18);
				swapTblA.push_back(13); swapTblB.push_back(15);
			}
		}
	}

	int chInc, chMax;
	if((IsDDR() && opt.bAllow6) || IsDouble())
	{
		// LongNote : +20, Invisible : +40
		chInc = 20;
		chMax = 40;
	}
	else
	{
		// 2P : +10
		// Invisible 1P : +20, Invisible 2P : +30
		// LongNote 1P  : +40, LongNote 2P  : +50
		chInc = 10;
		chMax = 50;
	}

	// ꂽ[
	// 悤₭ۂ̓ւ
	assert(swapTblA.size() == swapTblB.size()); // Ô

	// SWAP͏ȃ}Nc
	// x̒laȂbɕςAbȂaɕςAȊOȂ牽Ȃ
	#define SWAP(x,a,b) ((x) = (x)==(a) ? (b) : (x)==(b) ? (a) : (x))

	for(int i=0 ; i<=chMax ; i+=chInc)
	{
		for(int j=0 ; j<(int)swapTblA.size() ; j++)
			SWAP(obj.iChannel, swapTblA[j]+i, swapTblB[j]+i);
	}

	// namespaceȂ
	#undef SWAP
}

// SHUFFLE炱Ȃ
void NoteArrange(int objNum)
{
	// [hʂŃCVbtp̃e[up
	int chTbl[20]; // 0`10͖gp
	for(int i=0;i<20;i++) chTbl[i] = i; // 

	if(IsBM())
	{
		// BM
		if(opt.iMode==MD_BM_5)
		{
			// 5Key͓ʂ5Keŷ݂ŃVbt
			BOOL bFlag[10] = { FALSE };

			for(int i=11;i<16;i++)
			{
				int ch1;
				do
				{
					ch1 = 11 + random(5);//15܂ł̗
				} while(bFlag[ch1-10]==TRUE);

				chTbl[i] = ch1;
				bFlag[ch1-10] = TRUE;
			}
		}
		else
		{
			// 7or4Key
			BOOL bFlag[10] = { FALSE };

			for(int i=11;i<20;i++)
			{
				if(i==16)
				{
					i = 17;
					continue;
				}

				int ch1;
				do
				{
					ch1 = 11 + random(7);//17܂ł̗
					if(IN(ch1,16,17)) ch1+=2;//16,17=ScȂ18,19
				} while(bFlag[ch1-10]==TRUE);

				chTbl[i] = ch1;
				bFlag[ch1-10] = TRUE;
			}
		}
	}

	if(IsDDR() && opt.bAllow6)
	{
		// 6Arrow
		BOOL bFlag[10] = { FALSE };

		for(int i=11;i<17;i++)
		{
			int ch1;
			do
			{
				ch1 = 11 + random(6); //16܂ł̗
			} while(bFlag[ch1-10]==TRUE);

			chTbl[i] = ch1;
			bFlag[ch1-10] = TRUE;
		}
	}

	if(IsDDR() && !opt.bAllow6)
	{
		// 4Arrow
		BOOL bFlag[10] = { FALSE };
		int ch[] = { 11, 13, 15, 16 };

		for(int i=0;i<4;i++)
		{
			int ch1;
			do
			{
				ch1 = ch[random(4)]; //16܂ł̗
			} while(bFlag[ch1-10]==TRUE);

			chTbl[ch[i]] = ch1;
			bFlag[ch1-10] = TRUE;
		}
	}

	// More ShufflȅdȂh~p
	// double oldPix = -1.0;
	int dLongNoteEndPix[20]; // Om[g̏IʒuBY̓`l-50
	for(int i=0;i<20;i++)
		dLongNoteEndPix[i] = -1;

	int dInvisibleNotePix[20]; // sm[g݂̑ʒuBY̓`l-30
	for(int i=0;i<20;i++)
		dInvisibleNotePix[i] = -1;

	for(int i=0;i<objNum;i++)
	{
		if(!IsNote(obj[i].iChannel))
			continue; // `lH͑ΏۊO
			
		if(obj[i].iAnime!=6 && opt.iLittle == LT_MINIMUM ||
			obj[i].iAnime!=6 && obj[i].iAnime!=12 && opt.iLittle == LT_LITTLE ) // Little
		{
			obj[i].bDraw  = FALSE;
			obj[i].bJudge = FALSE;
			obj[i].bAutoPlay = TRUE;

			if(Is1PNote(obj[i].iChannel))
				pd.totalNote[0]--; //1Pnotes--

			if(Is2PNote(obj[i].iChannel))
				pd.totalNote[1]--; //2Pnotes--

			continue; // LittleŌ炵A4KeyȂǂłQdɌ炷̂h
		}

		if(opt.iNArrange == NA_SHUFFLE)
			NoteArrangeShuffle(obj[i], dLongNoteEndPix, dInvisibleNotePix);

		if(opt.iNArrange == NA_MIRROR)
			NoteArrangeMirror(obj[i]);

		if(opt.iNArrange == NA_LINESHUFFLE)
		{
			// ݂̃[hŎgȂ`lchTblVbtȂ̂Ń`FbNsv
			// XNb`̃`lchTblςȂ̂œl
			if(Is1PNote(obj[i].iChannel))
				obj[i].iChannel = chTbl[obj[i].iChannel]; // 1P

			if(Is2PNote(obj[i].iChannel))
				obj[i].iChannel = chTbl[obj[i].iChannel-10] + 10; // 2P

			if(Is1PInvisibleNote(obj[i].iChannel))
				obj[i].iChannel = chTbl[obj[i].iChannel-20] + 20; // 1P Invisible

			if(Is2PInvisibleNote(obj[i].iChannel))
				obj[i].iChannel = chTbl[obj[i].iChannel-30] + 30; // 2P Invisible

			if(Is1PLongNote(obj[i].iChannel))
				obj[i].iChannel = chTbl[obj[i].iChannel-40] + 40; // 1P LongNote
			
			if(Is2PLongNote(obj[i].iChannel))
				obj[i].iChannel = chTbl[obj[i].iChannel-50] + 50; // 2P LongNote
		}

		int iCh = obj[i].iChannel;
		if(IsDDR() && !opt.bAllow6 && (iCh == 12 || iCh ==14 || IN(iCh,18,19)) ) //4AllowȂ(1P)&6,7̓I[gvCnotes--
			obj[i].bAutoPlay = TRUE, pd.totalNote[0]--;

		if(IsDDR() && !opt.bAllow6 && (iCh == 22 || iCh ==24 || IN(iCh,28,29)) ) //4AllowȂ(2P)&6,7̓I[gvCnotes--
			obj[i].bAutoPlay = TRUE, pd.totalNote[1]--;

		if(IsDDR() && opt.bAllow6 && IN(iCh,18,19) ) //6AllowȂ(1P)6,7̓I[gvCnotes--
			obj[i].bAutoPlay = TRUE, pd.totalNote[0]--;

		if(IsDDR() && opt.bAllow6 && IN(iCh,28,29) ) //6AllowȂ(2P)6,7̓I[gvCnotes--
			obj[i].bAutoPlay = TRUE, pd.totalNote[1]--;

		if(opt.iMode==MD_BM_4 && (iCh==12||iCh==14||iCh==18)) // AUTOPLAY PART 1P (4-Line)
		{
			obj[i].bAutoPlay = TRUE;
			pd.totalNote[0]--;
		}

		if(opt.iMode==MD_BM_4 && (iCh==22||iCh==24||iCh==28)) // AUTOPLAY PART 2P (4-Line)
		{
			obj[i].bAutoPlay = TRUE;
			pd.totalNote[1]--;
		}

		if(opt.iMode==MD_BM_5 && (iCh==18||iCh==19)) // AUTOPLAY PART 1P (5-Line)
		{
			obj[i].bAutoPlay = TRUE;
			pd.totalNote[0]--;
		}

		if(opt.iMode==MD_BM_5 && (iCh==28||iCh==29)) // AUTOPLAY PART 2P (5-Line)
		{
			obj[i].bAutoPlay = TRUE;
			pd.totalNote[1]--;
		}

		if(IsBM() && Is1PLongNote(iCh)) // łBM[h̓Om[gΉ
		{
			obj[i].bAutoPlay = TRUE;
			pd.totalNote[0]--;
		}

		if(IsBM() && Is2PLongNote(iCh))
		{
			obj[i].bAutoPlay = TRUE;
			pd.totalNote[1]--;
		}

	}//endof for(int i=0;i<objNum;i++)

}

// t@CsStrɊi[B̕Ԃ
// max𒴂EOFɂĂԂ
int GetLine(FILE* fp, char* str, int max){

 //	if(ftell(fp) == -1L)
//		return(0); // t@Č݈ʒu擾łȂ(NULL`FbN˂)

	if(fp==NULL || str==NULL)
		return(0);

	int i=0;
	int ch = fgetc(fp);

	if(ch==EOF)
		return(0);

	str[i] = ch;

	while(str[i]!='\n' && str[i]!='\r' && str[i]!=EOF && i<max-1)
	{
		i++;
		str[i] = fgetc(fp);
	}

	if(str[0]=='\n' || str[0]=='\r'){ // (1ڂs)
		str[0] = '\0';
		return(1);
	}

//	long pos = ftell(fp);
//	if(fgetc(fp)=='')

	str[i] = '\0';

	return(i);

}

// ݈ʒucEnd܂ł̕StrɊi[B̕Ԃ
// EOFɂA0Ԃ(t@C|C^͌ɖ߂)
int GetStr(FILE* fp, char* Str, char cEnd){

	long defpos = ftell(fp);

	if(defpos == -1L){
		Str[0]='\0';
		return(0); // t@Č݈ʒu擾łȂ
	}

	int i=0;

	Str[i]=fgetc(fp);

	if(Str[i]==EOF){
		Str[0]='\0';
		fseek(fp,defpos,SEEK_SET); //ʒuɖ߂
		return(0);
	}

	while(cEnd != Str[i]){
		i++;
		Str[i]=fgetc(fp);
		if(Str[i]==EOF){
			Str[0]='\0';
			fseek(fp,defpos,SEEK_SET); //ʒuɖ߂
			return(0);
		}
	}

	Str[++i]='\0';

/*	char buf[1024];
	wsprintf(buf,"GetStr() OK! Str=%s",Str);
	WriteLog(buf);
*/
	return(i);

}

// 󔒂ǂݔ΂
char* SeekToChar(char* pChar){

	while( (*pChar)==' ' )// || iscntrl(*pChar))
		pChar++;

	return(pChar);

}

// cEnd܂fpi߂
// sfpɖ߂FALSE
BOOL SeekTo(FILE* fp,char cEnd){

	long posBef,posInit;
	char cGet;

	posInit = ftell(fp);
	if(posInit == -1L)
		return(FALSE);
	
	posBef = ftell(fp);
	if(posBef == -1L)
		return(FALSE);

	cGet = fgetc(fp);

	if(cGet == EOF){
		fseek(fp,posInit,SEEK_SET);
		return(FALSE);
	}

	while(cGet != cEnd) // fpcEnd܂Ői߂
	{
		posBef = ftell(fp);
		if(posBef == -1L){
			fseek(fp,posInit,SEEK_SET);
			return(FALSE);
		}

		cGet = fgetc(fp);
		if(cGet == EOF){
			fseek(fp,posInit,SEEK_SET);
			return(FALSE);
		}
	}

	fseek(fp,posBef,SEEK_SET); // cEndɃ|C^킹

//	WriteLog("SeekTo() OK!");

	return(TRUE);

}

// str1str2܂܂Ȃ炻̈ʒuA܂܂ȂNULLԂ
char* strmatch(char* str, char* str2){

//	printf("compare %s,%s\n",str,str2);

	while(*str != '\0')
	{
		if(_strnicmp(str, str2,strlen(str2))==0)
			return str;

		str++;
	}

	return NULL;
}

// BMSABG-BMPSysRAMɈړāAw肳ꂽKBVRAM󂯂܂B
// Ȋ֐Ȃ()
void AllocVRAM(int iKB){

	int iBytes = 0;

	for(int i=100;i<=355;i++)
	{
		iBytes += dd.MoveTo(i,FALSE);

		if(iBytes >= iKB*1024)
			return;
	}

	iBytes += dd.MoveTo(32, FALSE);
	if(iBytes >= iKB*1024)
		return;

	iBytes += dd.MoveTo(33, FALSE);
	// ܂ŗKvʊmۂłĂȂȂB

}

// ̍Ō̃Xy[X菜
void Trim(char* buf, int bytes){

	char* pCh = buf + (bytes-1);

	int i=0;
	while( i<=bytes && (*pCh==' ' || *pCh==0x20 || *pCh=='\t') )
	{
		*pCh = '\0';
		pCh--;
		i++;
	}

}

// 0.34bȑOKeycfg.datɃo[Wǉ
// ɂΉȂ
void KeycfgDataAddVersion(void){

	FILE* fp = fopen(keycfg.GetCfgFile(), "r");

	if(fp==NULL) return;

	int dummy[8];
	int num = fscanf(fp, "%d %d %d %d %d %d %d %d", &dummy[0], &dummy[1], &dummy[2], &dummy[3], &dummy[4], &dummy[5], &dummy[6], &dummy[7]);

	if(num!=8)
	{
		fclose(fp);
		return; // łɃo[W
	}

	fseek(fp, 0, SEEK_SET);

	// f[^obNAbv
	char buf[8192]; buf[0]=0;
	int i=0, check=0;

	buf[i] = check = fgetc(fp);
	while(check!=EOF)
	{
		i++;
		buf[i] = check = fgetc(fp);
	}

	fclose(fp); fp=NULL;

	fp = fopen("KeyCfg.dat", "w");
	if(fp==NULL) return;

	fprintf(fp, "%s", "DDR_Keycfg_034b\n");
	for(int j=0;j<i;j++)
		fputc(buf[j], fp);

	fclose(fp);

}

void GetLastErrorStr(char* str){

	FormatMessage( 

		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,

		NULL,

		GetLastError(),

		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // ftHg

		(LPTSTR)str,

		1024,

		NULL 

	);

	//ŕKvɉ lpMsgBuf Ɋւ鏈s
	// ...
	while(*str!='\0')
	{
		if(*str=='\n' || *str=='\r') *str = '\0';
		str++;
	}

	return;

}

// OReport.log폜wb_
void InitReportLog(void){

	SetFileAttributes("Report.log", FILE_ATTRIBUTE_NORMAL);
	DeleteFile("Report.log");

	WriteLog("%s %s", lpszAppName, szVerStr);

	OSVERSIONINFO osinfo;
	ZERO(osinfo);
	osinfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	if(GetVersionEx(&osinfo))
	{
		char szOS[128];
		switch(osinfo.dwPlatformId)
		{
			case VER_PLATFORM_WIN32_WINDOWS:
			{
				if(osinfo.dwMinorVersion>=90)
					strcpy(szOS, "WindowsMe"); // Version 4.90
				else if(osinfo.dwMinorVersion>=10)
					strcpy(szOS, "Windows98"); // Version 4.10
				else
					strcpy(szOS, "Windows95"); // Version 4.00

				// Windows 95/98/Me: Identifies the build number of the operating system in the low-order word.
				// The high-order word contains the major and minor version numbers. 
				osinfo.dwBuildNumber = LOWORD(osinfo.dwBuildNumber);
				break;
			}

			case VER_PLATFORM_WIN32_NT:
			{
				if(osinfo.dwMajorVersion>=5)
				{
					if(osinfo.dwMinorVersion>=1)
						strcpy(szOS, "WindowsXP"); // (or Windows .NET Server) Version 5.1
					else
						strcpy(szOS, "Windows2000"); // Version 5.0
				}
				else
					strcpy(szOS, "WindowsNT");

				break;
			}

			case VER_PLATFORM_WIN32s:   strcpy(szOS, "Win32s");				break; // DirectX̂H
			default:					strcpy(szOS, "Unknown Windows");	break;
		}

		// szCSDVersion
		// Windows NT/2000/XP: Contains a null-terminated string, such as "Service Pack 3", that indicates the latest Service Pack installed on the system. If no Service Pack has been installed, the string is empty.
		// Windows 95/98/Me: Contains a null-terminated string that indicates additional version information. For example, " C" indicates Windows 95 OSR2 and " A" indicates Windows 98 Second Edition.
		// ]vȃXy[XĂ邱ƂB܂
		Trim(osinfo.szCSDVersion, strlen(osinfo.szCSDVersion));

		if(osinfo.szCSDVersion[0]=='\0')
			WriteLog("Running on %s Version %d.%d Build %d", szOS, osinfo.dwMajorVersion, osinfo.dwMinorVersion, osinfo.dwBuildNumber);
		else
			WriteLog("Running on %s Version %d.%d Build %d %s", szOS, osinfo.dwMajorVersion, osinfo.dwMinorVersion, osinfo.dwBuildNumber, osinfo.szCSDVersion);

		if(CCPUID::GetID()>=3)
		{
			WriteLog("MMX Supported. Using MMX Optimization");
		}
		else
		{
			WriteLog("MMX Unsupported.");
		}

	}
	else
	{
		WriteLog("OS̎擾Ɏs");
	}

}

// ʂ~߂(param==1) / ĊJ(param==0) / gO(param==2)
//#define SEQ_RESTART	0
//#define SEQ_PAUSE		1
//#define SEQ_TOGGLE	2
void PauseSequence(int param){

	if(param==SEQ_TOGGLE)
	{
		if(bPaused)
			param = SEQ_RESTART;
		else
			param = SEQ_PAUSE;
	}

	switch(param)
	{
	case SEQ_RESTART:
		{
			if(!bPaused)
				return;

			// ĊJ
			ds.RestartAll();
			if(g_lpPlayTime!=NULL)
				g_lpPlayTime->Restart();
			bPaused = FALSE;
			break;
		}

	case SEQ_PAUSE:
		{
			if(bPaused)
				return;

			// |[Y
			ds.PauseAll();
			if(g_lpPlayTime!=NULL)
				g_lpPlayTime->Pause();
			bPaused = TRUE;
			break;
		}
	}

}

// vkeykeyԖڂ̃L[̃ACR(24x16)`悷
void DrawKeyIcon(int x, int y, int vkey, int key){

/*

	// 710-854 : L[RtBOACR
*/

	int bmpnum = keycfg.GetKeyBMPNum(vkey, key);
	if(bmpnum==-1)
		return;

	// ACRwi
	dd.DrawSprite(710+bmpnum, x,y, 1.0, FALSE);

	// WCpbhԍƂAƂ
	int vkeynum = keycfg.GetVKey(vkey,key);
	if(vkeynum==-1)
		return; // ȂƎv

	int dev = vkeynum/256;
	int keynum = vkeynum%256;

	switch(dev)
	{
	case 0: break; // L[{[hBȂɂKvȂ
	case 1:
		{
			// MIDIBՂȂ特(C#5etc)`
			if(bmpnum==145)
			{
				// 890-896 : MIDICDEFGAB (13,2352)c7 5x6
				// 897     : MIDI (13,2412) 6x6
				// 900-910 : MIDIIN^[uԍ[0-10](7,2352)c11 5x6
				// MIDI`ʒu(7,8)
				int dx=7, dy=8;

				// K
				//			  h h#  # ~ t@	t@# \ \#  # V
				int tbl[] = {  0,  0, 1,  1, 2,   3,    3, 4,  4, 5,  5, 6};
				dd.DrawSprite(890+tbl[keynum%12] , x+dx, y+dy, 1.0, FALSE);
				dx+=5;

				// 
				if(keynum%12==1 || keynum%12==3 || keynum%12==6 || keynum%12==8 || keynum%12==10)
					dd.DrawSprite(897, x+dx, y+dy, 1.0, FALSE);
				dx+=6;

				// IN^[uԍ
				dd.DrawSprite(900+keynum/12, x+dx, y+dy, 1.0, FALSE);
			}

			break;
		}
		
	case 2:
	case 3:
		{
			// WCpbh
			// 870-884 : WCpbhԍ (19,2352)c15 5x6
			// WCpbhԍ`ʒu(1,10)
			dd.DrawSprite(870+dev-2, x+1, y+10, 1.0, FALSE);

			// {^Ȃ{^ԍ`
			if(keynum>=4)
			{
				// 860-869 : WCpbh{^ԍ (0,2352)c10 7x6
				// WCpbh{^ԍ`ʒu(9,8)
				char buf[4];
				sprintf(buf, "%2d", keynum-3);
				DrawDigit(860, x+9, y+8, buf, FALSE);
			}
			break;
		}
	}

}

// pl=0 : 1P
// pl=1 : 2P
double CalcBMScore(int pl){

	if(pd.totalNote[pl]==0)
		return 0.0;

	double score = 0;

//	score += 200000.0 * result[pl].perfect / double(pd.totalNote[pl]);
//	score += 100000.0 * result[pl].great   / double(pd.totalNote[pl]);
//	score += 20000.0  * result[pl].good    / double(pd.totalNote[pl]);

	score = (200000.0*result[pl].perfect + 100000.0*result[pl].great + 20000.0*result[pl].good) / double(pd.totalNote[pl]);

	return score;

//	if(pd.dBMScore[pl]>200000.0)
//		pd.dBMScore[pl]=200000.0;

}

void WriteScore(void){

	// Җ]̃XRAo@\(:-p

	FILE* fp = fopen("score.txt","a+");
	if(fp==NULL)
		return; // CDNH

	if(ScoreInfo.lpHeader==NULL)
		return;

	char* mode[]   = { "BM 4Key", "BM 5Key", "BM 7Key", "DDR 4-Arrow", "DDR 6-Arrow"};
	char* bmmode[] = { "--", "1P", "2P", "Double", "Battle" };
	char* valu[]   = { "SS", "S", "A", "B", "C", "D", "F", "N" };
	char  modestr[128];
	char  resstr[512];
	char  timestr[64];

	// vC / Ȏ
	DWORD time = ScoreInfo.playtime;
	if(time>pd.endms) time = pd.endms;
	wsprintf(timestr,"%d:%02d.%03d / %d:%02d.%03d",ms2min(time),ms2sec(time),ms2ms(time),ms2min(pd.endms),ms2sec(pd.endms),ms2ms(pd.endms));

	// {[_[zāAׂẴm[g@I΃NA
//	BOOL bClear1P = (int)pd.dHP[0]>=BM_BORDER && (result[0].perfect + result[0].great + result[0].good + result[0].boo + result[0].miss)>=pd.totalNote[0];
//	BOOL bClear2P = (int)pd.dHP[1]>=BM_BORDER && (result[1].perfect + result[1].great + result[1].good + result[1].boo + result[1].miss)>=pd.totalNote[1];

	// {[_[zāAȂ̍Ō܂ł΃NA
	BOOL bClear1P = (int)pd.dHP[0]>=BM_BORDER && time==pd.endms;
	BOOL bClear2P = (int)pd.dHP[1]>=BM_BORDER && time==pd.endms;

	int level;
	if(IsBM())
	{
		level = ScoreInfo.lpHeader->level;
		if(!IN(ScoreInfo.lpHeader->player,0,4))
		{
			// MSD
			char player[32], diff[32];
			if(IsBasic())
				strcpy(diff, "Basic");
			if(IsAnother())
				strcpy(diff, "Another");
			if(IsManiac())
				strcpy(diff, "SSR");

			if(IsSingle())
				strcpy(player, "Single");
			if(IsCouple())
				strcpy(player, "Couple");
			if(IsDouble())
				strcpy(player, "Double");

			sprintf(modestr, "%s Mode %s %s", mode[opt.iMode], player, diff);
		}
		else
		{
			// BMS
			sprintf(modestr, "%s Mode %s Play", mode[opt.iMode], bmmode[ScoreInfo.lpHeader->player]);
		}
		sprintf(resstr,"1P %s (Gauge:%3d%%) %6d Pts.\nTotalNote:%4d  JG:%4d  GR:%4d  GD:%4d  BD:%4d  PR:%4d(%4d)  MaxCombo:%4d",
			bClear1P ? "Cleared" : "Failed ", (int)pd.dHP[0], (int)pd.dBMScore[0], pd.totalNote[0], result[0].perfect, result[0].great, result[0].good, result[0].boo, result[0].miss+result[0].ouch, result[0].ouch, result[0].maxCombo);

		if(IsCouple())
		{
			char buf[256];
			sprintf(buf,"\n2P %s (Gauge:%3d%%) %6d Pts.\nTotalNote:%4d  JG:%4d  GR:%4d  GD:%4d  BD:%4d  PR:%4d(%4d)  MaxCombo:%4d",
				bClear2P ? "Cleared" : "Failed ", (int)pd.dHP[1], (int)pd.dBMScore[1], pd.totalNote[0], result[1].perfect, result[1].great, result[1].good, result[1].boo, result[1].miss+result[1].ouch, result[1].ouch, result[1].maxCombo);
			strcat(resstr, buf);
		}
	}
	else
	{
		// DDR
		level = ScoreInfo.lpHeader->level; //[pd.mode+1];
		char diff[12];
		char player[12];

		if(IsBasic())
			strcpy(diff, "Basic");
		if(IsAnother())
			strcpy(diff, "Another");
		if(IsManiac())
			strcpy(diff, "SSR");

		if(IsSingle())
			strcpy(player, "Single");
		if(IsCouple())
			strcpy(player, "Couple");
		if(IsDouble())
			strcpy(player, "Double");

		sprintf(modestr, "%s Mode %s %s", mode[opt.iMode], player, diff);

		sprintf(resstr,"1P Rank:%2s (Gauge:%3d%%) %9d Pts.\nTotalNote:%4d  PF:%4d  GR:%4d  GD:%4d  BO:%4d  MS:%4d  OC:%4d  OK:%4d  NG:%4d  MaxCombo:%4d",
			valu[pd.eValu[0]], (int)pd.dHP[0], pd.iScore[0], pd.totalNote[0], result[0].perfect, result[0].great, result[0].good, result[0].boo, result[0].miss, result[0].ouch, result[0].ok, result[0].ng, result[0].maxCombo);
		if(IsCouple())
		{
			char buf[256];
			sprintf(buf,"\n2P Rank:%2s (Gauge:%3d%%) %9d Pts.\nTotalNote:%4d  PF:%4d  GR:%4d  GD:%4d  BO:%4d  MS:%4d  OC:%4d  OK:%4d  NG:%4d  MaxCombo:%4d",
				valu[pd.eValu[1]], (int)pd.dHP[1], pd.iScore[1], pd.totalNote[1], result[1].perfect, result[1].great, result[1].good, result[1].boo, result[1].miss, result[1].ouch, result[1].ok, result[1].ng, result[1].maxCombo);
			strcat(resstr, buf);
		}
	}

	SYSTEMTIME st;
	GetLocalTime(&st);

	char* gamelevel[] = {"Easy","Normal","Hard"};

	char optstr[128];
	char* hsstr[] = {"x0.5","x0.75","x1.0","x1.2","x1.5","x2.0","x2.5","x3.0","x3.5","x4.0","x6.0","x8.0","x16","x256"}; // HighSpeed
	char* apstr[] = {"--", "A1", "A2", "AB", "AA"}; // AutoPlay
	char* asstr[] = {"--", "S1", "S2", "SB"}; // AutoScratch
	char* ipstr[] = {"--", "IP"}; // Ignore Poor
	char* ocstr[] = {"--", "OC"}; // OUCH
	char* vdstr[] = {"VV", "FL"}; // Flat/Vivid
	char* blstr[] = {"--", "HD", "SD", "ST"}; // HID / SUD / STEALTH
	char* arstr[] = {"--", "MR", "SF", "LS"}; // Mirror / Shuffle / Line Shuffle
	char* ltstr[] = {"--", "LT", "MN"}; // Little / Minimum
	char* hststr[]= {"--", "AC", "DC", "PR"}; // Accel. / Decel. / Para.
	char* revstr[]= {"--", "RV"}; // Reverse

	strcpy(optstr, hsstr[opt.iHighSpeedMode]);
	strcat(optstr, " ");

	strcat(optstr, apstr[opt.iAutoPlay]);
	strcat(optstr, " ");

	strcat(optstr, asstr[opt.iAutoScr]);
	strcat(optstr, " ");

	if(IsBM())
	{
		// BM Only
		strcat(optstr, ipstr[opt.bIgPoor]);
		strcat(optstr, " ");
	}
	else
	{
		// DDR Only
		strcat(optstr, ocstr[opt.bOUCH]);
		strcat(optstr, " ");

		strcat(optstr, vdstr[opt.bFlat]);
		strcat(optstr, " ");

		strcat(optstr, revstr[opt.bReverse]);
		strcat(optstr, " ");
	}

	strcat(optstr, blstr[opt.iBlind]);
	strcat(optstr, " ");

	strcat(optstr, arstr[opt.iNArrange]);
	strcat(optstr, " ");

	strcat(optstr, ltstr[opt.iLittle]);
	strcat(optstr, " ");

	strcat(optstr, hststr[opt.iHighSpStyle]);


	fprintf(fp, "%4d/%02d/%02d %d:%02d / %s\n", st.wYear, st.wMonth, st.wDay, st.wHour, st.wMinute, szVerStr);
	fprintf(fp, "%s\n", modestr);
	fprintf(fp, "(%s) %s / %s\n", ScoreInfo.lpHeader->genre.c_str(), ScoreInfo.lpHeader->title.c_str(), ScoreInfo.lpHeader->artist.c_str());
	fprintf(fp, "~%d\n", level);
	fprintf(fp, "%s\n", resstr);
	fprintf(fp, "Game Level : %s  PlayTime : %s\n", gamelevel[opt.iLevel], timestr);
	fprintf(fp, "Options : %s\n", optstr);
	fprintf(fp, "------------------------------------------------\n");

	fclose(fp);

}

void WriteScoreDB(void)
{
	// CScoreւ̏݁B
	// \̃f[^Tx[W

	// {[_[zāAȂ̍Ō܂ł΃NA
	DWORD time = ScoreInfo.playtime;
	if(time>pd.endms) time = pd.endms;

	string filename = ScoreInfo.fullpath; //(ScoreInfo.lpHeader->szPath) + ScoreInfo.lpHeader->szFile;

	int file_size = score.GetFileSize(filename.c_str());
	if(file_size==-1)
	{
		WriteLog("WriteScore() : t@CTCY擾Ɏs (file:%s)", filename.c_str());
		return;
	}

	DWORD file_crc;
	int file_type;
	if(IN(ScoreInfo.lpHeader->player,0,4)) // ǂȔʖ@˂c
	{
		// BMS
		file_crc = score.CalcCRC32(filename.c_str());
		file_type = TYPE_BMS;
	}
	else
	{
		// MSD
		file_crc = score.CalcCRC32(filename.c_str(), pd.mode);
		file_type = TYPE_MSD;
	}

	if(file_crc==0xFFFFFFFF)
	{
		// t@Cort@CI[vsƌĂł傤
		WriteLog("WriteScore() : CRC擾ɎsH (file:%s)", filename.c_str());
		return;
	}

	SCORE sc = { 0 };
	BOOL bRegistOK = IsValidScore();
	if(bRegistOK)
	{
		// XRA܂Ƃ߂
		sc.timestamp = ::time(NULL);
		sc.maxCombo = result[0].maxCombo;
		sc.perfect  = result[0].perfect;
		sc.great    = result[0].great;
		sc.good     = result[0].good;
		sc.boo      = result[0].boo;
		sc.miss     = result[0].miss;
		sc.ouch     = result[0].ouch;
		
		WORD hsval[] = {50, 75, 100, 120, 150, 200, 250, 300, 350, 400, 600, 800, 1600, 25600 }; // HighSpeed * 100
		sc.play_opt.highSpeed = hsval[opt.iHighSpeedMode];
		sc.play_opt.blind	  = opt.iBlind;
		sc.play_opt.noteArr	  = opt.iNArrange;
		sc.play_opt.hsStyle	  = opt.iHighSpStyle;

		if(result[0].perfect + result[0].great + result[0].good + result[0].boo + result[0].miss != pd.totalNote[0])
		{
			// g[^m[gƒ@{vȂ
			// XRA͓o^Ȃ
			bRegistOK = FALSE;

			if(time==pd.endms && !ScoreInfo.bObjSkiped)
			{
				// ɗ獢̂
				WriteLog("WriteScore() : g[^m[gƒ@{vȂBoOH҂ɘAĂ(%d / %d %d %d %d %d)", pd.totalNote[0], result[0].perfect, result[0].great, result[0].good, result[0].boo, result[0].miss);
				assert(0);
			}
		}

		if(IsBM())
		{
			// BM
			sc.bmScore  = (DWORD)pd.dBMScore[0];
			sc.play_opt.comboMode = opt.iCombo;

			if(sc.bmScore==0)
				bRegistOK = FALSE;
		}
		else
		{
			// DDR
			sc.ddrScore = pd.iScore[0];
			sc.ok		= result[0].ok;
			sc.ng		= result[0].ng;
			sc.play_opt.ouch = opt.bOUCH;
			sc.play_opt.flat = opt.bFlat;
			sc.play_opt.reverse = opt.bReverse;

			if(sc.ddrScore==0)
				bRegistOK = FALSE;
		}
	} // endof if XRA܂Ƃ߂

	MUSIC_STAT* lpMS = score.Get(file_crc, (DWORD)file_size);

	if(lpMS==NULL)
	{
		// VKo^
		MUSIC_STAT newMS;
		ZeroMemory(&newMS, sizeof(newMS));
		newMS.filesize = file_size;
		newMS.filetype = file_type;
		newMS.title	 = ScoreInfo.lpHeader->title;
		newMS.artist = ScoreInfo.lpHeader->artist;
		newMS.genre	 = ScoreInfo.lpHeader->genre;

		if(bRegistOK)
			score.RegistScore(&newMS, &sc, (IsBM() ? MODE_BM : MODE_DDR)); // XRAo^

		// vCJEg͋Ȃ𔼕ȏvCCNg
		if(time > pd.endms/2)
		{
			if(IsBM())
				newMS.bmPlaycount++;
			else
				newMS.ddrPlaycount++;
		}

		if(!score.Insert(file_crc, (DWORD)file_size, &newMS))
		{
			// sBȂłHmF
			WriteLog("WriteScore() : CScoreւ̐VKo^Ɏs");
		}
	}
	else
	{
		// XV

		// vCJEg͋Ȃ𔼕ȏvCCNg
		if(time > pd.endms/2)
		{
			if(IsBM())
				lpMS->bmPlaycount++;
			else
				lpMS->ddrPlaycount++;
		}

		if(bRegistOK)
			score.RegistScore(lpMS, &sc, (IsBM() ? MODE_BM : MODE_DDR)); // XRAo^
	}

	score.Save(szScoreDB);

}

// ̃e|̃p[Ze[WŕԂ
double CalcTempo(int delta, BOOL bMusical){

	if(bMusical)
	{
		// y_I グ = * pow(2.0, 1/12)
		return 100 * pow(2.0, delta/12.0);
	}
	else
	{
		// `I
		return 100 + delta*5;
	}
}

// 胉CƃIuWF̋nHSSTƂlĕԂ
int CalcObjYDDR(int y){

	y = 480-y;
	if(opt.iHighSpStyle==HST_ACCEL)
	{
//		if(y<480)
			// 230400 = pow(480,2)
			y = int(double(pow(double(y),3)) / 230400.0); //xt
	}

	if(opt.iHighSpStyle==HST_DECEL)
	{
		if(y<480)
		{
			// 61.304754591484248527890042274384 = pow(pow(double(480),1.0/3.0),2.0)
			// 91.95713188722637279183506341157  = pow(pow(double(480),1.0/3.0),2.0)*1.5
			y = int(double(pow(double(y),1.0/3.0))*91.957131887226) - 240; //xt
		}
	}

	if(opt.iHighSpStyle==HST_PARA)
	{
		// 110592000 = pow(480,3)
		y = int(double(pow(double(y),4)) / 110592000.0); //t
	}

	y = 480-y;
	y+=PLAYAREA_Y;

	return y;

}

// by http://nt.sakura.ne.jp/~miwaki/progtips/shortcut/getlink.shtml
HRESULT GetShortcutLink(LPCTSTR pszLink, LPSTR pszFilePath, int cchMaxPath, WIN32_FIND_DATA *wfd)
{
    HRESULT hres;
    IShellLink *psl;

	hres = CoInitialize(NULL);
	if(FAILED(hres))
		return hres;

    // IShellLink IuWFNg쐬|C^擾
    hres = CoCreateInstance(CLSID_ShellLink, NULL, CLSCTX_INPROC_SERVER, IID_IShellLink, (void **)&psl);
    if (SUCCEEDED(hres))
    {
        IPersistFile *ppf;

        // IPersistFile C^[tFCX̖₢킹Ȃ
        hres = psl->QueryInterface(IID_IPersistFile, (void **)&ppf);
        if (SUCCEEDED(hres))
        {
            WCHAR wsz[MAX_PATH];   // Unicode ւ̃obt@

            // ANSIō\悤ɂ
            MultiByteToWideChar(CP_ACP, 0, pszLink, -1, wsz, MAX_PATH);

            // V[gJbg[h
            hres = ppf->Load(wsz, STGM_READ);

            if (SUCCEEDED(hres))
            {
                // N擾
                hres = psl->GetPath(pszFilePath, cchMaxPath, wfd, SLGP_UNCPRIORITY);
            }

            // IPersistFile ւ̃|C^J
            ppf->Release();
        }
        // IShellLinkւ̃|C^J
        psl->Release();
    }
	
	CoUninitialize();
    return hres;
} 

// ݂̃IvVŁAIRpXRA̓o^邩
BOOL IsValidScore(void)
{
	if(IsCouple()) return FALSE;
		
	if(IsDouble())
	{
		// Double
		if(opt.iAutoPlay==AP_1P || opt.iAutoPlay==AP_2P || opt.iAutoPlay==AP_BOTH) return FALSE;
	}
	else
	{
		// Single
		if(opt.iAutoPlay==AP_1P || opt.iAutoPlay==AP_BOTH) return FALSE;
	}
			
	if(IsBM())
	{
		if(IsDouble())
		{
			// Double
			if(opt.iAutoScr!=AS_OFF) return FALSE;
		}
		else
		{
			// Single
			if(opt.iAutoScr==AS_1P || opt.iAutoScr==AS_BOTH) return FALSE;
		}

		if(opt.bIgPoor) return FALSE;

		// Project2DXf[^ł && Project2DX SupportONȂL^
		if(ScoreInfo.bUrami)
		{
			if(!opt.bUrami)
				return FALSE;
		}
	}

	if(opt.iLittle!=LT_OFF) return FALSE;

	if(opt.iTempoChange!=0) return FALSE;

//	if(opt.iAutoTempoChange!=0 && opt.iTempoChange!=0) return FALSE; Ȃ

	if(ScoreInfo.bTempoChanged || ScoreInfo.bObjSkiped) return FALSE;

	return TRUE;
}

void ReAllocOBJ(void)
{
	if(obj==NULL)
	{
		// m
		obj = (tagObj*)malloc(sizeof(tagObj) * MAX_OBJ);
		if(obj==NULL)
		{
			assert(0);
			WriteLog("ReAllocOBJ() : IuWFi[p̃mۂɎs");
			exit(-1);
		}
	}
	else
	{
		// {{Ŋg
		if(MAX_OBJ > INT_MAX/2)
		{
			assert(0);
			WriteLog("ReAllocOBJ() : vꂽʂ܂BBMSt@CȂłH");
			exit(-1); // Integer Overflow
		}

		MAX_OBJ = MAX_OBJ * 2;
		obj = (tagObj*)realloc(obj, sizeof(tagObj) * MAX_OBJ);
		if(obj==NULL)
		{
			assert(0);
			WriteLog("ReAllocOBJ() : IuWFi[p̃mۂɎs");
			exit(-1);
		}
	}
}

BOOL LoadSoundSet(int ssNum)
{
	if(ssNum < SS_TITLE || SS_KEYCONFIG < ssNum)
	{
		assert(0);
		return FALSE;
	}

	const char* fileNameTbl[] = 
	{
		"SS\\title.wav",		// SS_TITLE(10)
		"SS\\select.wav",		// SS_SELECTMUSIC(11)
		"SS\\option.wav",		// SS_OPTION(12)
		"SS\\ms_left.wav",		// SS_MS_LEFT(13)
		"SS\\ms_right.wav",		// SS_MS_RIGHT(14)
		"SS\\ms_decide.wav",	// SS_MS_DECIDE(15)
		"SS\\bm_cleared.wav",	// SS_BM_CLEARED(16)
		"SS\\bm_failed.wav",	// SS_BM_FAILED(17)
		"SS\\ddr_cleared.wav",	// SS_DDR_CLEARED(18)
		"SS\\ddr_failed.wav",	// SS_DDR_FAILED(19)
		"SS\\juke_up.wav",		// SS_JUKE_UP(20)
		"SS\\juke_down.wav",	// SS_JUKE_DOWN(21)
		"SS\\keyconfig.wav",	// SS_KEYCONFIG(22)
	};

	int stream = Cfg["WAVStreaming"];
	const char* fileName = fileNameTbl[ssNum-SS_TITLE];

	if(stream==WS_SSONLY || stream==WS_ALL)
		return ds.LoadWaveFile(ssNum, fileName, TRUE); // Xg[~O
	else
		return ds.LoadWaveFile(ssNum, fileName, FALSE); // Ȃ
}

BOOL UnLoadSoundSet(int ssNum)
{
	return ds.ReleaseWave(ssNum);
}

BOOL PlaySoundSet(int ssNum)
{
	if(ssNum < SS_TITLE || SS_KEYCONFIG < ssNum)
	{
		assert(0);
		return FALSE;
	}

	BOOL loopTbl[] = 
	{
		TRUE,	// SS_TITLE(10)
		TRUE,	// SS_SELECTMUSIC(11)
		TRUE,	// SS_OPTION(12)
		FALSE,	// SS_MS_LEFT(13)
		FALSE,	// SS_MS_RIGHT(14)
		FALSE,	// SS_MS_DECIDE(15)
		TRUE,	// SS_BM_CLEARED(16)
		TRUE,	// SS_BM_FAILED(17)
		TRUE,	// SS_DDR_CLEARED(18)
		TRUE,	// SS_DDR_FAILED(19)
		FALSE,	// SS_JUKE_UP(20)
		FALSE,	// SS_JUKE_DOWN(21)
		TRUE,	// SS_KEYCONFIG(22)
	};

	return ds.Play(ssNum, loopTbl[ssNum-SS_TITLE]);
}
