//
// XRÅǗS
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "CScore.h"

extern void WriteLog(const char* Format,...);

CScore::CScore()
{
}

CScore::~CScore()
{
}

// Ver.1.01
BOOL CScore::LoadVer101(FILE* fp)
{
	// Ver.1.01t@C\
	// EOF܂ŌJԂ
	// {
	//		{
	//			ȃt@CCRC32
	//			MUSIC_STAT(stringȃoWORD len + char[len]Ŋi[)
	//		}
	//		LubNCRC32
	// }

	int numRecord = 0;
	while(1)
	{
		struct tagBuf{
			DWORD file_crc32;
			MUSIC_STAT data;
		} buf;

		size_t sizeMS = sizeof(buf)-SIZEOF_MS_STR; // stringsizeof(MUSIC_STAT)

		// f[^[h
		if(fread(&buf, sizeMS, 1, fp)!=1)
		{
			if(feof(fp))
				break; // t@CI[
			else
			{
				WriteLog("CScore::Load() : [hG[(numRecord:%d)", numRecord);
				return FALSE; // [hG[
			}
		}

		// OCRCvZ
		m_crc32.Clear();
		m_crc32.Calc(&buf, sizeMS);

		// stringA[hCRCvZ
		if(!ReadString(buf.data.title, fp)) return FALSE;
		if(!ReadString(buf.data.artist, fp)) return FALSE;
		if(!ReadString(buf.data.genre, fp)) return FALSE;

		// CRC32[h
		DWORD crc32;
		if(fread(&crc32, sizeof(crc32), 1, fp)!=1)
		{
			// f[^ɑΉCRCȂ
			WriteLog("CScore::Load() : R[hɑΉCRC܂(numRecord:%d)", numRecord);
			return FALSE;
		}

		// CRC`FbN
		if(m_crc32.Get() != crc32)
		{
			// CRCG[
			WriteLog("CScore::Load() : f[^G[łBR[h%dj܂", numRecord);
		}
		else
		{
			// ǂݍݐ
			// ǉƂɂƏĂΏdR[h͂Ȃ͂
			m_Scores.insert(make_pair(buf.file_crc32, buf.data));
		}

		numRecord++;
	}

	WriteLog("CScore::Load() : ǂݍݐB%d̃R[hǂݍ݂܂", numRecord);
	return TRUE;

}

BOOL CScore::Load(const char* filename)
{
	// wb_\(IɂŒ)
	// signature 12byte "DELIGHTSCORE"
	// ver 4byte t@Co[W

	FILE* fp = fopen(filename, "rb");
	if(fp==NULL)
	{
		WriteLog("CScore::Load() : XRAt@CJ܂");
		return FALSE;
	}

	// wb_`FbN
	char sign[16];
	if(fread(sign, 12, 1, fp)!=1)
	{
		WriteLog("CScore::Load() : XRAt@C̃wb_ǂݍ݂Ɏs");
		fclose(fp);
		return FALSE;
	}

	if(strncmp(sign, "DELIGHTSCORE", 12)!=0)
	{
		WriteLog("CScore::Load() : XRAt@C̃wb_sł");
		fclose(fp);
		return FALSE;
	}

	// o[W擾
	DWORD ver = 0;
	if(fread(&ver, sizeof(DWORD), 1, fp)!=1)
	{
		WriteLog("CScore::Load() : XRAt@C̃o[W擾Ɏs");
		fclose(fp);
		return FALSE;
	}

	BOOL res = FALSE;
	switch(ver)
	{
		case VER_100:
		{
			// I[v\[XÕXRAt@C
			// f[^h~̂߃obNAbv
			// [h̓T|[gȂ
			fclose(fp);
			rename(filename, (string(filename) + ".ver100").c_str());
			return TRUE;
		}

		case VER_101: res = LoadVer101(fp); break;
		default: WriteLog("CScore::Load() : Ή̃o[Wł(0x%08x)", ver); break;
	}

	fclose(fp);
	return res;
}

BOOL CScore::Save(const char* filename)
{
	// LoadƈčŐVł݂̂ŃZ[u΂

	// wb_\(IɂŒ)
	// signature 12byte "DELIGHTSCORE"
	// ver 4byte t@Co[W

	FILE* fp = fopen(filename, "wb");
	if(fp==NULL)
	{
		WriteLog("CScore::Save() : XRAt@CJ܂");
		return FALSE;
	}

	// wb_
	if(fwrite("DELIGHTSCORE", 12, 1, fp)!=1)
	{
		WriteLog("CScore::Save() : wb_݂Ɏs");
		fclose(fp);
		return FALSE;
	}

	// o[W
	DWORD ver = VER_101;
	if(fwrite(&ver, sizeof(DWORD), 1, fp)!=1)
	{
		WriteLog("CScore::Save() : o[W݂Ɏs");
		fclose(fp);
		return FALSE;
	}

	// Ver.1.01t@C\
	// EOF܂ŌJԂ
	// {
	//		{
	//			ȃt@CCRC32
	//			MUSIC_STAT(stringȃoWORD len + char[len]Ŋi[)
	//		}
	//		LubNCRC32
	// }

	int numRecord = 0;
	for(multimap<DWORD, MUSIC_STAT>::iterator i = m_Scores.begin() ; i!=m_Scores.end() ; i++)
	{
		struct tagBuf{
			DWORD file_crc32;
			MUSIC_STAT data;
		} buf;

		size_t sizeMS = sizeof(buf)-SIZEOF_MS_STR; // stringsizeof(buf)

		buf.file_crc32 = (*i).first;
		buf.data = (*i).second;

		// CRC擾
		DWORD crc32;
		m_crc32.Clear();
		m_crc32.Calc(&buf, sizeMS);

		// f[^
		if(fwrite(&buf, sizeMS, 1, fp)!=1)
		{
			WriteLog("CScore::Save() : R[h%d݂̏Ɏs", numRecord);
			fclose(fp);
			return FALSE;
		}

		// stringȂ珑
		if(!WriteString(buf.data.title, fp)  ||
		   !WriteString(buf.data.artist, fp) ||
		   !WriteString(buf.data.genre, fp)     )
		{
			WriteLog("CScore::Save() : R[h%d݂̏Ɏs", numRecord);
			fclose(fp);
			return FALSE;
		}
			
		crc32 = m_crc32.Get();

		// CRC32
		if(fwrite(&crc32, sizeof(crc32), 1, fp)!=1)
		{
			WriteLog("CScore::Save() : R[h%d݂̏Ɏs", numRecord);
			fclose(fp);
			return FALSE;
		}

		numRecord++;
	}

	WriteLog("CScore::Save() : ݐB%d̃R[h݂܂", numRecord);
	fclose(fp);
	return TRUE;

}

// ̃bpBǌJ֐
int CScore::GetFileSize(const char* filename)
{
	FILE* fp = fopen(filename, "rb");
	if(fp==NULL) return -1;

	int size = GetFileSize(fp);
	fclose(fp);

	return size;
}

// oCi[hȂƓĂɂȂȂ
int CScore::GetFileSize(FILE* fp)
{
	// ݈ʒuL
	int old = ftell(fp);

	// 擾
	fseek(fp, 0, SEEK_END);
	int size = ftell(fp);

	// ߂
	fseek(fp, old, SEEK_SET);

	return size;
}

// MSD͊e[hƂɈقȂCRCԂ[hƂɕʂ̃t@CƂĈ
// msd_modeȗƈʓICRC32Ԃ
// [h̒萔consts.hŒ`
// 0 : SINGLE BASIC
// 1 : SINGLE ANOTHER
// 2 : SINGLE MANIAC
// 3 : DOUBLE BASIC
// 4 : DOUBLE ANOTHER
// 5 : DOUBLE MANIAC
// 6 : COUPLE BASIC
// 7 : COUPLE ANOTHER
// 8 : COUPLE MANIAC
DWORD CScore::CalcCRC32(const char* filename, int msd_mode/* = -1*/)
{
	FILE* fp = fopen(filename, "rb");
	if(fp==NULL) return 0xFFFFFFFF;

	int filesize = GetFileSize(fp);
	BYTE* buf = new BYTE[filesize+16];
	if(buf==NULL)
	{
		fclose(fp);
		return 0xFFFFFFFF;
	}

	if(fread(buf, filesize, 1, fp)!=1)
	{
		delete [] buf;
		fclose(fp);
		return 0xFFFFFFFF;
	}

	if(SINGLE+BASIC<=msd_mode && msd_mode<=DOUBLE+MANIAC)
	{
		// f[^Ƀ[hԍtACRCς
		// Couple͔T|[g
		buf[filesize] = (BYTE)msd_mode;
		filesize++;
	}

	m_crc32.Clear();
	m_crc32.Calc(buf, filesize);

	delete [] buf;
	fclose(fp);

	return m_crc32.Get();
}

// ɂ̂擾B݂ȂNULL
// |C^̎̂čXVĂ悢
MUSIC_STAT*	CScore::Get(DWORD crc32, DWORD filesize)
{
	pair<multimap<DWORD, MUSIC_STAT>::iterator, multimap<DWORD, MUSIC_STAT>::iterator> range;
	range = m_Scores.equal_range(crc32);

	for(multimap<DWORD, MUSIC_STAT>::iterator i = range.first ; i!=range.second ; i++)
	{
		if((*i).second.filesize==filesize)
			return &((*i).second);
	}

	return NULL;

}
// VKo^Bɑ݂FALSE
BOOL CScore::Insert(DWORD crc32, DWORD filesize, MUSIC_STAT* data)
{
	pair<multimap<DWORD, MUSIC_STAT>::iterator, multimap<DWORD, MUSIC_STAT>::iterator> range;
	range = m_Scores.equal_range(crc32);

	for(multimap<DWORD, MUSIC_STAT>::iterator i = range.first ; i!=range.second ; i++)
	{
		if((*i).second.filesize==filesize)
			return FALSE;
	}

	// ݂Ȃ̂ŐVKo^
	MUSIC_STAT ms = *data;
	ms.filesize = filesize;
	m_Scores.insert(make_pair(crc32, ms));
	return TRUE;
}

// MUSIC_STATT|[g֐

// XRAo^BNC炻̏(1`BEST_NUM)ԂBNO-1
// g[^XRAƃvC񐔂Z
// mode = MODE_BM / MODE_DDR
int CScore::RegistScore(MUSIC_STAT* target, SCORE* score, int mode)
{
	if(mode==MODE_BM)
	{
		// NCȂĂ݌vf[^͉Z
		target->bmTotalScore += score->bmScore;
		target->bmScorecount++;

		for(int i=0;i<BEST_NUM;i++)
		{
			if(score->bmScore > target->bmScore[i].bmScore)
			{
				for(int j=BEST_NUM-1 ; j>=i+1 ; j--)
				{
					// ЂƂɉ
					target->bmScore[j] = target->bmScore[j-1];
				}
				
				// VXRA
				target->bmScore[i] = (*score);

				return i+1; // ʂԂ
			}
		}

		return -1; // NO
	}
	else if(mode==MODE_DDR)
	{
		// NCȂĂ݌vf[^͉Z
		target->ddrTotalScore += score->ddrScore;
		target->ddrScorecount++;

		for(int i=0;i<BEST_NUM;i++)
		{
			if(score->ddrScore > target->ddrScore[i].ddrScore)
			{
				for(int j=BEST_NUM-1 ; j>=i+1 ; j--)
				{
					// ЂƂɉ
					target->ddrScore[j] = target->ddrScore[j-1];
				}
				
				// VXRA
				target->ddrScore[i] = (*score);

				return i+1; // ʂԂ
			}
		}

		return -1; // NO
	}
	else
	{
		// [hρ`
		return -1;
	}
}

BOOL CScore::WriteString(string str, FILE* fp)
{
	WORD len = str.size();
	char* buf = new char[len+4];
	strcpy(buf, str.c_str());

	m_crc32.Calc(&len, sizeof(len));
	m_crc32.Calc(buf, len);

	if(fwrite(&len, sizeof(len), 1, fp)!=1)
	{
		WriteLog("CScore::WriteString() : ̒߂܂");
		delete [] buf;
		return FALSE;
	}

	if(len!=0)
	{
		// OƂƂOԂ̂ŉ
		if(fwrite(buf, len, 1, fp)!=1)
		{
			WriteLog("CScore::WriteString() : 񂪏߂܂(len:%hu)", len);
			delete [] buf;
			return FALSE;
		}
	}

	delete [] buf;
	return TRUE;
}

BOOL CScore::ReadString(string& str, FILE* fp)
{
	WORD len;
	if(fread(&len, sizeof(len), 1, fp)!=1)
	{
		WriteLog("CScore::ReadString() : ̒ǂݍ߂܂");
		return FALSE;
	}

	char* buf = new char[len+4];
	if(buf==NULL)
	{
		WriteLog("CScore::ReadString() : obt@mۂł܂(len:%hu)", len);
		return FALSE;
	}

	if(len!=0)
	{
		// OǂݍƂƂOԂ̂ŉ
		if(fread(buf, len, 1, fp)!=1)
		{
			WriteLog("CScore::ReadString() : 񂪓ǂݍ߂܂(len:%hu)", len);
			return FALSE;
		}
	}

	buf[len] = '\0';

	m_crc32.Calc(&len, sizeof(len));
	m_crc32.Calc(buf, len);

	str = buf;
	delete [] buf;

	return TRUE;
}
