//
// DirectSoundobt@Xg[~OĂNX
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef __AudioStream__
#define __AudioStream__

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <mmsystem.h>

#define INITGUID
#define DIRECTSOUND_VERSION 0x0300
// ŐṼwb_gƈꕔŏł炵
// A}CN\tg̃R[hSourceForgeɂ͍ڂȂ
#include <dsound.h>
#pragma comment(lib, "dsound.lib")

#include <string>
#include <vector>
#include <list>
using std::string;
using std::vector;
using std::list;

#include "AudioFile.h"
#include "CEvent.h"
#include "yaneCriticalSection.h"

class AudioStream
{
private:

	// FillΏۂ̃obt@
	static const int FILL_BUF_A = 0;
	static const int FILL_BUF_B = 1;

	typedef struct tagAudioInfo
	{
		AudioFile* file;
		LPDIRECTSOUNDBUFFER dsBuf; // DirectSoundNXŊmہAB̃NXStopx
		LPDIRECTSOUNDNOTIFY dsNotify;
		DWORD readPos; // ݂̍ĐʒuBWAVł̃oCg
		BOOL isLoop; // [vĐǂBXg[~OΏۂdsBuf͕K[vݒɂĂ
		int stopCount; // f[^̖ɂ̂ŁA2FillBufferStop邽߂̃JEg_E
		LONG oldVolume; // StopɈxVolumêőÔL

		// (0        <= offset < halfSize)obt@̑O
		// (halfSize <= offset < bufSize) obt@̌㔼
		DWORD bufSize; // dsBuf̃TCY
		DWORD halfSize; // obt@̒ʒu

		HANDLE eventWriteA; // ꂪobt@̑OWrite
		HANDLE eventWriteB; // ꂪobt@̌㔼Write
		HANDLE eventStop;

		// SoundBlasterNotify̓oOĂĕʂ̃obt@Notifyꏏɔł炵B
		// ̂ŎɂǂFill邩̃tOĐ`FbN
		int fillFlag;

		tagAudioInfo()
		{
			file = NULL;
			dsBuf = NULL;
			dsNotify = NULL;
			eventWriteA = eventWriteB = eventStop = NULL;
			stopCount = -1;
			fillFlag = FILL_BUF_A;
		}
	} AUDIOINFO;

	// EventԍAUDIOINFO̔ԍւ̃bNAbvȂƂȂ̂
	// list͂߂vector
	vector<AUDIOINFO> m_AudioInfo;


	// StopƃmCYDirectSound̐K@c
	// tF[hAEĝStop
	static const int FADE_TIME = 1000; // 1000msătF[hāAɂStop
	typedef struct tagFadeInfo
	{
		LPDIRECTSOUNDBUFFER dsBuf; // tF[hΏۃobt@
		//DWORD startPos; // obt@̂߂tF[hā[
		DWORD startTime; // tF[hJn(timeGetTime̖߂l)
	} FADEINFO;

	// ɑtF[h邱Ƃ͂܂Ȃł傤
	// ǉE폜list
	list<FADEINFO> m_FadeInfo;
	CCriticalSection m_FadeInfoCS; // r


	HANDLE m_StreamingThreadHandle;

	HANDLE m_ThreadEnd; // StreamingThreadIBƂ܂Ƃ߂Wait̂ŊĐHANDLE
	HANDLE m_ThreadStop;  // StreamingThread̏ꎞ~B
	CEvent m_ThreadStart; // StreamingThread̏ĊJ
	CEvent m_Ack; // StreamingThread̏L2ւ̉

	static unsigned __stdcall StreamingThread(void* lpAudioStream);
	static void ReloadAudioInfoList(vector<HANDLE>& handles, AudioStream* as);
	static void ProcessBuffer(AudioStream* as, AUDIOINFO& info, int whichEvent);

	static BOOL FillDSBuffer(AudioStream* as, AUDIOINFO& info, int whichBuf);
	static void FadeOut(BYTE* buf, DWORD written, DWORD bits, DWORD ch);

	void UnRegisterAll(void);

public:

	AudioStream();
	~AudioStream();

	BOOL Init(void);
	void Term(void);

	// (쐬ς݂)obt@ɑ΂ăXg[~Ȍ
	// ꂾĂׂ΃vobt@OAXg[~OȂǂׂĂ܂
	// ĂяodsBuf->Play()邾
	// K[vLPlay()邱
	// obt@TCYWAṼTCYƁA܂Ȃ
	BOOL Register(LPDIRECTSOUNDBUFFER dsBuf, const string& fileName, BOOL isLoop = FALSE);

	// [vĐ邩ǂ
	// ǂɂꍇAdsBuf͕K[vLPlay()邱
	BOOL SetLoop(LPDIRECTSOUNDBUFFER dsBuf, BOOL isLoop);

	// Xg[~OΏۂO
	// dsBufReleaseOɌĂяo
	BOOL UnRegister(LPDIRECTSOUNDBUFFER dsBuf);
};

#endif
