/*!
 * @file TrapBase.h
 * @brief Q[̃gbvx[X̃vg^Cv
 * @date 2014/02/01
 * @author Deskull
 * 2014 Sikabane Works.
 */

#include "stdafx.h"
#include "GameElement.h"

namespace Deeangband
{

/*!
 * @class TrapBase
 * @brief gbvx[X̃NX
 */
class TrapBase : public GameElement
{
	std::string name;

	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive &archive, const unsigned int) 
	{
		archive & BOOST_SERIALIZATION_NVP(name);
	}

private:

public:

	/*! 
	 * @brief TrapBaseNXRXgN^(GameElementoΉ)
	 * @param id GameElementID
	 * @param tag GameElement̃^O
	 * @param gameWorld gameWorldQƃ|C^
	 */
	TrapBase::TrapBase(ID id, TAG tag, GameWorld *gameWorld);

	TrapBase::TrapBase(void);

	TrapBase::~TrapBase(void);

	std::string TrapBase::GetName(void);
};

}