/*!
* @file Species.h
* @brief Q[̃N[`[ʂ̃vg^Cv
* @date 2014/02/01
* @author Deskull
* 2014 Sikabane Works.
*/

#include "stdafx.h"
#include "GameElement.h"
#include "BaseStatusTable.h"

#pragma once

namespace Deeangband
{

	/*!
	* @class Species
	* @brief N[`[ʂ̃NX
	*/
	class Species : public GameElement
	{

	private:

		std::string name;   //!< N[`[̖O
		SOUL baseSoul; //!< {\E

		HEIGHT averageHeight;    //!< ϐg
		HEIGHT averageWeight;    //!< ϑ̏d

		FEED baseFeed; //!< {{l
		LEVEL divineLevel; //!< {_x

		ID baseCamp; //!< {wc

		BaseStatusTable baseStatus; //!< {Xe[^X

		std::map<TAG, SKILL_EXP> skillExpList; //!< XLolXg

		friend class boost::serialization::access;
		template<class Archive> void serialize(Archive &archive, const unsigned int) 
		{
			archive & BOOST_SERIALIZATION_NVP(name);
			archive & BOOST_SERIALIZATION_NVP(baseSoul);
			archive & BOOST_SERIALIZATION_NVP(averageHeight);
			archive & BOOST_SERIALIZATION_NVP(averageWeight);
			archive & BOOST_SERIALIZATION_NVP(baseFeed);
			archive & BOOST_SERIALIZATION_NVP(divineLebel);
			archive & BOOST_SERIALIZATION_NVP(baseCamp);
			archive & BOOST_SERIALIZATION_NVP(baseStatus);
		}

	public:

		/*! 
		* @brief SpeciesNXRXgN^(GameElementoΉ)
		* @param id GameElementID
		* @param tag GameElement̃^O
		* @param gameWorld gameWorldQƃ|C^
		*/
		Species::Species(ID id, TAG tag, GameWorld *gameWorld);

		/*! 
		* @brief SpeciesNXRXgN^
		*/
		Species::Species(void);

		/*! 
		* @brief SpeciesNXfXgN^
		*/
		Species::~Species(void);

		/*! 
		* @brief N[`[ʂ̖OԂ
		* @return O
		*/
		std::string Species::GetName(void);

		/*! 
		* @brief N[`[ʂ̊{\EʂA
		* @return \E
		*/
		SOUL Species::GetBaseSoul(void);

		/*! 
		* @brief N[`[ʂ̕ϐgԂ
		* @return ϐg
		*/
		HEIGHT Species::GetAverageHeight(void);

		/*! 
		* @brief N[`[ʂ̕ϑ̏dԂ
		* @return ϑ̏d
		*/
		WEIGHT Species::GetAverageWeight(void);

		/*! 
		* @brief N[`[ʂ̊{{xԂ
		* @return {{x
		*/
		FEED Species::GetBaseFeed(void);

		/*! 
		* @brief N[`[ʂ̃XL{olԂ
		* @param tag 擾XL̃^O
		* @return YXL̊{olAS̖oȂ0Ԃ
		*/
		SKILL_EXP Species::GetSkillExp(TAG tag);

		/*! 
		* @brief N[`[ʂ̊{wcԂ
		* @return {wcID
		*/
		ID Species::GetBaseCampID(void);

	};

}