/*!
* @file Species.cpp
* @brief Q[̃N[`[ʂ`
* @date 2014/02/01
* @author Deskull
* 2014 Sikabane Works.
*/

#include "stdafx.h"
#include "Species.h"

namespace Deeangband
{

	Species::Species(ID id, TAG tag, GameWorld *gameWorld) : GameElement(id, tag, gameWorld)
	{
		Species();
		return;
	}

	Species::Species(void)
	{
		this->name = "_~[";
		this->baseSoul = 100;
		this->baseFeed = 20000;

		this->averageHeight = 160;
		this->averageWeight = 50;

		this->baseStatus.Set(8, 8, 8, 8, 8, 8);

		this->skillExpList.clear();
		this->baseCamp = CAMP_VARIABLE;
	}

	Species::~Species(void)
	{
	}

	std::string Species::GetName(void)
	{
		return this->name;
	}

	SOUL Species::GetBaseSoul(void)
	{
		return this->baseSoul;
	}

	HEIGHT Species::GetAverageHeight(void)
	{
		return this->averageHeight;
	}

	WEIGHT Species::GetAverageWeight(void)
	{
		return this->averageWeight;
	}

	FEED Species::GetBaseFeed(void)
	{
		return this->baseFeed;
	}

	SKILL_EXP Species::GetSkillExp(TAG tag)
	{
		if(this->skillExpList.count(tag)) return this->skillExpList[tag];
		else return 0;
	}

	ID Species::GetBaseCampID(void)
	{
		return this->baseCamp;
	}

}