/*!
* @file ItemBase.cpp
* @brief Q[̃ACex[X`
* @date 2014/02/01
* @author Deskull
* 2014 Sikabane Works.
*/

#include "stdafx.h"
#include "ItemBase.h"

namespace Deeangband
{

	ItemBase::ItemBase(ID id, TAG tag, GameWorld *gameWorld) : ItemTemplate(id, tag, gameWorld)
	{
		this->SetDammyData();
	}

	ItemBase::ItemBase(void)
	{
		this->SetDammyData();
	}

	ItemBase::~ItemBase(void)
	{
	}

	void ItemBase::SetDammyData(void)
	{
		this->name = "̕Ȃ";
		this->weight = 0;
	}

	WEIGHT ItemBase::GetWeight(void)
	{
		return this->weight;
	}

	Dice ItemBase::GetDamageDice(void)
	{
		return this->baseDamage;
	}


	void ItemBase::XMLSave(std::string filename)
	{
		ItemBase itemBase = *this;
		std::ofstream ofs(filename);
		assert(ofs);
		boost::archive::xml_oarchive oa(ofs);
		oa << BOOST_SERIALIZATION_NVP(itemBase);
	}

}