/*!
 * @file Item.cpp
 * @brief Q[̃N[`[`
 * @date 2013/12/11
 * @author Deskull
 * 2013 Sikabane Works.
 */

#include "stdafx.h"
#include "Item.h"

namespace Deeangband
{

Item::Item(ID id, TAG tag, GameWorld *gameWorld) : ItemTemplate(id, tag, gameWorld)
{
	this->SetDammyData();
}

Item::Item(void)
{
	this->SetDammyData();
}

Item::~Item(void)
{
}

void Item::SetDammyData(void)
{
	this->weight = 0;
}

bool Item::TakeEffect(Effect *effectPtr, POWER amount)
{
	if(effectPtr)
	{
		amount = 0;
	}
	return true;
}

void Item::XMLSave(std::string filename)
{
	Item item = *this;
	std::ofstream ofs(filename);
    assert(ofs);
    boost::archive::xml_oarchive oa(ofs);
	oa << BOOST_SERIALIZATION_NVP(item);
}

}