/*!
* @file GameWorld.h
* @brief Q[Ẽvg^Cv錾
* @date 2013/02/01
* @author Deskull
* 2013-2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Deeangband.h"

#include "Authority.h"
#include "Building.h"
#include "Camp.h"
#include "Creature.h"
#include "CreatureTrait.h"
#include "Dungeon.h"
#include "Effect.h"
#include "Feature.h"
#include "FixedArtifact.h"
#include "ItemBase.h"
#include "ItemEgo.h"
#include "ItemTrait.h"
#include "Karma.h"
#include "Quest.h"
#include "Skill.h"
#include "Species.h"
#include "TrapBase.h"

#include "Item.h"
#include "Creature.h"
#include "Floor.h"
#include "Trap.h"

BOOST_CLASS_VERSION(GameWorld, 1);

namespace Deeangband
{

	/*!
	* @class GameWorld
	* @brief Q[ẼNX
	*/
	class GameWorld
	{
	private:

		//ÓIf[^Xg
		std::map<TAG, std::shared_ptr<Authority>> authorityList;          /*!<S\Xg*/
		std::map<TAG, std::shared_ptr<Building>> buildingList;            /*!<S{݃Xg*/
		std::map<TAG, std::shared_ptr<Camp>> campList;                    /*!<SwcXg*/
		std::map<TAG, std::shared_ptr<CreatureTrait>> creatureTraitList;  /*!<SN[`[Xg*/
		std::map<TAG, std::shared_ptr<Dungeon>> dungeonList;              /*!<S_WXg*/
		std::map<TAG, std::shared_ptr<Effect>> effectList;                /*!<SʑXg*/
		std::map<TAG, std::shared_ptr<Feature>> featureList;              /*!<Sn`Xg*/
		std::map<TAG, std::shared_ptr<FixedArtifact>> fixedArtifactList;  /*!<SŒA[eBt@NgXg*/
		std::map<TAG, std::shared_ptr<ItemBase>> itemBaseList;            /*!<SACex[XXg*/
		std::map<TAG, std::shared_ptr<ItemEgo>> itemEgoList;              /*!<SACeGSXg*/
		std::map<TAG, std::shared_ptr<ItemTrait>> itemTraitList;          /*!<SACeXg*/
		std::map<TAG, std::shared_ptr<Karma>> karmaList;                  /*!<SJ}Xg*/
		std::map<TAG, std::shared_ptr<Quest>> questList;                  /*!<SNGXgXg*/
		std::map<TAG, std::shared_ptr<Skill>> skillList;                  /*!<SXLXg*/
		std::map<TAG, std::shared_ptr<Species>> speciesList;              /*!<SN[`[ʃXg*/
		std::map<TAG, std::shared_ptr<TrapBase>> trapBaseList;            /*!<Sgbvx[XʃXg*/

		//If[^Xg
		std::map<ID, std::shared_ptr<Item>> itemList;                    /*!<SACeXg*/
		std::map<ID, std::shared_ptr<Creature>> creatureList;            /*!<SN[`[Xg*/
		std::map<ID, std::shared_ptr<Floor>> floorList;                  /*!<StAXg*/
		std::map<ID, std::shared_ptr<Trap>> trapList;                    /*!<SgbvXg*/

		GAME_TIME gameTime; //!<Q[

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param fileVersion t@Co[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int fileVersion) 
		{
			archive & BOOST_SERIALIZATION_NVP(creatureList);
			archive & BOOST_SERIALIZATION_NVP(itemList);
			archive & BOOST_SERIALIZATION_NVP(floorList);
			archive & BOOST_SERIALIZATION_NVP(trapList);
		}

	public:

		/*!
		* @brief GameWorldNX̃RXgN^
		* @param gSurface Q[̃C^[tFCXƂȂ GameSurface Q
		*/
		GameWorld::GameWorld(void);

		/*!
		* @brief GameWorldNX̃fXgN^
		*/
		GameWorld::~GameWorld(void);

		/*!
		* @brief GameWorldɑ݂錠\Ԃ
		* @param tag \̃^O
		* @return \̎Qƃ|C^A݂ȂNULLԂB
		*/
		Authority *GameWorld::GetAuthority(TAG tag);

		/*!
		* @brief GameWorldɑ݂N[`[Ԃ
		* @param tag N[`[̃^O
		* @return N[`[̎Qƃ|C^A݂ȂNULLԂB
		*/
		CreatureTrait *GameWorld::GetCreatureTrait(TAG tag);

		/*!
		* @brief GameWorldɑ݂ʑԂ
		* @param tag ʑ̃^O
		* @return ʑ̎Qƃ|C^A݂ȂNULLԂB
		*/
		Effect *GameWorld::GetEffect(TAG tag);

		/*!
		* @brief GameWorldɑ݂ŒA[eBt@NgԂ
		* @param tag ʑ̃^O
		* @return ŒA[eBt@Ng̎Qƃ|C^A݂ȂNULLԂB
		*/
		FixedArtifact *GameWorld::GetFixedArtifact(TAG tag);

		/*!
		* @brief GameWorldɑ݂n`Ԃ
		* @param tag n`̃^O
		* @return n`̎Qƃ|C^A݂ȂNULLԂB
		*/
		Feature *GameWorld::GetFeature(TAG tag);

		/*!
		* @brief GameWorldɑ݂x[XACeԂ
		* @param tag x[XACẽ^O
		* @return x[XACe̎Qƃ|C^A݂ȂNULLԂB
		*/
		ItemBase *GameWorld::GetItemBase(TAG tag);

		/*!
		* @brief GameWorldɑ݂ACeGSԂ
		* @param tag ACeGS̃^O
		* @return ACeGS̎Qƃ|C^A݂ȂNULLԂB
		*/
		ItemEgo *GameWorld::GetItemEgo(TAG tag);

		/*!
		* @brief GameWorldɑ݂ACeԂ
		* @param tag ACẽ^O
		* @return ACe̎Qƃ|C^A݂ȂNULLԂB
		*/
		ItemTrait *GameWorld::GetItemTrait(TAG tag);

		/*!
		* @brief GameWorldɑ݂J}Ԃ
		* @param tag J}̃^O
		* @return J}̎Qƃ|C^A݂ȂNULLԂB
		*/
		Karma *GameWorld::GetKarma(TAG tag);

		/*!
		* @brief GameWorldɑ݂XLԂ
		* @param tag XL̃^O
		* @return XL̎Qƃ|C^A݂ȂNULLԂB
		*/
		Skill *GameWorld::GetSkill(TAG tag);

		/*!
		* @brief GameWorldɑ݂XLԂ
		* @param tag XL̃^O
		* @return XL̎Qƃ|C^A݂ȂNULLԂB
		*/
		Species *GameWorld::GetSpecies(TAG tag);

		/*!
		* @brief GameWorldɑ݂gbvʂԂ
		* @param tag gbvʂ̃^O
		* @return gbvʂ̎Qƃ|C^A݂ȂNULLԂB
		*/
		TrapBase *GameWorld::GetTrapBase(TAG tag);

		/*!
		* @brief GameWorldɑ݂{݂Ԃ
		* @param tag {݂̃^O
		* @return {݂̎Qƃ|C^A݂ȂNULLԂB
		*/
		Building *GameWorld::GetBuilding(TAG tag);

		/*!
		* @brief GameWorldɑ݂wcԂ
		* @param tag wc̃^O
		* @return wc̎Qƃ|C^A݂ȂNULLԂB
		*/
		Camp *GameWorld::GetCamp(TAG tag);

		/*!
		* @brief GameWorldɑ݂_WԂ
		* @param tag _W̃^O
		* @return _W̎Qƃ|C^A݂ȂNULLԂB
		*/
		Dungeon *GameWorld::GetDungeon(TAG tag);

		/*!
		* @brief GameWorldɑ݂ACeԂ
		* @param id ACeID
		* @return ACe̎Qƃ|C^A݂ȂNULLԂB
		*/
		Item *GameWorld::GetItem(ID id);

		/*!
		* @brief GameWorldɑ݂tAԂ
		* @param id tAID
		* @return tA̎Qƃ|C^A݂ȂNULLԂB
		*/
		Floor *GameWorld::GetFloor(ID id);

		/*!
		* @brief GameWorldɑ݂N[`[Ԃ
		* @param id N[`[ID
		* @return N[`[̎Qƃ|C^A݂ȂNULLԂB
		*/
		Creature *GameWorld::GetCreature(ID id);

		/*!
		* @brief GameWorldɑ݂NGXgԂ
		* @param tag NGXg̃^O
		* @return NGXg̎Qƃ|C^A݂ȂNULLԂB
		*/
		Quest *GameWorld::GetQuest(TAG tag);

		/*!
		* @brief Q[ԂԂ
		* @return Q[
		*/
		GAME_TIME GameWorld::GetGameTime(void);

		/*!
		* @brief XMLVACYɂQ[f[^ۑ
		* @return Ȃ
		*/
		void GameWorld::XMLSave(void);

	};

}